/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.FeedPacket;
import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.TimedPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFAudioControl
extends MRFPacket
implements FeedPacket,
TimedPacket {
    private short feedIdx;
    private boolean grant = false;
    private short talkerAddress;
    private long time;

    public MRFAudioControl(short feedIdx, boolean grant, short talkerAddress, long time) {
        super((byte)4);
        this.feedIdx = feedIdx;
        this.grant = grant;
        this.talkerAddress = talkerAddress;
        this.time = time;
    }

    public MRFAudioControl(byte[] packetData) throws IOException {
        super((byte)4);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.feedIdx = istr.readShort();
        this.time = istr.readLong();
        this.talkerAddress = istr.readShort();
        this.grant = istr.readBoolean();
    }

    public short getFeedIdx() {
        return this.feedIdx;
    }

    public boolean getGrant() {
        return this.grant;
    }

    public short getTalkerAddress() {
        return this.talkerAddress;
    }

    public long getTime() {
        return this.time;
    }

    public void setFeedIdx(short feedIdx) {
        this.feedIdx = feedIdx;
    }

    public void setGrant(boolean grant) {
        this.grant = grant;
    }

    public void setTalkerAddress(short talkerAddress) {
        this.talkerAddress = talkerAddress;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeShort(this.feedIdx);
        ostr.writeLong(this.time);
        ostr.writeShort(this.talkerAddress);
        ostr.writeBoolean(this.grant);
        return bostr.toByteArray();
    }

    public String toString() {
        return "MRFAudioControl: " + this.feedIdx + ", grant: " + this.grant + ", talker: " + this.talkerAddress + ", time: " + MRFAudioControl.decodeTime(this.time);
    }
}

