/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.TimedPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFRecordingControl
extends MRFPacket
implements TimedPacket {
    private boolean record;
    private long time;

    public MRFRecordingControl(boolean record, long time) {
        super((byte)15);
        this.record = record;
        this.time = time;
    }

    public MRFRecordingControl(byte[] packetData) throws IOException {
        super((byte)15);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.record = istr.readBoolean();
        this.time = istr.readLong();
    }

    public boolean isRecording() {
        return this.record;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setRecording(boolean record) {
        this.record = record;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeBoolean(this.record);
        ostr.writeLong(this.time);
        return bostr.toByteArray();
    }

    public String toString() {
        return "MRFRecordingControl:  recording: " + this.record + ", time: " + MRFRecordingControl.decodeTime(this.time);
    }
}

