/***
 * Will automatically call the VLE.resize_iframe function (max 1 per 500ms) if the size of the body element changes.
 *
 * @author: Jenni Osborn, Edwin Langley
 * @version: 0.2
 * @type {null}
 * @example Example usage
 * <!doctype html>
 * <html>
 *   <head>
 *     <title>Demo Application</title>
 *     <meta charset="utf-8">
 *     <link rel="stylesheet" href="styles.css">
 *     <script src="vleapi.1.js"></script>
 *   </head>
 *   <body>
 *     <div>Variable content</div>
 *     <script type="module" src="modules/resize.js"></script>
 *   </body>
 * </html>
 */


let myTimeout = null;
let currentWidth = document.body.offsetWidth;
let currentHeight = document.body.offsetHeight;

function onResize() {
  const width = document.body.offsetWidth;
  const height = document.body.offsetHeight;
  if (width !== currentWidth) {
    window.VLE.resize_iframe();
    /*console.log(
      `%c📐 Resized IFrame (Title: ${
        document.getElementsByTagName("title")[0].innerHTML
      }) - ${new Date()} 📐`,
      "background: #222; color: #bada55"
    );
    */
  } else if (height !== currentHeight) {
    window.VLE.resize_iframe();
    /*console.log(      `%c📐 Resized IFrame (Title: ${
        document.getElementsByTagName("title")[0].innerHTML
      }) - ${new Date()} 📐`,
      "background: #222; color: #bada55"
    );*/
  }
  currentWidth = width;
  currentHeight = height;
}
new ResizeObserver(() => {
  clearTimeout(myTimeout);
  myTimeout = setTimeout(() => onResize(), 200);
}).observe(document.body);

