data = {
    "accessibledescription":"Brand equity. What makes a brand financially valuable? The answer lies partly in the brand equity. Aaker (1991, p. 15) defines brand equity as the set of brand assets and liabilities linked to a brand, its name and symbol, that add to or subtract the value provided by a product or a service to a firm and/or to that firm's customers.",
    "title":"Figure 8.1  Brand equity",
    "fps": -1,        
    "defaultDescription":"defaultId",
    "activityMargin":10,
    "originalWidth":530,
    "originalHeight":580,
    "menuItems":[
        {
            "linkId":"BrandEquityId",
            
            "type":"rect",
            "x":192,
            "y":80,
            "w":148,
            "h":76,
            "r":8,
            "bgColour":"#d7e7f4",
            "borderColour":"#3ca7d5",
            "bgColourActive":"#fbe6d0",
            "borderColourActive":"#3ca7d5",
  
                     
            "label":[
                {
                    "text":"Brand equity",
                    "x":226,
                    "y":102,
                    "colour":"#000000",
                    "colourActive":"#000000",
                    "colourVisted":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":"bold"
                },
                {
                    "text":"Name and symbol",
                    "x":212,
                    "y":126,
                    "colour":"#000000",
                    "colourActive":"#000000",
                    "colourVisted":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        },
        {
            "linkId":"BrandAwarenessId",
            
            "type":"rect",
            "x":192,
            "y":6,
            "w":148,
            "h":48,
            "r":8,
            "bgColour":"#ffffff",
            "borderColour":"#3ca7d5",
            "bgColourActive":"#fbe6d0",
            "borderColourActive":"#3ca7d5",
         
             "label":[
                {
                    "text":"Brand awareness",
                    "x":216,
                    "y":28,
                    "colour":"#000000",
                    "colourActive":"#000000",
                    "colourVisted":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        },
        {
            "linkId":"BrandLoyaltyId",
            
             "type":"rect",
            "x":78,
            "y":188,
            "w":148,
            "h":48,
            "r":8,
            "bgColour":"#ffffff",
            "borderColour":"#3ca7d5",
             "bgColourActive":"#fbe6d0",
            "borderColourActive":"#3ca7d5",
             "label":[
                {
                    "text":"Brand loyalty",
                    "x":114,
                    "y":210,
                    "colour":"#000000",
                    "colourActive":"#000000",
                    "colourVisted":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        },
        {
            "linkId":"BrandAssociationsId",
            
            "type":"rect",
            "x":0,
            "y":94,
            "w":148,
            "h":48,
            "r":8,
            "bgColour":"#ffffff",
            "borderColour":"#3ca7d5",
             "bgColourActive":"#fbe6d0",
            "borderColourActive":"#3ca7d5",
             "label":[
                {
                    "text":"Brand associations",
                    "x":18,
                    "y":116,
                    "colour":"#000000",
                    "colourActive":"#000000",
                    "colourVisted":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        },
        {
            "linkId":"PerceivedQualityId",
            
            "type":"rect",
            "x":382,
            "y":94,
            "w":148,
            "h":48,
            "r":8,
            "bgColour":"#ffffff",
            "borderColour":"#3ca7d5",
            "bgColourActive":"#fbe6d0",
            "borderColourActive":"#3ca7d5",
             "label":[
                {
                    "text":"Perceived quality",
                    "x":406,
                    "y":116,
                    "colour":"#000000",
                    "colourActive":"#000000",
                    "colourVisted":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        },
        {
            "linkId":"ProprietaryBrandAssetsId",
            
            "type":"rect",
            "x":304,
            "y":188,
            "w":148,
            "h":48,
            "r":8,
            "bgColour":"#ffffff",
            "borderColour":"#3ca7d5",
            "bgColourActive":"#fbe6d0",
            "borderColourActive":"#3ca7d5",
             "label":[
                {
                    "text":"Proprietary",
                    "x":346,
                    "y":202,
                    "colour":"#000000",
                    "colourActive":"#000000",
                    "colourVisted":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                },
                {
                    "text":"brand assets",
                    "x":340,
                    "y":218,
                    "colour":"#000000",
                    "colourActive":"#000000",
                    "colourVisted":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        }
        
    ],
     
    "description":[
        {
            "linkId":"defaultId",
            
                  
            "text":[
                {
                    "x":16,
                    "y":276,
                    "w":510,
                    "str":"Brand equity<br><br>Brand equity creates value for customers and managers. It helps customers interpret brands and be more confident in purchase decisions. For example, when consumers are aware of a brand and make quality associations they become more confident in their buying decision. By generating loyal customers, brands allow the organisation to charge premium prices and contribute to efficient resource allocation. In fact brands generate competitive advantage (Aaker, 1991).<br><br>Yet, how can we assess the value of a brand?",
                    "colour":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        },
        {
            "linkId":"BrandEquityId",
            
                  
            "text":[
                {
                    "x":16,
                    "y":276,
                    "w":510,
                    "str":"Brand equity<br><br>Brand equity creates value for customers and managers. It helps customers interpret brands and be more confident in purchase decisions. For example, when consumers are aware of a brand and make quality associations they become more confident in their buying decision. By generating loyal customers, brands allow the organisation to charge premium prices and contribute to efficient resource allocation. In fact brands generate competitive advantage (Aaker, 1991).<br><br>Yet, how can we assess the value of a brand?",
                    "colour":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        },
        {
            "linkId":"BrandAwarenessId",
            
        
            "text":[
               
                {
                   "x":16,
                    "y":276,
                    "w":510,
                    "str":"Brand awareness<br><br>Brand awareness relates to the level of consumer awareness regarding the existence of a particular brand. When consumers think about soft drinks which brands do they recall? Coca-Cola and Pepsi have strong brand awareness in this market.",
                    "colour":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        },
        {
            "linkId":"BrandLoyaltyId",
            
        
            "text":[
               
                {
                    "x":16,
                    "y":276,
                    "w":510,
                    "str":"Brand Loyalty<br><br>Brand loyalty refers to consumers who repeatedly buy the same brand. Having loyal customers enhances brand visibility and allows organisations to save resources in attracting new customers. It further pressurises retailers to make these brands available to customers. For example, online retailer Amazon has a loyalty programme (Amazon Prime) offering benefits to customers who join as a way of building customer loyalty.",
                    "colour":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        },
        {
            "linkId":"BrandAssociationsId",
            
        
            "text":[
               
                {
                    "x":16,
                    "y":276,
                    "w":510,
                    "str":"Brand Associations<br><br>Marketers try to attach positive and strong associations to the brand such as lifestyle and personality. For example, the Ritz Hotel in London is associated with luxury and sophistication.",
                    "colour":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        },
        {
            "linkId":"PerceivedQualityId",
            
        
            "text":[
               
                {
                    "x":16,
                    "y":276,
                    "w":510,
                    "str":"Perceived Quality<br><br>Quality level is an association that consumers attach to a brand. When the market perceives a brand as being high quality, organisations avoid competing on the basis of price and may adopt premium pricing strategies. For example, Rolls Royce is highly regarded for its quality and reliability.",
                    "colour":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        },
        {
            "linkId":"ProprietaryBrandAssetsId",
            
        
            "text":[
               
                {
                    "x":16,
                    "y":276,
                    "w":510,
                    "str":"Proprietary brand assets<br><br>Proprietary brand assets, which are normally legally protected, include patents, channel relationships and trademarks that are attached to the brand. In high technology products, brand innovation may lie in protecting product/technology patents and licensing. For example, there have been legal issues between Apple and Samsung regarding aspects related to their brands. Apple contends Samsung\u2019s Galaxi Tab 10.1 is too similar in terms of design to its iPad and Samsung considers Apple infringed its 3G patents. Both companies have made legal complaints in various countries including Australia, Germany and The Netherlands).<br><br>Proprietary assets also include aspects such as brand symbols (e.g. logo) and the brand name. PepsiCo, Inc. has clear guidelines for the use of trademarks, names, titles, logos, images, designs, copyrights and other proprietary materials. All these objects are copyrighted and can only be used for commercial purposes with the company's agreement.",
                    "colour":"#000000",
                    "lineSpacing":18,
                    "fontFamily":"sans-serif",
                    "fontSize":"10pt",
                    "fontStyle":""
                }
            ]
        }    
    ],
    
    "bgObjects":[
        {
            "linkId":["ALLID"],
            "type":"line",
            "points":[{"x":266,"y":48},{"x":266,"y":82}],
            "lineWidth":1,
            "borderColour":"#3fa6d3"            
         },
         {
            "linkId":["ALLID"],
            "type":"line",
            "points":[{"x":140,"y":116},{"x":390,"y":116}],
            "lineWidth":1,
            "borderColour":"#3fa6d3"            
         },
          {
            "linkId":["ALLID"],
            "type":"line",
            "points":[{"x":220,"y":150},{"x":206,"y":190}],
            "lineWidth":1,
            "borderColour":"#3fa6d3"            
         },
          {
            "linkId":["ALLID"],
            "type":"line",
            "points":[{"x":308,"y":150},{"x":326,"y":190}],
            "lineWidth":1,
            "borderColour":"#3fa6d3"            
         },
         {
            "linkId":["defaultId","ProprietaryBrandAssetsId","BrandEquityId","BrandLoyaltyId","BrandAwarenessId","BrandAssociationsId","PerceivedQualityId"],
            "type":"rect",
            "x":6,
            "y":260,
            "w":520,
            "h":310,
            "r":8,
            "bgColour":"#ffffff",
            "borderColour":"#3fa6d3"
             
         }
         
        
    ]
  
};
