/**
 * @fileOverview HTML - simple DIV element to contain HTML content - intended to be used in conjunction with a controller and other activities
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

OU.require('OU.util.Layer');
OU.require('OU.util.Div');
/**
 * @class Loads HTML content into a div
 * @extends OU.util.Activity
 * @param {object} data - data.js content
 * @param {string} instance - unique instance name
 * @param {OU.util.Controller} controller - (optional) reference of parent controller
 */
OU.activity.HTML = function(data,instance,controller) {
    /**
     * Starting point when running with HTML5 Canvas Support
     */
    OU.activity.HTML.prototype.canvasView = function() {

        var inRe = /\<input/, aRe=/\<a/,taRe = /\<textarea/;

        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw background on backdrop layer

        this.margin=this.data.margin || 40;
        this.htmlDiv = new OU.util.Div({
            innerHTML:this.data.html,
            x:this.x+this.margin,
            y:this.y+this.margin,
            w:this.w-this.margin*2,
            h:this.h-this.margin*2,
            container: this,
            style: this.data.style,
            overflow: this.data.overflow
        });
        if(!this.htmlDiv.hasScrollBar && !inRe.test(this.data.html) && !aRe.test(this.data.html) && !taRe.test(this.data.html)) // if html doesn't contain any input fields, then stop the Done Bar from poping up when touched
            OU.nobbleDoneBar(this.htmlDiv.div);

        // Process any controller API requests that are in the data file - will have no effect if they aren't defined
        this.controller.processAPI(this.data.controllerAPI);
    };
    /**
     * resizes the background and div
     */
    OU.activity.HTML.prototype.resize = function() {
        OU.activity.HTML.superClass_.resize.call(this); // call the parent class resize

        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        this.htmlDiv.resize({
            x:this.x+this.margin,
            y:this.y+this.margin,
            w:this.w-this.margin*2,
            h:this.h-this.margin*2,
            container: this
        });
    };

    OU.base(this,data,instance,controller);
};
OU.inherits(OU.activity.HTML,OU.util.Activity);
