//<![CDATA[

/**
 * TODO add some resize code in may need to add the viewport in programatically.
 *
 **/

var VIEWKEY = 32,
    UPARROWKEY = 38,
    DOWNARROWKEY = 40,
    LEFTARROWKEY = 37,
    RIGHTARROWKEY = 39,
    AKEY = 65,
    DKEY = 68,
    WKEY = 87,
    SKEY = 83,
    BKEY = 66,
    VKEY = 86,
    HKEY = 72,
    gTotalQuestionCount,
    gQuestionData = new Array(),
    gLeftX = this.data.margin,
    gRightX = (this.data.width / 2) + gLeftX,
    gTitleHeight = 16,
    gQuestionHeight = 22,
    gQuestionKern = 18,
    gInitialY = this.data.marginTop,
    gElmQuestionsAreaId,
    gxmlns = "http://www.w3.org/2000/svg",
    gTextWrapElm,
    gElmAnswersAreaId,
    gMaxColwidth,
    gCurrentRow = -1,
    gCurrentCol = -1,
    gLastRow = -1,
    gHandleId = 0,
    gX = 0,
    bMoveHandle = false,
    debugOn = true,
    gMaxOptions = this.data.scaleHeadings.length,
    gActivityHeight = this.data.height,
    gIsSVG = false,
    gDivId,
    gDefaultDownloadImageFile = "b844_unit1_likert_download_image.php?ul=",
    gDefaultMenuImageFile = "b844_unit1_likert_menu.php?ul=",
    gDefaultViewImageFile = "b844_unit1_likert.php?ul=",
    scaleFactorH = 1,
    scaleFactorW = 1,
    VMLAutoGenerate = false;


function trace(str) {

    // if (debugOn && console)
    {
        // console.log(str);
    }
}

/*
 Function: setScaleFactor

 Resets the scalling factor

 See Also:

 */
function setScaleFactor() {
    scaleFactorH = document.documentElement.clientHeight / (this.data.height);
    scaleFactorW = document.documentElement.clientWidth / (this.data.width);

    // console.log("scaleFactorH:"+scaleFactorH);
    //  console.log("scaleFactorW:"+scaleFactorW);
}


function doResize() {
    /*
     document.documentElement.setAttributeNS(null,"height",document.documentElement.clientHeight+"px");
     document.documentElement.setAttributeNS(null,"width",document.documentElement.clientWidth+"px");
     setScaleFactor();

     var elmt = document.getElementById("containerId");
     elmt.setAttributeNS(null,"transform","scale(1)");
     */

}

function doLoad(isSVG) {
    var divLineId;

    gIsSVG = isSVG;
    gMaxColwidth = ((this.data.width / 2) - (this.data.margin * 2));

    if (gIsSVG) {
        //gSVGRoot = document.documentElement;
        gSVGRoot = document.getElementsByTagName('svg')[0];
        console.log(gSVGRoot);
        console.dir(gSVGRoot);
    }

    if (gIsSVG) {
        gElmQuestionsAreaId = gSVGRoot.getElementById("QuestionColumn");
        gElmAnswersAreaId = gSVGRoot.getElementById("AnswersColumn");
        gElmControlsAreaId = gSVGRoot.getElementById("Controls");

        gTextWrapElm = document.createElementNS(gxmlns, "text");
        gTextWrapElm.setAttributeNS(null, "id", "textWrapId");
        gTextWrapElm.setAttributeNS(null, "x", this.data.width);
        gTextWrapElm.setAttributeNS(null, "y", 0);
        gTextWrapElm.setAttributeNS(null, "class", "fontType titleFontSize");
        gTextWrapElm.textContent = "JustDebug";
        gElmQuestionsAreaId.appendChild(gTextWrapElm);
    }
    else {
        gDivId = document.getElementById("divChart");

        divLineId = document.getElementById("divLine");

        if (VMLAutoGenerate === true) {
            divLineId.innerHTML = '<v:shape id="userPathId" style="left:0px;top:0px;width:880;height:1076;clear:both;position:absolute;" coordorigin="0 0" coordsize="880 1076"><v:stroke weight="2px" color="' + this.data.userLineColour + '"/></v:shape><v:shape id="meanPathId" style="left:0px;top:0px;width:880;height:1076;clear:both;position:absolute;visibility:hidden;" coordorigin="0 0" coordsize="880 1076"><v:stroke dashstyle="dash" weight="2px" color="' + this.data.meanLineColour + '"/></v:shape>';
        }
    }

    trace("loaded svg");
    trace("this.data.width:" + this.data.width);

    createQuestionaire();

    if (gIsSVG) {
        gSVGRoot.setAttributeNS(null, "height", this.data.height);
        gSVGRoot.setAttributeNS(null, "width", this.data.width);

        gSVGRoot.setAttributeNS(null, "onmousemove", "moveHandle(evt)");
        gSVGRoot.setAttributeNS(null, "onmouseup", "moveHandleUp(evt)");

        var elmt = document.createElementNS(gxmlns, "rect");
        elmt.setAttributeNS(null, "width", this.data.width);
        elmt.setAttributeNS(null, "height", this.data.height);
        elmt.setAttributeNS(null, "x", "0");
        elmt.setAttributeNS(null, "y", "0");
        elmt.setAttributeNS(null, "style", "fill:black;opacity:0.01");
        gElmQuestionsAreaId.appendChild(elmt);
    }

    if (gIsSVG) {
        document['onkeyup'] = KeyUp;
        document['onkeydown'] = KeyDown;

        scaleFactorH = 0.86;
        scaleFactorW = 0.86;

    }

    window.focus();
}


function createQuestionaire() {
    var sectionCount = 0, questionCount = 0, count, subCount, currentY = gInitialY, dataObj = new Object(), tempY;

    gTotalQuestionCount = 0;

    for (count = this.data.section.length; count > 0; count--, sectionCount++) {
        currentY += gTitleHeight;

        currentY = drawSectionTitle(this.data.section[sectionCount].title, gLeftX, currentY);

        trace(this.data.section[sectionCount].title);
        questionCount = 0;
        for (subCount = this.data.section[sectionCount].questions.length; subCount > 0; subCount--, questionCount++) {
            trace(this.data.section[sectionCount].questions[questionCount].question);

            dataObj = new Object()
            dataObj.meanScore = parseInt(this.data.section[sectionCount].questions[questionCount].mean_score.toFixed(0));
            dataObj.userScore = this.data.startIndex;

            currentY = drawQuestion(this.data.section[sectionCount].questions[questionCount].question, this.data.section[sectionCount].questions[questionCount].prefix, gLeftX, currentY, (gTotalQuestionCount + questionCount), dataObj);

            gQuestionData.push(dataObj);
        }
        gTotalQuestionCount += questionCount;

    }

    gActivityHeight = currentY;

    if (gIsSVG) {
        //Help Hint
        var elmtSpan = document.createElementNS(gxmlns, "text");
        elmtSpan.setAttributeNS(null, "x", gLeftX);
        elmtSpan.setAttributeNS(null, "y", currentY + gTitleHeight);
        elmtSpan.setAttributeNS(null, "class", "fontType fontSize fontGrey disableHighlight");
        elmtSpan.textContent = "View help by pressing the H key or clicking on the help button";
        gElmQuestionsAreaId.appendChild(elmtSpan);
    } else {
        if (VMLAutoGenerate === true) {
            elm = ' <div  style="left:' + gLeftX + 'px;top:' + (currentY) + 'px; width:' + gMaxColwidth + 'px; position:absolute;" class="fontType fontSize fontGrey disableHighlight">View help by pressing the H key or clicking on the help button</div>';
            gDivId.innerHTML += elm;
        }
    }

    drawLine();
    drawAnswers();
    drawControls();
}

function drawSectionTitle(szStr, x, y) {
    var elm, elmtSpan;
    if (gIsSVG) {

        elm = document.createElementNS(gxmlns, "text");
        elmtSpan = document.createElementNS(gxmlns, "tspan");

        elmtSpan.setAttributeNS(null, "x", x);
        elmtSpan.setAttributeNS(null, "y", y);
        elmtSpan.setAttributeNS(null, "class", "fontType titleFontSize disableHighlight");
        elmtSpan.textContent = szStr;
        elm.appendChild(elmtSpan);
        gElmQuestionsAreaId.appendChild(elm);

    } else {

        if (VMLAutoGenerate === true) {
            elm = '<div style="left:' + x + 'px;top:' + y + 'px; position:absolute;" class="fontType titleFontSize disableHighlight">' + szStr + '</div>'
            gDivId.innerHTML += elm;
        }
    }

    return (y + gQuestionHeight);
}

function drawQuestion(szStr, szPrefix, x, y, idx, dataObj) {
    var elm, splitStingArray = szStr.split(" "), splitCount = 0,
        bBreak = false, szSubStr = "", lines = 0, bRect;

    dataObj.y = y;

    if (gIsSVG) {
        elm = document.createElementNS(gxmlns, "text")

        while (splitCount < splitStingArray.length) {

            gTextWrapElm.textContent = "";
            gTextWrapElm.setAttributeNS(null, "class", "fontType fontSize disableHighlight");

            bBreak = false;
            szSubStr = "";

            while (!bBreak) {
                gTextWrapElm.textContent += splitStingArray[splitCount] + " ";

                //  console.log(gTextWrapElm.getComputedTextLength());

                if (gTextWrapElm.getComputedTextLength() > gMaxColwidth - this.data.QuestionMargin || splitCount >= splitStingArray.length) {
                    var elmtSpan = document.createElementNS(gxmlns, "tspan");
                    elmtSpan.setAttributeNS(null, "x", x + this.data.QuestionMargin);
                    elmtSpan.setAttributeNS(null, "y", y);
                    if (idx % 2 === 1) {
                        elmtSpan.setAttributeNS(null, "class", "fontType fontSize fontBlack disableHighlight");
                    }
                    else {
                        elmtSpan.setAttributeNS(null, "class", "fontType fontSize fontGrey disableHighlight");
                    }
                    elmtSpan.textContent = szSubStr;
                    elm.appendChild(elmtSpan);
                    gElmQuestionsAreaId.appendChild(elm);

                    if (y === dataObj.y) {
                        var elmtSpan = document.createElementNS(gxmlns, "tspan");
                        elmtSpan.setAttributeNS(null, "x", x);
                        elmtSpan.setAttributeNS(null, "y", y);
                        if (idx % 2 === 1) {
                            elmtSpan.setAttributeNS(null, "class", "fontType fontSize fontBlack disableHighlight");
                        }
                        else {
                            elmtSpan.setAttributeNS(null, "class", "fontType fontSize fontGrey disableHighlight");
                        }
                        elmtSpan.textContent = szPrefix;
                        elm.appendChild(elmtSpan);
                        gElmQuestionsAreaId.appendChild(elm);

                    }

                    y += gQuestionKern;
                    lines++;
                    bBreak = true;
                } else {
                    szSubStr += splitStingArray[splitCount] + " ";
                    splitCount++;
                }

            }
        }

        dataObj.y += ((lines - 1) * (gQuestionKern / 2));
        y += 6;
    }
    else { //VML for IE
        if (VMLAutoGenerate === true) {
            if (idx % 2 === 1) {
                elm = ' <div  id="qpx' + idx + '" style="left:' + x + 'px;top:' + y + 'px; width:' + this.data.QuestionMargin + 'px; position:absolute;" class="fontType fontSize fontBlack disableHighlight">' + szPrefix + '</div>';
                elm += ' <div  id="qx' + idx + '" style="left:' + (x + this.data.QuestionMargin) + 'px;top:' + y + 'px; width:' + gMaxColwidth + 'px; position:absolute;" class="fontType fontSize fontBlack disableHighlight">' + szStr + '</div>';
            }
            else {
                elm = ' <div  id="qpx' + idx + '" style="left:' + x + 'px;top:' + y + 'px; width:' + this.data.QuestionMargin + 'px; position:absolute;" class="fontType fontSize fontGrey disableHighlight">' + szPrefix + '</div>';
                elm += ' <div  id="qx' + idx + '" style="left:' + (x + this.data.QuestionMargin) + 'px;top:' + y + 'px; width:' + gMaxColwidth + 'px; position:absolute;" class="fontType fontSize fontGrey disableHighlight">' + szStr + '</div>';
            }

            gDivId.innerHTML += elm;
        }

        bBreak = true;

        dataObj.y += document.getElementById("qx" + idx).offsetHeight / 2;
        y += document.getElementById("qx" + idx).offsetHeight + 6;

        y += 6;
    }

    return (y);
}

function drawAnswers() {
    var dWidth = (gMaxColwidth / gMaxOptions);

    if (gIsSVG) {

        gTextWrapElm.setAttributeNS(null, "class", "fontType fontSize");
        gTextWrapElm.textContent = this.data.scaleLeftHeading;

        var elmHeading = document.createElementNS(gxmlns, "text");
        elmHeading.setAttributeNS(null, "x", (gMaxColwidth + (dWidth / 2)) - (gTextWrapElm.getComputedTextLength() / 2));
        elmHeading.setAttributeNS(null, "y", gInitialY - 2);
        elmHeading.setAttributeNS(null, "class", "fontType fontSize disableHighlight");
        elmHeading.textContent = this.data.scaleLeftHeading;
        gElmQuestionsAreaId.appendChild(elmHeading);


        gTextWrapElm.setAttributeNS(null, "class", "fontType fontSize");
        gTextWrapElm.textContent = this.data.scaleRightHeading;

        elmHeading = document.createElementNS(gxmlns, "text");
        elmHeading.setAttributeNS(null, "x", (gMaxColwidth + (dWidth * (gMaxOptions - 1)) + (dWidth / 2)) - (gTextWrapElm.getComputedTextLength() / 2));
        elmHeading.setAttributeNS(null, "y", gInitialY - 2);
        elmHeading.setAttributeNS(null, "class", "fontType fontSize disableHighlight");
        elmHeading.textContent = this.data.scaleRightHeading;
        gElmQuestionsAreaId.appendChild(elmHeading);


        for (var subCount = 0; subCount < gMaxOptions; subCount++) {
            var xpos = gMaxColwidth + (dWidth * subCount) + (dWidth / 2);
            var elmHeading = document.createElementNS(gxmlns, "text");
            elmHeading.setAttributeNS(null, "x", xpos - this.data.circleRadius / 2);
            elmHeading.setAttributeNS(null, "y", gInitialY * 2);
            elmHeading.setAttributeNS(null, "class", "fontType titleFontSize disableHighlight");
            elmHeading.textContent = this.data.scaleHeadings[subCount];
            gElmQuestionsAreaId.appendChild(elmHeading);
        }

        for (var count = 0; count < gQuestionData.length; count++) {
            trace("y=" + gQuestionData[count].y);
            trace("mean=" + gQuestionData[count].meanScore);


            for (var subCount = 0; subCount < gMaxOptions; subCount++) {
                var xpos = gMaxColwidth + (dWidth * subCount) + (dWidth / 2);
                var elmt = document.createElementNS(gxmlns, "circle");
                elmt.setAttributeNS(null, "id", "c" + ((gMaxOptions * count) + subCount));
                elmt.setAttributeNS(null, "cx", xpos);
                elmt.setAttributeNS(null, "cy", gQuestionData[count].y - 4);
                elmt.setAttributeNS(null, "r", this.data.circleRadius);
                elmt.setAttributeNS(null, "class", "unhighlightedCircle");
                elmt.setAttributeNS(null, "onclick", "handleEvent(evt)");
                elmt.setAttributeNS(null, "onmousedown", "moveHandleDown(evt)");
                gElmAnswersAreaId.appendChild(elmt);
            }

            var xpos = gMaxColwidth + ((this.data.startIndex - 1) * dWidth) + (dWidth / 2);
            var elmt = document.createElementNS(gxmlns, "circle");
            elmt.setAttributeNS(null, "cx", xpos);
            elmt.setAttributeNS(null, "id", "q" + (count + 1) + "Id");
            elmt.setAttributeNS(null, "cy", gQuestionData[count].y - this.data.circleRadius / 2);
            elmt.setAttributeNS(null, "r", this.data.circleRadius);
            elmt.setAttributeNS(null, "class", "highlightedCircle disableHighlight");
            gElmAnswersAreaId.appendChild(elmt);
        }
    }
    else {
        if (VMLAutoGenerate === true) {
            var elmHeading = ' <div  style="left:' + ((gMaxColwidth + (dWidth / 2))) + 'px;top:' + (gInitialY - 10) + 'px; position:absolute; text-align:center; width:50px" ;  class="fontType fontSize disableHighlight ">' + this.data.scaleLeftHeading + '</div>';
            gDivId.innerHTML += elmHeading;

            elmHeading = ' <div style="left:' + ((gMaxColwidth + (dWidth * (gMaxOptions - 1)) + (dWidth / 2))) + 'px;top:' + (gInitialY - 10) + 'px; position:absolute; width:50px; text-align:center;" class="fontType fontSize disableHighlight">' + this.data.scaleRightHeading + '</div>';
            gDivId.innerHTML += elmHeading;


            for (var subCount = 0; subCount < gMaxOptions; subCount++) {
                var xpos = gMaxColwidth + (dWidth * subCount) + (dWidth / 2) + 6;

                elmHeading = '<div style="left:' + (xpos - (this.data.circleRadius / 2)) + 'px;top:' + ((gInitialY * 2) + 2) + 'px; position:absolute; width:50px; text-align:center;" class="fontType fontSize disableHighlight">' + this.data.scaleHeadings[subCount] + '</div>';
                gDivId.innerHTML += elmHeading;
            }

            for (var count = 0; count < gQuestionData.length; count++) {
                trace("y=" + gQuestionData[count].y);
                trace("mean=" + gQuestionData[count].meanScore);


                for (var subCount = 0; subCount < gMaxOptions; subCount++) {

                    var xpos = gMaxColwidth + (dWidth * subCount) + (dWidth) - (this.data.circleRadius);
                    var elmt;

                    elmt = '<v:oval id="c' + ((gMaxOptions * count) + subCount) + '" style="margin-top:4px; position:absolute;top:' + (gQuestionData[count].y - 16).toFixed(0) + 'px;left:' + (xpos - 16).toFixed(0) + 'px;width:' + (this.data.circleRadius * 2) + ';height:' + (this.data.circleRadius * 2) + '" onclick="handleEventIE(event);"> <v:fill color="#c0c0c0" /></v:oval>';

                    gDivId.innerHTML += elmt;

                }

                var xpos = gMaxColwidth + (dWidth * (this.data.startIndex - 1)) + (dWidth) - (this.data.circleRadius);
                var elmt = '<v:oval id="q' + (count + 1) + 'Id" style="margin-top:4px; position:absolute;top:' + (gQuestionData[count].y - 16).toFixed(0) + 'px;left:' + (xpos - 16).toFixed(0) + 'px;width:' + (this.data.circleRadius * 2) + ';height:' + (this.data.circleRadius * 2) + '"><v:stroke color="' + this.data.userLineColour + '" weight="2pt" /><v:fill opacity="1%" color="#ffffff" /></v:oval>';
                gDivId.innerHTML += elmt;
            }
        }
    }
}

function drawLine() {
    if (gIsSVG) {
        var dWidth = (gMaxColwidth / gMaxOptions);
        var elmt = document.createElementNS(gxmlns, "path");


        var x = gMaxColwidth + (dWidth * (gQuestionData[0].userScore - 1)) + (dWidth / 2);
        var mx = gMaxColwidth + (dWidth * (gQuestionData[0].meanScore - 1)) + (dWidth / 2);
        var y = gQuestionData[0].y - this.data.circleRadius / 2;

        var pathStr = "M " + x + "," + y;
        var meanPathStr = "M " + mx + "," + y;

        for (var count = 1; count < gQuestionData.length; count++) {
            x = gMaxColwidth + (dWidth * (gQuestionData[count].userScore - 1)) + (dWidth / 2);
            mx = gMaxColwidth + (dWidth * (gQuestionData[count].meanScore - 1)) + (dWidth / 2);
            y = gQuestionData[count].y - this.data.circleRadius / 2;

            pathStr += " L " + x + "," + y;
            meanPathStr += " L " + mx + "," + y;
        }

        // console.log(pathStr);
        elmt.setAttributeNS(null, "id", "userPathId");
        elmt.setAttributeNS(null, "d", pathStr);

        elmt.setAttributeNS(null, "class", "userLine disableHighlight");
        gElmAnswersAreaId.appendChild(elmt);

        // Now draw the mean line

        elmt = document.createElementNS(gxmlns, "path");
        elmt.setAttributeNS(null, "id", "meanPathId");
        elmt.setAttributeNS(null, "d", meanPathStr);
        elmt.setAttributeNS(null, "class", "meanPathStyle disableHighlight");
        elmt.setAttributeNS(null, "stroke-dasharray", "5,5");
        gElmAnswersAreaId.appendChild(elmt);
    }
    else {
        var dWidth = (gMaxColwidth / gMaxOptions);
        var x = gMaxColwidth + (dWidth * (gQuestionData[0].userScore - 1)) + (dWidth) - 16;
        var mx = gMaxColwidth + (dWidth * (gQuestionData[0].meanScore - 1)) + (dWidth) - 16;
        var y = (gQuestionData[0].y - this.data.circleRadius / 2);
        var pathStr = "m " + x.toFixed(0) + "," + y.toFixed(0);
        var meanPathStr = "m " + mx.toFixed(0) + "," + y.toFixed(0);

        for (var count = 1; count < gQuestionData.length; count++) {
            x = gMaxColwidth + (dWidth * (gQuestionData[count].userScore - 1)) + (dWidth) - 16;
            mx = gMaxColwidth + (dWidth * (gQuestionData[count].meanScore - 1)) + (dWidth) - 16;
            y = (gQuestionData[count].y - this.data.circleRadius / 2);


            pathStr += " l " + x.toFixed(0) + "," + y.toFixed(0);
            meanPathStr += " l " + mx.toFixed(0) + "," + y.toFixed(0);

        }

        pathStr += "  e";
        meanPathStr += "nf e";

        document.getElementById("userPathId").setAttribute("path", pathStr);
        document.getElementById("meanPathId").setAttribute("path", meanPathStr);
    }
}

function handleEventIE(event) {
    var circleId = event.srcElement.id;
    var circleIndex = parseInt(circleId.substring(1));
    var questionIdx = parseInt(circleIndex / gMaxOptions);

    gCurrentRow = questionIdx;
    gHandleId = circleId;
    gX = event.x;

    if (gLastRow != -1) {
        var elmt = document.getElementById("q" + (gLastRow + 1) + "Id");
        elmt.stroke.color = this.data.userLineColour;
    }

    updateLine(circleId, false);
}

function handleEvent(evt) {
    //onclick event handler
}

function moveHandleDown(evt) {
    var circleId = evt.target.id;
    var circleIndex = parseInt(circleId.substring(1));
    var questionIdx = parseInt(circleIndex / gMaxOptions);

    bMoveHandle = true;
    gCurrentRow = questionIdx;
    gHandleId = circleId;
    gX = evt.target.x / scaleFactorH;

    var elmt = document.getElementById("q" + (questionIdx + 1) + "Id");
    elmt.setAttributeNS(null, "class", "highlightedCircle disableHighlight focusOn");


    if (gLastRow != -1) {
        elmt = document.getElementById("q" + (gLastRow + 1) + "Id");
        elmt.setAttributeNS(null, "class", "highlightedCircle disableHighlight");
        circleId = "c" + ((gLastRow * gMaxOptions) + gCurrentCol);
    }
}

function moveHandle(evt) {
    if (bMoveHandle && gHandleId != 0) {
        gX = evt.clientX / scaleFactorH;

        if (gX < (this.data.width / 2)) {
            gX = this.data.width / 2;
        }
        else if (gX > (this.data.width - this.data.margin - this.data.circleRadius)) {
            gX = this.data.width - this.data.margin - this.data.circleRadius;
        }
        updateLine(gHandleId, false);
    }
    else {
        bMoveHandle = false;
    }

}

function moveHandleUp(evt) {
    var x, dx, circleId = "c", questionIdx, dWidth, elmt;
    if (bMoveHandle) {

        dx = evt.clientX / scaleFactorH;
        dWidth = (gMaxColwidth / gMaxOptions);

        bMoveHandle = false;

        for (var count = 0; count < gMaxOptions; count++) {
            x = gMaxColwidth + (dWidth * count) + (dWidth / 2);
            if (x >= (dx - this.data.circleRadius ) && x <= (dx + this.data.circleRadius )) {
                questionIdx = parseInt(parseInt(gHandleId.substring(1)) / gMaxOptions);
                circleId += ((questionIdx * gMaxOptions) + count);
                trace("circleId:" + circleId + "questionIdx:" + questionIdx)
                break;
            }
        }
        if (circleId === "c") {
            updateLine(gHandleId, false);
        } else {
            updateLine(circleId, false);
        }
    }
}


function keyboardUpdateLine() {
    var elmt, circleId;

    if (gCurrentRow === -1 || gCurrentCol === -1) {
        gCurrentRow = 0;
        gCurrentCol = 0;
    }

    elmt = document.getElementById("q" + (gCurrentRow + 1) + "Id");

    if (gIsSVG) {
        elmt.setAttributeNS(null, "class", "highlightedCircle disableHighlight focusOn");
    } else {
        elmt.stroke.color = this.data.highlightColour;
    }

    circleId = "c" + ((gCurrentRow * gMaxOptions) + gCurrentCol);
    updateLine(circleId, true);


    if (gLastRow != gCurrentRow && gLastRow != -1) {
        elmt = document.getElementById("q" + (gLastRow + 1) + "Id");
        if (gIsSVG) {
            elmt.setAttributeNS(null, "class", "highlightedCircle disableHighlight");
        } else {
            elmt.stroke.color = this.data.userLineColour;
        }
        circleId = "c" + ((gLastRow * gMaxOptions) + gCurrentCol);
        gLastRow = gCurrentRow;
    }
}


function updateLine(circleId, bKeyBoard) {
    var dWidth = (gMaxColwidth / gMaxOptions);
    var elmt = document.getElementById("userPathId");
    var circleIndex = parseInt(circleId.substring(1));
    var questionIdx = parseInt(circleIndex / gMaxOptions);
    var uScore = (circleIndex % gMaxOptions) + 1;
    var pathStr = "";

    trace(questionIdx);
    trace(uScore);

    gQuestionData[questionIdx].userScore = uScore;

    if (gIsSVG) {
        for (var count = 0; count < gQuestionData.length; count++) {
            if (count === gCurrentRow && bMoveHandle) {
                x = gX;

            } else {
                x = gMaxColwidth + (dWidth * (gQuestionData[count].userScore - 1)) + (dWidth / 2);
            }

            y = gQuestionData[count].y - this.data.circleRadius / 2;
            if (count === 0) {
                pathStr = "M " + x + "," + y;
            } else {
                pathStr += " L " + x + "," + y;
            }
        }

        elmt.setAttributeNS(null, "d", pathStr);
        elmt = document.getElementById("q" + (questionIdx + 1) + "Id");

        if (bMoveHandle) {
            x = gX;
        }
        else {
            x = gMaxColwidth + (dWidth * (gQuestionData[questionIdx].userScore - 1)) + (dWidth / 2);
            if (!bKeyBoard) {
                elmt.setAttributeNS(null, "class", "highlightedCircle disableHighlight");
            }
        }

        elmt.setAttributeNS(null, "cx", x);
    }
    else {
        for (var count = 0; count < gQuestionData.length; count++) {
            if (count === gCurrentRow && bMoveHandle) {
                x = gX;
            }
            else {
                x = gMaxColwidth + (dWidth * (gQuestionData[count].userScore - 1)) + (dWidth) - 16;
            }

            y = gQuestionData[count].y - this.data.circleRadius / 2;

            if (count === 0) {
                pathStr = "m " + x.toFixed(0) + "," + y.toFixed(0);
            }
            else {
                pathStr += " l " + x.toFixed(0) + "," + y.toFixed(0);
            }
        }

        elmt.setAttribute("path", pathStr);
        elmt = document.getElementById("q" + (questionIdx + 1) + "Id");

        if (bMoveHandle) {
            x = gX;
        }
        else {
            x = gMaxColwidth + (dWidth * (gQuestionData[questionIdx].userScore - 1)) + (dWidth) - (this.data.circleRadius) - 16;

            if (!bKeyBoard) {
                elmt.setAttribute("class", "highlightedCircle disableHighlight");
            }
        }
        elmt.style.left = x.toFixed(0) + "px";
    }
}


function drawControls() {
    if (gIsSVG) {
        var dWidth = (gMaxColwidth / gMaxOptions),
            elmt,
            y;

        elmt = document.createElementNS(gxmlns, "rect");

        elmt.setAttributeNS(null, "onclick", "toggleMean()");

        elmt.setAttributeNS(null, "width", "80");
        elmt.setAttributeNS(null, "height", "20");

        elmt.setAttributeNS(null, "x", "0");
        elmt.setAttributeNS(null, "y", "0");

        elmt.setAttributeNS(null, "class", "controlButtonStyle");
        gElmControlsAreaId.appendChild(elmt);

        elmt = document.createElementNS(gxmlns, "text");
        elmt.setAttributeNS(null, "onclick", "toggleMean()");
        elmt.setAttributeNS(null, "id", "MeanButtonTextId");
        elmt.setAttributeNS(null, "x", "40");
        elmt.setAttributeNS(null, "y", "14");
        elmt.setAttributeNS(null, "class", "fontType fontSize textCenter");
        elmt.textContent = "Show Mean";
        gElmControlsAreaId.appendChild(elmt);


        /*
         elmt = document.createElementNS(gxmlns,"rect");

         elmt.setAttributeNS(null,"onclick","handleImageRequest('viewImageId')");

         elmt.setAttributeNS(null,"width","80");
         elmt.setAttributeNS(null,"height","20");

         elmt.setAttributeNS(null,"x","140");
         elmt.setAttributeNS(null,"y","0");

         elmt.setAttributeNS(null,"class","controlButtonStyle");
         gElmControlsAreaId.appendChild(elmt);

         elmt = document.createElementNS(gxmlns,"text");
         elmt.setAttributeNS(null,"onclick","handleImageRequest()");
         elmt.setAttributeNS(null,"id","viewImageId");
         elmt.setAttributeNS(null,"x","180");
         elmt.setAttributeNS(null,"y","14");
         elmt.setAttributeNS(null,"class","fontType fontSize textCenter");
         elmt.textContent = "View";
         gElmControlsAreaId.appendChild(elmt);
         */

        elmt = document.createElementNS(gxmlns, "rect");

        elmt.setAttributeNS(null, "onclick", "viewHelp()");

        elmt.setAttributeNS(null, "width", "80");
        elmt.setAttributeNS(null, "height", "20");

        elmt.setAttributeNS(null, "x", "270");
        elmt.setAttributeNS(null, "y", "0");

        elmt.setAttributeNS(null, "class", "controlButtonStyle");
        gElmControlsAreaId.appendChild(elmt);

        elmt = document.createElementNS(gxmlns, "text");
        elmt.setAttributeNS(null, "onclick", "viewHelp()");
        //elmt.setAttributeNS(null, "id", "helpId");
        elmt.setAttributeNS(null, "x", "310");
        elmt.setAttributeNS(null, "y", "14");
        elmt.setAttributeNS(null, "class", "fontType fontSize textCenter");
        elmt.textContent = "Help";

        gElmControlsAreaId.appendChild(elmt);
        gElmControlsAreaId.setAttributeNS(null, "transform", "translate(" + (gMaxColwidth + 40) + "," + (gActivityHeight) + ")");
    }
    else {
        if (VMLAutoGenerate === true) {
            var elmt = '<input type="button" id="MeanButtonTextId" style="display:block;position:absolute; left:' + (gMaxColwidth + 50).toFixed(0) + 'px; top:' + (gActivityHeight) + 'px; width:80px;" onclick="toggleMean();"  value="Show Mean" />';
            elmt += '<input type="button" style="display:block;position:absolute;left:' + (gMaxColwidth + 200).toFixed(0) + 'px; top:' + (gActivityHeight) + 'px; width:80px;" onclick="handleImageRequest();"     value="View" />';
            elmt += '<input type="button" style="display:block;position:absolute;left:' + (gMaxColwidth + 350).toFixed(0) + 'px; top:' + (gActivityHeight) + 'px; width:80px;" onclick="viewHelp();"  value="Help" />';
            gDivId.innerHTML += elmt;
        }
    }
    gActivityHeight += 60;
}

function toggleMean() {
    var elmVisible = document.getElementById("meanPathId").style.visibility;

    if (elmVisible === "visible") {
        document.getElementById("meanPathId").style.visibility = "hidden";
        document.getElementById("MeanButtonTextId").textContent = "Show Mean";
    }
    else {
        document.getElementById("meanPathId").style.visibility = "visible";
        document.getElementById("MeanButtonTextId").textContent = " Hide Mean";
    }

}

function toggleHelp() {
    var elmVisible = document.getElementById("meanPathId").style.visibility;

    if (elmVisible === "visible") {
        document.getElementById("meanPathId").style.visibility = "hidden";
        document.getElementById("MeanButtonTextId").textContent = "Show Mean";
    }
    else {
        document.getElementById("meanPathId").style.visibility = "visible";
        document.getElementById("MeanButtonTextId").textContent = " Hide Mean";
    }

}

function consumeKey(evt) //You must return this function for it to work in IE
{
    if (evt.preventDefault) {
        evt.preventDefault();
    }
    return false;
}

function KeyUp(evt) {
}


function KeyDown(evt) {
    trace("KeyCode" + evt.keyCode);

    switch (evt.keyCode) {
        case WKEY: {
            gLastRow = gCurrentRow;
            gCurrentRow--;
            if (gCurrentRow < 0) {
                gCurrentRow = 0;
            }
            gCurrentCol = gQuestionData[gCurrentRow].userScore - 1;
            keyboardUpdateLine();
            consumeKey(evt);
            break;
        }
        case SKEY:
        {
            gLastRow = gCurrentRow;
            gCurrentRow++;
            if (gCurrentRow >= gQuestionData.length) {
                gCurrentRow = gQuestionData.length - 1;
            }
            gCurrentCol = gQuestionData[gCurrentRow].userScore - 1;
            keyboardUpdateLine();
            consumeKey(evt);
            break;
        }
        case AKEY:
        {
            gCurrentCol--;
            if (gCurrentCol < 0) {
                gCurrentCol = 0;
            }
            keyboardUpdateLine();
            consumeKey(evt);
            break;
        }
        case DKEY:
        {
            gCurrentCol++;

            if (gCurrentCol >= gMaxOptions) {
                gCurrentCol = gMaxOptions - 1;
            }

            keyboardUpdateLine();
            consumeKey(evt);
            break;
        }
        case VKEY:
        {
            //handleImageRequest();
            //  viewImage();
            //  consumeKey(evt);
            break;
        }

        case HKEY:
        {
            viewHelp();
            consumeKey(evt);
            break;
        }
        case VIEWKEY:
        {
            toggleMean();
            consumeKey(evt);
            break;
        }

    }//End switch

}

function handleImageRequest(id) {

    viewImage();


}

function viewHelp() {
    if (gIsSVG) {
        if (document.getElementById("helpId").style.display === "block") {
            document.getElementById("helpId").style.display = "none";
            gSVGRoot.style.visibility = "block";
        }
        else {
            document.getElementById("helpId").style.display = "block";
            gSVGRoot.style.display = "none";
            top.window.scrollTo(0, 0);
        }
    }
    else {
        if (document.getElementById("helpId").style.visibility === "visible") {
            document.getElementById("helpId").style.visibility = "hidden";
        } else {
            document.getElementById("helpId").style.visibility = "visible";
            top.window.scrollTo(0, 0);
        }

    }

    return;
}

function viewImage() {
    var uri = this.data.chartUrl, graphDataString = "", sVisible;


    if (gIsSVG) {
        sVisible = parent.document.getElementById("pictureId").style.visibility;
    } else {
        sVisible = document.getElementById("pictureId").style.visibility;
    }

    for (var count = 0; count < gQuestionData.length; count++) {
        graphDataString += gQuestionData[count].userScore;
    }

    if (gIsSVG) {
        parent.document.getElementById("viewImagId").src = uri + gDefaultViewImageFile + graphDataString;
        parent.document.getElementById("imageLinkId").innerHTML = uri + gDefaultViewImageFile + graphDataString;
    } else {
        document.getElementById("viewImagId").src = uri + gDefaultViewImageFile + graphDataString;
        document.getElementById("imageLinkId").innerHTML = uri + gDefaultViewImageFile + graphDataString;
    }

    if (gIsSVG) {
        if (sVisible == "hidden") {
            parent.document.getElementById("pictureId").style.visibility = "visible";
            top.window.scrollTo(0, 0);

        } else {
            parent.document.getElementById("pictureId").style.visibility = "hidden";
        }
    } else {
        if (sVisible == "hidden") {
            document.getElementById("pictureId").style.visibility = "visible";
            top.window.scrollTo(0, 0);

        } else {
            document.getElementById("pictureId").style.visibility = "hidden";
        }

    }
}
//]]>
