/**
 * info box menu activity
 *
 * @fileOverview InfoBoxMenu - An activity for clicking on hotspots to reveal a description
 *
 * @author Tegai Lansdell
 */



OU.vml = function(data,instance,controller) {
    
   
    
    this.instance = instance || 'vml1';
    
    this.data = data || {};
        
    this.controller = controller;
    
    this.state = OU.LOADING;
    
    this.dataDir = 'data/';
    
    this.Uid = 0;
    this.globalZIndex = 0;
    
    this.init();
   
};



OU.vml.prototype.init = function()
{
   

    document.namespaces.add('v',"urn:schemas-microsoft-com:vml", "#default#VML");
   
    if(!document.documentMode || document.documentMode < 8)
    {
      var styles = document.createElement('style');
      styles.type = "text/css";
      styles.styleSheet.cssText ='v\\:*{behavior: url(#default#VML);}'; 
      document.getElementsByTagName('head')[0].appendChild(styles);
    }

    this.vmlView();
    
};

OU.vml.prototype.getUid = function ()
{
    return "vmlUid_"+this.Uid;
    
};

OU.vml.prototype.incrementUid = function ()
{
    this.Uid++;
    return "vmlUid_"+this.Uid;
};

OU.vml.prototype.getZIndex = function ()
{
    return this.globalZIndex;
    
};

OU.vml.prototype.setZIndex = function (index)
{
    this.globalZIndex=index;
    
};

OU.vml.prototype.incrementZIndex = function ()
{
    this.globalZIndex+=1;
    return this.globalZIndex;
};

OU.vml.prototype.renderVML = function(vml)
{
    //add the bits using insertAdjacentHTML
        
    document.getElementsByTagName('body')[0].insertAdjacentHTML('beforeEnd', vml);
        
};


OU.vml.prototype.viewVML = function()
{ 
    // over ride in sub class
};


OU.vml.prototype.vmlObject = function(params)
{
    
    this.data           = params.obj;
    this.vmlString      = "";
    this.zIndex         = params.that.incrementZIndex();
    this.uId            = params.that.incrementUid();
    this.w              = params.w;
    this.h              = params.h;
    this.x              = params.x  || 0;
    this.y              = params.y  || 0;
    this.link           = params.link || "";
    this.bgColour       = params.obj.bgColour || "#ffffff";
    this.borderColour   = params.obj.borderColour || "#ffffff";
    this.type           = params.obj.type;
    this.textColour     = params.obj.colour || "#000000";
    this.text           = params.obj.text || "";
    this.lineWidth      = params.obj.lineWidth || 1;
    this.defaultWidth   = params.that.data.originalWidth;
    this.defaultHeight  = params.that.data.originalHeight;    
    this.lineHeight     = params.obj.lineWidth || 1;
    OU.vml.prototype.vmlObject.prototype.render= function ()
    {
         OU.vml.prototype.renderVML(this.vmlString);
    }
    
    OU.vml.prototype.vmlObject.prototype.getVml= function ()
    {
         return this.vmlString;
    }
    
    OU.vml.prototype.vmlObject.prototype.clearVml= function ()
    {
        this.vmlString ="";
    }
    
    OU.vml.prototype.vmlObject.prototype.create= function ()
    {
        var count=0, index=0, obj = this.data;
    
      
        switch (this.type)
        {
            case "poly":
            {
               
                this.vmlString = '<v:shape ';
                if (this.link)
                {
                        this.vmlString += this.link;
                }
                this.vmlString += 'style="z-index:'+this.zIndex+';width:'+this.w+'px;height:'+
                                  this.h+'px;position:absolute;left:'+
                                  0+'px;top:'+
                                  0+'px;" strokeweight="'+obj.lineWidth+'pt"';
                
                
                this.vmlString += ' strokecolor="'+this.borderColour+'" fillcolor="'+this.bgColour;
                
                
                this.vmlString += '" coordsize="'+this.w+' '+this.h+'">';

                this.vmlString += '<v:path v="m '+obj.points[0].x+','+obj.points[0].y+' l';
            
                index=1;
                for (count=obj.points.length-1; count>0; count--, index++)
                {
                   this.vmlString += ' '+(obj.points[index].x)+','+(obj.points[index].y);
                }
                
                this.vmlString += ' x e" /></v:shape>';
                
                
                break;
            }
            case "line":
            {
                this.vmlString = '<v:shape style="position:absolute;z-index:'+
                                    this.zIndex+';width:'+
                                    this.w+'px;height:'+
                                    this.h+'px;left:'+this.x+'px;top:'+
                                    this.y+'px" strokecolor="'+
                                    this.borderColour+'" strokeweight="'+
                                    obj.lineWidth+'pt" coordsize="'+this.w+' '+this.h+'">';

                this.vmlString += '<v:path v="m '+obj.points[0].x+','+obj.points[0].y+' l';
            
                index=1;
                for (count=obj.points.length-1; count>0; count--, index++)
                {
                   this.vmlString += ' '+obj.points[index].x+','+obj.points[index].y;
                }
                
                this.vmlString += ' e "/></v:shape>';
                
                break;
            }
            case "text":
            {
                 //TODO: add support for bullets  
    
                this.vmlString  = '<v:group style="line-height:'+this.lineHeight+';z-index:'+this.zIndex+';width:'+this.w+'px;height:'+this.h+'px;position:absolute;left:'+this.x+'px;top:'+this.y+'px">';
                this.vmlString += '<v:textbox ';
                 if (this.link)
                {
                        this.vmlString += this.link;
                }
                this.vmlString +=' ><span style="color:'+this.textColour+'; font-size:'+obj.fontSize+'; font-family:'+obj.fontFamily +'; font-style:'+obj.fontStyle+'">';
                this.vmlString += this.text;
                this.vmlString += '</span></v:textbox>'; 
                this.vmlString += ' </v:group>';

                break;
            }
            
            case "circle":
            case "oval":
            {
              
                this.vmlString = '<v:group ';
                if (this.link)
                {
                   this.vmlString += this.link; 
                }  
                
                
                this.vmlString += ' style="z-index:'+this.zIndex+';width:'+this.w+'px;height:'+ 
                                    this.h+'px;position:absolute;left:'+(this.x)+'px;top:'+
                                    this.y+ 'px;" coordorigin="'+this.x+','+
                                    this.y+'" coordsize="'+this.w+','+this.h+'">';    
                
                this.vmlString += '<v:oval style="z-index:'+this.zIndex+';width:'+
                                    this.w+'px;height:'+ this.h+'px;left:'+
                                    this.x+'px;top:'+this.y+ 'px;"';
                
               
                this.vmlString += ' strokecolor="'+this.borderColour+'" fillcolor="'+this.bgColour;
               
                this.vmlString += '" /></v:group>';                              
                                              
        
                
               break;
            }
            case "rects":
            {
               
                             
               this.vmlString = '<v:group ';
               if (this.link)
               {
                  this.vmlString += this.link; 
               }   
               
               this.vmlString += ' style="z-index:'+this.zIndex+';width:'+this.w+'px;height:'+ this.h+'px;position:absolute;left:'+this.x+'px;top:'+this.y+ 'px;" coordorigin="'+this.x+','+this.y+'" coordsize="'+(this.w)+','+(this.h)+'">';    
              
			  
               this.vmlString += '<v:roundrect style="width:'+this.w+'px;height:'+ this.h+'px;left:'+this.x+'px;top:'+this.y+ 'px;" ';
               this.vmlString += ' strokecolor="'+this.borderColour+'" fillcolor="'+this.bgColour; 
               this.vmlString += '" /></v:group>';
			   
			  
               this.zIndex++;
             
               
              break;  
            }
            case "rect":
            {
                 this.vmlString = '<v:group ';
               if (this.link)
               {
                  this.vmlString += this.link; 
               }   
               
               this.vmlString += 'style="z-index:'+this.zIndex+';width:'+this.w+'px;height:'+ this.h+'px;position:absolute;left:'+0+'px;top:'+0+
                   'px;" coordorigin="0 0" coordsize="'+this.w+' '+this.h+'">';    
            
              this.vmlString+= '<v:roundrect style="width:'+this.w+'px;height:'+this.h+'px;left:'+this.x+'px;top:'+this.y+
                               'px" fillcolor="'+this.bgColour+'" strokecolor="'+this.borderColour+'" strokeweight="1pt" ';
               this.vmlString += ' /></v:group>';
               this.zIndex++;
			   
			 
               // Note the roundedrect chops off the top and bottom if the strokeWidth is not correctly defined.
               break;
            }
            
            case "rect-simple":
            {  
               this.vmlString = '<v:group ';
               if (this.link)
               {
                  this.vmlString += this.link; 
               }   
               
               if (this.borderColour===undefined){this.borderColour="white";}
               
               this.vmlString += 'style="z-index:'+this.zIndex+';width:'+this.w+'px;height:'+ this.h+'px;position:absolute;left:'+this.x+'px;top:'+this.y+ 'px;" coordorigin="'+this.x+','+this.y+'" coordsize="'+this.w+','+this.h+'">';    
               this.vmlString += '<v:rect style="z-index:'+this.zIndex+';width:'+this.w+'px;height:'+ this.h+'px;left:'+this.x+'px;top:'+this.y+ 'px;" ';
               this.vmlString += ' strokecolor="'+this.borderColour+'" fillcolor="'+this.bgColour;
               this.vmlString += '" /></v:group>';
               this.zIndex++;
             
               break;
            }
            default:
                console.log("Error unknown type");
                vmlString="Error Unknown type";
        }
        
        
    }
};



OU.vml.InfoBoxMenu = function(data,instance,controller) {

  
    OU.vml.InfoBoxMenu.prototype.vmlView = function () {
       var self = this ,  count=0, subCount=0, groupCount=0, txtCount=0, bDefaultText=false;
       
       this.groupArray = [];
       this.linkArray = [];
       
       this.linkArrayClicked = [];
       
       this.groupIdList = [];
       this.zIndex =0;
       this.textXOffset = 16;
       this.textYOffset = 8;
       this.textMargin = 10;
       this.defaultDescription = this.data.defaultDescription;
 
       this.w = this.data.originalWidth;
       this.h = this.data.originalHeight;
      
       
      
       
       subCount=0;
       for (count=this.data.menuItems.length;count>0;count--,subCount++ )
       {
           this.groupIdList[subCount]=this.data.menuItems[subCount].linkId;
           
           if (this.defaultDescription === this.groupIdList[subCount]) {
               bDefaultText = true;
           }
           
       }
       
       if (bDefaultText === false){
           this.groupIdList.push(this.defaultDescription);
          
       }
       
       
       
       subCount=0;
       //Next copy  all the link IDs to the group array
       
       
       
       for (count=this.groupIdList.length;count>0;count--,subCount++ )
       {
           this.groupArray[this.groupIdList[subCount]] = [];
           
           
           if (this.data.bgObjects){
            for (var bgCount=0;bgCount<this.data.bgObjects.length;bgCount++){
             //bg objects
              for (var bgSubCount=0; bgSubCount<this.data.bgObjects[bgCount].linkId.length; bgSubCount++){
                if (this.groupIdList[subCount] === this.data.bgObjects[bgCount].linkId[bgSubCount] || this.data.bgObjects[bgCount].linkId[bgSubCount] === "ALLID")
                {
                    var t = new OU.vml.prototype.vmlObject({
                        that:this,
                        obj:this.data.bgObjects[bgCount],
                        w:(this.data.bgObjects[bgCount].w)?this.data.bgObjects[bgCount].w:((this.data.bgObjects[bgCount].r)?this.data.bgObjects[bgCount].r*2:this.w),
                        h:(this.data.bgObjects[bgCount].h)?this.data.bgObjects[bgCount].h:((this.data.bgObjects[bgCount].r)?this.data.bgObjects[bgCount].r*2:this.h),
                        x:(this.data.bgObjects[bgCount].x)?this.data.bgObjects[bgCount].x:((this.data.bgObjects[bgCount].cx)?this.data.bgObjects[bgCount].cx-this.data.bgObjects[bgCount].r:0),
                        y:(this.data.bgObjects[bgCount].y)?this.data.bgObjects[bgCount].y:((this.data.bgObjects[bgCount].cy)?this.data.bgObjects[bgCount].cy-this.data.bgObjects[bgCount].r:0)
                    });
                    
                    if (t.type==="text"){t.y -= this.textYOffset;}
                                        
                    t.create();
                    
                    var str = t.getVml();
                    
                    
                    this.groupArray[this.groupIdList[subCount]].push(str);
                   
                    this.zIndex = this.getZIndex();
                   
                }
              }
            }
           }
           
           //Links
                    
         
           {
            
            
             var lsubCount=0;
            for (var lcount=this.data.menuItems.length;lcount>0;lcount--,lsubCount++ )
            {
                
                 var t = new OU.vml.prototype.vmlObject({
                        that:this,
                        obj:this.data.menuItems[lsubCount],
                        w:(this.data.menuItems[lsubCount].w)?this.data.menuItems[lsubCount].w:((this.data.menuItems[lsubCount].r)?this.data.menuItems[lsubCount].r*2:this.w),
                        h:(this.data.menuItems[lsubCount].h)?this.data.menuItems[lsubCount].h:((this.data.menuItems[lsubCount].r)?this.data.menuItems[lsubCount].r*2:this.h),
                        x:(this.data.menuItems[lsubCount].x)?this.data.menuItems[lsubCount].x:((this.data.menuItems[lsubCount].cx)?this.data.menuItems[lsubCount].cx-this.data.menuItems[lsubCount].r:0),
                        y:(this.data.menuItems[lsubCount].y)?this.data.menuItems[lsubCount].y:((this.data.menuItems[lsubCount].cy)?this.data.menuItems[lsubCount].cy-this.data.menuItems[lsubCount].r:0),
                        link:' onclick ="OU.vml.InfoBoxMenu.event(\''+this.data.menuItems[lsubCount].linkId+'\');"'
                    });
                    
                                        
                    if (this.groupIdList[subCount]===this.groupIdList[lsubCount])
                    {
                       
                       t.bgColour = this.data.menuItems[lsubCount].bgColourActive;
                       t.borderColour = this.data.menuItems[lsubCount].borderColourActive;


                    } else{
                     
                       t.bgColour = this.data.menuItems[lsubCount].bgColour;
                       t.borderColour = this.data.menuItems[lsubCount].borderColour;
                    }
                    
                    t.create();
                                        
                    this.groupArray[this.groupIdList[subCount]].push(t.getVml());

               this.zIndex = this.getZIndex();
               
                groupCount=0;
           
                for (txtCount=this.data.menuItems[lsubCount].label.length-1; txtCount>=0; txtCount--, groupCount++)
                {
                   var width=(this.data.menuItems[lsubCount].w)?this.data.menuItems[lsubCount].w:(this.data.menuItems[lsubCount].r)?this.data.menuItems[lsubCount].r*2:this.w;
                   var height=(this.data.menuItems[lsubCount].h)?this.data.menuItems[lsubCount].h:(this.data.menuItems[lsubCount].ch)?this.data.menuItems[lsubCount].ch:this.h;
                   
                   var xpos =(this.data.menuItems[lsubCount].label[groupCount].x)?this.data.menuItems[lsubCount].label[groupCount].x:this.data.menuItems[lsubCount].cx ;
                   var ypos =(this.data.menuItems[lsubCount].label[groupCount].y)?this.data.menuItems[lsubCount].label[groupCount].y:this.data.menuItems[lsubCount].cy ;
                   
                   
                    var t = new OU.vml.prototype.vmlObject({
                        that:this,
                        obj:this.data.menuItems[lsubCount].label[groupCount],
                        w:width,
                        h:height,
                        x:xpos,
                        y:ypos,
                        link:' onclick ="OU.vml.InfoBoxMenu.event(\'' + this.data.menuItems[lsubCount].linkId+'\');" '
                    });
                   t.y -= this.textYOffset;
                   
                   t.type = "text";
                   
                   if (this.groupIdList[subCount]===this.groupIdList[lsubCount])
                   {
                   
                    t.textColour = this.data.menuItems[lsubCount].label[groupCount].colourActive;
                    
                    

                   }else{
                       
                       t.textColour = this.data.menuItems[lsubCount].label[groupCount].colour;
                  
                  
                   }
                   
                   t.create();
                                  
                   this.groupArray[this.groupIdList[subCount]].push(t.getVml());
                   this.zIndex = this.getZIndex();
                   
                }

             }
           }
           
           
           //fg Objects
           if (this.data.fgObjects){
            for (var fgCount=0;fgCount<this.data.fgObjects.length;fgCount++){
             //fg objects
             for (var fgSubCount=0; fgSubCount<this.data.fgObjects[fgCount].linkId.length; fgSubCount++){
                if (this.groupIdList[subCount] === this.data.fgObjects[fgCount].linkId[fgSubCount] || this.data.fgObjects[fgCount].linkId[fgSubCount] === "ALLID")
                {
                    
                    
                    var t = new OU.vml.prototype.vmlObject({
                        that:this,
                        obj:this.data.fgObjects[fgCount],
                        w:(this.data.fgObjects[fgCount].w)?this.data.fgObjects[fgCount].w:((this.data.fgObjects[fgCount].r)?this.data.fgObjects[fgCount].r*2:this.w),
                        h:(this.data.fgObjects[fgCount].h)?this.data.fgObjects[fgCount].h:((this.data.fgObjects[fgCount].r)?this.data.fgObjects[fgCount].r*2:this.h),
                        x:(this.data.fgObjects[fgCount].x)?this.data.fgObjects[fgCount].x:((this.data.fgObjects[fgCount].cx)?this.data.fgObjects[fgCount].cx-this.data.fgObjects[fgCount].r:0),
                        y:(this.data.fgObjects[fgCount].y)?this.data.fgObjects[fgCount].y:((this.data.fgObjects[fgCount].cy)?this.data.fgObjects[fgCount].cy-this.data.fgObjects[fgCount].r:0)
                    });
                    
                    if (t.type==="text"){t.y -= this.textYOffset;}
                                        
                    t.create();
                    
                    var str = t.getVml();
                    
                    
                    this.groupArray[this.groupIdList[subCount]].push(str);
                 
                    this.zIndex = this.getZIndex();
                    
                    
                }
              }
            }
           }
           //description
           for (var descriptionCount=0;descriptionCount<this.data.description.length;descriptionCount++){
            //bg objects
            if (this.groupIdList[subCount] === this.data.description[descriptionCount].linkId)
            {
                for (var desSubCount=0; desSubCount< this.data.description[descriptionCount].text.length; desSubCount++)
                {
                   
                 
                   var width=(this.data.description[descriptionCount].text[desSubCount].w)?this.data.description[descriptionCount].text[desSubCount].w:this.w;
                   var height=(this.data.description[descriptionCount].text[desSubCount].h)?this.data.description[descriptionCount].text[desSubCount].h:this.h;
                   
                   var xpos =this.data.description[descriptionCount].text[desSubCount].x;
                   var ypos =this.data.description[descriptionCount].text[desSubCount].y - this.textYOffset;
                   
                   
                    var t = new OU.vml.prototype.vmlObject({
                        that:this,
                        obj:this.data.description[descriptionCount].text[desSubCount],
                        w:width,
                        h:height,
                        x:xpos,
                        y:ypos
                    });
                   
                   t.text = this.data.description[descriptionCount].text[desSubCount].str;
                   t.type = "text";
                  
                   
                   t.create();
                                    
                   this.groupArray[this.groupIdList[subCount]].push(t.getVml());

                   this.zIndex = this.getZIndex();
                 
                   // this.zIndex++;
                }
            }
           }
           
       }
         
       self.render();
    };
    
    OU.vml.InfoBoxMenu.event = function (id)
    {
        
                
        var divDom = document.getElementsByTagName('div');
        
        for (var count =0; count<divDom.length; count++)
            {
                if ((divDom[count].id).substr(0,4) === "ifa_"){
                    divDom[count].style.left = "-999999px";
                }
                
            }
        
        document.getElementById("ifa_"+id).style.left = "0px";
       
        
    }
     
    OU.vml.InfoBoxMenu.prototype.eventLink = function (id)
    {
        
                
        var divDom = document.getElementsByTagName('div');
        
        for (var count =0; count<divDom.length; count++)
            {
                if ((divDom[count].id).substr(0,4) === "ifa_"){
                    divDom[count].style.left = "-999999px";
                }
                
            }
        
        document.getElementById("ifa_"+id).style.left = "0px";
       
        
    }
    
 
    
    OU.vml.InfoBoxMenu.prototype.render = function () {
        
      var count=0, subCount=0, groupCount=0, groupSubCount=0, groupVisible = 0, vml = "";   
        
        
       for (count=this.groupIdList.length;count>0;count--,subCount++ )
       {
                
           groupVisible = -999999;
           if (this.defaultDescription === this.groupIdList[subCount]) {
              groupVisible = 0;
           }
           
           vml = '<div id="ifa_'+this.groupIdList[subCount]+'" style="position:absolute;left:'+groupVisible+'px;top:0px;width:'+this.data.originalWidth+'px;height:'+this.data.originalHeight+'px;">';
                     
           groupSubCount=0;
           
           for (groupCount=this.groupArray[this.groupIdList[subCount]].length; groupCount>0; groupCount--, groupSubCount++)
            {
                
                vml += this.groupArray[this.groupIdList[subCount]][groupSubCount];
           
               
            }
            
            vml += "</div>";
            this.renderVML(vml);
       }
        
      
    };
    
 
    
   OU.base(this, data, instance, controller);
};
OU.inherits(OU.vml.InfoBoxMenu, OU.vml);
