"use strict";

var _useVLE = true;
var _elements = {};
var _activity = el('#activity');
var _selectedMarket = void 0;
var _values = {};
var _last = void 0;
var _lastCity = void 0;

var _revealButtonText = {
    show: "Save and reveal answer",
    hide: "Hide answer"
};

var _markets = {
    Amsterdam: [{
        name: "Euronext",
        cap: 4.36
    }],
    Frankfurt: [{
        name: "Deutsche Boerse",
        cap: 2.22
    }],
    "Hong Kong": [{
        name: "Hong Kong Stock Exchange",
        cap: 4.46
    }],
    London: [{
        name: "London Stock Exchange",
        cap: 4.38
    }],
    "New York": [{
        name: "NASDAQ",
        cap: 10.93
    }, {
        name: "New York Stock Exchange",
        cap: 23.12
    }],
    Shanghai: [{
        name: "Shanghai Stock Exchange",
        cap: 5.01
    }],
    Shenzhen: [{
        name: "Shenzhen Stock Exchange ",
        cap: 3.49
    }],
    Tokyo: [{
        name: "Tokyo Stock Exchange",
        cap: 6.22
    }],
    Toronto: [{
        name: "Toronto Stock Exchange",
        cap: 2.29
    }]
};

window.onload = function () {
    init();
};

function init() {
    "use strict";

    initSVG();
    initDivs();
}

function initSVG() {
    "use strict";

    var div = document.createElement('div');
    div.classList.add('media-div');
    div.id = "map-div";

    var xhr = new XMLHttpRequest();
    xhr.open('get', "img/b294_u02_map_cities.svg", true);
    xhr.onreadystatechange = function () {
        if (xhr.readyState != 4) return;
        var svg = xhr.responseXML.documentElement;
        svg = document.importNode(svg, true);
        svg.setAttribute('id', 'map');
        svg.setAttribute('viewBox', "0 0 510 287.2");
        svg.setAttribute('width', '100%');
        div.appendChild(svg);
        /* ie svg bug workaround */
        var styleTags = svg.querySelectorAll('style');
        for (var i = styleTags.length; i--;) {
            styleTags[i].textContent += '';
        }
        addListeners();
    };
    xhr.send();

    _activity.appendChild(div);

    return div;
}

function initDivs() {
    var html = "";

    for (var market in _markets) {
        if (_markets.hasOwnProperty(market)) {
            var id = adjust(market);
            var info = _markets[market];
            html += "\n                <div id=\"exchange-" + id + "\" class=\"hidden\">\n                ";

            for (var i = 0; i < info.length; i++) {
                var name = info[i].name.trim();
                var cap = info[i].cap;
                var number = _markets[market].length > 1 ? "" + i : "";
                var logo = "./img/b294_u02_" + id + number + "_logo.svg";
                var bar = "./img/b294_u02_" + id + number + "_bar.svg";
                var barAlt = name + " market capital bar chart: " + cap + " trillions of US dollars";
                var logoAlt = name + " logo";
                html += "\n                    <div class=\"info\">\n                        <div class=\"exchange\">\n                            <span class=\"name\">" + name + "</span>" + market + "</span>\n                        </div>\n                        <div class=\"cap\">\n                            <span class=\"cap\">" + cap + "</span><b>(Trillions of US $)</b><br/>Market capitalisation in 2018\n                        </div>\n                        <img src=\"" + logo + "\" class=\"logo\" alt=\"" + logoAlt + "\" title=\"" + logoAlt + "\"/>\n                        <div class=\"bar\">\n                            <img src=\"" + bar + "\" title=\"" + barAlt + "\" alt=\"" + barAlt + "\"/>\n                        </div>\n                    </div>\n                ";
            }

            html += "\n                </div>\n            ";
        }
    }
    el("#market-info").innerHTML = html;
}

function addListeners() {
    var _loop = function _loop(market) {
        if (_markets.hasOwnProperty(market)) {
            var elements = el("." + adjust(market));
            for (var i = 0; i < elements.length; i++) {
                if (elements[i].classList.contains("click") || elements[i].classList.contains("city-blob")) {
                    elements[i].addEventListener("click", function (e) {
                        click(e, market);
                    });
                    elements[i].addEventListener('keydown', function (e) {
                        checkEnterSpace(e, market);
                    });
                }
            }
        }
    };

    for (var market in _markets) {
        _loop(market);
    }
}

function checkEnterSpace(e, market) {
    console.log("yes");
    if (e.keyCode === 13 || e.keyCode === 32) {
        e.preventDefault();
        click(e, market);
    }
}

function click(e, market) {
    market = adjust(market);
    if (_last) {
        _last.classList.add("hidden");
    }
    if (_lastCity) {
        _lastCity.classList.add("no-show");
    }
    var div = el("#exchange-" + market);
    div.classList.remove("hidden");
    _last = div;
    var cityOutline = el("#outline-" + market);
    cityOutline.classList.remove("no-show");
    _lastCity = cityOutline;
    ///el("." + market)[0].focus();
}

// get element
function el(arg) {
    var search = arg.substring(1);
    var found = undefined;

    if (_elements.hasOwnProperty(search)) {
        found = _elements[search];
    } else {
        if (arg.substring(0, 1) === "#") {
            found = document.getElementById(search);
        } else if (arg.substring(0, 1) === "$") {
            found = document.getElementsByName(search);
        } else if (arg.substring(0, 1) === ".") {
            found = document.getElementsByClassName(search);
        }
        _elements[search] = found;
    }
    return found;
}

function adjust(text) {
    return text.toLowerCase().replace(" ", "");
}
