"use strict";

var _useVLE = true;
var _elements = {};
var _activity = el('#activity');
var _selectedMarket = void 0;
var _values = {};
var _revealButtonText = {
    show: "Save and reveal answer",
    hide: "Hide answer"
};

var _columns = {
    Class: [{
        name: "Investment grade",
        rowSpan: 4
    }, {
        name: "Below investment grade (junk bonds)",
        rowSpan: 6
    }],
    Grade: [{
        name: "AAA",
        group: "a"
    }, {
        name: "AA+, AA, AA-",
        group: "a"
    }, {
        name: "A+, A, A-",
        group: "a"
    }, {
        name: "BBB+, BBB, BBB-",
        group: "a"
    }, {
        name: "BB+, BB",
        group: "b"
    }, {
        name: "B",
        group: "b"
    }, {
        name: "CCC",
        group: "b"
    }, {
        name: "CC",
        group: "c"
    }, {
        name: "SD",
        group: "c"
    }, {
        name: "D",
        group: "c"
    }],
    "Capacity to meet financial commitments": ["Extremely strong", "Very strong", "Strong", "Adequate", "Facing major future uncertainties", "Facing major uncertainties", "Currently vulnerable", "Currently highly vulnerable", "Selective default", "In default"]
};

var _popups = {
    "a": "\n        Ratings from AAA to A means there is a very limited probability that the issuer will \n        default in the long term (say in the next 5 years). The issuer has \u2018extremely strong\u2019 \n        (AAA) to \u2018strong\u2019 (A)  capacity to meet financial commitments. Ratings with a relatively \n        low risk of default correspond to \u2018Investment grade\u2019. \n        ",
    "b": "\n        Bonds with credit ratings below the BBB\u2212 grade are considered low credit quality. \n        Otherwise known as \u2018junk bonds\u2019, they are viewed as significantly speculative. These \n        ratings indicate that the issuer has uncertain  capacity to meet future financial \n        commitments, and it is likely  to be negatively affected by adverse economic conditions. \n        Junk bonds carry a significant degree of risk, since their rating indicates that the \n        issuer is facing major  uncertainties.\n        ",
    "c": "\n        CC rating signals an issuer that is highly vulnerable and faces imminent default. \n        Ratings below CC indicate that the issuer is already insolvent, with no prospect for \n        recovery. While D rating indicates a general default of the issuer, SD stands for \n        \u2018selective default\u2019, meaning that the issuer is defaulting only on specific types of \n        financial obligations.\n        ",
    "none": ""
};

window.onload = function () {
    init();
};

function init() {
    "use strict";

    initTable();
    addListeners();
}

function initTable() {
    var rowCount = Object.keys(_columns["Grade"]).length;
    var index = {};
    var count = {};

    var html = "\n        <table>\n        ";

    for (var column in _columns) {
        if (_columns.hasOwnProperty(column)) {
            index[column] = 0;
            count[column] = 0;
            html += "\n                <th>" + column + "</th>\n            ";
        }
    }
    for (var row = 0; row < rowCount; row++) {
        html += "\n            <tr>\n            ";
        for (var _column in _columns) {
            if (_columns.hasOwnProperty(_column)) {
                if (_column === "Class") {
                    if (count[_column] < 1) {
                        var cell = _columns[_column][index[_column]];
                        count[_column] = cell.rowSpan - 1;
                        html += "\n                            <td rowSpan=\"" + cell.rowSpan + "\" class=\"" + _column.toLowerCase() + "\">" + cell.name + "</td>\n                        ";
                        index[_column]++;
                    } else {
                        count[_column]--;
                    }
                } else if (_column === "Grade") {
                    var _cell = _columns[_column][row];
                    html += "\n                        <td class=\"click " + _cell.group + " " + _column.toLowerCase() + "\" tabIndex=\"0\">" + _cell.name + "</td>\n                    ";
                } else {
                    var _cell2 = _columns[_column][row];
                    html += "\n                        <td class=\"capacity\">" + _cell2 + "</td>\n                    ";
                }
            }
        }
        html += "\n            </tr>\n            ";
    }
    html += "        \n        </table>\n        ";

    el("#activity").innerHTML = html;
}

function addListeners() {
    var _loop = function _loop(popup) {
        if (_popups.hasOwnProperty(popup)) {
            var elements = el("." + popup);
            for (var i = 0; i < elements.length; i++) {
                elements[i].addEventListener("click", function (e) {
                    click(e, popup);
                });
                elements[i].addEventListener('keypress', function (e) {
                    checkEnterSpace(e, popup);
                });
            }
        }
    };

    for (var popup in _popups) {
        _loop(popup);
    }
}

function checkEnterSpace(e, popup) {
    "use strict";

    if (e.keyCode === 13 || e.keyCode === 32) {
        e.preventDefault();
        click(e, popup);
    }
}

function click(e, popup) {
    el("#info").classList.remove("hidden");
    el("#text").innerHTML = _popups[popup];
}

// get element
function el(arg) {
    var search = arg.substring(1);
    var found = undefined;

    if (_elements.hasOwnProperty(search)) {
        found = _elements[search];
    } else {
        if (arg.substring(0, 1) === "#") {
            found = document.getElementById(search);
        } else if (arg.substring(0, 1) === "$") {
            found = document.getElementsByName(search);
        } else if (arg.substring(0, 1) === ".") {
            found = document.getElementsByClassName(search);
        }
        _elements[search] = found;
    }
    return found;
}

function adjust(text) {
    return text.toLowerCase().split(" ")[0];
}
