"use strict";

var _useVLE = true;
var _elements = {};
var _activity = el('#activity');
var _selectedMarket = void 0;
var _values = {};
var _revealButtonText = {
    show: "Save and reveal answer",
    hide: "Hide answer"
};

var _markets = {
    "Financial-Market": {
        heading: "Financial Market",
        type: 0,
        entered: "",
        text: "\n            The place in which operators with excess funds (called lenders or investors) exchange \n            their resources with organisations that are looking to raise the funds required for \n            their objectives (called borrowers). \n        "
    },
    "Capital-Market": {
        heading: "Capital Market",
        type: 1,
        entered: "",
        text: "\n            Where financial securities like stock and bonds are traded. Both businesses and \n            governments can issue (sell) securities on the capital markets in order to raise funds.\n        "
    },
    "Money-Market": {
        heading: "Money Market",
        type: 1,
        entered: "",
        text: "\n            The section of financial market that deals with the trading of assets characterised by a \n            high level of liquidity. Examples of these financial instruments are commercial papers, \n            certificates of deposit, treasury bills, cash deposits, and sale and repurchase \n            agreements.\n        "
    },
    "Stock-Market": {
        heading: "Stock Market",
        type: 2,
        entered: "",
        text: "\n            The portion of the Capital Market in which companies stocks are traded. \n        "
    },
    "Bond-Market": {
        heading: "Bond Market",
        type: 2,
        entered: "",
        text: "\n            The portion of the Capital Market in which bonds issued by both companies and \n            governments are traded.\n        "
    },
    "Primary-Stock-Market": {
        heading: "Primary Stock Market",
        type: 3,
        entered: "",
        text: "\n            The Primary stock market, or \u2018new issue market\u2019, is where newly created financial \n            assets in the form of stocks are put on exchange.      \n        "
    },
    "Secondary-Stock-Market": {
        heading: "Secondary Stock Market",
        type: 3,
        entered: "",
        text: "\n            Where previously issued financial assets in the form of stocks are exchanged and where \n            transactions between investors occur. It is the market in which usually most of the \n            trading in stocks takes place.\n        "
    },
    "Primary-Bond-Market": {
        heading: "Primary Bond Market",
        type: 3,
        entered: "",
        text: "\n            The Primary bond market, or \u2018new issue market\u2019, is where newly created financial assets \n            in the form of bonds are put on exchange.\n        "
    },
    "Secondary-Bond-Market": {
        heading: "Secondary Bond Market",
        type: 3,
        entered: "",
        text: "\n            Where previously issued financial assets in the form of bonds are exchanged and where \n            transactions between investors occur.\n        "
    },
    "Over-the-counter-Stock-Market-(OTC)": {
        heading: "Over-the-counter Stock Market (OTC)",
        type: 3,
        entered: "",
        text: "\n            The OTC market is not physically recognisable. Instead, it comprises networks of \n            bilateral trading relationships between dealers. It is not subject to strict regulation \n            about the quantity and quality of the assets traded.\n        "
    },
    "Over-the-counter-Bond-Market-(OTC)": {
        heading: "Over-the-counter Bond Market (OTC)",
        type: 3,
        entered: "",
        text: "\n            The OTC market is not physically recognisable. Instead, it comprises networks of \n            bilateral trading relationships between dealers. It is not subject to strict regulation \n            about the quantity and quality of the assets traded.\n        "
    }
};

window.onload = function () {
    init();
};

function init() {
    "use strict";

    initSVG();
    loadValues();
}

function setValues() {
    for (var market in _values) {
        if (_values.hasOwnProperty(market)) {
            _markets[market].entered = _values[market];
        }
    }
}

function initSVG() {
    "use strict";

    var div = document.createElement('div');
    div.classList.add('media-div');
    div.id = "map-div";

    var xhr = new XMLHttpRequest();
    xhr.open('get', "img/tree.svg", true);
    xhr.onreadystatechange = function () {
        if (xhr.readyState != 4) return;
        var svg = xhr.responseXML.documentElement;
        svg = document.importNode(svg, true);
        svg.setAttribute('id', 'tree');
        svg.setAttribute('viewBox', "0 0 533.47 302.13");
        svg.setAttribute('width', '100%');
        svg.setAttribute('margin', '0');
        div.appendChild(svg);
        /* ie svg bug workaround */
        var styleTags = svg.querySelectorAll('style');
        for (var i = styleTags.length; i--;) {
            styleTags[i].textContent += '';
        }
        addListeners();
    };
    xhr.send();

    _activity.appendChild(div);

    return div;
}

function addListeners() {
    el("#reveal").addEventListener("click", reveal);

    var _loop = function _loop(market) {
        if (_markets.hasOwnProperty(market)) {
            var elements = el("." + market);
            for (var i = 0; i < elements.length; i++) {
                elements[i].addEventListener("click", function (e) {
                    click(e, market);
                });
                elements[i].addEventListener('keypress', function (e) {
                    checkEnterSpace(e, market);
                });
            }
        }
    };

    for (var market in _markets) {
        _loop(market);
    }
}

function reveal() {
    if (el("#reveal").innerHTML === _revealButtonText.show) {
        el("#reveal").innerHTML = _revealButtonText.hide;
        _markets[_selectedMarket].entered = el("#definition").value;
        el("#text").classList.remove("hidden");
        el("#text").innerHTML = _markets[_selectedMarket].text;
        if (_values[_selectedMarket] !== _markets[_selectedMarket].entered) {
            _values[_selectedMarket] = _markets[_selectedMarket].entered;
            saveValues();
        }
    } else {
        el("#text").innerHTML = "";
        el("#text").classList.add("hidden");
        el("#reveal").innerHTML = _revealButtonText.show;
    }
}

function checkEnterSpace(e, market) {
    "use strict";

    if (e.keyCode === 13 || e.keyCode === 32) {
        e.preventDefault();
        click(e, market);
    }
}

function click(e, market) {
    if (_selectedMarket) {
        el("#info").classList.remove("type" + _markets[_selectedMarket].type);
    }
    _selectedMarket = market;
    el("#info").classList.add("type" + _markets[_selectedMarket].type);
    el("#heading").innerHTML = _markets[market].heading;
    el("#definition").value = _markets[market].entered;
    el("#info").classList.remove("hidden");
    el("#text").classList.add("hidden");
    el("#text").innerHTML = "";
    el("#reveal").innerHTML = _revealButtonText.show;
}

// get element
function el(arg) {
    var search = arg.substring(1);
    var found = undefined;

    if (_elements.hasOwnProperty(search)) {
        found = _elements[search];
    } else {
        if (arg.substring(0, 1) === "#") {
            found = document.getElementById(search);
        } else if (arg.substring(0, 1) === "$") {
            found = document.getElementsByName(search);
        } else if (arg.substring(0, 1) === ".") {
            found = document.getElementsByClassName(search);
        }
        _elements[search] = found;
    }
    return found;
}

function saveValues() {
    if (_useVLE) {
        submitToVLE({ "blk01_u02_ses01_a1_7": JSON.stringify(_values) });
    } else {
        localStorage.setItem('blk01_u02_ses01_a1_7', JSON.stringify(_values));
    }
}

function loadValues() {
    "use strict";

    if (_useVLE) {
        retrieveFromVLE(['blk01_u02_ses01_a1_7']);
    } else {
        var values = JSON.parse(localStorage.getItem("blk01_u02_ses01_a1_7"));
        if (values) {
            _values = values;
            setValues();
        }
    }
}

function submitToVLE(values) {
    // use these to reference students saved data
    var course_id = VLE.get_param('course_id') || VLE.get_param('_c');
    var document_id = VLE.get_param('document_id') || VLE.get_param('_i');
    var activity_id = VLE.get_param('activity_id') || VLE.get_param('_a');

    // an empty variable not using anything here
    var previous_values = undefined;

    // call the vle api to save the students text entty
    VLE.set_server_data(true, values, function () {}, function (msg) {
        if (!msg === null) {
            console.log("Failed to save to VLE", msg);
        }
    }, previous_values, null, activity_id, document_id, course_id);
}

function retrieveFromVLE(data) {
    // use these to grab students for this activity from vle
    var course_id = VLE.get_param('course_id') || VLE.get_param('_c');
    var document_id = VLE.get_param('document_id') || VLE.get_param('_i');
    var activity_id = VLE.get_param('activity_id') || VLE.get_param('_a');

    VLE.get_server_data(true, data, function (values) {
        loadOK(values);
    }, function (msg) {
        if (!msg === null) {
            console.log("Failed to load from VLE", msg);
        }
    }, activity_id, document_id, course_id);
}

function loadOK(values) {
    if (values['blk01_u02_ses01_a1_7']) {
        _values = JSON.parse(values['blk01_u02_ses01_a1_7']);
        setValues();
    }
}

function adjust(text) {
    return text.toLowerCase().split(" ")[0];
}
