/*global data */
var Activity = (function () {
    var _attempts = 0;
    var _maxAttempts = 1;

    function Activity(data, rowCount) {
        var container = document.createElement("div");
        container.id = "container";
        document.body.appendChild(container);

        var table = document.createElement("table");
        container.appendChild(table);

        var i, cell, count = 0;
        for (i = 0; i < rowCount; ++i) {
            var row = table.insertRow(i);

            if (i === 0) {
                for (j = 0; j < data.titles.length; ++j) {
                    cell = row.insertCell();
                    cell.id = "header";
                    cell.innerHTML = data.titles[j];
                }
            } else {
                cell = row.insertCell();

                if (count == 1) {
                    cell.innerHTML = "<input id='data" + count + "' type='text'/>" + data.texts[count];
                } else {
                    cell.innerHTML = data.texts[count] + "<input id='data" + count + "' type='text'/>";
                }

                count++;
            }
        }

        window.addEventListener("keypress", function (e) {
            if (e.charCode === 0 || e.charCode === 45 || e.charCode === 46) {
                return true;
            } else if (e.charCode < 48 || e.charCode > 57) {
                e.preventDefault();
                return false;
            }
        });

        var checkButton = document.createElement("input");
        checkButton.id = "submit";
        checkButton.type = "button";
        checkButton.value = "Check";
        checkButton.addEventListener("click", function () {
            submit();
        });
        document.body.appendChild(checkButton);
    }

    function submit() {
        _attempts++;

        var $feedback = document.getElementById("feedback");
        if ($feedback !== null) {
            $feedback.parentNode.removeChild($feedback);
        }

        var inputs = document.querySelectorAll("input[type=text]");
        var responses = [], results = [], i;

        responses[0] = Math.round(inputs[0].value);
        responses[1] = inputs[1].value ? parseFloat(inputs[1].value).toFixed(1) : 0;

        for (i = 0; i < inputs.length; ++i) {
            results[i] = false;

            if (responses[i] == data.answers[i]) {
                results[i] = true;
                inputs[i].value = responses[i];
            } else {
                inputs[i].value = "";
            }
        }

        var div = document.createElement("div");
        div.id = "feedback";
        div.className = "feedback";

        var elem;
        if (!results[0] || !results[1]) {
            if (_attempts > _maxAttempts) {
                div.innerHTML = data.feedback[1].text;

                for (i = 0; i < inputs.length; ++i) {
                    inputs[i].value = data.answers[i];
                }

                elem = document.getElementById('submit');
                elem.parentNode.removeChild(elem);
            } else {
                div.innerHTML = data.feedback[0].text;
            }
        } else {
            div.innerHTML = data.feedback[2].text;
            elem = document.getElementById('submit');
            elem.parentNode.removeChild(elem);
        }

        document.body.appendChild(div);
        resize();
    }

    function resize() {
        var parentIframe = window.frameElement,
            height = document.body.clientHeight;

        if (window.frameElement !== null) {
            parentIframe.setAttribute("height", height + 20);
        }
    }

    return Activity;
}());

var user = new Activity(data, 3);