var Activity = (function () {
    var maxAttempts = 1;
    var currAttempts = 0;

    function Activity(data) {
        $("#content").append("<table/>");
        var $table = $("table");
        $table.attr("id", "tbl1");
        var i, j;
        for (i = 0; i < data.rowHeaders.length; ++i) {
            $table.append("<tr id='tr" + i + "'/>");
            $("#tr" + i).append("<td><b>" + (i + 1) + ".&nbsp;</b>" + data.rowHeaders[i].text + "</td>");
            if (data.rowHeaders[i].hasOwnProperty("type")) {
                for (j = 0; j < data.colHeaders.length; ++j) {
                    $("#tr" + i).append("<td/>");
                }
            } else {
                for (j = 0; j < data.colHeaders.length - 1; ++j) {
                    $("#tr" + i).append("<td style='text-align: center'><input type='checkbox' tabindex='-1'/></td>");
                }
            }
        }
        $("input:checkbox").each(function (index, element) {
            element.name = "option" + index;
            $(element).wrap("<span class='custom-checkbox' tabindex='1'/>");

            var id = this.parentElement.parentElement.parentElement.id;
            $(element).click(agree(id));
        });
        $("html").on("keyup", function (event) {
            var nodeName = event.target.nodeName.toLowerCase();
            if (event.which == 13) {
                if (nodeName == "span") {
                    $(event.target).children("input:checkbox").trigger("click");
                }
            }
        });
        $("table").prepend("<tr id='header'></tr>");
        for (i = 0; i < data.colHeaders.length; ++i) {
            $("#header").append("<th id='th" + i + "'>" + data.colHeaders[i].text + "</th>");
        }
        $("#content").append("<input id='reveal' type='button' value='Reveal'/>");
        $("#reveal").click(function () {
            var $table = $("#t2");
            if ($table.length > 0) {
                $table.remove();
                resize();
            } else {
                reveal();
            }
        });
        $("#content").append("<input id='checkAnswers' type='button' value='Check your answer'/>");

        $("#checkAnswers").click(function () {
            checkAnswers();
        });
        $("#content").append("<input id='resetAnswers' type='button' value='Reset'/>");

        $("#resetAnswers").click(function () {
            resetAnswers();
        });
        $("#content").append("<div id='response'/>");
        retrieveDataFromVLE();
    }

    function resetAnswers() {
        $("#tbl1").find("input:checkbox").each(function (index, element) {
            $(element).parent().removeClass("selected");
            $(element).prop("checked", false);
        });
        $("#checkAnswers").removeAttr("disabled");
        $("#reveal").removeAttr("disabled");
        $("#response").removeClass("active");
        currAttempts = 0;
        resize();
    }

    function checkAnswers() {
        var $table = $("#tbl1");
        var anws = [0, 3, 4, 6, 9, 11, 13];
        var correctNum = 0;
        var replaceChecks=[];
        $table.find("input:checkbox").each(function (index, element) {
            for (var i = 0; i < anws.length; i++) {
                if (anws[i] === Number(element.name.split("option")[1])) {
                    if (element.checked) {
                        correctNum++;
                        replaceChecks.push(element);
                    }
                }
            }
            $(element).prop("checked",false)
            $(element).parent().removeClass("selected");
        });
        for(var j=0; j<replaceChecks.length; j++){
            $(replaceChecks[j]).prop("checked",true)
            $(replaceChecks[j]).parent().addClass("selected");
        }
        var maxReached = false;
        if (currAttempts < maxAttempts) {
            currAttempts++;
        } else {
            $("#reveal").click();
            maxReached = true;
        }
        $("#response").addClass("active");
        if (correctNum === anws.length) {
            $("#response").html("<p>Correct. Well done.</p><p>Examples of income are pay, Jobseeker’s Allowance and pension payments.</p><p>Shares, a house, a work of art and a savings account are all assets.</p><p>It is important to remember that some assets can provide an income, such as the interest from savings or dividend payments from shares.</p><p>Assets themselves are not income but they can be used to obtain a one-off source of money, such as drawing out the stock of savings, selling a house, or selling some shares. This would transform one asset (for example, a house) into another asset (cash in the bank after the sale).</p>");
            $("#checkAnswers").attr("disabled", true);
            $("#reveal").attr("disabled", true);
        } else {
            if (maxReached) {
                $("#response").html("<p>Some of your answers are incorrect. The correct answers have been completed for you.</p><p>Examples of income are pay, Jobseeker’s Allowance and pension payments.</p><p>Shares, a house, a work of art and a savings account are all assets.</p><p>It is important to remember that some assets can provide an income, such as the interest from savings or dividend payments from shares.</p><p>Assets themselves are not income but they can be used to obtain a one-off source of money, such as drawing out the stock of savings, selling a house, or selling some shares. This would transform one asset (for example, a house) into another asset (cash in the bank after the sale).</p>");
            } else {
                $("#response").html("<p>Some of your answers are incorrect. The incorrect answers have been removed. Try again.</p>");

            }
        }
        resize();
        resize();
    }

    function agree(id) {
        return function () {
            $("#" + id).find("input:checkbox").each(function (index, element) {
                $(element).parent().removeClass("selected");
                $(element).prop("checked", false);
            });
            $(this).prop("checked", true);
            $(this).parent().toggleClass("selected");
            saveDataToVLE();
            $("#response").removeClass("active");
            resize();
        };
    }

    function resize() {
        VLE.resize_iframe();
    }

    function reveal() {
        $("#tbl1").find("input:checkbox").each(function (index, element) {
            if (index === 0 ||
            index === 3 ||
            index === 4 ||
            index === 6 ||
            index === 9 ||
            index === 11 ||
            index === 13) {
                $(element).wrap("<span class='custom-checkbox selected'/>");
            } else {
                $(element).wrap("<span class='custom-checkbox'/>");
            }
        });

        $("#checkAnswers").attr("disabled", true);
        $("#reveal").attr("disabled", true);
        $("#response").html("<p>The correct answers have been completed for you.</p><p>Examples of income are pay, Jobseeker’s Allowance and pension payments.</p><p>Shares, a house, a work of art and a savings account are all assets.</p><p>It is important to remember that some assets can provide an income, such as the interest from savings or dividend payments from shares.</p><p>Assets themselves are not income but they can be used to obtain a one-off source of money, such as drawing out the stock of savings, selling a house, or selling some shares. This would transform one asset (for example, a house) into another asset (cash in the bank after the sale).</p>");
        $("#response").addClass("active");
        resize();
    }

    function saveDataToVLE(callback) {
        var temp = {
            checkboxes: []
        };
        $("input:checkbox").each(function (index, element) {
            temp.checkboxes[index] = $(element).is(":checked");
        });
        temp.checkboxes = JSON.stringify(temp.checkboxes);
        VLE.set_server_data(true, temp, function () {
            if (callback) {
                callback();
            }
            console.log("set_server_data was successful");
        }, function (msg) {
            if (callback) {
                callback();
            }
            console.log("set_server_data has failed");
            if (msg !== null) {
                console.log(msg);
            }
        });
    }

    function retrieveDataFromVLE() {
        var array = [];
        array.push("checkboxes");
        VLE.get_server_data(true, array, function (savedData) {
            var checkboxes = [];
            if (savedData.checkboxes !== "") {
                checkboxes = JSON.parse(savedData.checkboxes);

                $("input:checkbox").each(function (index, element) {
                    if (checkboxes[index] === true) {
                        $(element).prop("checked", true);
                        $(this).parent().addClass("selected");
                    }
                });
            }
        }, function (msg) {
            console.log("Failed to get server data.");
            if (msg !== null) {
                console.log(msg);
            }
        });
    }
    return Activity;
}());

var act = new Activity(data);