/*global $:false, data */

var Activity = (function () {
    function Activity(data) {
        var i;
        for (i = 0; i < data.clickableAreas.length; ++i) {
            $("#map").append("<div id='point" + i + "' tabIndex='1'></div>");

            $("#point" + i).css("left", data.clickableAreas[i].left).css("top", data.clickableAreas[i].top);
        }

        $("#thumb1").button().click(function () {
            showVideo("videos/db125_2018j_vid111-640x360", "db125_2018j_vid111-320x176");
        });
        $("#thumb2").button().click(function () {
            showVideo("videos/db125_2018j_vid112-640x360", "db125_2018j_vid112-320x176");
        });

        $("#point0").button().click(function () {
            showContent(0);
        });

        $("#point1").button().click(function () {
            showContent(1);
        });

        $("#point2").button().click(function () {
            showContent(2);
        });

        $("#point3").button().click(function () {
            showContent(3);
        });

        $("#point4").button().click(function () {
            showContent(4);
        });

        $("#point5").button().click(function () {
            showContent(5);
        });

        $("#point6").button().click(function () {
            showContent(6);
        });

        $("#point7").button().click(function () {
            showContent(7);
        });

        $("#point8").button().click(function () {
            showContent(8);
        });

        $("#point9").button().click(function () {
            showContent(9);
        });

        $("#point10").button().click(function () {
            showContent(10);
        });

        $("#point11").button().click(function () {
            showContent(11);
        });

        $("html").keypress(function (event) {
            if (event.which == 13) {
                switch (event.target.id) {
                    case "point0":
                        showContent(0);
                        break;
                    case "point1":
                        showContent(1);
                        break;
                    case "point2":
                        showContent(2);
                        break;
                    case "point3":
                        showContent(3);
                        break;
                    case "point4":
                        showContent(4);
                        break;
                    case "point5":
                        showContent(5);
                        break;
                    case "point6":
                        showContent(6);
                        break;
                    case "point7":
                        showContent(7);
                        break;
                    case "point8":
                        showContent(8);
                        break;
                    case "point9":
                        showContent(9);
                        break;
                    case "point10":
                        showContent(10);
                        break;
                    case "point11":
                        showContent(11);
                        break;
                    case "thumb1":
                        showVideo("videos/db125_2018j_vid110-640x360");
                        break;
                }
            }
        });
    }

    function feedbackModal(content, w, h) {
        $("#content").append("<div id='feedback' tabIndex='100'>" + content + "</div>");
        $("#feedback").dialog({
            modal: true,
            show: {
                effect: "blind",
                duration: 1
            },
            open: function (e, ui) {
                var $dlg = $(e.target);
                if ($dlg.is(':visible')) {
                    $dlg.focus();
                }
            },
            position: {
                my: "top",
                at: "top",
                of: $("#map"),
                within: $("body")
            },
            buttons: {
                close: function () {
                    $(this).dialog("close");
                    $("#feedback").remove();
                }
            },
            width: w,
            height: h
        }).css({
            textAlign: "center"
        });
        $(".ui-dialog-titlebar").remove();
    }

    function showVideo(filename, caption) {
        var dialog = {
            feedback: function () { }
        };

        var html = "<video width='640' height='360' src='" + filename + ".mp4' type='video/mp4' id='player1' poster='" + filename + ".jpg' controls='controls' preload='auto' autoplay='true'><track id='subtitles' kind='subtitles' src='subtitles/" + caption + ".srt' srclang='en' /></video>";
        var modal = dialog[feedbackModal(html, 675, 490)];

        $("video").mediaelementplayer({
            loop: false,
            success: function (mediaElement, domObject) {
                mediaElement.addEventListener('canplay', function () {
                    mediaElement.play();
                }, false);
            }
        });
    }

    function showContent(index) {
        var dialog = {
            feedback: function () { }
        };

        var html = data.title[index].text + "<image src='" + data.images[index].text + "'></image><p>" + data.content[index].text + "</p>";
        var modal = dialog[feedbackModal(html, 680, "auto")];
    }

    return Activity;
}());

var act = new Activity(data);