var DataObject = (function () {
    function DataObject() {
        this.allowedAttempts = 2;
        this.attempts = 0;
        this.correctResponses = [];
        this.incorrectResponses = [];
    }

    DataObject.prototype.reset = function () {
        this.attempts = 0;

        while (this.correctResponses.length > 0) {
            this.correctResponses.pop();
        }

        while (this.incorrectResponses.length > 0) {
            this.incorrectResponses.pop();
        }
    };

    DataObject.prototype.correctCount = function () {
        var count = 0;
        var i;
        for (i = 0; i < this.correctResponses.length; ++i) {
            if (this.correctResponses[i] !== "") {
                count++;
            }
        }
        return count;
    };

    return DataObject;
}());

var Activity = (function () {
    var dataObject = new DataObject();
    var selection = null;
    var selectForDeletion = null;

    function Activity() {
        var $content = $("#content");
        $content.append("<div id='choices'/>");
        $content.append("<div id='target'/>");

        $content.append("<img src='" + data.image + "'></img>");

        var choices = data.choices;
        shuffleArray(choices);

        var $choices = $("#choices");

        var i;
        for (i = 0; i < data.choices.length; ++i) {
            $choices.append("<div id='div" + i + "'>" + choices[i].text + "</div>");
        }

        $choices.find("div").draggable({
            revert: "invalid",
            zIndex: 100,
            refreshPositions: true,
            containment: "#content",
            drag: function (e, ui) {
                ui.helper.addClass("selected");
            },
            stop: function (e, ui) {
                ui.helper.removeClass("selected");
            }
        }).sortable();

        $choices.droppable({
            drop: function (e, ui) {
                ui.draggable.detach().css({ top: 0, left: 0 }).appendTo(this);
            }
        });

        $choices.on("click", function () {
            if (!$(selectForDeletion).parent().hasClass("ui-droppable-disabled")) {
                $(selectForDeletion).appendTo("#choices");

                $(".drop").removeClass("selected");
                $(selectForDeletion).addClass("selected");

                selection = selectForDeletion;
                selectForDeletion = null;
            }
        });

        $choices.find("div").on("click", function (e) {
            if (this.parentNode.parentNode.id != "target") {
                e.stopPropagation();
                $(".drop").removeClass("selected");

                if ($(this).hasClass("selected")) {
                    $(this).removeClass("selected");
                    selection = null;
                } else {
                    var $divs = $choices.find("div");

                    if ($divs.hasClass("selected")) {
                        $divs.removeClass("selected");
                    }

                    $(this).addClass("selected");
                    selection = this;
                    selectForDeletion = this;
                }
            }
        });

        for (i = 0; i < data.choices.length; i++) {
            $("#target").append("<div id='td" + i + "' tabIndex='" + 1 + "'></div>");
        }

        for (i = 0; i < data.choices.length; i++) {
            $("#td" + i).css("left", data.droppableAreas[i].left).css("top", data.droppableAreas[i].top);
            $("#td" + i).addClass("drop");
        }

        var $td = $(".drop");

        $td.droppable({
            hoverClass: "hover",
            tolerance: "pointer",
            drop: function (e, ui) {
                if (this.children.length > 0) {
                    $(this.children[0]).appendTo("#choices");
                }

                ui.draggable.detach().css({ top: 0, left: 0 }).appendTo(this);

                $choices.find("div").removeClass("selected");
                $(this).focus();
                selectForDeletion = this.children[0];
            }
        });

        $td.on("click", function () {
            if (selection !== null) {
                if (!$(this).hasClass("ui-droppable-disabled")) {
                    if ($(this).children.length > 0) {
                        $(this).children(0).appendTo("#choices");
                    }

                    $(selection).detach().removeClass("selected").css({ top: 0, left: 0 }).appendTo(this);
                    selectForDeletion = selection;
                    selection = null;
                }
            }

            $choices.find("div").removeClass("selected");
        });

        $td.on("click", "div", function (e) {
            var $parent = $(this).parent();

            if (selection !== null) {
                if (!$parent.hasClass("ui-droppable-disabled")) {
                    if ($parent.children.length > 0) {
                        $parent.children(0).appendTo("#choices");
                    }

                    $(selection).detach().removeClass("selected").css({ top: 0, left: 0 }).appendTo($parent[0]);
                    selectForDeletion = selection;
                }
            } else {
                selectForDeletion = this;
            }

            $choices.find("div").removeClass("selected");
            $parent.focus();

            e.stopPropagation();
        });

        $("#target").on("keyup", function (e) {
            var id = e.target.id;
            var $first,
                parent;

            if (e.which == 9) {
                $choices.find("div").removeClass("selected");
                $choices.find("div").first().addClass("selected");
            } else if (e.which == 13 || e.which == 32) {
                if ((e.target.nodeName == "DIV" || e.target.nodeName == "div") && !$(e.target).hasClass("ui-droppable-disabled")) {
                    if (e.target.children.length > 0) {
                        $(e.target.children[0]).appendTo("#choices");
                    }
                    $first = $choices.find("div").first();
                    $first.appendTo("#" + id);
                    selectForDeletion = $first[0];

                    $first.removeClass("selected");
                    $first = $choices.find("div").first();
                    selection = $first[0];
                    $first.addClass("selected");
                } else if (selection !== null) {
                    parent = $(selection).parent()[0];
                    if ((parent.nodeName == "DIV" || parent.nodeName == "div") && !$(parent).hasClass("ui-droppable-disabled")) {

                        $(selection).appendTo("#choices");
                        $first = $choices.find("div").first();
                        $first.appendTo(parent);
                        selectForDeletion = selection;
                        selection = $first[0];
                    }
                }
            } else if (e.which == 46 || e.which == 8) {
                if ((e.target.nodeName == "DIV" || e.target.nodeName == "div") && !$(e.target).hasClass("ui-droppable-disabled")) {
                    e.preventDefault();
                    if (e.target.children.length > 0) {
                        $(e.target.children[0]).appendTo("#choices");

                        $first = $choices.find("div").first();
                        selection = $first[0];
                        $first.addClass("selected");
                    }
                } else if (selectForDeletion !== null) {
                    e.preventDefault();
                    parent = $(selectForDeletion).parent()[0];
                    if ((parent.nodeName == "DIV" || parent.nodeName == "div") && !$(parent).hasClass("ui-droppable-disabled")) {
                        $(selectForDeletion).appendTo("#choices");
                        selectForDeletion = null;

                        $first = $choices.find("div").first();
                        selection = $first[0];
                        $first.addClass("selected");
                    }
                }
            }
        });

        $content.append("<div id='container'/>");
        var $container = $("#container");
        $container.append("<input id='submit' type='button' value='Check'/>");
        $container.append("<input id='reset' type='button' value='Reset'/>");

        $("#submit").button().click(function () {
            submit();
        });

        $("#reset").button().click(function () {
            reset();
        });

        for (i = 0; i < $td.length; ++i) {
            dataObject.correctResponses[i] = "";
            dataObject.incorrectResponses[i] = "";
        }

        retrieveDataFromVLE();
    }

    function getText(html) {
        return $('<div></div>').html(html).text();
    }

    function saveDataToVLE() {
        var temp = {
            attempts: 0,
            correctResponses: [],
            incorrectResponses: []
        };

        temp.attempts = JSON.stringify(dataObject.attempts);
        temp.correctResponses = JSON.stringify(dataObject.correctResponses);
        temp.incorrectResponses = JSON.stringify(dataObject.incorrectResponses);

        VLE.set_server_data(true, temp, function () {
            console.log("set_server_data was successful");
        }, function (msg) {
            console.log("set_server_data has failed");
            if (msg !== null) {
                console.log(msg);
            }
        });
    }

    function retrieveDataFromVLE() {
        var array = [];
        array.push("attempts");
        array.push("correctResponses");
        array.push("incorrectResponses");

        VLE.get_server_data(true, array, function (savedData) {
            if (parseInt(savedData.attempts) > 0) {
                dataObject.attempts = JSON.parse(savedData.attempts);
                dataObject.correctResponses = JSON.parse(savedData.correctResponses);
                dataObject.incorrectResponses = JSON.parse(savedData.incorrectResponses);

                var $td = $(".drop");
                var text;

                $td.each(function (index, element) {
                    if (dataObject.correctResponses[index] !== "") {
                        $("#choices").find("div").each(function (choiceIndex, choiceElement) {
                            text = getText(choiceElement.innerHTML);
                            if (text == dataObject.correctResponses[index]) {
                                $(choiceElement).appendTo("#td" + index);
                            }
                        });
                    } else if (dataObject.incorrectResponses[index] !== "") {
                        $("#choices").find("div").each(function (choiceIndex, choiceElement) {
                            if (text == dataObject.incorrectResponses[index]) {
                                $(choiceElement).appendTo("#td" + index);
                            }
                        });
                    }
                });

                var child;
                $td.each(function (index, element) {
                    if (element.children.length > 0) {
                        child = element.children[0];
                        text = getText(child.innerHTML);
                        if (text == getText(data.answers[index].text)) {
                            dataObject.correctResponses[index] = text;
                            dataObject.incorrectResponses[index] = "";
                            $(child).addClass("green-border").draggable("disable").css('cursor', 'default');
                            $(element).droppable("disable");
                        } else {
                            if (dataObject.attempts >= dataObject.allowedAttempts) {
                                dataObject.incorrectResponses[index] = text;
                                dataObject.correctResponses[index] = "";
                                $(child).addClass("red-border").draggable("disable").css('cursor', 'default');
                            } else {
                                $(child).appendTo("#choices");
                            }
                        }
                    }
                });

                if (dataObject.attempts >= dataObject.allowedAttempts) {
                    $("#choices").find("div").draggable("disable").css('cursor', 'default');
                    $td.droppable("disable").css('cursor', 'default');

                    $("#submit").hide();

                    if (dataObject.correctCount() == data.answers.length) {
                        $("#submit").hide();

                        $td.each(function (index, element) {
                            if (element.children.length > 0) {
                                child = element.children[0];
                                text = getText(child.innerHTML);

                                if (text == dataObject.incorrectResponses[index]) {
                                    dataObject.incorrectResponses[index] = "";
                                    $(child).removeClass("red-border");
                                    $(child).appendTo("#choices");
                                }
                            }
                        });
                    }
                } else {
                    if (dataObject.correctCount() == data.answers.length) {
                        $("#choices").find("div").draggable("disable").css('cursor', 'default');
                        $td.droppable("disable").css('cursor', 'default');

                        $("#submit").hide();
                    }
                }
            }
        }, function (msg) {
            console.log("Failed to get server data.");
            if (msg !== null) {
                console.log(msg);
            }
        });
    }

    function shuffleArray(array) {
        var i, j, temp;
        for (i = array.length - 1; i > 0; i--) {
            j = Math.floor(Math.random() * (i + 1));
            temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    }

    function feedbackModal(message) {
        $("#content").append("<div id='feedback'>" + message + "</div>");
        $("#feedback").dialog({
            modal: true,
            position: {
                my: "center",
                at: "center",
                of: $("body"),
                within: $("body")
            },
            buttons: {
                close: function () {
                    $(this).dialog("close");
                    $("#feedback").remove();
                }
            },
            width: "50%"
        });
        $(".ui-dialog-titlebar").remove();
    }

    function getFeedbackMessage() {
        var message = "";

        if (dataObject.attempts == 1) {
            if (dataObject.correctCount() < data.answers.length) {
                if (dataObject.correctCount() > 0) {
                    message = data.feedback[1].text + "<br/><br/>";
                } else {
                    message = data.feedback[0].text + "<br/><br/>";
                }
            } else if (dataObject.correctCount() == data.answers.length) {
                message = "<br/>" + data.feedback[3].text + "<br/>";
            }
        } else {
            if (dataObject.correctCount() < data.answers.length) {
                message = data.feedback[2].text + "<br/><br/>";
            } else if (dataObject.correctCount() == data.answers.length) {
                message = "<br/>" + data.feedback[3].text + "<br/>";
            }
        }

        if (message === "") {
            message = "<br/>Please enter a value!<br/>";
        }

        return message;
    }

    function reveal() {
        var $td = $(".drop");

        $td.find("div").each(function (index, element) {
            $(element).appendTo("#choices");
        });

        var $choices = $("#choices");
        $choices.find("div").draggable("disable").css('cursor', 'default');

        var len = data.answers.length;
        var text;
        var i;
        for (i = 0; i < len; ++i) {
            $choices.find("div").each(function (index, element) {
                text = getText(element.innerHTML);
                if (text == getText(data.answers[i].text)) {
                    $(element).appendTo("#td" + i);
                }
            });
        }

        $td.find("div").removeClass("green-border red-border").addClass("grey-border").draggable("disable").css('cursor', 'default');
        $td.css('cursor', 'default');
        $("#submit").hide();

        //dataObject.attempts = 1;
        for (i = 0; i < len; ++i) {
            dataObject.correctResponses[i] = getText(data.answers[i].text);
            dataObject.incorrectResponses[i] = "";
        }

        saveDataToVLE();
    }

    function submit() {
        dataObject.attempts++;
        var $td = $(".drop");

        var text,
            child;
        $td.each(function (index, element) {
            if (element.children.length > 0) {
                child = element.children[0];
                text = getText(child.innerHTML);

                if (text == getText(data.answers[index].text)) {
                    dataObject.correctResponses[index] = text;
                    dataObject.incorrectResponses[index] = "";
                    $(child).addClass("green-border").draggable("disable").css('cursor', 'default');
                    $(element).droppable("disable");
                } else {
                    if (dataObject.attempts >= dataObject.allowedAttempts) {
                        dataObject.incorrectResponses[index] = text;
                        dataObject.correctResponses[index] = "";
                        $(child).addClass("red-border").draggable("disable").css('cursor', 'default');
                    } else {
                        $(child).appendTo("#choices");
                    }
                }
            }
        });

        var dialog = {
            feedback: function () { }
        };

        var message = getFeedbackMessage();
        var modal = dialog[feedbackModal(message)];

        if (dataObject.attempts >= dataObject.allowedAttempts) {
            $("#choices").find("div").draggable("disable").css('cursor', 'default');
            $td.droppable("disable").css('cursor', 'default');

            $("#submit").hide();

            if (dataObject.correctCount() == data.answers.length) {
                $("#submit").hide();

                $td.each(function (index, element) {
                    if (element.children.length > 0) {
                        child = element.children[0];
                        text = getText(child.innerHTML);

                        if (text == dataObject.incorrectResponses[index]) {
                            dataObject.incorrectResponses[index] = "";
                            $(child).removeClass("red-border");
                            $(child).appendTo("#choices");
                        }
                    }
                });
            } else {
                reveal();
            }
        } else {
            if (dataObject.correctCount() == data.answers.length) {
                $("#choices").find("div").draggable("disable").css('cursor', 'default');
                $td.droppable("disable").css('cursor', 'default');

                $("#submit").hide();
            }
        }

        saveDataToVLE();
    }

    function reset() {
        var $td = $(".drop");

        $td.find("div").each(function (index, element) {
            $(element).appendTo("#choices");
        });

        dataObject.reset();

        var i;
        for (i = 0; i < $td.length; ++i) {
            dataObject.correctResponses[i] = "";
            dataObject.incorrectResponses[i] = "";
        }

        var choices = data.choices;
        shuffleArray(choices);

        var $choices = $("#choices");
        $choices.find("div").each(function (index, element) {
            element.innerHTML = choices[index].text;
        });

        $td.droppable("enable").css("cursor", "pointer");
        $choices.find("div").removeClass("green-border red-border grey-border").draggable("enable").css("cursor", "pointer");

        $("#submit").off("click").val("Check").show().click(function () {
            submit();
        });

        saveDataToVLE();
    }

    return Activity;
}());

var act = new Activity();