var Activity = (function () {
    var _attempts = 0;
    var _maxAttempts = 2;

    function Activity(data) {
        $("body").append("<div id='content'><table><tr id='tr0'/></table></div>");
        $("#tr0").append("<th/>");

        var i;
        for (i = 0; i < data.list.length; ++i) {
            $("th").append("<div id='tr" + i + "'><img src='" + data.images[i].text + "' alt='" + data.list[i].text + "'></img></div>");
        }

        $("#tr0").append("<td rowspan='14'/>");

        $("td").append("<ul id='sortable'/>");

        for (i = 0; i < data.list.length; ++i) {
            $("#sortable").append("<li id='choice" + i + "' tabindex='1' class='ui-state-default'><span class='ui-icon ui-icon-arrowthick-2-n-s'></span>" + data.list[i].text + "</li>");
        }

        var choices = shuffleArray($("li").toArray());
        $("#sortable").html = "";
        $("#sortable").append(choices);

        $("#sortable").sortable({
            items: "li:not(.unsortable)"
        });

        $("#sortable li").bind("keydown", function (event) {
            var current, id;

            if (event.which == 38) {
                event.preventDefault();
                current = $(this).text();
                id = this.id;
                if ($(this).prev().length > 0) {
                    $(this).text($(this).prev().text());
                    $(this).prop("id", $(this).prev()[0].id);
                    $(this).prev().text(current).focus();
                    $(this).prev().prop("id", id);

                    $("li").removeClass("unsortable");
                }
            } else if (event.which == 40) {
                event.preventDefault();
                if ($(this).next().length > 0) {
                    current = $(this).text();
                    id = this.id;
                    $(this).text($(this).next().text());
                    $(this).prop("id", $(this).next()[0].id);
                    $(this).next().text(current).focus();
                    $(this).next().prop("id", id);

                    $("li").removeClass("unsortable");
                }
            }
        });

        $content = $("#content");
        $content.append("<div><input id='submit' type='button' value='Submit'/><input id='reveal' type='button' value='Reveal'/></div>");

        $("#submit").button().click(function () {
            submit();
        });

        $("#reveal").button().click(function () {
            reveal();
        });

        //retrieveDataFromVLE();
    }

    function submit() {
        var count = 0;

        _attempts++;

        $("li").each(function (index, element) {
            var id = element.id.replace("choice", "");
            if (id == index) {
                $(element).addClass("unsortable");
                count++;
            }
        });

        $("#feedback").remove();
        if (count < data.list.length) {
            if (_attempts == 1) {
                $("#content").append("<div id='feedback'>" + data.feedback[0].text + "</div>");
            } else {
                reveal();

                $("#content").append("<div id='feedback'>" + data.feedback[1].text + "</div>");
                return;
            }
        } else if (count == data.list.length) {
            $("#content").append("<div id='feedback'>" + data.feedback[2].text + "</div>");

            $("#submit").off("click").val("Reset").click(function () {
                reset();
            });
        }

        $("#sortable").sortable({
            update: function () {
                $("li").removeClass("unsortable");
            }
        });

        saveDataToVLE();
    }

    function reset() {
        var choices = shuffleArray($("li").toArray());
        $("#sortable").html = "";
        $("#sortable").append(choices);

        $("li").removeClass("unsortable").removeAttr("style");

        $("#submit").off("click").val("Submit").click(function () {
            submit();
        });

        $("#reveal").show();

        $("#feedback").remove();

        _attempts = 0;

        saveDataToVLE();
    }

    function reveal() {
        $("#sortable").remove();
        $("td").append("<ul id='sortable'/>");

        for (i = 0; i < data.list.length; ++i) {
            $("#sortable").append("<li id='choice" + i + "' style='cursor: default' class='ui-state-default unsortable'><span class='ui-icon ui-icon-arrowthick-2-n-s'></span>" + data.list[i].text + "</li>");
        }

        $("#sortable").sortable({ cancel: ".unsortable" });

        $("#submit").off("click").val("Reset").click(function () {
            reset();
        });

        $("#reveal").hide();

        $("#feedback").remove();

        saveDataToVLE();
    }

    function shuffleArray(array) {
        var i, j, temp;
        for (i = array.length - 1; i > 0; i--) {
            j = Math.floor(Math.random() * (i + 1));
            temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    }

    function saveDataToVLE() {
        var temp = {
            data: []
        };

        $("li").each(function (index, element) {
            temp.data[index] = element.textContent;
        });

        temp.data = JSON.stringify(temp.data);

        VLE.set_server_data(true, temp, function () {
            console.log("set_server_data was successful");
        }, function (msg) {
            console.log("set_server_data has failed");
            if (msg !== null) {
                console.log(msg);
            }
        });
    }

    function retrieveDataFromVLE() {
        var array = [];
        array.push("data");

        VLE.get_server_data(true, array, function (savedData) {
            if (savedData.data !== "") {
                var data = JSON.parse(savedData.data);

                $("#sortable").remove();
                $("td").append("<ul id='sortable'/>");

                for (i = 0; i < data.length; ++i) {
                    $("#sortable").append("<li id='choice" + i + "' tabindex='1' class='ui-state-default'><span class='ui-icon ui-icon-arrowthick-2-n-s'></span>" + data[i] + "</li>");
                }

                $("#sortable").sortable({
                    items: "li:not(.unsortable)"
                });

                $("#sortable li").bind("keydown", function (event) {
                    var current, id;

                    if (event.which == 38) {
                        event.preventDefault();
                        current = $(this).text();
                        id = this.id;
                        if ($(this).prev().length > 0) {
                            $(this).text($(this).prev().text());
                            $(this).prop("id", $(this).prev()[0].id);
                            $(this).prev().text(current).focus();
                            $(this).prev().prop("id", id);

                            $("li").removeClass("unsortable");
                        }
                    } else if (event.which == 40) {
                        event.preventDefault();
                        if ($(this).next().length > 0) {
                            current = $(this).text();
                            id = this.id;
                            $(this).text($(this).next().text());
                            $(this).prop("id", $(this).next()[0].id);
                            $(this).next().text(current).focus();
                            $(this).next().prop("id", id);

                            $("li").removeClass("unsortable");
                        }
                    }
                });
            }
        }, function (msg) {
            console.log("Failed to get server data.");
            if (msg !== null) {
                console.log(msg);
            }
        });
    }

    return Activity;
}());

var act = new Activity(data);