/*global data */
var Activity = (function () {
    var _index = 0;
    var _paused = false;
    var _timerId;
    var _timerInterval=100;

    function Activity(data, rowCount, colCount) {
        var controls = document.createElement("div");
        controls.id = "controls";
        document.body.appendChild(controls);

        var prevButton = document.createElement("input");
        prevButton.id = "prevButton";
        prevButton.type = "button";
        prevButton.value = "Previous";
        prevButton.addEventListener("click", function () {
            if (_index > 0) {
                --_index;
                slide();
            }
        });
        controls.appendChild(prevButton);

        var playButton = document.createElement("input");
        playButton.id = "playButton";
        playButton.type = "button";
        playButton.value = "Play";
        playButton.addEventListener("click", function () {
            if (!_paused) {
                this.value = "Pause";
                playfunction();
            } else {
                clearInterval(_timerId);
                this.value = "Play";
            }

            _paused = !_paused;
        });
        controls.appendChild(playButton);


        var playfunction=function(){
            if(_index===0) {
                _timerInterval=12000;
            }
            if(_index===1) {
                _timerInterval=14000;
            }
            if(_index===2) {
                _timerInterval=15000;
            }
            if(_index===3) {
                _timerInterval=15000;
            }
            if(_index===4) {
                _timerInterval=10000;
            }
            window.setTimeout(function(){
                if (_index < 4) {
                    _index++;
                    slide();
                    playfunction();
                }
            },_timerInterval);
        };

        var nextButton = document.createElement("input");
        nextButton.id = "nextButton";
        nextButton.type = "button";
        nextButton.value = "Next";
        nextButton.addEventListener("click", function () {
            if (_index < 4) {
                _index++;
                slide();
            }
        });
        controls.appendChild(nextButton);

        var numbers = document.createElement("div");
        numbers.id = "numbers";
        document.body.appendChild(numbers);

        var button1 = document.createElement("button");
        button1.innerText = "1";
        button1.setAttribute("class","step-btn");
        button1.addEventListener("click", function () {
            _index = 0;
            slide();
        });
        numbers.appendChild(button1);

        var button2 = document.createElement("button");
        button2.innerText = "2";
        button2.setAttribute("class","step-btn");
        button2.addEventListener("click", function () {
            _index = 1;
            slide();
        });
        numbers.appendChild(button2);

        var button3 = document.createElement("button");
        button3.innerText = "3";
        button3.setAttribute("class","step-btn");
        button3.addEventListener("click", function () {
            _index = 2;
            slide();
        });
        numbers.appendChild(button3);

        var button4 = document.createElement("button");
        button4.innerText = "4";
        button4.setAttribute("class","step-btn");
        button4.addEventListener("click", function () {
            _index = 3;
            slide();
        });
        numbers.appendChild(button4);

        var button5 = document.createElement("button");
        button5.innerText = "5";
        button5.setAttribute("class","step-btn");
        button5.addEventListener("click", function () {
            _index = 4;
            slide();
        });
        numbers.appendChild(button5);

        slide();

    }

    function slide() {
        var stepBtns=document.querySelectorAll(".step-btn");
        for(var i=0; i<stepBtns.length;i++){
            stepBtns[i].setAttribute("class",stepBtns[i].getAttribute("class").split("current-step").join(""))

        }
        if(stepBtns.length>0){
            stepBtns[_index].setAttribute("class",stepBtns[_index].getAttribute("class")+" current-step");
        }

        // add class to _index+1
        //stepBtns[_index+1].setAttribute("class",stepBtns[_index+1].getAttribute("class")+" current-step")
        var container = document.getElementById("container");

        if (container !== null) {
            document.body.removeChild(container);
        }

        container = document.createElement("div");
        container.id = "container";
        document.body.insertBefore(container, document.body.childNodes[0]);

        switch (_index) {
            case 0:
                slide1();
                break;
            case 1:
                slide2();
                break;
            case 2:
                slide3();
                break;
            case 3:
                slide4();
                break;
            case 4:
                slide5();
                break;
        }
    }

    function slide1() {
        var text = document.createElement("div");
        text.id = "slideText";
        text.innerHTML = data.texts[_index];
        container.appendChild(text);

        var slide = document.createElement("div");
        slide.className = "slide";
        container.appendChild(slide);

        var i, div;

        div = document.createElement("div");
        div.id = "start";
        div.innerText = "0";
        slide.appendChild(div);

        for (i = 0; i < data.labels.length; ++i) {
            div = document.createElement("div");
            div.id = "bar" + i;
            slide.appendChild(div);
        }

        div = document.createElement("div");
        div.id = "end";
        div.innerText = "0";
        slide.appendChild(div);

        for (i = 0; i < data.labels.length; ++i) {
            div = document.createElement("div");
            div.id = "label" + i;
            div.className = "labels";
            div.innerHTML = data.labels[i];
            slide.appendChild(div);
        }

        resize();
    }

    function slide2() {
        var text = document.createElement("div");
        text.id = "slideText";
        text.innerHTML = data.texts[_index];
        container.appendChild(text);

        var slide = document.createElement("div");
        slide.className = "slide";
        container.appendChild(slide);

        var i, div;

        div = document.createElement("div");
        div.id = "start";
        div.innerText = "0";
        slide.appendChild(div);

        for (i = 0; i < data.labels.length; ++i) {
            div = document.createElement("div");
            div.id = "bar" + i;
            slide.appendChild(div);

            if (i === 0 || i === 4) {
                div.style.height = "20px";
            }
        }

        div = document.createElement("div");
        div.id = "end";
        div.innerText = "0";
        slide.appendChild(div);

        for (i = 0; i < data.labels.length; ++i) {
            div = document.createElement("div");
            div.id = "label" + i;
            div.className = "labels";
            div.innerHTML = data.labels[i];
            slide.appendChild(div);
        }

        div = document.createElement("div");
        var parent = document.getElementById("bar1");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "50px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        div = document.createElement("div");
        parent = document.getElementById("bar3");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "40px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        div = document.createElement("div");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "10px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        div = document.createElement("div");
        div.innerHTML = "Unspent income is saved";
        container.appendChild(div);
        div.style.width = "60px";
        div.style.height = "50px";
        div.style.position = "absolute";
        div.style.top = "100px";
        div.style.color = "#70ad47";

        var circle = document.createElement("div");
        circle.id = "circle";
        div.appendChild(circle);

        resize();
    }

    function slide3() {
        var text = document.createElement("div");
        text.id = "slideText";
        text.innerHTML = data.texts[_index];
        container.appendChild(text);

        var slide = document.createElement("div");
        slide.className = "slide";
        container.appendChild(slide);

        var i, div;

        div = document.createElement("div");
        div.id = "start";
        div.innerText = "0";
        slide.appendChild(div);

        for (i = 0; i < data.labels.length; ++i) {
            div = document.createElement("div");
            div.id = "bar" + i;
            slide.appendChild(div);

            if (i === 0) {
                div.style.height = "100px";
            } else if (i === 2) {
                div.style.height = "80px";
                div.style.marginBottom = "-80px";
            } else if (i === 4) {
                div.style.height = "20px";
            }
        }

        div = document.createElement("div");
        div.id = "end";
        div.innerText = "0";
        slide.appendChild(div);

        for (i = 0; i < data.labels.length; ++i) {
            div = document.createElement("div");
            div.id = "label" + i;
            div.className = "labels";
            div.innerHTML = data.labels[i];
            slide.appendChild(div);

            if (i === 2) {
                div.style.marginTop = "80px";
            }
        }

        div = document.createElement("div");
        var parent = document.getElementById("bar1");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "50px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        div = document.createElement("div");
        parent = document.getElementById("bar3");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "40px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        div = document.createElement("div");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "10px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        resize();
    }

    function slide4() {
        var text = document.createElement("div");
        text.id = "slideText";
        text.innerHTML = data.texts[_index];
        container.appendChild(text);

        var slide = document.createElement("div");
        slide.className = "slide";
        container.appendChild(slide);

        var i, div;

        div = document.createElement("div");
        div.id = "start";
        div.innerText = "0";
        slide.appendChild(div);

        for (i = 0; i < data.labels.length; ++i) {
            div = document.createElement("div");
            div.id = "bar" + i;
            slide.appendChild(div);

            if (i === 0) {
                div.style.height = "100px";
            } else if (i === 2) {
                div.style.height = "50px";
                div.style.marginBottom = "-50px";
            } else if (i === 4) {
                div.style.height = "50px";
            }
        }

        div = document.createElement("div");
        div.id = "end";
        div.innerText = "0";
        slide.appendChild(div);

        for (i = 0; i < data.labels.length; ++i) {
            div = document.createElement("div");
            div.id = "label" + i;
            div.className = "labels";
            div.innerHTML = data.labels[i];
            slide.appendChild(div);

            if (i === 2) {
                div.style.marginTop = "50px";
            }
        }

        div = document.createElement("div");
        var parent = document.getElementById("bar1");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "50px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        div = document.createElement("div");
        parent = document.getElementById("bar3");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "40px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        div = document.createElement("div");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "10px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        div = document.createElement("div");
        div.innerHTML = "Part of each mortgage payment reduces the mortgage";
        container.appendChild(div);
        div.style.width = "100px";
        div.style.height = "50px";
        div.style.position = "absolute";
        div.style.top = "80px";
        div.style.color = "#ed7d31";

        var circle = document.createElement("div");
        circle.id = "circle2";
        div.appendChild(circle);

        resize();
    }

    function slide5() {
        var text = document.createElement("div");
        text.id = "slideText";
        text.innerHTML = data.texts[_index];
        container.appendChild(text);

        var slide = document.createElement("div");
        slide.className = "slide";
        container.appendChild(slide);

        var i, div;

        div = document.createElement("div");
        div.id = "start";
        div.innerText = "0";
        slide.appendChild(div);

        for (i = 0; i < data.labels.length; ++i) {
            div = document.createElement("div");
            div.id = "bar" + i;
            slide.appendChild(div);

            if (i === 0) {
                div.style.height = "100px";
            } else if (i === 2) {
                div.style.height = "1px";
            } else if (i === 4) {
                div.style.height = "100px";
            }
        }

        div = document.createElement("div");
        div.id = "end";
        div.innerText = "0";
        slide.appendChild(div);

        for (i = 0; i < data.labels.length; ++i) {
            div = document.createElement("div");
            div.id = "label" + i;
            div.className = "labels";
            div.innerHTML = data.labels[i];
            slide.appendChild(div);
        }

        div = document.createElement("div");
        var parent = document.getElementById("bar1");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "50px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        div = document.createElement("div");
        parent = document.getElementById("bar3");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "40px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        div = document.createElement("div");
        parent.appendChild(div);
        div.style.height = "5px";
        div.style.backgroundColor = "#000";
        div.style.marginTop = "10px";
        div.style.marginLeft = "30px";
        div.style.width = "40px";

        resize();
    }

    function resize() {
        var height = document.body.offsetHeight;

        if (window.frameElement !== null) {
            window.frameElement.setAttribute("height", height + 230);
        }
    }

    return Activity;
}());

var user = new Activity(data);