define({
    tables: [      
        {
            rows: {
                num: 5
            },
            cols: {
                num: 2,
                headers: true
            },
            layout: 'auto',
            content: [
                [
                    'Risk',
					'Head of IT'
                ],
                [
                    'Safety',
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    },

                ],
                [
                    'Finance',
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    },
                ],
                [
                    'Legal Risk',
                    {
                        input: {
                            options: 1,
                            answer: 3
                        }
                    },
                ],
				[
                    'BC',
                    {
                        input: {
                            options: 1,
                            answer: 3
                        }
                    },
                ],
            ],
            plugins: ['input'],
            input: {
                type: 'select',
                options: [
                    {
                        shuffle: true,
                        data: [
                            'This person is not informed about this risk',
                            'High Level Summary of the Risk for Information',
							'High Level Summary for Action / Decision Making',
							'Detailed Information for Action / Decision Making'
                        ]
                    },
                    {
                        shuffle: true,
                        data: [
                            'This person is not informed about this risk',
                            'High Level Summary of the Risk for Information',
							'High Level Summary for Action / Decision Making',
							'Detailed Information for Action / Decision Making'
                        ]
                    }

                ]
            },
            buttons: {
                enabled: ['check', 'reveal', 'reset']
            }
        },
        {
            parent: '.content',
            rows: {
                num: 4,
                height: 40
            },
            cols: {
                num: 5,
                headers: true
            },
            content: [
                [
                    {
                        html: '2x2',
                        colspan: 2,
                        rowspan: 2
                    },
                    '1x1',
                    '1x1',
                    '1x1'
                ],
                [
                    '1x1',
                    {
                        html: '2x2',
                        colspan: 2,
                        rowspan: 2
                    }
                ],
                [
                    {
                        html: '3x3',
                        colspan: 3,
                        rowspan: 1
                    },
                    '1x1',
                    '1x1',
                    '1x1',
                    '1x1'
                ],
                [
                    {
                        html: 'Here\'s a textarea',
                        colspan: 3,
                        input: [
                            {
                                type: 'textarea'
                            },
                            {
                                type: 'textarea'
                            }
                        ]
                    }
                ]
            ],
            plugins: ['extend', 'input', 'save'],
            extend: {
                cols: {
                    enable: true
                },
                rows: {
                    enable: true
                }
            },
            input: {
                type: 'checkbox',
                answer: [
                    [
                        'This is an answer.',
                        'This is another answer.',
                        0,
                        1
                    ]
                ]
            },
            buttons: {
                data: {
                    bomb: {
                        html: 'Explode'
                    }
                },
                enabled: '*'
            },
            feedback: {
                type: 'score'
            }
        },
        {
            rows: {
                num: 6,
                height: 50
            },
            cols: {
                num: 4,
                width: 100,
                headers: true
            },
            content: [
                [
                    'Case number',
                    'Parties',
                    'Court judgment',
                    'Impact',
                    'Bomb',
                    'Sausage'
                ]
            ],
            plugins: ['extend', 'input', 'save'],
            extend: {
                cols: {
                    enable: true
                },
                rows: {
                    enable: true
                }
            },
            input: {
                type: 'textarea'
            },
            buttons: {
                enabled: ['save', 'reset']
            }
        },
        {
            width: 512,
            classes: ['no-borders'],
            rows: {
                num: 6
            },
            cols: {
                num: 4,
                headers: true
            },
            content: [
                ['', 'Swim', 'Fly', 'Walk'],
                ['Human'],
                ['Dog'],
                ['Snake'],
                ['Bird'],
                ['Snail']
            ],
            plugins: ['input', 'save'],
            input: {
                type: 'checkbox',
                answer: [
                    [1, 0, 1],
                    [1, 0, 1],
                    [1, 0, 0],
                    [1, 1, 1],
                    [0, 0, 0]
                ]
            },
            buttons: {
                enabled: ['check', 'reveal', 'save', 'reset', 'retry']
            }
        },
        {
            width: 512,
            rows: {
                num: 4
            },
            cols: {
                num: 4,
                headers: true
            },
            content: [
                [
                    '',
                    'Disagree',
                    'Don\'t care',
                    'Agree'
                ],
                ['Statement 1'],
                ['Statement 2'],
                ['Statement 3']
            ],
            plugins: ['input', 'save'],
            input: {
                type: 'radio',
                answer: [
                    [1, 0, 0],
                    [0, 1, 0],
                    [0, 0, 1]
                ]
            },
            buttons: {
                enabled: ['check', 'reveal', 'save', 'reset']
            }
        },
        {
            width: 512,
            rows: {
                num: 6,
                height: 80
            },
            cols: {
                num: 2,
                headers: true
            },
            content: [
                [
                    'Emphasis in Chomskyan linguistics (tick one)',
                    'Short quotation from reading that supports your answer'
                ],
                [
                    {
                        input: [
                            {
                                label: 'the biological',
                                answer: 1
                            },
                            {
                                label: 'the social'
                            }
                        ]
                    },
                    {
                        input: [
                            {
                                type: 'textarea',
                                answer: 'The child has a universal grammar, so to speak, programmed into his brain as part of his genetic inheritance. (Searle, 1972)'
                            }
                        ]
                    }
                ],
                [
                    {
                        input: [
                            {
                                label: 'theory',
                                answer: 1
                            },
                            {
                                label: 'practice'
                            }
                        ]
                    },
                    {
                        input: [
                            {
                                type: 'textarea',
                                answer: 'Chomsky argued that the goal of linguistic description should be to construct a theory that would account for the infinite number of sentences of a natural language. (Searle, 1972)'
                            }
                        ]
                    }
                ],
                [
                    {
                        input: [
                            {
                                label: 'syntax',
                                answer: 1
                            },
                            {
                                label: 'phonology'
                            },
                            {
                                label: 'lexis'
                            }
                        ]
                    },
                    {
                        input: [
                            {
                                type: 'textarea',
                                answer: 'Chomsky attempted to apply the conventional methods of structural linguistics to the study of syntax, but found that the methods that had apparently worked so well with phonemes and morphemes did not work very well with sentences. (Searle, 1972)'
                            }
                        ]
                    }
                ],
                [
                    {
                        input: [
                            {
                                label: 'languages'
                            },
                            {
                                label: 'language',
                                answer: 1
                            }
                        ]
                    },
                    {
                        input: [
                            {
                                type: 'textarea',
                                answer: 'One traditional argument against the existence of an innate language learning faculty is that human languages are so diverse. … Chomsky has attempted to turn this argument on its head: In spite of surface differences, all human languages have very similar underlying structures… . (Searle, 1972)'
                            }
                        ]
                    }
                ],
                [
                    {
                        input: [
                            {
                                label: 'observation'
                            },
                            {
                                label: 'introspection',
                                answer: 1
                            }
                        ]
                    },
                    {
                        input: [
                            {
                                type: 'textarea',
                                answer: 'Chomsky has used his results about language to try to develop general anti-behaviorist and anti-empiricist conclusions about the nature of the human mind… . (Searle, 1972)'
                            }
                        ]
                    }
                ]
            ],
            plugins: ['input', 'save'],
            input: {
                type: 'radio'
            },
            buttons: {
                enabled: ['reveal', 'save', 'reset']
            }
        },
        {
            rows: {
                num: 7,
                height: 85
            },
            cols: {
                num: 3,
                width: 170,
                headers: true
            },
            content: [
                [
                    'Core views on:',
                    'Linguistic competence',
                    'Communicative competence'
                ],
                [
                    'How people acquire competence',
                    'Innate in all humans.',
                    'Learned through social participation in a speech community.'
                ],
                [
                    'Role of sociocultural context'
                ],
                [
                    'Analytical focus'
                ],
                [
                    'Central understanding of the language user'
                ],
                [
                    'Understanding of language in use'
                ],
                [
                    'Type of empirical evidence used to support the concept'
                ]
            ],
            plugins: ['input', 'save'],
            input: {
                type: 'textarea',
                answer: [
                    [
                        'Irrelevant. Focus is on universals.',
                        'Extremely important. Communicative competence varies according to social context.'
                    ],
                    [
                        'Language in the mind. Form. Is a form grammatical?',
                        'The meanings and functions of language in use. Is language used appropriately?'
                    ],
                    [
                        'Ideal speaker–listener. Seen in isolation.',
                        'Real speakers in real situations, ‘a person in a social world’.'
                    ],
                    [
                        'Performance – an imperfect rendering of competence.',
                        'Language best studied ‘in use’ as it is a system designed for use.'
                    ],
                    [
                        'Introspection of the linguist – sentences invented for the purposes of theoretical exploration.',
                        'Evidence gathered of language use ‘in the field’, i.e. in real (not experimental) settings, using ethnographic methods.'
                    ]
                ]
            },
            buttons: {
                enabled: ['reveal', 'save', 'reset']
            }
        },
        {
            rows: {
                num: 22
            },
            cols: {
                num: 3
            },
            content: [
                ['A:', 'Hello.'],
                ['C:', 'Hi.'],
                ['A:', 'welcome.'],
                ['C:', 'thanks # how are you? (hugs A)'],
                ['A:', 'I’m fine # how are you?'],
                ['C:', 'oh it’s nice to see you WOW (looking from hall into house)'],
                ['A:', 'come in.'],
                ['C:', 'yeah'],
                ['D:', 'hello how are you?'],
                ['A:', 'fine # you’ve # had your hair all cut off'],
                ['C:', 'should I take my shoes off #'],
                ['D:', 'yes I have.'],
                ['A:', 'hmmmm? (to B)'],
                ['C:', 'should I take my shoes off'],
                ['A:', 'Ahh.	 * whatever it doesn’t matter'],
                ['C:', 'WOW * WOW it’s amazing how different furniture looks when it’s able to space out a bit heh'],
                ['A:', 'well * actually * this stuff is uhh'],
                ['C:', 'I know that’s not yours # right?'],
                ['A:', 'yeah # my parents had some stuff left over # but not ours'],
                ['C:', 'but just like the cabinet and uh'],
                ['A:', 'yeah'],
                ['C:', 'wow']
            ],
            plugins: ['input', 'save'],
            input: {
                type: 'textarea'
            },
            buttons: {
                enabled: ['save', 'reset']
            }
        },
        {
            rows: {
                num: 10,
                height: 60
            },
            cols: {
                num: 2,
                headers: true
            },
            content: [
                ['Case', 'Directive 2004/38'],
                ['<em>Commission of the European Communities v Kingdom of Belgium</em> (Case C- 408/03) [2006] ECR I-02647'],
                ['<em>Grzelczyk v Centre public d’aide sociale d’Ottignies-Louvain-la-Neuve</em> (Case C-184/99) [2001] ECR I-06193'],
                ['<em>Pensionsversicherungsanstalt v Peter Brey</em> (Case C-140/12) [2013] ECR I-0'],
                ['<em>Michel Trojani v Centre public d\'aide sociale de Bruxelles</em> (CPAS) (Case C-456/02) [2004] ECR I-07573'],
                ['<em>Office national d’allocations familiales pour travailleurs salariés (ONAFTS) v Radia Hadj Ahmed</em> (Case C-45/12)  13 June 2013'],
                ['<em>Elisabeta Dano and Florin Dano v Jobcenter Leipzig</em> (Case C-333/13) 11 November 2014'],
                ['<em>Athanasios Vatsouras (C-22/08) and Josif Koupatantze (C-23/08) v Arbeitsgemeinschaft (ARGE) Nürnberg 900</em> [2009] ECR I-04585'],
                ['<em>The Queen, on the application of Dany Bidar v London Borough of Ealing and Secretary of State for Education and Skills</em> (Case C-209/03) [2005] ECR -02119'],
                ['<em>Blaise Baheten Metock and Others v Minister for Justice, Equality and Law Reform</em> (Case C-127/08) [2008] ECR  I-06241'],
                ['<em>Hungary v Slovak Republic</em> (Case C-364/10) 16 October 2012'],
                ['<em>Secretary of State for the Home Department v Muhammad Sazzadur Rahman and Others</em> (Case C-83/11) 5 September 2012'],
                ['O v Minister voor Immigratie, Integratie en Asiel and Minister voor Immigratie, Integratie en Asiel v B 12 March 2014'],
                ['<em>The Queen, on the application of Sean Ambrose McCarthy and Others v Secretary of State for the Home Department</em> (Case C-202/13) [2014] 29 June 2013'],
                ['<em>Ruiz Zambrano v Office National de l’Emploi (ONEm)</em> (Case C-34/09) [2011] ECR I-01177'],
                ['<em>Judgment of the Court (Fourth Chamber) of Flora May Reyes v Migrationsverket.Flora May Reyes</em> (Case C-423/12) 16 January 2014']
            ],
            plugins: ['extend', 'input', 'save'],
            input: {
                type: 'textarea'
            },
            extend: {
                rows: {
                    enable: true,
                    max: 30
                }
            },
            buttons: {
                enabled: ['save', 'reset']
            }
        },
        {
            rows: {
                num: 6,
                height: 70
            },
            cols: {
                num: 4,
                headers: true
            },
            content: [
                [
                    'Case number',
                    'Parties',
                    'Facts',
                    'Impact on European Union Citizenship'
                ]
            ],
            plugins: ['extend', 'input', 'save'],
            input: {
                type: 'textarea'
            },
            extend: {
                rows: {
                    enable: true
                }
            },
            buttons: {
                enabled: ['save', 'reset']
            }
        },
        {
            rows: {
                num: 5
            },
            cols: {
                num: 2
            },
            content: [
                ['nerves of'],
                ['please provide written'],
                ['there will be zero'],
                ['a spontaneous'],
                ['pay particular']
            ],
            plugins: ['input'],
            input: {
                type: 'textarea',
                answer: [
                    ['steel'],
                    ['permission (or consent)'],
                    ['tolerance'],
                    ['outburst (or explosion, or round of applause)'],
                    ['attention (or heed)']
                ]
            },
            buttons: {
                enabled: ['reveal', 'reset']
            }
        },
        {
            rows: {
                num: 10
            },
            cols: {
                num: 3,
                headers: true
            },
            layout: 'auto',
            content: [
                [
                    'Example sentence',
                    'Speech act and grammatical form',
                    'Direct or indirect'
                ],
                [
                    'Jean: Hello, Grandad.',
                    {
                        input: {
                            options: 0,
                            answer: 0
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    }
                ],
                [
                    'Billy: I wondered who the hell it was.',
                    {
                        input: {
                            options: 0,
                            answer: 1
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 1
                        }
                    }
                ],
                [
                    'Jean: I’m sorry.',
                    {
                        input: {
                            options: 0,
                            answer: 2
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    }
                ],
                [
                    'Billy: I thought it was some of that mad lot carrying on.',
                    {
                        input: {
                            options: 0,
                            answer: 3
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    }
                ],
                [
                    'Well, come in if you’re coming,',
                    {
                        input: {
                            options: 0,
                            answer: 4
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    }
                ],
                [
                    'it’s draughty standing about in the doorway.',
                    {
                        input: {
                            options: 0,
                            answer: 5
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 1
                        }
                    }
                ],
                [
                    'I’ve only just sat down.',
                    {
                        input: {
                            options: 0,
                            answer: 3
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    }
                ],
                [
                    'Jean: (coming in) Did I disturb you,',
                    {
                        input: {
                            options: 0,
                            answer: 6
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    }
                ],
                [
                    'I am sorry.',
                    {
                        input: {
                            options: 0,
                            answer: 2
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    }
                ]
            ],
            plugins: ['input'],
            input: {
                type: 'select',
                options: [
                    {
                        shuffle: true,
                        data: [
                            'greeting - declarative',
                            'question – declarative',
                            'apology – declarative',
                            'statement – declarative',
                            'invitation – imperative',
                            'command – declarative',
                            'question – interrogative'
                        ]
                    },
                    {
                        data: [
                            'D',
                            'I'
                        ]
                    }
                ]
            },
            buttons: {
                enabled: ['check', 'reveal', 'reset']
            }
        },
        {
            width: 880,
            rows: {
                num: 9,
                height: 100
            },
            cols: {
                num: 5,
                headers: true
            },
            content: [
                ['', 'Clip A OBSERVATION 1', 'Clip B OBSERVATION 2', 'Clip C OBSERVATION 3', 'Comment – how easy to identify? What could/could not be observed?'],
                ['<strong>S</strong>-settings and scenes'],
                ['<strong>P</strong>-participants'],
                ['<strong>E</strong>-ends'],
                ['<strong>A</strong>-acts'],
                ['<strong>K</strong>-keys'],
                ['<strong>I</strong>-instrumentalities'],
                ['<strong>N</strong>-norms'],
                ['<strong>G</strong>-genres']
            ],
            plugins: ['input'],
            input: {
                type: 'textarea',
                answer: [
                    [
                        'Some kind of public space – a park or square',
                        'A business meeting, probably in a conference suite',
                        'A school classroom',
                        'Some basic information about settings not accessible without being physically present, e.g. where (which country, region, institution) and when (date, time). In addition, my judgements were also influenced by the nature of the <em>acts</em> and <em>genres</em> in the different clips, e.g. the language in Clip B is peppered with the lexis of the business world.'
                    ],
                    [
                        'A man and a woman talking',
                        'A main speaker and an audience that was able to ask questions',
                        'A teacher and a classroom of students',
                        'The ethnicity, sex and approximate age of the participants are apparent but not confirmed. Also, there are clues about the relationship between them, in the filmed settings, from the way they interact. I can’t know much more about them without using other kinds of methods, such as interviews or questionnaires.'
                    ],
                    [
                        'The ends seem to be to reach a consensus about the type of flat one or both of the speakers would like to rent or buy.',
                        'The ends for the presenter seem to be to persuade his audience of the efficacy of some new guidelines.',
                        'The ends seem to be to increase the students’ knowledge of rivers.',
                        'This aspect is particularly hard to ascertain from one-off observation. In any case, not all participants may share the same aims.'
                    ],
                    [
                        'The woman uses questions to ascertain the man’s opinion. She also uses a statement to put forward a proposal. The man’s statements seem to be to raise objections to her proposals.',
                        'Explanations from the presenter and questions from the audience',
                        'Commands and questions from the teacher to the students',
                        'Like <em>ends</em>, this is difficult to comment on from a one-off observation. Of course, the speech acts in Clip A would be impossible for a non-Spanish speaker to identify without subtitling in a language they know (raising issues about translation).'
                    ],
                    [
                        'Informal and conflictual – the man seems to be resisting the woman’s ideas.',
                        'Formal, as is typical for communication in this genre',
                        'Informal but clearly the teacher is in charge',
                        'The tone of Clip A is harder for someone who is unfamiliar with the norms of Spanish conversation to ascertain. In this case, it may sound more conflictual to an outsider than it actually is.'
                    ],
                    [
                        'Spoken language accompanied by gaze, gesture, etc.',
                        'Spoken, combined with multimodal communication',
                        'Spoken, combined with multimodal communication',
                        '<em>Instrumentalities</em> (otherwise known as <em>modalities</em> or <em>modes</em> – see Unit 4) seem relatively easy to identify.'
                    ],
                    [
                        'A turn-taking norm is in operation, although there is also overlap, indicating the informal nature of the exchanges.',
                        'The presenter clearly controls ‘the floor’.',
                        'The teacher controls the floor and seems to have the right to direct what is being said and by whom.',
                        'Norms of interaction and of interpretation differ from culture to culture. Observers inevitably bring some assumptions about norms from their own culture which they need to be take account of.'
                    ],
                    [
                        'Informal conversation',
                        'Business presentation',
                        'Classroom lesson',
                        'We recognise these genres because they are familiar in our own culture. The nature of an unfamiliar genre would not always be obvious from observation unless the researcher brings shared knowledge.'
                    ]
                ],
                freeResponseOptions: {
                    showAnswerInPlace: false
                    //hideAttemptOnReveal: false
                }
            },
            buttons: {
                enabled: ['reveal', 'save', 'reset']
            }
        },
        {
            width: 'auto',
            rows: {
                num: 8
            },
            cols: {
                num: 2
            },
            content: [
                [
                    {
                        html: 'Off the record:',
                        colspan: 2
                    }
                ],
                [
                    {
                        input: {
                            options: 0,
                            answer: 0
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    }
                ],
                [
                    {
                        html: 'On the record without redress:',
                        colspan: 2
                    }
                ],
                [
                    {
                        input: {
                            options: 0,
                            answer: 1
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 1
                        }
                    }
                ],
                [
                    {
                        html: 'On the record with positive politeness redress:',
                        colspan: 2
                    }
                ],
                [
                    {
                        input: {
                            options: 0,
                            answer: 2
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 2
                        }
                    }
                ],
                [
                    {
                        html: 'On the record with negative politeness redress:',
                        colspan: 2
                    }
                ],
                [
                    {
                        input: {
                            options: 0,
                            answer: 3
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 3
                        }
                    }
                ]
            ],
            plugins: ['input'],
            input: {
                type: 'select',
                options: [
                    {
                        shuffle: true,
                        data: [
                            'I don’t know how I’m going to catch the train on time.',
                            'Take me to the station.',
                            'Be a sport and give me a lift!',
                            'Is there any chance you could take me to the station?'
                        ]
                    },
                    {
                        shuffle: true,
                        data: [
                            'What time are we scheduled to finish the meeting?',
                            'I want to leave the meeting early.',
                            'Let me leave early and I’ll love you forever!',
                            'Would you mind if I left early?'
                        ]
                    }
                ]
            },
            buttons: {
                enabled: ['check', 'reveal', 'reset']
            }
        },
        {
            width: 'auto',
            rows: {
                num: 14
            },
            cols: {
                num: 6
            },
            content: [
                [
                    {
                        html: '1',
                        rowspan: 2
                    },
                    'She',
                    'bought',
                    'the car',
                    {
                        html: 'from him for £3,000.',
                        colspan: 2
                    }
                ],
                [
                    {
                        input: {
                            options: 0,
                            answer: 0
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    },
                    {
                        input: {
                            options: 0,
                            answer: 3
                        }
                    },
                    {
                        colspan: 2,
                        input: {
                            options: 0,
                            answer: 5
                        }
                    }
                ],
                [
                    {
                        html: '2',
                        rowspan: 2
                    },
                    'He',
                    'sold',
                    'her',
                    'the car',
                    'for £3,000.'
                ],
                [
                    {
                        input: {
                            options: 0,
                            answer: 0
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    },
                    {
                        input: {
                            options: 0,
                            answer: 6
                        }
                    },
                    {
                        input: {
                            options: 0,
                            answer: 3
                        }
                    },
                    {
                        input: {
                            options: 0,
                            answer: 5
                        }
                    }
                ],
                [
                    {
                        html: '3',
                        rowspan: 2
                    },
                    'She',
                    'paid',
                    'him',
                    '£3,000',
                    'for the car.'
                ],
                [
                    {
                        input: {
                            options: 0,
                            answer: 0
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    },
                    {
                        input: {
                            options: 0,
                            answer: 6
                        }
                    },
                    {
                        input: {
                            options: 0,
                            answer: 3
                        }
                    },
                    {
                        input: {
                            options: 0,
                            answer: 5
                        }
                    }
                ],
                [
                    {
                        html: '4',
                        rowspan: 2
                    },
                    'He',
                    'got',
                    '£3,000',
                    {
                        html: 'for the car.',
                        colspan: 2
                    }
                ],
                [
                    {
                        input: {
                            options: 0,
                            answer: 0
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    },
                    {
                        input: {
                            options: 0,
                            answer: 3
                        }
                    },
                    {
                        colspan: 2,
                        input: {
                            options: 0,
                            answer: 5
                        }
                    }
                ],
                [
                    {
                        html: '5',
                        rowspan: 2
                    },
                    'The car',
                    'cost',
                    'her',
                    {
                        html: '£3,000.',
                        colspan: 2
                    }
                ],
                [
                    {
                        input: {
                            options: 0,
                            answer: 2
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 1
                        }
                    },
                    {
                        input: {
                            options: 0,
                            answer: 7
                        }
                    },
                    {
                        colspan: 2,
                        input: {
                            options: 0,
                            answer: 8
                        }
                    }
                ],
                [
                    {
                        html: '6',
                        rowspan: 2
                    },
                    'The car',
                    'was sold',
                    'to her',
                    {
                        html: 'for £3,000.',
                        colspan: 2
                    }
                ],
                [
                    {
                        input: {
                            options: 0,
                            answer: 3
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 0
                        }
                    },
                    {
                        input: {
                            options: 0,
                            answer: 6
                        }
                    },
                    {
                        colspan: 2,
                        input: {
                            options: 0,
                            answer: 5
                        }
                    }
                ],
                [
                    {
                        html: '7',
                        rowspan: 2
                    },
                    'She',
                    'faced',
                    'a £3,000 bill',
                    {
                        html: 'for the car',
                        colspan: 2
                    }
                ],
                [
                    {
                        input: {
                            options: 0,
                            answer: 1
                        }
                    },
                    {
                        input: {
                            options: 1,
                            answer: 2
                        }
                    },
                    {
                        input: {
                            options: 0,
                            answer: 4
                        }
                    },
                    {
                        colspan: 2,
                        input: {
                            options: 0,
                            answer: 5
                        }
                    }
                ]
            ],
            plugins: ['input'],
            input: {
                type: 'select',
                options: [
                    {
                        data: [
                            'Actor',
                            'Actor?',
                            'Carrier',
                            'Goal',
                            'Goal?',
                            'Circumstance',
                            'Recipient',
                            'Beneficiary',
                            'Attribute'
                        ],
                        shuffle: true
                    },
                    {
                        data: [
                            'Pr: material',
                            'Pr: relational: attributive',
                            'Pr: material?'
                        ],
                        shuffle: true
                    }
                ]
            },
            buttons: {
                enabled: ['check', 'reveal', 'reset']
            }
        },
        {
            intro: '<h3>Baby Clinic</h3>',
            width: 'auto',
            rows: {
                num: 23
            },
            cols: {
                num: 4,
                headers: true
            },
            content: [
                ['Speaker', '', 'Process', ''],
                ['Yusra:', 'You', '’re', 'the doctor'],
                ['', '', {
                    input: {
                        options: 0,
                        answer: 0
                    }
                }, ''],
                ['Yusra:', 'I', '’m', 'the nurse'],
                ['', '', {
                    input: {
                        options: 0,
                        answer: 0
                    }
                }, ''],
                ['Daniel:', 'You', '’ll have to write', 'it'],
                ['', '', {
                    input: {
                        options: 0,
                        answer: 1
                    }
                }, ''],
                ['Daniel:', 'I', '’ll be', 'the doctor'],
                ['', '', {
                    input: {
                        options: 0,
                        answer: 0
                    }
                }, ''],
                ['Daniel (doctor):', '<strong>What</strong>', '<strong>’s</strong>', '<strong>the matter</strong>'],
                ['', '', {
                    input: {
                        options: 0,
                        answer: 0
                    }
                }, ''],
                ['Yusra (nurse):', '<strong>I</strong>', '<strong>wrote</strong>', ''],
                ['', '', {
                    input: {
                        options: 0,
                        answer: 1
                    }
                }, ''],
                ['Yusra (nurse):', '<strong>The baby</strong>', '<strong>has</strong>', '<strong>infection</strong>'],
                ['', '', {
                    input: {
                        options: 0,
                        answer: 0
                    }
                }, ''],
                ['Yusra (nurse):', '<strong>The baby</strong>', '<strong>has</strong>', '<strong>infection</strong>'],
                ['', '', {
                    input: {
                        options: 0,
                        answer: 0
                    }
                }, ''],
                ['Yusra (nurse):', '<strong>I</strong>', '<strong>wrote</strong>', '<strong>that for you</strong>'],
                ['', '', {
                    input: {
                        options: 0,
                        answer: 1
                    }
                }, ''],
                ['Yusra (nurse):', '<strong>Where</strong>', '<strong>’s</strong>', '<strong>your baby?</strong>'],
                ['', '', {
                    input: {
                        options: 0,
                        answer: 0
                    }
                }, ''],
                ['Meggie (parent):', '<strong>My baby</strong>', '<strong>is</strong>', '<strong>there</strong>'],
                ['', '', {
                    input: {
                        options: 0,
                        answer: 0
                    }
                }, '']
            ],
            footnote: '<h4>Transcription Key</h4>' +
            '<p><strong>Bold</strong> – children speaking as a role, e.g. nurse<br />' +
            'Roman – children speaking as themselves organising the role-plays</p>',
            plugins: ['input'],
            input: {
                type: 'select',
                options: [
                    {
                        data: [
                            'Relational',
                            'Material',
                            'Mental'
                        ],
                        shuffle: true
                    }
                ]
            },
            buttons: {
                enabled: ['check', 'reveal', 'reset']
            }
        },
        {
            intro: '<h3>The café</h3>',
            width: 'auto',
            rows: {
                num: 14
            },
            cols: {
                num: 4,
                headers: true
            },
            content: [
                [
                    'Meggie (chef)',
                    '<strong>Does she</strong>',
                    '<strong>like</strong>',
                    '<strong>eggies?</strong>'
                ],
                [
                    {
                        colspan: 2
                    },
                    {
                        input: {
                            options: 0,
                            answer: 2
                        }
                    },
                    ''
                ],
                [
                    'Yusra:',
                    '<strong>She</strong>',
                    '<strong>finished</strong>',
                    '<strong>the chicken</strong>'
                ],
                [
                    {
                        colspan: 2
                    },
                    {
                        input: {
                            options: 0,
                            answer: 1
                        }
                    },
                    ''
                ],
                [
                    '3',
                    '<strong>Oh, she</strong>',
                    '<strong>loves</strong>',
                    '<strong>that</strong>'
                ],
                [
                    {
                        colspan: 2
                    },
                    {
                        input: {
                            options: 0,
                            answer: 2
                        }
                    },
                    ''
                ],
                [
                    '4',
                    '<strong>That</strong>',
                    '<strong>’s</strong>',
                    '<strong>a baby one</strong>'
                ],
                [
                    {
                        colspan: 2
                    },
                    {
                        input: {
                            options: 0,
                            answer: 0
                        }
                    },
                    ''
                ],
                [
                    '5',
                    '<strong>That</strong>',
                    '<strong>’s</strong>',
                    '<strong>broccoli</strong>'
                ],
                [
                    {
                        colspan: 2
                    },
                    {
                        input: {
                            options: 0,
                            answer: 0
                        }
                    },
                    ''
                ],
                [
                    '6',
                    '<strong>Who</strong>',
                    '<strong>wants</strong>',
                    '<strong>a princess spoon?</strong>'
                ],
                [
                    {
                        colspan: 2
                    },
                    {
                        input: {
                            options: 0,
                            answer: 2
                        }
                    }
                ],
                [
                    '7',
                    '<strong>My baby</strong>',
                    '<strong>loves</strong>',
                    '<strong>princesses’ spoon</strong>'
                ],
                [
                    {
                        colspan: 2
                    },
                    {
                        input: {
                            options: 0,
                            answer: 2
                        }
                    },
                    ''
                ]
            ],
            plugins: ['input'],
            input: {
                type: 'select',
                options: [
                    {
                        data: [
                            'Relational',
                            'Material',
                            'Mental'
                        ],
                        shuffle: true
                    }
                ]
            },
            buttons: {
                enabled: ['check', 'reveal', 'reset']
            }
        },
        {
            type: 'textarea',
            rows: {
                num: 2,
                height: 50
            },
            cols: {
                num: 4,
                headers: true
            },
            content: [
                [
                    'Time code',
                    'Name',
                    'Spoken language',
                    'Gestures'
                ]
            ],
            plugins: ['extend', 'input', 'save'],
            extend: {
                rows: {
                    enable: true
                }
            },
            input: {
                type: 'textarea'
            },
            buttons: {
                enabled: ['save', 'reset']
            }
        }
    ]
});
