var sentence_completion = (function () {
    "use strict";
    var data = "", i, j, numTries = 0, selects = "";

    var init = function () {
        var options, optionNum = 1, optionString = "", request = new XMLHttpRequest();
        var protocol = location.protocol;
        request.onreadystatechange = function () {
            if ((protocol === "http:" || protocol === "https:") && request.readyState === 4) {
                {
                    if (request.status !== 200) {
                        alert("Error loading data: " + request.status);
                    }
                }
            }
        };
        request.open("GET", "./data/data.json", false);
        request.send(null);
        try {
            data = JSON.parse(request.responseText);
        } catch (e) {
            alert("Parsing error:" + e);
            return;
        }

        var el = document.getElementById('page');
        if (protocol !== "http:" && protocol !== "https:") {
            if (el) {
                el.className = 'first';
            }
        }

        selects = data.html.replace(/__\] \[__/g, "__][__").split("[__SELECT__]");
        for (i = 1; i < selects.length; i++) {
            optionString = optionString + selects[i - 1] + "<select id='cb" + (optionNum++) + "'>";
            options = selects[i].split("__]");
            optionString += "<option value='0'>...</option>";
            for (j = 0; j < options.length - 1; j++) {
                optionString += "<option value='" + (j + 1) + "'>" + options[j].replace(/\[__/g, "") + "</option>";
            }
            optionString += "</select>";
        }
        optionString += selects[selects.length - 1];
        optionString = optionString.replace(/\[__(.*?)__\]/g, "");
        document.getElementById("question").innerHTML = optionString;
        document.getElementById("check").innerHTML = data.buttonCaption || "Check";
    };

    var checkAnswers = function () {
        var feedback = "", ok = true, partial = false, tf, numWrong = 0;
        for (i = 1; i < selects.length; i++) {
            tf = (document.getElementById("cb" + i).selectedIndex === data.corrects[i - 1]);
            ok = ok && tf;
            if (tf) {
                partial = true;
            }
            //remove incorrect answers
            if (data.removeIncorrect) {
                if (document.getElementById("cb" + i).selectedIndex !== data.corrects[i - 1] && document.getElementById("cb" + i).selectedIndex !== 0) {
                    document.getElementById("cb" + i).selectedIndex = 0;
                    numWrong++;
                }
            }
        }
        if (ok) {
            feedback = " " + data.correctFeedback + " " + (data.extraCorrectFeedback || "") + " " + (data.extraFeedback || "");
            disableOptions();
        }
        else {
            numTries++;

            if (partial) {
                feedback += " " + data.partialFeedback;
            }
            else if (!ok) {
                feedback += " " + (numTries > 1 ? data.multipleIncorrectFeedback : data.incorrectFeedback);
            }
            if (data.removeIncorrect && numWrong > 0 && numTries < data.maxTries) {
                feedback += " " + data.removeIncorrectFeedback;
            }
            if (numTries < data.maxTries) {
                feedback += " " + data.intermediateFeedback;
            }

            if (numTries >= data.maxTries) {//fill in correct answers
                feedback += " " + (data.extraIncorrectFeedback || "") + (data.extraFeedback || "");
                for (i = 1; i < selects.length; i++) {
                    document.getElementById("cb" + i).selectedIndex = data.corrects[i - 1];
                }
                disableOptions();
            }
        }
        document.getElementById("feedback").innerHTML = feedback;
        document.getElementById("feedback").style.display = "block";
    };

    var disableOptions = function () {
        for (i = 1; i < selects.length; i++) {
            document.getElementById("cb" + i).disabled = "disabled";
        }
        document.getElementById("check").disabled = "disabled";
    };

    return {
        init: init,
        checkAnswers: checkAnswers,
        disableOptions: disableOptions
    };
}());

sentence_completion.init();
