/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 303);
/******/ })
/************************************************************************/
/******/ ({

/***/ 117:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Ipip50 = function () {
    function Ipip50(identifier, options) {
        _classCallCheck(this, Ipip50);

        this.questionNodes = [];
        this.container = document.querySelector(identifier);
        this.resultsPanel = document.createElement('div');
        this.message = document.createElement('div');
        this.indicatorHolder = document.createElement('div');
        this.scale = {
            "Very Inaccurate": { positive: 1, negative: 5 },
            "Moderately Inaccurate": { positive: 2, negative: 4 },
            "Neither Inaccurate nor Accurate": { positive: 3, negative: 3 },
            "Moderately Accurate": { positive: 4, negative: 2 },
            "Very Accurate": { positive: 5, negative: 1 }
        };
        this.factors = { extraversion: 0, agreeableness: 0, conscientiousness: 0, emotionalstability: 0, intellect: 0 };
        this.questions = [{ text: "Am the life of the party.", factor: "extraversion", keyedPositive: true }, { text: "Feel comfortable around people.", factor: "extraversion", keyedPositive: true }, { text: "Start conversations.", factor: "extraversion", keyedPositive: true }, { text: "Talk to a lot of different people at parties.", factor: "extraversion", keyedPositive: true }, { text: "Don't mind being the center of attention.", factor: "extraversion", keyedPositive: true }, { text: "Don't talk a lot.", factor: "extraversion", keyedPositive: false }, { text: "Keep in the background.", factor: "extraversion", keyedPositive: false }, { text: "Have little to say.", factor: "extraversion", keyedPositive: false }, { text: "Don't like to draw attention to myself.", factor: "extraversion", keyedPositive: false }, { text: "Am quiet around strangers.", factor: "extraversion", keyedPositive: false }, { text: "Am interested in people.", factor: "agreeableness", keyedPositive: true }, { text: "Sympathize with others' feelings.", factor: "agreeableness", keyedPositive: true }, { text: "Have a soft heart.", factor: "agreeableness", keyedPositive: true }, { text: "Take time out for others.", factor: "agreeableness", keyedPositive: true }, { text: "Feel others' emotions.", factor: "agreeableness", keyedPositive: true }, { text: "Make people feel at ease.", factor: "agreeableness", keyedPositive: true }, { text: "Am not really interested in others.", factor: "agreeableness", keyedPositive: false }, { text: "Insult people.", factor: "agreeableness", keyedPositive: false }, { text: "Am not interested in other people's problems.", factor: "agreeableness", keyedPositive: false }, { text: "Feel little concern for others.", factor: "agreeableness", keyedPositive: false }, { text: "Am always prepared.", factor: "conscientiousness", keyedPositive: true }, { text: "Pay attention to details.", factor: "conscientiousness", keyedPositive: true }, { text: "Get chores done right away.", factor: "conscientiousness", keyedPositive: true }, { text: "Like order.", factor: "conscientiousness", keyedPositive: true }, { text: "Follow a schedule.", factor: "conscientiousness", keyedPositive: true }, { text: "Am exacting in my work.", factor: "conscientiousness", keyedPositive: true }, { text: "Leave my belongings around.", factor: "conscientiousness", keyedPositive: false }, { text: "Make a mess of things.", factor: "conscientiousness", keyedPositive: false }, { text: "Often forget to put things back in their proper place.", factor: "conscientiousness", keyedPositive: false }, { text: "Shirk my duties.", factor: "conscientiousness", keyedPositive: false }, { text: "Am relaxed most of the time.", factor: "emotionalstability", keyedPositive: true }, { text: "Seldom feel blue.", factor: "emotionalstability", keyedPositive: true }, { text: "Get stressed out easily.", factor: "emotionalstability", keyedPositive: false }, { text: "Worry about things.", factor: "emotionalstability", keyedPositive: false }, { text: "Am easily disturbed.", factor: "emotionalstability", keyedPositive: false }, { text: "Get upset easily.", factor: "emotionalstability", keyedPositive: false }, { text: "Change my mood a lot.", factor: "emotionalstability", keyedPositive: false }, { text: "Have frequent mood swings.", factor: "emotionalstability", keyedPositive: false }, { text: "Get irritated easily.", factor: "emotionalstability", keyedPositive: false }, { text: "Often feel blue.", factor: "emotionalstability", keyedPositive: false }, { text: "Have a rich vocabulary.", factor: "intellect", keyedPositive: true }, { text: "Have a vivid imagination.", factor: "intellect", keyedPositive: true }, { text: "Have excellent ideas.", factor: "intellect", keyedPositive: true }, { text: "Am quick to understand things.", factor: "intellect", keyedPositive: true }, { text: "Use difficult words.", factor: "intellect", keyedPositive: true }, { text: "Spend time reflecting on things.", factor: "intellect", keyedPositive: true }, { text: "Am full of ideas.", factor: "intellect", keyedPositive: true }, { text: "Have difficulty understanding abstract ideas.", factor: "intellect", keyedPositive: false }, { text: "Am not interested in abstract ideas.", factor: "intellect", keyedPositive: false }, { text: "Do not have a good imagination.", factor: "intellect", keyedPositive: false }];

        this.options = options;
        return this;
    }

    Ipip50.prototype.init = function init(options) {
        var _this = this;

        this.container.className += "slide-viewport";
        // process data questions into dom questions
        this.questions.forEach(function (q, i) {
            var question = _this._makeQuestion(i, q);
            _this.questionNodes.push(question);
        });

        // add questions to slides based on division
        var division = this.options && this.options.hasOwnProperty('division') ? this.options.division : this.questionNodes.length;

        this.indicatorHolder.className = "indicator-holder";
        this.container.insertBefore(this.indicatorHolder, null);
        this._divideSlides(this.questionNodes, division);

        // add button
        this.container.lastChild.appendChild(this._makeButton('Calculate', function () {
            _this._calculate();
        }, "calculate"));

        // add results panel last
        this.container.appendChild(this._makeResultsPanel());
    };

    Ipip50.prototype._divideSlides = function _divideSlides(questions, division) {
        var _this2 = this;

        var iteration = 0;

        var _loop = function _loop() {
            var panel = void 0,
                limit = questions.length;
            division = limit > division ? division : limit; // handles remainder
            panel = _this2._makePanel(questions.splice(0, division), iteration + 1);

            if (iteration > 0) {
                // all but first panel
                panel.appendChild(_this2._makeButton("Back", function () {
                    _this2._activatePanel(panel.previousSibling);
                }, "previous"));
            }

            if (limit > division) {
                // all but last panel
                panel.appendChild(_this2._makeButton("Next", function () {
                    _this2._activatePanel(panel.nextSibling);
                }, "next"));
            }

            if (iteration === 0) _this2._activatePanel(panel); // activate first panel

            _this2.container.appendChild(panel);
            iteration++;
        };

        while (questions.length > 0) {
            _loop();
        }
    };

    Ipip50.prototype._makeQuestion = function _makeQuestion(id, questionObj) {
        var questionBlock = document.createElement('div'),
            questionTxt = document.createElement('div');

        questionBlock.className = "question";
        questionTxt.className = "question-text";
        questionTxt.innerText = questionObj.text;
        questionBlock.appendChild(questionTxt);
        questionBlock.id = id;

        for (var prop in this.scale) {
            var scaleObj = this.scale[prop];
            var option = this._makeOption(id, questionObj, prop, scaleObj.negative, scaleObj.positive);
            questionBlock.appendChild(option);
        }

        return questionBlock;
    };

    Ipip50.prototype._makeOption = function _makeOption(id, questionObj, scalelabel, negative, positive) {
        var _this3 = this;

        var label = document.createElement('label');
        var radio = document.createElement('input');
        label.className = "label";
        label.innerText = scalelabel;
        label.appendChild(radio);
        radio.type = "radio";
        radio.name = '[' + id + '_' + questionObj.factor + ']';
        radio.value = questionObj.keyedPositive ? positive : negative;
        radio.setAttribute('data-question', id);

        radio.addEventListener("change", function (evt) {
            var option = evt.target;
            _this3.questions[option.getAttribute('data-question')].value = parseInt(option.value);
            var parent = option.parentNode;

            while (parent.className.indexOf('question') === -1) {
                parent = parent.parentNode;
            }

            parent.className = "question answered";
        });

        return label;
    };

    Ipip50.prototype._makePanel = function _makePanel(questions, id) {
        var panel = document.createElement('div');
        panel.className = "slide";
        panel.setAttribute("tabindex", "-1");
        panel.setAttribute("hidden", "hidden");
        panel.id = 'panel-' + id;

        // add questions to dom
        questions.forEach(function (q, i) {
            panel.appendChild(q);
        });

        this._addPanelIndicator(panel);

        return panel;
    };

    Ipip50.prototype._addPanelIndicator = function _addPanelIndicator(panel) {
        var _this4 = this;

        var indicator = document.createElement('div');
        indicator.className = "indicator-item";

        indicator.innerText = panel.id.split('-', 2).pop();
        indicator.setAttribute('data-panel', panel.id);

        indicator.addEventListener('click', function (event) {
            _this4._activatePanel(panel);
        });

        this.indicatorHolder.appendChild(indicator);
    };

    Ipip50.prototype._makeResultsPanel = function _makeResultsPanel() {
        var panel = this.resultsPanel;
        panel.className = "slide";
        panel.id = "results";
        panel.setAttribute("tabindex", "-1");
        panel.setAttribute("hidden", "hidden");

        return panel;
    };

    Ipip50.prototype._activatePanel = function _activatePanel(panel) {
        var panels = [].slice.call(this.container.querySelectorAll('.slide'));
        var indicators = [].slice.call(this.container.querySelectorAll('.indicator-item'));

        panels.forEach(function (pEl) {
            pEl.className = "slide";
            pEl.setAttribute("hidden", "hidden");
        });

        indicators.forEach(function (iEl) {
            iEl.className = "indicator-item";
            if (iEl.getAttribute('data-panel') === panel.id) {
                iEl.className = "indicator-item active";
            }

            if (panel.id === "results") {
                iEl.style.display = "none";
            } else {
                iEl.style.display = "";
            }
        });

        panel.removeAttribute("hidden");
        panel.className += " active";
        panel.focus();
    };

    Ipip50.prototype._makeButton = function _makeButton(text, func) {
        var classString = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

        var button = document.createElement('button');
        button.innerText = text;
        button.className = classString || button.className;

        button.addEventListener('click', function (evt) {
            func(evt);
        });

        return button;
    };

    Ipip50.prototype._calculate = function _calculate() {
        var _this5 = this;

        var unanswered = [];
        this.questions.forEach(function (q, i) {
            var questionNode = document.getElementById(i);
            var panelId = questionNode.parentNode.id;
            var indicator = _this5.container.querySelector('.indicator-item[data-panel="' + panelId + '"]');

            if (q.value === undefined) {
                unanswered.push(i);
                questionNode.className = "question unanswered";
                if (indicator.className.indexOf('unanswered') === -1) {
                    indicator.className = indicator.className += " unanswered";
                }
            } else {
                questionNode.className = "question answered";
            }

            switch (q.factor) {
                case "extraversion":
                    _this5.factors.extraversion += q.value;break;
                case "agreeableness":
                    _this5.factors.agreeableness += q.value;break;
                case "conscientiousness":
                    _this5.factors.conscientiousness += q.value;break;
                case "emotionalstability":
                    _this5.factors.emotionalstability += q.value;break;
                case "intellect":
                    _this5.factors.intellect += q.value;break;
            }
        });

        if (unanswered.length > 0) {
            // this.message.innerHTML = "Some questions are unanswered";
            // this.container.parentNode.appendChild(this.message);

            // reset factors if errors
            this.factors = { extraversion: 0, agreeableness: 0, conscientiousness: 0, emotionalstability: 0, intellect: 0 };

            return false;
        }

        if (this.options.hasOwnProperty('postCalc')) {
            this.options.postCalc({
                factors: this.factors,
                resultsPanel: this.resultsPanel,
                resetButton: this._makeButton('Restart', function () {
                    _this5.reset();
                })
            });
        }
        this._activatePanel(this.resultsPanel);

        // this.resultsPanel.appendChild(this._makeButton('Restart', () => {
        //     this.reset();
        // }));

        return this.factors;
    };

    Ipip50.prototype.reset = function reset() {
        var radios = [].slice.call(this.container.querySelectorAll('input[type=radio]'));
        var questionNodes = [].slice.call(this.container.querySelectorAll('.question'));

        questionNodes.forEach(function (el) {
            el.className = "question";
        });

        radios.forEach(function (el) {
            el.checked = false;
        });

        this.questions.forEach(function (el) {
            delete el.value;
        });

        this.factors = { extraversion: 0, agreeableness: 0, conscientiousness: 0, emotionalstability: 0, intellect: 0 };

        this._activatePanel(this.container.querySelector(".slide"));
    };

    return Ipip50;
}();

exports.Ipip50 = Ipip50;

/***/ }),

/***/ 118:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});
var Resizer = function Resizer() {
	this.container = undefined;
	this.transition = false;
	this.height;
	this.anonFunction;
};
Resizer.prototype = {

	resize: function resize(element) {
		this.container = document.querySelector(element);
		//let height = this.conatiner.getBoundingClientRect()
		this.height = parseFloat(getComputedStyle(this.container).height);
		return this;
	},

	withTransition: function withTransition() {
		this.transition = true;
		return this;
	},

	doAction: function doAction(anonFunction) {
		this.anonFunction = anonFunction;
		return this;
	},

	init: function init() {
		var transitionEventName = this._whichTransitionEvent();

		if (!transitionEventName || !this.transition) {
			this._fallBackEvent();
			return;
		}

		this._transitionEvent(transitionEventName);
		return;
	},

	_transitionEvent: function _transitionEvent(transitionEventName) {
		/* Listen for a transition! */
		this.container.addEventListener(transitionEventName, function () {
			var heightAfterTransition = parseFloat(getComputedStyle(this.container).height);

			if (heightAfterTransition > this.height) {
				this.height = heightAfterTransition;
				this.anonFunction();
			}
		});
	},

	_fallBackEvent: function _fallBackEvent() {

		this.container.addEventListener("click", function () {
			this._fallBackEventHeightCheck();
		}.bind(this));

		this.container.addEventListener("keyup", function (evt) {
			if (evt.keyCode === 13 || evt.keyCode === 39) {
				this._fallBackEventHeightCheck();
			}
		}.bind(this));
	},

	_fallBackEventHeightCheck: function _fallBackEventHeightCheck() {
		var heightAfterChange = parseFloat(getComputedStyle(this.container).height);

		if (heightAfterChange > this.height) {
			this.height = heightAfterChange;
			var timeout = setTimeout(function () {
				this.anonFunction();
				clearTimeout(timeout);
			}.bind(this), 100);
		}
	},

	/**
  * Below code implements vle resize script taking css transitions into account
  */
	/* From Modernizr */
	_whichTransitionEvent: function _whichTransitionEvent() {
		var t,
		    el = document.createElement("fakeelement"),
		    transitions = {
			"transition": "transitionend",
			"OTransition": "oTransitionEnd",
			"MozTransition": "transitionend",
			"WebkitTransition": "webkitTransitionEnd"
		};

		for (t in transitions) {
			if (el.style[t] !== undefined) {
				return transitions[t];
			}
		}

		return false;
	}

};

exports.Resizer = Resizer;

/***/ }),

/***/ 119:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
		value: true
});
var Data = {
		"config": {
				"attempts": 3
		},
		"html": "\n\t\t<h2>Extraversion</h2>\n\t\t<p>Extraversion is marked by pronounced engagement with the external world. Extraverts enjoy being with people, are full of energy, and often experience positive emotions. They tend to be enthusiastic, action-oriented, individuals who are likely to say \"Yes!\" or \"Let's go!\" to opportunities for excitement. In groups they like to talk, assert themselves, and draw attention to themselves.</p>\n\t\t<p>Introverts lack the exuberance, energy, and activity levels of extraverts. They tend to be quiet, low-key, deliberate, and disengaged from the social world. Their lack of social involvement should not be interpreted as shyness or depression; the introvert simply needs less stimulation than an extravert and prefers to be alone. The independence and reserve of the introvert is sometimes mistaken as unfriendliness or arrogance. In reality, an introvert who scores high on the agreeableness dimension will not seek others out but will be quite pleasant when approached.</p>\n\n\t\t<h2>Agreeableness</h2>\n\t\t<p>Agreeableness reflects individual differences in concern with cooperation and social harmony. Agreeable individuals value getting along with others. They are therefore considerate, friendly, generous, helpful, and willing to compromise their interests with others'. Agreeable people also have an optimistic view of human nature. They believe people are basically honest, decent, and trustworthy.</p>\n\t\t<p>Disagreeable individuals place self-interest above getting along with others. They are generally unconcerned with others' well-being, and therefore are unlikely to extend themselves for other people. Sometimes their skepticism about others' motives causes them to be suspicious, unfriendly, and uncooperative.</p>\n\t\t<p>Agreeableness is obviously advantageous for attaining and maintaining popularity. Agreeable people are better liked than disagreeable people. On the other hand, agreeableness is not useful in situations that require tough or absolute objective decisions. Disagreeable people can make excellent scientists, critics, or soldiers.</p>\n\n\t\t<h2>Conscientiousness</h2>\n\t\t<p>Conscientiousness concerns the way in which we control, regulate, and direct our impulses. Impulses are not inherently bad; occasionally time constraints require a snap decision, and acting on our first impulse can be an effective response. Also, in times of play rather than work, acting spontaneously and impulsively can be fun. Impulsive individuals can be seen by others as colorful, fun-to-be-with, and zany.</p>\n\t\t<p>Nonetheless, acting on impulse can lead to trouble in a number of ways. Some impulses are antisocial. Uncontrolled antisocial acts not only harm other members of society, but also can result in retribution toward the perpetrator of such impulsive acts. Another problem with impulsive acts is that they often produce immediate rewards but undesirable, long-term consequences. Examples include excessive socializing that leads to being fired from one's job, hurling an insult that causes the breakup of an important relationship, or using pleasure-inducing drugs that eventually destroy one's health.</p>\n\t\t<p>Impulsive behavior, even when not seriously destructive, diminishes a person's effectiveness in significant ways. Acting impulsively disallows contemplating alternative courses of action, some of which would have been wiser than the impulsive choice. Impulsivity also sidetracks people during projects that require organized sequences of steps or stages. Accomplishments of an impulsive person are therefore small, scattered, and inconsistent.</p>\n\t\t<p>A hallmark of intelligence, what potentially separates human beings from earlier life forms, is the ability to think about future consequences before acting on an impulse. Intelligent activity involves contemplation of long-range goals, organizing and planning routes to these goals, and persisting toward one's goals in the face of short-lived impulses to the contrary. The idea that intelligence involves impulse control is nicely captured by the term prudence, an alternative label for the Conscientiousness domain. Prudent means both wise and cautious. Persons who score high on the Conscientiousness scale are, in fact, perceived by others as intelligent.</p>\n\t\t<p>The benefits of high conscientiousness are obvious. Conscientious individuals avoid trouble and achieve high levels of success through purposeful planning and persistence. They are also positively regarded by others as intelligent and reliable. On the negative side, they can be compulsive perfectionists and workaholics. Furthermore, extremely conscientious individuals might be regarded as stuffy and boring. Unconscientious people may be criticized for their unreliability, lack of ambition, and failure to stay within the lines, but they will experience many short-lived pleasures and they will never be called stuffy.</p>\n\n\t\t<h2>Neuroticism</h2>\n\t\t<p>Freud originally used the term neurosis to describe a condition marked by mental distress, emotional suffering, and an inability to cope effectively with the normal demands of life. He suggested that everyone shows some signs of neurosis, but that we differ in our degree of suffering and our specific symptoms of distress. Today neuroticism refers to the tendency to experience negative feelings. Those who score high on Neuroticism may experience primarily one specific negative feeling such as anxiety, anger, or depression, but are likely to experience several of these emotions. People high in neuroticism are emotionally reactive. They respond emotionally to events that would not affect most people, and their reactions tend to be more intense than normal. They are more likely to interpret ordinary situations as threatening, and minor frustrations as hopelessly difficult. Their negative emotional reactions tend to persist for unusually long periods of time, which means they are often in a bad mood. These problems in emotional regulation can diminish a neurotic's ability to think clearly, make decisions, and cope effectively with stress.</p>\n\t\t<p>At the other end of the scale, individuals who score low in neuroticism are less easily upset and are less emotionally reactive. They tend to be calm, emotionally stable, and free from persistent negative feelings. Freedom from negative feelings does not mean that low scorers experience a lot of positive feelings; frequency of positive emotions is a component of the Extraversion domain.</p>\n\n\t\t<h2>Openness to Experience</h2>\n\t\t<p>Openness to Experience describes a dimension of cognitive style that distinguishes imaginative, creative people from down-to-earth, conventional people. Open people are intellectually curious, appreciative of art, and sensitive to beauty. They tend to be, compared to closed people, more aware of their feelings. They tend to think and act in individualistic and nonconforming ways. Intellectuals typically score high on Openness to Experience; consequently, this factor has also been called Culture or Intellect. Nonetheless, Intellect is probably best regarded as one aspect of openness to experience. Scores on Openness to Experience are only modestly related to years of education and scores on standard intelligent tests.</p>\n\t\t<p>Another characteristic of the open cognitive style is a facility for thinking in symbols and abstractions far removed from concrete experience. Depending on the individual's specific intellectual abilities, this symbolic cognition may take the form of mathematical, logical, or geometric thinking, artistic and metaphorical use of language, music composition or performance, or one of the many visual or performing arts. People with low scores on openness to experience tend to have narrow, common interests. They prefer the plain, straightforward, and obvious over the complex, ambiguous, and subtle. They may regard the arts and sciences with suspicion, regarding these endeavors as abstruse or of no practical use. Closed people prefer familiarity over novelty; they are conservative and resistant to change.</p>\n\t\t<p>Openness is often presented as healthier or more mature by psychologists, who are often themselves open to experience. However, open and closed styles of thinking are useful in different environments. The intellectual style of the open person may serve a professor well, but research has shown that closed thinking is related to superior job performance in police work, sales, and a number of service occupations.</p>\n\t\n\t"
};

exports.Data = Data;

/***/ }),

/***/ 120:
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ 121:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "libs/FileSaver.js";

/***/ }),

/***/ 303:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _Resizer = __webpack_require__(118);

var _Ipip = __webpack_require__(117);

__webpack_require__(120);

var _data = __webpack_require__(119);

__webpack_require__(121);

//import "file-loader?name=[name].[ext]!./data/data.js";


// import additional assets
// import custom modules
var quiz = new _Ipip.Ipip50('#test', {
        division: 10,
        postCalc: function postCalc(data) {
                var factor = data.factors;

                var btn = document.createElement('button');
                var note = document.createElement('div');
                var info = document.createElement('div');

                var htmlSummary = "Extraversion: " + factor.extraversion + "\r\n\nAgreeableness: " + factor.agreeableness + "\r\n\nConscientiousness: " + factor.conscientiousness + "\r\n\nEmotional Stability: " + factor.emotionalstability + "\r\n\nIntellect: " + factor.intellect + "\r\n\r\n";

                btn.innerText = "Download";
                btn.className = "download-btn";
                btn.addEventListener("click", function () {
                        saveTextAs(htmlSummary, "results.txt");
                });

                note.innerText = htmlSummary + "*If you encounter any issues downloading the file please copy and paste.";
                note.className = "download-note";

                data.resultsPanel.appendChild(note);
                data.resultsPanel.appendChild(btn);
                data.resultsPanel.appendChild(data.resetButton);
                data.resultsPanel.appendChild(info);

                info.innerHTML = _data.Data.html;
        }
}).init();

// let resizer = new Resizer();
// resizer.resize('#test').init();
// let buttons = [].slice.call(document.querySelectorAll('button'));
// buttons.forEach((btn) => {
//     btn.addEventListener("click", () => {
//         resizer.resize('#test').init();
//     });
// });

// [].slice.call(document.querySelectorAll('#test input[type=radio]')).forEach((el)=>{
//     const group = Array.from(document.querySelectorAll(`input[name="${el.name}"]`));
//     const checked = document.querySelector(`input[name="${el.name}"]:checked`);

//     if (checked === null) {
//         const item = group[~~(Math.random() * group.length)];
//         const event = new Event('change');
//         item.checked = true;
//         item.dispatchEvent(event);
//     }
//  });

//import "file-loader?name=img/[name].[ext]!./img/gauge.jpg";


// import additional assets

/***/ })

/******/ });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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