/* Copyright 2011 Jason Davies https://github.com/jasondavies/newick.js */
function parseNewick(a){for(var e=[],r={},s=a.split(/\s*(;|\(|\)|,|:)\s*/),t=0;t<s.length;t++){var n=s[t];switch(n){case"(":var c={};r.branchset=[c],e.push(r),r=c;break;case",":var c={};e[e.length-1].branchset.push(c),r=c;break;case")":r=e.pop();break;case":":break;default:var h=s[t-1];")"==h||"("==h||","==h?r.name=n:":"==h&&(r.length=parseFloat(n))}}return r}



/* Parts copyright 2016 Mike Bostock https://d3js.org */
var allData = [];
var HCM; //set flag if in Windows high contrast mode
//var bgColor = "white", strokeColor = "black";
var bgColor, strokeColor;
var outerRadius = window.innerWidth / 2.5,
    innerRadius = outerRadius - 140;
var nodecount = 0;
var storeArrayNames = [];
var firstTime = true;
//console.log (window.innerWidth, window.innerHeight);
//console.log (innerRadius, outerRadius);
if (outerRadius < 140)
	alert ("Window too small to display image. If you're using a mobile phone try turning it to landscape mode and refreshing the page.");
// A data object that will be saved to the VLE for storing a selected list of ingredients.
var vledata = {
	'ingredients': '',
	'speciesnames':''
};

var categories = ["Poultry, meat and dairy", "Fish", "Shellfish", "Leafy and flowery vegetables", "Roots, bulbs and tubers", "Fruiting vegetables", "Peas and beans", "Fruit", "Nuts, seeds and oils", "Grains and cereals", "Herbs and spices", "Algae and seaweeds", "Mushrooms", "Micro-organisms", "Miscellaneous"];

var color = d3.scaleOrdinal()
    .domain(["Prokaryota","Fungi", "Animalia", "Protista", "Plantae"]) //d3 domains not to be confused with taxonomical domains!
	//this array needs to match the high level groups used in the Newick data, which in the Mike Bostock example is just the 3 taxonmic domains but in my version will presumably be kingdoms. The setColor function below then looks for these strings in the Newick file and colors those nodes and each of their children accordingly
	//.domain(["Bacteria", "Archaea", "Protozoa","Chromista","Plantae","Fungi","Animalia"]) //kingdoms - to use when I have appropriate newick data
    //.range(d3.schemeCategory10);
	//custom color range
	
	.range([
		//fully saturated colours so need to change the opacity in key squares to match the pie chart segments	
		d3.rgb('#ff3c00'), //prokaryota
		d3.rgb('#1f77b4'), //fungi
		d3.rgb('#cdb4ed'), //animalia
		d3.rgb('#133714'), //protista (algae)
		d3.rgb('#5eff6d')  //plantae
	]);
	
	
	
var cluster = d3.cluster()
    .size([360, innerRadius]) //360 creates a full circle for the dendrogram. 180 would give a semi-circle, in the unlikely event that's useful
    .separation(function(a, b) { return 1; });

	
var svg = d3.select("body").append("svg");

var currentX= outerRadius;
var currentY = outerRadius;
var currentScale = 1;

    HCM = HCTest();
    if (HCM === true) {
        console.log('in high contrast mode');
		//set colours of labels, lines and background in SVG here. Invert display
		bgColor = "black";
		strokeColor = "yellow";
    } else {
        console.log('not in high contrast mode');
		bgColor = "white";
		strokeColor = "black";
    }
	$("body").css("background-color", bgColor);
	$("#treeoflife").css("background-color", bgColor);

	
var zoom = d3.zoom()

    .scaleExtent([1, 10]) //limit to 10x magnification and no lower than 100%
	.on('zoom', function() {
		//ANS added zooming. 
		var t = d3.event.transform;
		//console.log (t);
		var src;
		try {
			src = d3.event.sourceEvent.toString();
		}
		catch(err) {
			src = 'null';// if zoom is called via the buttons rather than mousewheel or dragging to pan
		}
		//centre first time, after that depends on mouse position
		if (firstTime) { 
			t.x = currentX; 
			t.y = currentY; 
			firstTime = false;
		}
		//needs to be applied to group not whole svg for IE,Safari
		svg.select("#main_group").attr("transform", t); 
	
		currentX = t.x; currentY = t.y;
		currentScale = t.k; //store current zoom level so it can be taken into account when using the pan buttons
		
  })//end of zoom function
  

svg.attr("width", outerRadius * 2)
    .attr("height", outerRadius * 2)
	.attr("id", "treeoflife")
	.attr("z-index", -1)
	.attr("focusable", "false")
	.call(zoom) //allow mousewheel zooming
	

var chart = svg.append("g")
	.attr("transform", "translate(" + outerRadius + "," + outerRadius + ")")
	.attr("id", "main_group")
	
	
//kingdoms legend. would this be better done with divs rather than part of SVG. Move to top left as advised by accessibility testing - less scrolling around when zoomed in

//background to the key
var legendBack = svg.append("rect")
	.attr("transform", function(d, i) { return "translate(" + (outerRadius *0.001) + "," + (outerRadius*0.21+i * 20 + 50) + ")"; })
	.attr("width", 150)
	.attr("height", 130)
	.attr("fill", bgColor)
	
var legend = svg.append("g")
    .attr("class", "legend")
	.attr("id","legendBox")
	
  .selectAll("g")
  .data(color.domain())
  .enter().append("g").attr("class", "legend")
    .attr("transform", function(d, i) { return "translate(" + (outerRadius *0.3) + "," + (outerRadius*0.23+i * 20 + 50) + ")"; }); //bottom left
	//.attr("transform", function(d, i) { return "translate(" + (outerRadius*0.98) + "," + (outerRadius*0.72+i * 20 + 10) + ")"; }); //centre

//the coloured squares	
legend.append("rect")
    .attr("x", -15)
    .attr("width", 18)
    .attr("height", 18)
    .attr("fill", color)
	.attr("opacity", 0.3);

legend.append("text")
	
    .attr("x", -23)
    .attr("y", 9)
    .attr("dy", ".35em")
    .attr("text-anchor", "end")
	.attr("fill",strokeColor)
    .text(function(d) { return d; });

	
$( window ).resize(function() {
	//to do - resize chart here?
	/*
	console.log("resize");
	outerRadius = window.innerWidth / 2.5;
    innerRadius = outerRadius - 140;
	svg.attr("width", outerRadius * 2)
		.attr("height", outerRadius * 2)
		
	chart.attr("transform", "translate(" + outerRadius + "," + outerRadius + ")");
	
	currentX= outerRadius;
	currentY = outerRadius;
	scale = outerRadius/200;
	
	
	svg.select("#main_group").attr("transform", "translate("+ outerRadius + "," + outerRadius + ")scale("+currentScale+")")
	
	*/
});


	
//read the data and process	
d3.text("ediblespecies_phylo.txt", function(error, life) {
  //Mike Bostock
  if (error) throw error;

  var root = d3.hierarchy(parseNewick(life), function(d) { return d.branchset; })
      .sum(function(d) { return d.branchset ? 0 : 1; })
      .sort(function(a, b) { return (a.value - b.value) || d3.ascending(a.data.length, b.data.length); });

  cluster(root);
  
  

  setRadius(root, root.data.length = 0, innerRadius / maxLength(root));
  setColor(root);

  var linkExtension = chart.append("g")
      .attr("class", "link-extensions")
    .selectAll("path")
    .data(root.links().filter(function(d) { return !d.target.children; }))
    .enter().append("path")
      .each(function(d) { d.target.linkExtensionNode = this; })
      .attr("d", linkExtensionConstant);

  var link = chart.append("g")
      .attr("class", "links")
    .selectAll("path")
    .data(root.links())
    .enter().append("path")
      .each(function(d) { d.target.linkNode = this; })
      .attr("d", linkConstant)
      .attr("stroke", function(d) { 
			return strokeColor;//d.target.color; 
				});
	highlightSVGBackground();
  chart.append("g")
    .attr("class", "labels")
    .selectAll("text")
    .data(root.leaves())
    .enter().append("text")
      .attr("dy", ".31em")
      .attr("transform", function(d) { return "rotate(" + (d.x - 90) + ")translate(" + (innerRadius + 4) + ",0)" + (d.x < 180 ? "" : "rotate(180)"); })
      .attr("text-anchor", function(d) { return d.x < 180 ? "start" : "end"; })
	  .style('fill', strokeColor)
      .text(function(d) { 
		
		if (d.data.name.indexOf('_ott') > 0)
			return d.data.name.substr(0, d.data.name.indexOf('_ott')).replace(/_/g, " "); 
		else
			return d.data.name.replace(/_/g, " ");
		})
      .attr('id', function(d) {	
		
		//console.log(d.data.name.substr(0, d.data.name.indexOf('_ott')).replace(/_/g, " "));
		if (d.data.name.indexOf('_ott') > 0)
			return d.data.name.substr(0, d.data.name.indexOf('_ott')); 
		else
			return d.data.name;
		})
	.attr("tabindex", function(d) {
		nodecount++;
		//console.log (nodecount);
		//return nodecount+1000;
		return -1; //disabled for the time being as it was tabbing through all 600 species before getting to the ingredients and not sure how useful that is anyway. can I turn on tabindexes dynamically at some point, or skip to svg/ ingredients?
	})
	.attr("focusable","t")
	  //.attr('visibility','hidden') //ANS - could be hidden to start with if we think it'll be too cluttered with text of 600 species
      .on("mouseover", mouseovered(true))
	  .on("focus", mouseovered(true))
      .on("mouseout", mouseovered(false));
	//end of Mike Bostock code
	
	//ANS
	//read ingredients data from ingredients.js and set up accordion with checkboxes in groups of food types
	
	$("body").append ('<div id = "ingredientsDiv">')
	$("body").append('<div id = "ingredientsButtonsDiv"> <button id="saveList" aria-label = "export ingredients list" tabIndex = "9" onclick = "saveList()">Export</button><button id="clearList" aria-label = "clear ingredients list" tabIndex = "10" onclick = "clearList()">Clear all</button>');
	
	//select all btn just for debug purposes to check we haven't missed any ingredients that are in Newick file
	//$("#ingredientsButtonsDiv").append('<button id="selectAll" aria-label = "select all ingredients" onclick = "selectAll()">All</button>');
	
	$("#ingredientsButtonsDiv").append("<br/><br/><input type='text' id = 'findWordBox' tabIndex = '11' aria-label = 'type an ingredient to find then press enter' style = 'display:inline; width:90px;margin-left:4px;'/>")
	
	$("#findWordBox").keyup(function(event) {
		if (event.keyCode === 13) {
			$("#findBtn").click();
		}
	});
		
	$("#ingredientsButtonsDiv").append('<button id="findBtn" aria-label = "find ingredient" style = "display:inline;" tabIndex = "12" onclick = "filter()">Find</button>');
	//$("#ingredientsButtonsDiv").append('<button id="allBtn" style = "display:inline" aria-label = "remove filter and show all ingredients" onclick = "removeFilter()">All</button>');
	$("#ingredientsButtonsDiv").append('<br/><span id = "fullListLink" style = "display:none" tabIndex = "13"><a href="javascript:removeFilter();" >Back to full list</a></span>');
	
	$("#fullListLink").keyup(function(event) {
		if (event.keyCode === 13) {
			removeFilter();
		}
	});
	/*
	$( "*" ).focus(function() {
		console.log(document.activeElement + ", " + document.activeElement.id + " has the focus");
	});
	*/
	$("#body").append('</div><i><b>Select ingredients:</b></i></div>');
	$("#ingredientsDiv").append('<div id = "panels" >');
	for (var i = 0; i < categories.length; i++) {
		$("#panels").append('<button id = accordion'+i+' otabIndex = '+(50+i)+'" class="accordion"> ► '+ categories[i]+'</button');
		var panelid = ("panel"+i)
		
		$("#panels").append('<div class="panel" id = '+panelid+' tabIndex = "-1">');
		
		for (var j = 0; j < data.ingredients.length; j++) 
		{
			var itemname = data.ingredients[j].common_name;
			//can be multiple species related to one ingredient so these now arrays
			var commonnames = [];//data.ingredients[j].species_name_common;
			var latinnames = [];//data.ingredients[j].species_name_latin;
			var family = data.ingredients[j].family;
			var kingdom = data.ingredients[j].kingdom;
		
			//var speciesClickName = latinname.replace(" ", "_");
			
			
			//need something like below if we're going to have multiple species for each ingredient
			/*
			for (var k = 0; k < data.ingredients[j].unique_name.length; k++) 
			{
				//console.log(data.ingredients[j].species_name_latin[k])
				commonnames.push (data.ingredients[j].common_name[k])
				latinnames.push (data.ingredients[j].unique_name[k])
			}
			*/
			latinnames.push (data.ingredients[j].unique_name)
			allData[j] = new Ingredient(itemname, latinnames, family, kingdom);
			
			var cbid = j;//("cb"+j);
			
			if (categories[i] === data.ingredients[j].food_group)
			{
				var cb = '<span id = span'+j+'><label><input type="checkbox" id = '+cbid+' otabIndex = '+j+'" class = "cb_class" onclick = "selectIngredient(this.checked, this.id)">'+ itemname+'</label><br/></span>';
				//console.log(cb);
				$("#"+panelid).append(cb);	
			}		
		}
		$("#panels").append('</div>');
		$("#ingredientsDiv").append('</div>');
	}
	$("body").append ('</div')
	
	//add events to accordion
	var acc = document.getElementsByClassName("accordion");

	for (var i = 0; i < acc.length; i++) {
		acc[i].onclick = function(){
			this.classList.toggle("active");
			var open =this.innerHTML.indexOf('▼');
		
			if (open==-1)
				this.innerHTML = this.innerHTML.replace('►','▼');
			else
				this.innerHTML = this.innerHTML.replace('▼','►');
				
			var panel = this.nextElementSibling;
			if (panel.style.display === "block") {
				panel.style.display = "none";
			} else {
				panel.style.display = "block";
				
			}
		}
	}

	//clear checkboxes to begin with.  (users' selections stored on VL)?
	$(".cb_class").prop("checked", false);
	
	simulateDrag();	//desperate hack to fake first mouse interaction with tree of life to prevent jump to top left corner	
	$("#zoom_in").focus(); //need a sensible place for the tab order to start, otherwise seems to go through all svg nodes even though tab indexes are 100+

	
	document.getElementById("cb_shadeKingdoms").checked = true;
}); //end of text file processing


/*-------------------------------------------*/ //start of Mike Bostock code
function moveToFront() {
	this.parentNode.appendChild(this);
}
  
// Compute the maximum cumulative length of any node in the tree.
function maxLength(d) {
  return d.data.length + (d.children ? d3.max(d.children, maxLength) : 0);
}

// Set the radius of each node by recursively summing and scaling the distance from the root.
function setRadius(d, y0, k) {
  d.radius = (y0 += d.data.length) * k;
  if (d.children) d.children.forEach(function(d) { setRadius(d, y0, k); });
}

// Set the color of each node by recursively inheriting.
function setColor(d) {
  var name = d.data.name;
  //console.log(name);
  
  //ANS I think what this is doing is looking in the Newick data for one of the strings in the color.domain array (Bacteria, Eukaryota, Archaea in the Bostock example data but hopefully kingdoms in mine eventually) and if it finds it it sets the color of that node and all its children accordingly  
  d.color = color.domain().indexOf(name) >= 0 ? color(name) : d.parent ? d.parent.color : null;
  //console.log("d.color = ",d.color);
  
  if (d.children) d.children.forEach(setColor);
}

function linkVariable(d) {
  return linkStep(d.source.x, d.source.radius, d.target.x, d.target.radius);
}

function linkConstant(d) {
  return linkStep(d.source.x, d.source.y, d.target.x, d.target.y);
}

function linkExtensionVariable(d) {
  return linkStep(d.target.x, d.target.radius, d.target.x, innerRadius);
}

function linkExtensionConstant(d) {
  return linkStep(d.target.x, d.target.y, d.target.x, innerRadius);
}

// Like d3.svg.diagonal.radial, but with square corners.
function linkStep(startAngle, startRadius, endAngle, endRadius) {
  var c0 = Math.cos(startAngle = (startAngle - 90) / 180 * Math.PI),
      s0 = Math.sin(startAngle),
      c1 = Math.cos(endAngle = (endAngle - 90) / 180 * Math.PI),
      s1 = Math.sin(endAngle);
  return "M" + startRadius * c0 + "," + startRadius * s0
      + (endAngle === startAngle ? "" : "A" + startRadius + "," + startRadius + " 0 0 " + (endAngle > startAngle ? 1 : 0) + " " + startRadius * c1 + "," + startRadius * s1)
      + "L" + endRadius * c1 + "," + endRadius * s1;
}

//roll over the text labels to highlight that node. Not sure if we're going to show these labels - too much text if 600 species I suspect
function mouseovered(active) {
	return function(d) {
		highlightNode(d, active);
		var mouseoveredname = d.data.name.replace(/_/g, " "); //get latin name you've moused over
		//console.log (mouseoveredname);
		
		for (var i = 0; i<data.ingredients.length; i++)
		{
			if (data.ingredients[i].unique_name == mouseoveredname)
				showTaxonomy(i, active); 
		}
		
		//re-highlight any species that are selected in ingredients list
		for (var i = 0; i<storeArrayNames.length; i++) {
		highlightNode(d3.select('#'+storeArrayNames[i]).data()[0], true);
	}
	
	};
}
/*-------------------------------------------*/ //end of Mike Bostock code
function highlightKingdom(kingdom)
{
	//highlightNode(d3.select('#'+species).data()[0], true);
	
	for (var i = 0; i<data.ingredients.length; i++)
	{
		if (data.ingredients[i].kingdom == "NA")
		{
			var species = data.ingredients[i].unique_name.replace(" ","_");
			selectSpecies(species, true, i)
		}
	}
}

//called by selecting checkboxes in ingredients list - highlights the corresponding species in the tree of life
function selectIngredient (active, id)
{
	var storeArray = []; //to store checkbox ids on vle so these can be checked on reloading page
	
	for (var i = 0; i<data.ingredients.length; i++)
	{
		if($("#"+i).prop( "checked" ))
		{
			storeArray.push(i);
			//console.log(i);
		}
	}
	//console.log (storeArray);
	vledata.ingredients = storeArray;
		
	//select all species associated with this ingredient. Use this type of code if we're
	//going to have multiple species for each ingredient
	/*
	for (var i = 0; i<data.ingredients[id].unique_name.length; i++)
	{
		var species = data.ingredients[id].unique_name[i].replace(" ","_");
		
		selectSpecies(species, active, id)
	}
	*/
	var species = data.ingredients[id].unique_name.replace(/ /g,"_");
	
	selectSpecies(species, active, id)
	
	//re-highlight any selected nodes
	for (var i = 0; i<storeArrayNames.length; i++) {
		highlightNode(d3.select('#'+storeArrayNames[i]).data()[0], true);
	}
	vledata.speciesnames = JSON.stringify(storeArrayNames);
	//console.log(vledata.speciesnames);
	storeVLEdata();
}
	

function selectSpecies (species, active, id)
{
	var idx = $.inArray(species, storeArrayNames);
	if (active)
	{	
		//ANS changed 19-02-2018 to allow species to be pushed to array twice so that in cases (e.g. soybean, endamame, where same species is highlighted, unchecking box doesn't remove the highlighted line which is still valid for the other ingredient
		//if (idx == -1) {
			storeArrayNames.push(species); //add species to array if not already present
		//} 
	}
	else 
	{
		if (idx != -1) 
			storeArrayNames.splice(idx, 1); //remove if not active
	}
	
	d3.select('#'+species).classed("label--active", active);
//console.log (species);
	highlightNode(d3.select('#'+species).data()[0], active);
	
	//need to re-highlight all currently selected species as otherwise if you uncheck one then it removes any part of the path that's shared with another species
	for (var i = 0; i<storeArrayNames.length; i++) {
		highlightNode(d3.select('#'+storeArrayNames[i]).data()[0], true);
		
		//also need to re-highlight the labels
		var labelname = storeArrayNames[i].replace(/ /g,"_");
		d3.select('#'+labelname).classed("label--active", true);
	}
	
	showTaxonomy(id, active); //showTaxonomy now called from clicking on species in tree, not from ingredient as one ingredient may correspond to several species
}

//highlight the full path of a species in the tree
function highlightNode(d, active)
{
	if (!d) return;
	d3.select(d.linkExtensionNode).classed("link-extension--active", active).each(moveToFront);
	
	var highlightClass; //use a different class if in Windows high contrast mode
	if (HCM) highlightClass = "link-hc--active";
	else highlightClass = "link--active";
	do {
		d3.select(d.linkNode).classed(highlightClass, active).each(moveToFront); 
	}
	while (d = d.parent);
}

function inArray(needle,haystack)
{
    var count=haystack.length;
    for(var i=0;i<count;i++)
    {
        if(haystack[i]===needle)
		{
			//console.log("found at " ,i);
			return true;
		}
    }
    return false;
}


//show data about selected species in popup. 
function showTaxonomy(id, active)
{
	//console.log("showtax", id)
	var cn = data.ingredients[id].common_name;
	var ln = data.ingredients[id].unique_name;
	var fam = data.ingredients[id].family;
	var king = data.ingredients[id].kingdom;

	$("#info").html(
	"Common name: " + cn +"<br/>" +
	"Latin name: " +"<i>"+ln+"</i><br/>" +
	"Family: " +fam+"<br/>" +
	"Kingdom: " +king+"<br/>" 
	
	);
	$("#info").css('left',outerRadius-100)
	$("#info").css('top',outerRadius-50)
	if (active) 
	{
		$("#info").show();
		//$("#info").focus();
	}
	else 
		$("#info").hide();
		
	$("#AriaLiveRegion1").html ("Common name: " + cn +
	"Latin name: " +ln +
	"Family: " +fam +
	"Kingdom: " +king ); //update aria live region for screen readers with the details of this species
}


//zoom buttons. 
function zoomIn(amount) 
{
	//zoom.scaleBy(svg.transition().duration(200), amount);
	zoom.scaleBy(svg.transition(), amount);
}

function zoomOut(amount) 
{
	//zoom.scaleBy(svg.transition().duration(200), 1 / amount);
	zoom.scaleBy(svg.transition(), 1 / amount);
}

//build a list of selected ingredients for export to csv or similar
function saveList() 
{
	//var cbs = $( "[type=checkbox]" );
	var cbs = $(".cb_class");
	var csvContent = "";
	
	for (var i = 0; i<cbs.length; i++)
	{
		if (cbs[i].checked) //add any ingredient that has its checkbox selected, with all its associated data
		{
			cbnum = parseInt(cbs[i].id);
			
			var obj = allData[cbnum];
			
			//magic to convert objects to arrays
			var result = Object.keys(obj).map(function(key) {
			  return [obj[key]]; 
			});
			
			//result for each species on new line
			csvContent += result+ "\n";
			//replace commas with tabs then can copy straight from text area into spreadsheet in separate columns
			csvContent = csvContent.replace(/,/g, "\t"); 
		}
	}
	
	$("#csvDisplay").html(csvContent);
	$("#csvDiv").show();
	$("#closeCSV").focus();
	
}

//clear all ingredients checkboxes and remove all highlighted clades = label highlighting
function clearList() 
{
	var cbs = $(".cb_class");
	var csvContent = "";
	
	for (var i = 0; i<cbs.length; i++)
	{
		cbs[i].checked = false;

	}
	for (var i = 0; i<=data.ingredients.length; i++)
	{
		highlightNode(d3.select('#'+storeArrayNames[i]).data()[0], false);
		d3.select('#'+storeArrayNames[i]).classed("label--active", false);
	}
	storeArrayNames=[];
	$("#info").hide();
	$("#csvDiv").hide();
}

//for debug purposes: select everything
function selectAll() 
{
	var cbs = $(".cb_class");
	
	for (var i = 0; i<cbs.length; i++)
	{
		cbs[i].checked = true;
		selectIngredient(true, cbs[i].id)	
	}
	
	$("#info").hide();
	$("#csvDiv").hide();
}

function Ingredient (iname, scn, sln, fam, king,prot)
{
	
	console.log (iname);
	this.ingredientName = iname.replace(/,/g, " -"); //ingredients like deer, red have commas in which messes up the splitting into spreadsheet columns so replacing with hyphens here
	this.commonName = scn;
    this.latinName = sln;
	this.family = fam;
	this.kingdom = king;
	
}


//store the ingredients that have been selected via checkboxes and all highlighted species
function storeVLEdata()
{

	VLE.set_server_data(true, vledata,
			function () {
				// Successful, tell the user perhaps.
				//saveMessage(document.getElementById('save-message'), 'Saved');
				//console.log("saved", vledata)
			},
			function (message) {
				if (message === null) {
					// Not connected to the VLE so save to local storage.
					// Advise the user, maybe.
					//console.log("not connected to VLE")
				} else {
					// Cant save the VLE for some other reason.
					//saveMessage(document.getElementById('save-message'), 'Unable to save to VLE');
					console.log('Unable to save data to VLE: ' + message);
				}
			});
}

//retrieve a previous list of ingredients. Need some way of clearing this for testing purposes
function retrieveStoredVLEdata()
{
	 // Get data that has been saved to the VLE, if any.
    VLE.get_server_data(true, ['ingredients', 'speciesnames'],
            function (values) {
				
                // Look in the values object to see what's there. Not sure if you need this!
                if (values.hasOwnProperty('ingredients')) {
                    vledata.ingredients = values.ingredients;
					vledata.speciesnames = values.speciesnames;
                }
                
                // Now do something with the data here or pass it to a function.
				var arr = JSON.parse("[" + vledata.ingredients + "]");
				storeArrayNames = JSON.parse(vledata.speciesnames);
				
				//check appropriate checkboxes
				for (var i = 0; i<data.ingredients.length; i++)
				{			
					if ( inArray(i,arr))
					{
						//console.log ("check box "+i);
						$("#"+i).prop( "checked", true );	
					}	
				}
				
				//and highlight those nodes and text label
				for (var j = 0; j<storeArrayNames.length; j++)
				{			
					var ln = storeArrayNames[j];
					
					highlightNode(d3.select('#'+ln).data()[0], true);
					d3.select('#'+ln).attr('visibility','visible')
					d3.select('#'+ln).classed("label--active", true);
						
				}
            },
            function (message) { // Returns error message null if not on VLE.
                if (message === null) {
                    // Not on the VLE.
					console.log("unable to get data, not on VLE");
                } else {
                    // Other VLE error.
                    //saveMessage(document.getElementById('save-message'), 'Unable to get data from the server.');
                    console.log('Unable to get data from server.' + message);
                }
            });			
}

//attempt to detect if we're on a touch screen device (from S112 earthquake plotter, which also has browser detection using bowser if needed)

function is_touch_device () 
{
	 return (('ontouchstart' in window)
		  || (navigator.MaxTouchPoints > 0)
		  || (navigator.msMaxTouchPoints > 0));
}

function pan(direction)
{
	
	var svgTransition = d3.select("#main_group");
	var panAmount = 50;
	
	if (direction == 'l') {
		currentX -= panAmount;
		
	}
	if (direction == 'r') {
		currentX += panAmount;
		
	}
	if (direction == 'u') {
		currentY -= panAmount;
		
	}
	if (direction == 'd') {
		currentY += panAmount;
		
	}
	
	svgTransition.attr("transform", "translate(" + currentX + "," + currentY + ") scale("+currentScale+")");//.duration(500);
	
}

$( document ).ready(function() {
    retrieveStoredVLEdata();
});

function saveImage()
{
	//alert (bowser.name);
	//for reasons I don't understand nothing happens when trying to save image in Safari on iPad, though none
	//of the errors in saveSvgAsPng.js are triggered. So just trapping it here and alerting.
	if (bowser.name == 'Safari' && is_touch_device ()) 
	{
		alert ('Sorry, unable to save image in Safari. Try another browser or take a screen shot.'); 
		return; 
	} 
	else 
		saveSvgAsPng(document.getElementById('treeoflife'), 'dinnerplate_diversity.png',{scale: 6}); //increase scale so tiny text is readable
}



function highlightSVGBackground()
{
//svg pie chart based on https://hackernoon.com/a-simple-pie-chart-in-svg-dbdd653b6936 but with fancy ECMA script bits replaced wiht more basic code
//idea is to shade behind the major kingdoms (allowing the possibility of highlighting branches on top in different colours as well)

	var svgEl = document.querySelector('#pie');
	var pieGroup = d3.select("#main_group").append("g").attr("id","pie_group");
	
	//set sizes of wedges. If i knew how many species in each kingdom from the data then I could automate calculation of %ages
	var totalSpecies = 489;
	var slices = [
	  { percent: 19/totalSpecies, color: '#ff3c00' }, //bacteria
	  { percent: 41/totalSpecies, color: '#1f77b4' }, //fungi
	  { percent: 156/totalSpecies, color: '#cdb4ed' }, //animals
	  { percent: 28/totalSpecies, color: '#133714' }, //algae
	   { percent: 245/totalSpecies, color: '#5eff6d' }, //plants
	];
	var cumulativePercent = 0;

	function getCoordinatesForPercent(percent) {
	  var x = Math.cos(2 * Math.PI * percent);
	  var y = Math.sin(2 * Math.PI * percent);
	  return [x, y];
	}

	for (var i = 0; i <slices.length; i++) {
	  var startX = getCoordinatesForPercent(cumulativePercent)[0];
	  var startY = getCoordinatesForPercent(cumulativePercent)[1];
	  
	  // each slice starts where the last slice ended, so keep a cumulative percent
	  cumulativePercent += slices[i].percent;
	  
	  var endX = getCoordinatesForPercent(cumulativePercent)[0];
	  var endY = getCoordinatesForPercent(cumulativePercent)[1];
	  
	  // if the slice is more than 50%, take the large arc (the long way around)
	  var largeArcFlag = slices[i].percent > .5 ? 1 : 0;
	
	  var pathData = "M " + startX + " " + startY + " A 1 1 0 " +   largeArcFlag + "1 "+ endX + " " + endY + " L 0 0";

	  // create a <path> and append it to the <svg> element
	  var pathEl = document.createElementNS('http://www.w3.org/2000/svg', 'path');

	  pathEl.setAttribute('d', pathData);
	  pathEl.setAttribute('fill', slices[i].color);
	  svgEl.appendChild(pathEl);
  
	}
	//insert the background 'pie chart' into the main tree of life once it's the right size
	var piescale = innerRadius/outerRadius;
	
	//needs to go in a group otherwise transform doesn't work except in firefox
	$("#pie_group").attr("transform","scale("+piescale+") translate("+ (outerRadius*-1)+","+ outerRadius +") rotate(-90)");
	
	$("#pie_group").append(svgEl);
}

//this is desperate stuff :-( I cannot figure out why the first time you zoom in on the 
//tree of life it jumps to top left corner so here I'm programmatically faking the first drag event
//so that subsequent times are OK
function simulateDrag() {


	try {
		//following doesn't work in IE, which requires a different way of creating event. Couldn't get jquery trigger() to work.
		var event = new MouseEvent('mousedown', {
			view: window,
			bubbles: true,
			cancelable: true
			});
		}
	catch (err)
	{
		var event = document.createEvent("MouseEvent");
		event.initMouseEvent("mousedown",true,true,window,0,0,0,0,0,false,false,false,false,0,null);
	}
	var cb = document.getElementById('main_group'); 
	var cancelled = !cb.dispatchEvent(event);
  
  
  	try {
		//following doesn't work in IE, which requires a different way of creating event
		var event = new MouseEvent('mousemove', {
			view: window,
			bubbles: true,
			cancelable: true
			});
		}
	catch (err)
	{
		var event = document.createEvent("MouseEvent");
		event.initMouseEvent("mousemove",true,true,window,0,0,0,0,0,false,false,false,false,0,null);
	}
	var cb = document.getElementById('main_group'); 
	var cancelled = !cb.dispatchEvent(event);
	
	
	try {
		//following doesn't work in IE, which requires a different way of creating event
		var event = new MouseEvent('mouseup', {
			view: window,
			bubbles: true,
			cancelable: true
			});
		}
	catch (err)
	{
		var event = document.createEvent("MouseEvent");
		event.initMouseEvent("mouseup",true,true,window,0,0,0,0,0,false,false,false,false,0,null);
	}
	var cb = document.getElementById('main_group'); 
	var cancelled = !cb.dispatchEvent(event);

}

function filter ()
{
	//filter out all checkboxes except those where the word is found in the JSON ingredient name
	var word = $("#findWordBox").val().toLowerCase();
	var matchFound = false;
	
	if (word == "")
		return;
		
	var cbs = $(".cb_class");
	
	for (var i = 0; i<categories.length; i++)
	{
		$("#panel"+i).hide();	
		$(".accordion").css('display','none');
	}
	for (var i = 0; i<cbs.length; i++)
	{
		$("#span"+i).css('display','none');	
	}
	
	for (var i = 0; i< allData.length; i++)
	{
		if (allData[i].ingredientName.indexOf(word)>=0)
		{
			$("#span"+i).show();
			$("#"+i).parent().parent().parent().show(); //the panel
			matchFound = true;
			$("#nomatchDiv").remove();
		}
		
	}
	if (!matchFound)
		$("#ingredientsDiv").append("<div id = 'nomatchDiv'> <br/><br/>No matches found.</div>");
		
	//provide a means of removing the filter
	$("#fullListLink").show();
}

//go back to showing all checkboxes instead of filtered list
function removeFilter ()
{
	$("#findWordBox").val("");
	$("#nomatchDiv").remove();
	
	for (var i = 0; i<categories.length; i++)
	{
		$(".accordion").css('display','block').removeClass( "active" );
		var htmlstr = $("#accordion"+i).html();
		$("#accordion"+i).html(htmlstr.replace('▼','►'));
	}
	
	for (var i = 0; i< allData.length; i++)
	{
		$("#span"+i).show(); //re-show the checkboxes
		$("#"+i).parent().parent().parent().hide(); //the panels should still be hidden
	}
	$("#fullListLink").hide();
}

// Determines if document is in High Contrast Mode or not
// Returns boolean - true if high contrast, false otherwise
function HCTest(idval) {
    var objDiv, objImage, strColor, strWidth, strReady;
    var strImageID = idval; // ID of image on the page

    // Create a test div
    objDiv = document.createElement('div');

    //Set its color style to something unusual
    objDiv.style.color = 'rgb(31, 41, 59)';

    // Attach to body so we can inspect it
    document.body.appendChild(objDiv);

    // Read computed color value
    strColor = document.defaultView ? document.defaultView.getComputedStyle(objDiv, null).color : objDiv.currentStyle.color;
    strColor = strColor.replace(/ /g, '');

    // Delete the test DIV
    document.body.removeChild(objDiv);

    // Check if we get the color back that we set. If not, we're in 
    // high contrast mode. 
    if (strColor !== 'rgb(31,41,59)') {
        return true;
    } else {
        return false;
    }
}







