$(function() {
    var sliderHeight = 250;
    var sliderWidth = 12;
    var sliderLeft = 430;
    var sliderTop = 37;

    Snap.plugin(function (Snap, Element, Paper, glob) {
        Paper.prototype.multitext = function (x, y, txt) {
            txt = txt.split("\n");
            var t = this.text(x, y, txt);
            t.selectAll("tspan:nth-child(n+2)").attr({
                dy: "1.2em",
                x: x
            });
            return t;
        };
    });

    // are we running in epub? - crude check
    if ((location.protocol != "http:") && (location.protocol != "https:") && (location.protocol != "file:")) {
        // really want to be able to check if specifically running in iBooks
        $("body").css({"margin-top":"40px"}); //shift activity downwards to escape top black bar in iBooks
    }

    var x1 = 0, w1 = 126, x2 = 0, w2 = 126;
    var paper = Snap.select("#svg");
    var s = Snap.select("#block_1");
    s.attr({"display":"block", "transform":"translate(20,170) scale(1.5,1.5)"});
    s = Snap.select("#block_2");
    s.attr({"display":"block", "transform":"translate(550,170) scale(1.5,1.5)"});
    s = Snap.select("#thermometer");
    s.attr({"display":"block", "transform":"translate(317,20) scale(2.5,2.5)"});
    s = Snap.select("#key");
    s.attr({"display":"block", "transform":"translate(320,20) scale(2.5,2.5)"});

    Snap("svg").multitext(170, 130, "new layer doesn't fuse").attr({
        id: "text_1",
        font: "16pt Arial",
        textAnchor: "middle"
    });
    Snap("svg").multitext(700, 130, "new layer does fuse").attr({
        id: "text_1",
        font: "16pt Arial",
        textAnchor: "middle"
    });

    paper.attr({"visibility":"visible"});

    //$("#slider").attr("orient", "vertical"); // necessary for Firefox - why?!

    $('#slider').rangeslider({
        orientation: "vertical",
        polyfill: false
    });

    $(".rangeslider").css({
        "position": "absolute",
        "left": sliderLeft + "px",
        "top": sliderTop + "px",
        "height": sliderHeight + "px",
        "width": sliderWidth + "px"
    });

    $(".rangeslider__fill").css("background","#cceaf2");

    $("#slider").on("input change", function(ev) {
        doAnim($(this).val());
    });

    function doAnim(val) {
        var nval = 100*val/sliderHeight; //normalized value 0-100
        Snap.select("#hot_1").attr("opacity", nval/100);
        Snap.select("#hot_2").attr("opacity", nval/100);
        Snap.select("#hot_1").attr("x",40+(100-nval)/10);
        Snap.select("#hot_1").attr("width",w1 - 2*(100-nval)/10);
        Snap.select("#cold_1").attr("x",40+(100-nval)/10);
        Snap.select("#cold_1").attr("width",w1 - 2*(100-nval)/10);
    }
});