$(document).ready(function() {
	
		var msg ="You are viewing this activity in ";
if (/MSIE 10/i.test(navigator.userAgent)) {
   // This is internet explorer 10
   //window.alert('isIE10');
   msg += "Internet Explorer 10 ";
}
else if (/MSIE 9/i.test(navigator.userAgent) || /rv:11.0/i.test(navigator.userAgent)) {
    // This is internet explorer 9 or 11
    //window.location = 'pages/core/ie.htm';
   msg += "Internet Explorer 11 ";
}
else if (/Edge\/\d./i.test(navigator.userAgent)){
   // This is Microsoft Edge
   //window.alert('Microsoft Edge');
   msg += "Edge ";
}

if ( (/MSIE 10/i.test(navigator.userAgent)) || (/MSIE 9/i.test(navigator.userAgent) || /rv:11.0/i.test(navigator.userAgent)) || (/Edge\/\d./i.test(navigator.userAgent)) ){
	document.getElementById("main_container").style.display = "none";
	document.getElementById("alert_div").innerHTML = msg + ", which does not support the features needed for this activity.<br/> Please use Firefox or Chrome to view this activity.";
	document.getElementById("alert_div").style.display = "block";
}
else{
    var amp = 80;
    var ox1 = 8;
    var oy1 = 20 + amp;
    var ox2 = 8;
    var oy2 = oy1 + amp + 100;
    var gw = 360;
	var freq = 200;
	var amp = 0.5;
	var phase = 0;
    //var nc = 1;

    var margin = 8;
    var fmargin = 20;
    var axes_color = "#000000";
    var num_freq_ticks = 7;

    var wavedata = [], freqdata = [];
    var ncomps = 18;
    var period = 0.0025;
    var baseFreq = 400;
    var maxFreq = 7000;
    var harmonic = 1;

    var axes = [];

    axes[0] = {
        "ox": 20,
        "oy": 20+amp
    }

    var isLineDashSupported = true;
    var _canvas = document.createElement("canvas");
    _ctx = _canvas.getContext("2d");
    if (typeof _ctx.setLineDash === "undefined") isLineDashSupported = false;

    // line dash function for browsers without it, e.g. IE9 & 10
    var CP = window.CanvasRenderingContext2D && CanvasRenderingContext2D.prototype;
    if (CP.lineTo) {
        CP.dashedLine = function(x, y, x2, y2, da) {
            if (!da) da = [10,5];
            this.save();
            var dx = (x2-x), dy = (y2-y);
            var len = Math.sqrt(dx*dx + dy*dy);
            var rot = Math.atan2(dy, dx);
            this.translate(x, y);
            this.moveTo(0, 0);
            this.rotate(rot);
            var dc = da.length;
            var di = 0, draw = true;
            x = 0;
            while (len > x) {
                x += da[di++ % dc];
                if (x > len) x = len;
                draw ? this.lineTo(x, 0): this.moveTo(x, 0);
                draw = !draw;
            }
            this.restore();
        }
    }

	  function drawWave(amp, freq, phase) {
        var w, h, ox, oy, y1, y2, scale, step, wh;
console.log("drawing wave " + amp, freq, phase);
        var canvas = document.getElementById("component_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        drawTimeGraphAxes();

       // ox = parseInt(w / 2);
		ox = parseInt(margin);

        oy = parseInt(h / 2);
        scale = (w - (margin * 2)) / 20;

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#804080";
        ctx.lineWidth = 1;
        step = 0.01;
        //wh = (amp * h - margin * 2) / 2;
         wh = amp * ( h - margin * 2) / 2;
			ctx.beginPath();
        //for (var i = -10; i < 10; i = i + step) {
         for (var i = 0; i < 20; i = i + step) {
           //calculate sine wave
            y1 = wh * Math.sin(2.0 * Math.PI * freq * i / 1000 + (phase * Math.PI ) );
            y2 = wh * Math.sin(2.0 * Math.PI * freq * (i + step) / 1000 + (phase * Math.PI ));
            ctx.moveTo(ox+i*scale, oy-y1);
            ctx.lineTo(ox+(i + step)*scale, oy-y2);
        }
        ctx.stroke();
        ctx.restore();
    }
	
	    function drawTimeGraphAxes() {
        var canvas = document.getElementById("component_graph");
        var ctx = canvas.getContext("2d");
        ctx.save();
        ctx.translate(0.5,0.5);
        w = canvas.width;
        h = canvas.height;
        ox = parseInt(w / 2);
        oy = parseInt(h / 2);
        ctx.lineWidth = 1;
        ctx.strokeStyle = axes_color;
        ctx.beginPath();
        ctx.moveTo(ox, margin);
        ctx.lineTo(ox, h - margin);
        ctx.moveTo(margin, oy);
        ctx.lineTo(w - margin, oy);
        // draw ticks - horizontal axis
        ctx.moveTo(w - margin, oy);
        ctx.lineTo(w - margin, oy + 6);
        ctx.moveTo(margin, oy);
        ctx.lineTo(margin, oy + 6);
        // draw ticks - vertical axis
        ctx.moveTo(ox, margin);
        ctx.lineTo(ox - 6, margin);
        ctx.moveTo(ox, h - margin);
        ctx.lineTo(ox - 6, h - margin);
        ctx.stroke();
        // draw labels
        ctx.font = '10pt Arial';
        ctx.fillText('(ms)', w - margin - 24, oy - 6);
        ctx.fillText('-10', margin - 6, oy + 20);
        ctx.fillText('10', w - margin - 10, oy + 20);
        ctx.fillText('1', ox - 16, margin + 4);
        ctx.fillText('-1', ox - 20, h - margin + 4);
        ctx.font = 'italic 10pt Arial';
        ctx.fillText('t', w - margin - 34, oy - 6);
        ctx.fillText('V', ox + 5, margin + 4);
        ctx.restore();
    }
	
	function setComponents() {
        /* Build data arrays of frequency components */
        for (var i = 0; i < ncomps; i++) {
            if (i % 2 == 0) {
                wavedata[i] = 1.0 / (i + 1);
            }
            else {
                wavedata[i] = 0.0;
            }
        }
    }
	
		 function drawpi() {
		 //for (var n = 1; n <6; n++){
			 n=1;
			 var startel =  document.getElementById("start"+n);
			 var s = "s(t) = ";
			 startel.innerHTML = translate(s);
				var el = document.getElementById("pi"+n);
				var f = "sin(2 \\pi"; 			   
				el.innerHTML = translate(f);
				var midel =  document.getElementById("mid"+n);
			 var t = "t + ";
			 midel.innerHTML = translate(t);
			 var endel =  document.getElementById("end"+n);
			 //var u = "&deg; )";
			 var u = "\\pi )";
			 endel.innerHTML = translate(u);
		// }
    }
    function drawFormula(nc) {
        var el = document.getElementById("eqn");
        var f = "s(t) = A"; 
        nl_flag = false;
        for (var j = 1; j <= nc; j++) {
            if ((j > 6) && !(nl_flag)) {
                f += " \\newline ";
                nl_flag = true;
            }
            if (j > 1) {
                f += " + ";
                f += "\\frac{1}{" + (j * 2 - 1) + "} ";
            }
            f += "{\\sin(2 \\pi f t + \\phi)}";         
        }
       
        el.innerHTML = translate(f);
    }
    //drawAxes("time_graph", axes);
    //drawTimeDomainLabels("time_graph");
    //drawSquareWave();

    //drawAxes("component_graph", axes);
    //drawTimeDomainLabels("component_graph");
    //drawComponentWave(harmonic);
    //drawAxes("sum_graph", axes);
    //drawTimeDomainLabels("sum_graph");
    //drawSumWave(harmonic);
   var audioCtx = new (window.AudioContext || window.webkitAudioContext)();
	var oscillator, playing = false;

	drawWave(0.5, 200, 0);

    //setWaveFreq();
    setComponents();
    //drawFreqGraph();
    drawFormula(harmonic);
	drawpi(1);

    $("#btnPrev").prop("disabled", "disabled");

    $("#btnPrev").on("click", function() {
        if (harmonic > 1) harmonic--;
        if (harmonic <= 1) $("#btnPrev").prop("disabled", "disabled");
        clearCanvas("component_graph");
        clearCanvas("sum_graph");
        clearCanvas("freq_graph");
        drawAxes("component_graph", axes);
        drawTimeDomainLabels("component_graph");
        drawComponentWave(harmonic);
        drawAxes("sum_graph", axes);
        drawTimeDomainLabels("sum_graph");
        drawSumWave(harmonic);
        drawFormula(harmonic);
        drawFreqGraph();
        $("#btnNext").prop("disabled", "");
    });
    $("#btnNext").on("click", function() {
        if (harmonic < (ncomps/2)) harmonic++;
        if (harmonic >= (ncomps/2)) $("#btnNext").prop("disabled", "disabled");
        clearCanvas("component_graph");
        clearCanvas("sum_graph");
        clearCanvas("freq_graph");
        drawAxes("component_graph", axes);
        drawTimeDomainLabels("component_graph");
        drawComponentWave(harmonic);
        drawAxes("sum_graph", axes);
        drawTimeDomainLabels("sum_graph");
        drawSumWave(harmonic);
        drawFormula(harmonic);
        drawFreqGraph();
        $("#btnPrev").prop("disabled", "");
    });
	
	/*
	$('#freq_slider').rangeslider();
    $('#amp_slider').rangeslider();
    $('#phase_slider').rangeslider();

    $("#freq_slider").on("input change", function(ev) {
        freq = parseFloat(this.value);
        updateFreqText();
        angle_step = freq/50;
        drawWave();
    });
    $("#amp_slider").on("input change", function(ev) {
        amp = parseFloat(this.value);
        updateAmpText();
        drawWave();
    });
    $("#phase_slider").on("input change", function(ev) {
        phase = parseFloat(this.value);
        updatePhaseText();
        drawWave();
    });
*/
	    $("#frequency_input").on("input change", function(ev) {
        freq = parseFloat(this.value);
		var f_amp = parseFloat(document.getElementById("amplitude_input").value);
		var f_phase = parseFloat(document.getElementById("phase_input").value);
		if (isNaN(f_phase)) f_phase = 0;
        //updateFreqText();
        angle_step = freq/50;
		//console.log("freq drawing wave " + f_amp + ", " +  freq+ ", " +  f_phase);
        drawWave(f_amp, freq, f_phase);
    });
    $("#amplitude_input").on("input change", function(ev) {
        amp = parseFloat(this.value);
		var a_freq = parseFloat(document.getElementById("frequency_input").value);
		var a_phase = parseFloat(document.getElementById("phase_input").value)
		if (isNaN(a_phase)) a_phase = 0;
        //updateAmpText();
		//console.log("amp drawing wave " + amp + ", " +  a_freq+ ", " +  a_phase);
        drawWave(amp, a_freq, a_phase);
    });
    $("#phase_input").on("input change", function(ev) {
        phase = parseFloat(this.value);
 		var p_amp = parseFloat(document.getElementById("amplitude_input").value);
		var p_freq = parseFloat(document.getElementById("frequency_input").value);
		if (isNaN(phase)) phase = 0;
       //updatePhaseText();
		console.log("phase drawing wave " + p_amp + ", " +  p_freq+ ", " +  phase);
        drawWave(p_amp, p_freq, phase);
    });
	
	$("#audio").on("click", function(ev) { 

		if (!playing){ 
		    //console.log("have pressed button");
			var play_phase = (parseFloat(document.getElementById("phase_input").value) * Math.PI );
			var play_freq = parseFloat(document.getElementById("frequency_input").value);
			var play_amp = parseFloat(document.getElementById("amplitude_input").value);	
			if (isNaN(play_phase)) play_phase = 0;
		   playWave(play_amp, play_freq, play_phase);
		   document.getElementById("audio_img").src='./stop_48.png';
 		}
		else{
			oscillator.stop();
			playing=false;
		   document.getElementById("audio_img").src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAEn0lEQVRoge2ZT2gcVRzHn5kVPBTsJdhDlB4saC3iwUORHBaJIpLkTXBzECLoTUTSoIFMNz28mUB7CHQnp1CyIeDBZLdKqjkEzWHJvC05CLbZeWOgPXgQabC1a7Oz82beKM/DztvMJpvNZsv+UfYLc/k92P1+5v1+7/3eGwC66qqrrv7XQghFFH1xvt0+GtJEYum0Mre4oehJLmIa8dc04s+gnCcji59qp7+aiutL7yhzyR8UPcnDACphfP/x7qmEXZ+x/Lfb6fWQLieSHyl6cluYDwOgnCdrln9NtdhWGEYjbAHd4afb6RsAAMDlRHJS0ZO7YfNhgLDQtndBs9i8ShgtgfgPkOkOttozAACAuL7wwtRccvag8VoAQijnDmiELQcQjzTL/6JVvgEAAMT1hdeVueRXR5kPA8AsXYLYHaj2OyjnKSKlEHEnWmJeub747pSe/LGW+QoATHnw/Aaz9JqcyVfkvWq6X6om+0slrKDm2CdNNV+tWI8F2HQmYZbulEGydGco470S/l1EvCvBTDxE205fc8zPVS/WemtgKOtchJhulUDc/DC23wuPa5a/oRLGNctfPbG5Dz6ffnN0PL4VG4/zo556jdcq4miGRyCmy8Fs+DKmUTGGtp0+sTohi71xIoDYePxWLfNPA9CzYk+AJf5c+P+Gs25CpFM0wyMirhE/Udoj/JsnBahp/mkApJTNpZT9IJLe6xexUYP3QuyuQ0w5NGi8PAuWfUYlzFcJoydqO5oJ0JOy7wQQVFouxEQcYncgSKXC+xn7THkWLP+7oO34sCMAwDfuOWmlcENK2bwnZd8FX++VVyCI6QbElMuGU94DxN6gWaz+jrapAIGkdHGtBFG4UgbYdCaDVWm9DGDSaNArZToKIJLe65dSNpfSdtkYxM5IAGCJmHbXe00ljKuml+soAJB+/FKpFgr3ywBG4TzElA9j5w8Ru3qf9wY90m5nAXzr9Ekpm0fS9j0RGtx8cg5i+g80nEeA82cAAODqz4XeYCntLIBnV55cPJhCI7g4WJoBuiNiMyZ/tZRCrLNSqFoRy4YzcaiILb+/s4p4+c8XIyu2LqVs3pO2CUh758UQxO5NiCmHm85kGcB0JztqGZVSRRxsZH54IwuaOw4xpXKGnhVxzfJXO2ojC8znw+ZHNx4/P2w4tyCmXMYUld9+o63E6Hj8+6a1EssFBFYrDzHDm0UUNHO/RjP7jV7Dzdzopen+2KX4T01dRkHQTmfdeXG4kY2ifODtN9ZO16OpI24f6gUYuV24IGN3TTRw0HBi4XGR+w0daOpVI0dK2aAf75/ESmdj+bZd8YYRcSeCI2UBWe7LTQMAAIC4vlBxA3ccwL5xNw+z7ny4dQYAAO0X9plK2K5GGEMm+7Sp5kMQ9V+rYHcVGk4sXKxCyPTGglWHa5Y/2xLzIYjGL7ZM/y3NYotBy1BUTW9a9EIt18muFp0+zfJnVcLyQc7nkemNtdrzIdW83DVpFOU8RSP+ukgXsdYjq7Ie2qqDN3YifuB6/XdE2A2V/D2EEO9pp9+qqvaBQyUMa8RPINMb66g3fpT+05+Yuuqqq66O1b9OiqAm8YGwvgAAAABJRU5ErkJggg==";
		}
	});
	
	function playWave(play_amp, play_freq, play_phase){
	var k, track = '', player;
	     oscillator = audioCtx.createOscillator();
		var gainNode = audioCtx.createGain();
		oscillator.connect(gainNode);
		gainNode.connect(audioCtx.destination);
		gainNode.gain.value = play_amp;
		oscillator.frequency.value = play_freq;
		oscillator.type = "sine";
		var   duration = 10000;
		//console.log(" amp = "+ play_amp, play_freq, play_phase);
		oscillator.start();
		playing = true;
		
		 setTimeout(
			  function(){
				oscillator.stop();
				playing = false;
				document.getElementById("audio_img").src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAEn0lEQVRoge2ZT2gcVRzHn5kVPBTsJdhDlB4saC3iwUORHBaJIpLkTXBzECLoTUTSoIFMNz28mUB7CHQnp1CyIeDBZLdKqjkEzWHJvC05CLbZeWOgPXgQabC1a7Oz82beKM/DztvMJpvNZsv+UfYLc/k92P1+5v1+7/3eGwC66qqrrv7XQghFFH1xvt0+GtJEYum0Mre4oehJLmIa8dc04s+gnCcji59qp7+aiutL7yhzyR8UPcnDACphfP/x7qmEXZ+x/Lfb6fWQLieSHyl6cluYDwOgnCdrln9NtdhWGEYjbAHd4afb6RsAAMDlRHJS0ZO7YfNhgLDQtndBs9i8ShgtgfgPkOkOttozAACAuL7wwtRccvag8VoAQijnDmiELQcQjzTL/6JVvgEAAMT1hdeVueRXR5kPA8AsXYLYHaj2OyjnKSKlEHEnWmJeub747pSe/LGW+QoATHnw/Aaz9JqcyVfkvWq6X6om+0slrKDm2CdNNV+tWI8F2HQmYZbulEGydGco470S/l1EvCvBTDxE205fc8zPVS/WemtgKOtchJhulUDc/DC23wuPa5a/oRLGNctfPbG5Dz6ffnN0PL4VG4/zo556jdcq4miGRyCmy8Fs+DKmUTGGtp0+sTohi71xIoDYePxWLfNPA9CzYk+AJf5c+P+Gs25CpFM0wyMirhE/Udoj/JsnBahp/mkApJTNpZT9IJLe6xexUYP3QuyuQ0w5NGi8PAuWfUYlzFcJoydqO5oJ0JOy7wQQVFouxEQcYncgSKXC+xn7THkWLP+7oO34sCMAwDfuOWmlcENK2bwnZd8FX++VVyCI6QbElMuGU94DxN6gWaz+jrapAIGkdHGtBFG4UgbYdCaDVWm9DGDSaNArZToKIJLe65dSNpfSdtkYxM5IAGCJmHbXe00ljKuml+soAJB+/FKpFgr3ywBG4TzElA9j5w8Ru3qf9wY90m5nAXzr9Ekpm0fS9j0RGtx8cg5i+g80nEeA82cAAODqz4XeYCntLIBnV55cPJhCI7g4WJoBuiNiMyZ/tZRCrLNSqFoRy4YzcaiILb+/s4p4+c8XIyu2LqVs3pO2CUh758UQxO5NiCmHm85kGcB0JztqGZVSRRxsZH54IwuaOw4xpXKGnhVxzfJXO2ojC8znw+ZHNx4/P2w4tyCmXMYUld9+o63E6Hj8+6a1EssFBFYrDzHDm0UUNHO/RjP7jV7Dzdzopen+2KX4T01dRkHQTmfdeXG4kY2ifODtN9ZO16OpI24f6gUYuV24IGN3TTRw0HBi4XGR+w0daOpVI0dK2aAf75/ESmdj+bZd8YYRcSeCI2UBWe7LTQMAAIC4vlBxA3ccwL5xNw+z7ny4dQYAAO0X9plK2K5GGEMm+7Sp5kMQ9V+rYHcVGk4sXKxCyPTGglWHa5Y/2xLzIYjGL7ZM/y3NYotBy1BUTW9a9EIt18muFp0+zfJnVcLyQc7nkemNtdrzIdW83DVpFOU8RSP+ukgXsdYjq7Ie2qqDN3YifuB6/XdE2A2V/D2EEO9pp9+qqvaBQyUMa8RPINMb66g3fpT+05+Yuuqqq66O1b9OiqAm8YGwvgAAAABJRU5ErkJggg==";
			  }, 
			  duration
			);  

		/*	var k, track = '', player;
	player = document.getElementById("myaudio");
	
		console.log("in playing wave amp = " + play_amp + " frequency = " + play_freq + " phase = " + play_phase);

		for(k = 44100; k--;) {  
				//track += String.fromCharCode(Math.sin(k/44100*2*Math.PI*659.26)*127+128);
				track += String.fromCharCode(play_amp*Math.sin(k/44100*2*Math.PI*play_freq + play_phase)*127 +128);
		}
			//	console.log("track = " + track);
		//player = new Audio('data:audio/wav;base64,UklGRjUrAABXQVZFZm10IBAAAAA\BAAEARKwAAESsAAABAAgAZGF0YREr'+btoa('\0\0'+track));
		var wav = 'data:audio/wav;base64,UklGRjUrAABXQVZFZm10IBAAAAA\BAAEARKwAAESsAAABAAgAZGF0YREr'+btoa('\0\0'+track);		
		player.src = wav;
		player.play();				
		*/
	}
	

    

    function drawTimeDomainLabels(id) {
        var canvas = document.getElementById(id);
        var ctx = canvas.getContext("2d");
        ctx.save();
        ctx.font = "14px Arial";
        ctx.fillStyle = "#000000";
        ctx.textAlign = "right";
        ctx.translate(0.5, 0.5)
        ctx.save();
        ctx.translate(10, 10);
        ctx.rotate(3*Math.PI/2);
        ctx.fillText("Voltage (V)", 0,0);
        ctx.restore();
        ctx.fillText("time (ms)", 396,axes[0].oy+14);
        ctx.restore();
    }

    function drawAxes(id, axes) {
        var canvas = document.getElementById(id);
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#808080";
        ctx.lineWidth = 1;
        ctx.beginPath();
        // vertical axes
        ctx.moveTo(axes[0].ox, axes[0].oy + amp);
        ctx.lineTo(axes[0].ox, axes[0].oy - amp - 8);
        ctx.moveTo(axes[0].ox, axes[0].oy - amp - 8);
        ctx.lineTo(axes[0].ox - 4, axes[0].oy - amp - 4);
        ctx.moveTo(axes[0].ox, axes[0].oy - amp - 8);
        ctx.lineTo(axes[0].ox + 4, axes[0].oy - amp - 4);
        // horizontal axes
        ctx.moveTo(0, axes[0].oy);
        ctx.lineTo(w, axes[0].oy);
        ctx.moveTo(w, axes[0].oy);
        ctx.lineTo(w - 4, axes[0].oy - 4);
        ctx.moveTo(w, axes[0].oy);
        ctx.lineTo(w - 4, axes[0].oy + 4);
        ctx.stroke();
        ctx.restore();
    }

    function drawSquareWave() {
        var y1;

        var canvas = document.getElementById("time_graph");
        var ctx = canvas.getContext("2d");

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#0095c8";
        ctx.lineWidth = 2;
        ctx.beginPath();
        sine_width = gw / 2;
        for (var i = 0; i < gw; i=i+1) {
            //calculate sine wave
            //y1 = amp * Math.cos(2.0 * Math.PI * i/sine_width);
            //y2 = amp * Math.cos(2.0 * Math.PI * (i + 1)/sine_width);
            y1 = amp * Math.cos(2.0 * Math.PI * i / sine_width);
            if (y1 < 0) y1 = -1 * (0.75 * amp);
            else y1 = (0.75* amp);

            if (i==1)
                ctx.moveTo(axes[0].ox+i, oy1 - y1);
            else
                ctx.lineTo(axes[0].ox+i, oy1 - y1);
        }
        ctx.stroke();

        ctx.strokeStyle = "#000000";
        ctx.lineWidth = 1;
        ctx.beginPath();
        ctx.moveTo(100,174)
        ctx.lineTo(20,174)
        ctx.moveTo(20,174)
        ctx.lineTo(24,170)
        ctx.moveTo(20,174)
        ctx.lineTo(24,178)
        ctx.moveTo(122,174)
        ctx.lineTo(200,174)
        ctx.moveTo(200,174)
        ctx.lineTo(196,170)
        ctx.moveTo(200,174)
        ctx.lineTo(196,178)
        ctx.stroke();
        ctx.beginPath();
        if (isLineDashSupported) {
            ctx.setLineDash([5,5]);
            ctx.moveTo(200,180)
            ctx.lineTo(200,20)
        } else {
            ctx.dashedLine(200, 180, 200, 20, [5, 5]);
        }
        ctx.stroke();
        ctx.font = "16px Arial";
        ctx.fillText("T",108,180);
        ctx.restore();
    }
	
	    function reduce(numerator,denominator){
        var gcd = function gcd(a,b){
            return b ? gcd(b, a%b) : a;
        };
        gcd = gcd(numerator,denominator);
        return [numerator/gcd, denominator/gcd];
    }

  

	
    function drawComponentWave(j) {
        var y1;

        var canvas = document.getElementById("component_graph");
        var ctx = canvas.getContext("2d");
        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#c83300";
        ctx.lineWidth = 2;
        ctx.beginPath();
        sine_width = gw / 2;
        for (var i = 0; i < gw; i=i+1) {
            //calculate sine wave
            //y1 = amp * Math.cos(2.0 * Math.PI * i/sine_width);
            //y2 = amp * Math.cos(2.0 * Math.PI * (i + 1)/sine_width);
            y1 = 1 / (harmonic * 2 - 1) * amp * Math.cos((harmonic * 2 - 1) * 2.0 * Math.PI * i / sine_width + (harmonic - 1) % 2 * Math.PI);

            if (i==1)
                ctx.moveTo(axes[0].ox+i, oy1 - y1);
            else
                ctx.lineTo(axes[0].ox+i, oy1 - y1);
        }
        ctx.stroke();
        ctx.restore();
        var label;
        if (harmonic == 1)
            label = "fundamental frequency f";
        else
            label = "frequency " + (harmonic*2-1) + "f";
        $("#titleComponent").html("Harmonic component - " + label);
    }


    function drawSumWave(nc) {
        var y1, y2;

        var canvas = document.getElementById("sum_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#0095c8";
        ctx.lineWidth = 2;
        ctx.beginPath();
        sine_width = gw / 2;
        for (var i = 0; i < gw; i=i+1) {
            //calculate sine wave
            //y1 = amp * Math.cos(2.0 * Math.PI * i/sine_width);
            //y2 = amp * Math.cos(2.0 * Math.PI * (i + 1)/sine_width);
            a = amp;
            y1 = 0, y2 = 0;
            for (j=1; j<=nc; j++) {
                y1 = y1 + 1 / (j * 2 - 1) * a * Math.cos((j * 2 - 1) * 2.0 * Math.PI * i / sine_width + (j - 1) % 2 * Math.PI);
            }

            if (j==1)
                ctx.moveTo(axes[0].ox+i, oy1 - y1);
            else
                ctx.lineTo(axes[0].ox+i, oy1 - y1);
        }
        ctx.stroke();
        ctx.restore();
    }

    function drawFreqGraph() {
        var canvas = document.getElementById("freq_graph");
        var ctx = canvas.getContext("2d");
        ctx.save();
        ctx.translate(0.5,0.5);
        w = canvas.width;
        h = canvas.height;
        // draw axes
        oy = parseInt(h / 2);
        ctx.lineWidth = 1;
        ctx.strokeStyle = axes_color;
        ctx.beginPath();
        ctx.moveTo(fmargin, h - fmargin);
        ctx.lineTo(fmargin, fmargin);
        ctx.moveTo(fmargin, h - fmargin);
        ctx.lineTo(w - fmargin, h-fmargin);
        ctx.stroke();
        ctx.font = '10pt Arial';
        ctx.fillText('Hz', w - fmargin - 10, h - fmargin + 12);
        //tickspacing = (w - fmargin * 2 - 20)/num_freq_ticks;
        //ctx.beginPath();
        //for (var i=1; i<=num_freq_ticks; i++) {
        //    ctx.moveTo(fmargin+i*tickspacing, h-fmargin);
        //    ctx.lineTo(fmargin+i*tickspacing, h-fmargin+4);
        //    ctx.fillText(i, fmargin+i*tickspacing-4, h-fmargin+16);
        //}
        //ctx.stroke();

        // draw graph
        var ox, oy, y1, y2, scale, step, amp, label;
        ox = parseInt(w / 2);
        oy = parseInt(h / 2);
        scale = (w - (fmargin * 2) - 20) / num_freq_ticks;

        ctx.strokeStyle = "#0000bb";
        ctx.beginPath();
        for (var j = 0; j < ncomps; j++) {
            if (j == 2*(harmonic-1))
                ctx.fillStyle = "#c83300";
            else
                ctx.fillStyle = "#0000bb";

            if (freqdata[j] < maxFreq) {
                ctx.fillRect(
                    fmargin + scale * freqdata[j] / 1000 - 2,
                    h - fmargin - 110 * Math.abs(wavedata[j]),
                    4,
                    110 * Math.abs(wavedata[j])
                );
                if (wavedata[j] != 0) {
                    ctx.textAlign = "center";
                    if (j == 0)
                        label = "f"
                    else
                        label = (j+1) + "f";
                    ctx.fillText(label, fmargin + scale * freqdata[j] / 1000, h - fmargin + 16)
                }
            }
        }
        //ctx.fill();
        ctx.restore();
    }

    function clearCanvas(id) {
        var canvas = document.getElementById(id);
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    }
	
	
	function updateEqn() {
        var el = document.getElementById("eqn");
        var f = "s(t) = " + amp.toFixed(2); 
            f += "{\\sin(2 \\pi " + parseInt(freq) +" t + " + +(phase*360.0/16.0).toFixed(1) + "\\degrees)}";
		
        el.innerHTML = translate(f) ;
    }
	

}
});
