$(document).ready(function() {
	var msg ="You are viewing this activity in ";
if (/MSIE 10/i.test(navigator.userAgent)) {
   // This is internet explorer 10
   //window.alert('isIE10');
   msg += "Internet Explorer 10 ";
}
else if (/MSIE 9/i.test(navigator.userAgent) || /rv:11.0/i.test(navigator.userAgent)) {
    // This is internet explorer 9 or 11
    //window.location = 'pages/core/ie.htm';
   msg += "Internet Explorer 11 ";
}
else if (/Edge\/\d./i.test(navigator.userAgent)){
   // This is Microsoft Edge
   //window.alert('Microsoft Edge');
   msg += "Edge ";
}

if ((/MSIE 10/i.test(navigator.userAgent)) || (/MSIE 9/i.test(navigator.userAgent) || /rv:11.0/i.test(navigator.userAgent)) || (/Edge\/\d./i.test(navigator.userAgent))){
	document.getElementById("main_container").style.display = "none";
	document.getElementById("alert_div").innerHTML = msg + ", which does not support the features needed for this activity.<br/> Please use Firefox or Chrome to view this activity.";
	document.getElementById("alert_div").style.display = "block";
}
else{

    var amp = 80;
    var ox1 = 8;
    var oy1 = 20 + amp;
    var ox2 = 8;
    var oy2 = oy1 + amp + 100;
    var gw = 360;
	var freq = 200;
	var amp = 0.5;
	var phase = 0;
    //var nc = 1;

    var margin = 20;
    var ymargin = 5;
    var fmargin = 20;
    var axes_color = "#000000";
    var num_freq_ticks = 7;

    var wavedata = [], freqdata = [200, 400, 600, 800, 1000], ampdata = [0.5, 0, 0, 0, 0];
    var ncomps = 18;
    var period = 0.0025;
    var baseFreq = 400;
    var maxFreq = 1100;//7000;
    var harmonic = 1;

    var axes = [];

    axes[0] = {
        "ox": 20,
        "oy": 20+amp
    }

    var isLineDashSupported = true;
    var _canvas = document.createElement("canvas");
    _ctx = _canvas.getContext("2d");
    if (typeof _ctx.setLineDash === "undefined") isLineDashSupported = false;

    // line dash function for browsers without it, e.g. IE9 & 10
    var CP = window.CanvasRenderingContext2D && CanvasRenderingContext2D.prototype;
    if (CP.lineTo) {
        CP.dashedLine = function(x, y, x2, y2, da) {
            if (!da) da = [10,5];
            this.save();
            var dx = (x2-x), dy = (y2-y);
            var len = Math.sqrt(dx*dx + dy*dy);
            var rot = Math.atan2(dy, dx);
            this.translate(x, y);
            this.moveTo(0, 0);
            this.rotate(rot);
            var dc = da.length;
            var di = 0, draw = true;
            x = 0;
            while (len > x) {
                x += da[di++ % dc];
                if (x > len) x = len;
                draw ? this.lineTo(x, 0): this.moveTo(x, 0);
                draw = !draw;
            }
            this.restore();
        }
    }

		function drawWave(id, amp, freq, phase) {
        var w, h, ox, oy, y1, y2, scale, step, wh;
		var canvas = document.getElementById(id);
		var ctx = canvas.getContext("2d");

        w = canvas.width;
        h = canvas.height;
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        drawTimeGraphAxes(id);

        ox = parseInt(margin);
        oy = parseInt(h / 2);
        scale = (w - (margin * 2)) / 20;

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#804080";
        ctx.lineWidth = 1;
        step = 0.01;
        wh = amp * ( h - ymargin * 2) / 2;
        ctx.beginPath();
        for (var i = 0; i < 20; i = i + step) {
            //calculate sine wave
            //y1 = wh * Math.sin(2.0 * Math.PI * freq * i / 1000 + (phase * Math.PI / 180) );
           // y2 = wh * Math.sin(2.0 * Math.PI * freq * (i + step) / 1000 + (phase * Math.PI / 180));
             y1 = wh * Math.sin(2.0 * Math.PI * freq * i / 1000 + (phase * Math.PI) );
            y2 = wh * Math.sin(2.0 * Math.PI * freq * (i + step) / 1000 + (phase * Math.PI));
            ctx.moveTo(ox+i*scale, oy-y1);
            ctx.lineTo(ox+(i + step)*scale, oy-y2);
        }
        ctx.stroke();
        ctx.restore();
    }
	
	function drawFormula(nc) {
        var el = document.getElementById("eqn");
        var f = "s(t) = A"; 
        nl_flag = false;
        for (var j = 1; j <= nc; j++) {
            if ((j > 6) && !(nl_flag)) {
                f += " \\newline ";
                nl_flag = true;
            }
            if (j > 1) {
                f += " + ";
                f += "\\frac{1}{" + (j * 2 - 1) + "} ";
            }
            f += "{\\sin(2 \\pi f t + \\phi)}";         
        }
       
        el.innerHTML = translate(f);
    }

	function drawTimeGraphAxes(id) {
        var canvas = document.getElementById(id);
        var ctx = canvas.getContext("2d");
        ctx.save();
       // ctx.translate(0.5,0.5);
        w = canvas.width;
        h = canvas.height;
        ox = parseInt(margin);
        oy = parseInt(h / 2);
        ctx.lineWidth = 1;
        ctx.strokeStyle = axes_color;
        ctx.beginPath();
        ctx.moveTo(ox, ymargin);
        ctx.lineTo(ox, h - ymargin);
        ctx.moveTo(margin, oy);
        ctx.lineTo(w - margin, oy);
        // draw ticks - horizontal axis
        ctx.moveTo(w - margin, oy);
        ctx.lineTo(w - margin, oy + 6);
		//        scale = (w - (margin * 2)) / 20;
		var halfwidth = (w - (margin * 2))/2.0;
		//console.log(" halfwidth = " + halfwidth);
        ctx.moveTo(margin + halfwidth, oy);
        ctx.lineTo(margin + halfwidth, oy + 6);
        ctx.moveTo(margin, oy);
        ctx.lineTo(margin, oy + 6);
        // draw ticks - vertical axis
        ctx.moveTo(ox, ymargin);
        ctx.lineTo(ox - 6, ymargin);
        ctx.moveTo(ox, h - ymargin);
        ctx.lineTo(ox - 6, h - ymargin);
        ctx.stroke();
        // draw labels
        ctx.font = '10pt Arial';
        ctx.fillText('(ms)', w - margin - 24, oy - 6);
        ctx.fillText('0', margin - 9, oy + 10);
         ctx.fillText('10', margin  + halfwidth - 10, oy + 20);
       ctx.fillText('20', w - margin - 10, oy + 20);
        ctx.fillText('1', ox - 16, ymargin + 4);
        ctx.fillText('-1', ox - 20, h - ymargin + 4);
        ctx.font = 'italic 10pt Arial';
        ctx.fillText('t', w - margin - 34, oy - 6);
        ctx.fillText('V', ox + 5, ymargin + 4);
        ctx.restore();
    }
	
	function drawFreqGraph(id, freqthis, ampthis) {
		//console.log(" id = " + id);
        var canvas = document.getElementById(id);
        var ctx = canvas.getContext("2d");
        ctx.save();
        ctx.translate(0.5,0.5);
        w = canvas.width;
        h = canvas.height;
        // draw axes
        oy = parseInt(h / 2);
        ctx.lineWidth = 1;
        ctx.strokeStyle = axes_color;
        ctx.beginPath();
        ctx.moveTo(fmargin, h - fmargin);
        ctx.lineTo(fmargin, fmargin);
        ctx.moveTo(fmargin, h - fmargin);
        ctx.lineTo(w - fmargin, h-fmargin);
        ctx.stroke();
        ctx.font = 'italic 10pt Arial';
        ctx.fillText('f (Hz)', w - fmargin - 12, h - fmargin + 12);
        //tickspacing = (w - fmargin * 2 - 20)/num_freq_ticks;
        //ctx.beginPath();
        //for (var i=1; i<=num_freq_ticks; i++) {
        //    ctx.moveTo(fmargin+i*tickspacing, h-fmargin);
        //    ctx.lineTo(fmargin+i*tickspacing, h-fmargin+4);
        //    ctx.fillText(i, fmargin+i*tickspacing-4, h-fmargin+16);
        //}
        //ctx.stroke();
		
        // draw graph
        var ox, oy, y1, y2, scale, step, amp, label;
        ox = parseInt(w / 2);
        oy = parseInt(h / 2);
        //scale = (w - (fmargin * 2) - 20) / num_freq_ticks;
        scale = (w - (fmargin * 2) ) / maxFreq;

       // ctx.strokeStyle = "#0000bb";
        ctx.strokeStyle = "#0000bb";
        ctx.fillStyle = "#804080";
        ctx.beginPath();
		//console.log("freq = " + freqthis + ", maxfreq = " + maxFreq + ", " + ampthis);
		
		if(freqthis.length > 1){
			for (var j = 0; j < freqthis.length; j++) {
				/*if (j == 2*(harmonic-1))
					ctx.fillStyle = "#c83300";
				else
					ctx.fillStyle = "#0000bb";*/
	//       wh = amp * ( h - ymargin * 2) / 2;  
	//console.log("in loop " + freqthis[j] +", " + ampthis[j] + " maxfreq = " + maxFreq + "id = " + id);
				if (freqthis[j] < maxFreq) {
					//console.log("fillrect " + fmargin + ", " + ampdata);
				  //  ctx.fillRect(  fmargin + scale * freqdata[j] - 2,  h - fmargin - 110 * Math.abs(ampdata[j]),  4, 110 * Math.abs(ampdata[j]) ); 
				//  console.log("fillrect");
					ctx.fillRect(  fmargin + scale * freqthis[j] - 2,  h - fmargin,  4,   ((fmargin*2) -h)*Math.abs(ampthis[j]) ); 
					if (ampthis[j] != 0) {
						ctx.textAlign = "center";
						ctx.fillStyle = "#000000";
					  // if (freqdata.length ==1)
					  //      label = "f"
					   // else
						//   console.log("label");
							label =  "" + freqthis[j] ;
						ctx.fillText(label, fmargin + scale * freqthis[j] , h - fmargin + 16)
						ctx.fillStyle = "#804080";
				   }
				}
			}
		}
		else{
			//console.log("in loop " + freqthis +", " + ampthis + " maxfreq = " + maxFreq + "id = " + id);
				if (freqthis < maxFreq && freqthis > 0) {				
				//  console.log("fillrect");
					ctx.fillRect(  fmargin + scale * freqthis - 2,  h - fmargin,  4,   ((fmargin*2) -h)*Math.abs(ampthis) ); 
					if (ampthis != 0) {
						ctx.textAlign = "center";
						ctx.fillStyle = "#000000";					  
						//   console.log("label");
							label =  "" + freqthis ;
						ctx.fillText(label, fmargin + scale * freqthis , h - fmargin + 16)
						ctx.fillStyle = "#804080";
				   }
				}
			
			
		}
        //ctx.fill();
        ctx.restore();
    }
	
	function drawResultant(id) {
        var w, h, ox, oy, y1, y2, scale, step, wh;
		var canvas = document.getElementById(id);
		var ctx = canvas.getContext("2d");

        w = canvas.width;
        h = canvas.height;
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        drawTimeGraphAxes(id);

        ox = parseInt(margin);
        oy = parseInt(h / 2);
        scale = (w - (margin * 2)) / 20;

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#804080";
        ctx.lineWidth = 1;
        step = 0.01;
        wh = parseFloat(document.getElementById("amplitude_input").value) * (h - (ymargin * 2.0)) / 2.0;
        wh2 = parseFloat(document.getElementById("amplitude_input_1").value) * (h - (ymargin * 2.0)) / 2.0;
        wh3 = parseFloat(document.getElementById("amplitude_input_2").value) * (h - (ymargin * 2.0)) / 2.0;
        wh4 = parseFloat(document.getElementById("amplitude_input_3").value) * (h - (ymargin * 2.0)) / 2.0;
        wh5 = parseFloat(document.getElementById("amplitude_input_4").value) *( h - (ymargin * 2.0)) / 2.0;
		
		var f = [], a = [];
		f.push(parseFloat(document.getElementById("frequency_input").value)); 
		f.push(parseFloat(document.getElementById("frequency_input_1").value)); 
		f.push(parseFloat(document.getElementById("frequency_input_2").value)); 
		f.push(parseFloat(document.getElementById("frequency_input_3").value)); 
		f.push(parseFloat(document.getElementById("frequency_input_4").value)); 
		a.push(parseFloat(document.getElementById("amplitude_input").value)); 
		a.push(parseFloat(document.getElementById("amplitude_input_1").value)); 
		a.push(parseFloat(document.getElementById("amplitude_input_2").value)); 
		a.push(parseFloat(document.getElementById("amplitude_input_3").value)); 
		a.push(parseFloat(document.getElementById("amplitude_input_4").value)); 
        clearCanvas("freq_graph_5");
		
		//console.log("f = " + JSON.stringify(f) + ", a " + JSON.stringify(a));

		for (var j = 0; j < f.length; j++){
			for (var i = 0; i < f.length; i++){
				if (i != j){
					if (f[j] == f[i]){
						a[j] += a[i];
						a[i] = 0;
					}
				}
			}			
		}
		
		drawFreqGraph("freq_graph_5",f, a );

        ctx.beginPath();
		
		var phase = (parseFloat(document.getElementById("phase_input").value) * Math.PI );
		if (isNaN(phase))  phase = 0;
		var phase1 = (parseFloat(document.getElementById("phase_input_1").value) * Math.PI );
		if (isNaN(phase1))  phase1 = 0;
		var phase2 = (parseFloat(document.getElementById("phase_input_2").value) * Math.PI ) ;
		if (isNaN(phase2))  phase2 = 0;
		var phase3 = (parseFloat(document.getElementById("phase_input_3").value) * Math.PI );
		if (isNaN(phase3))  phase3 = 0;
		var phase4 = (parseFloat(document.getElementById("phase_input_4").value) * Math.PI );
		if (isNaN(phase4))  phase4 = 0;
		
        for (var i = 0; i < 20; i = i + step) {
            //calculate sine wave
           // y1 = wh * Math.sin(2.0 * Math.PI * freq * i / 1000 + (phase * Math.PI / 180) );
           // y2 = wh * Math.sin(2.0 * Math.PI * freq * (i + step) / 1000 + (phase * Math.PI / 180));
			y1 = wh * Math.sin( (parseFloat(document.getElementById("frequency_input").value) * 2 * Math.PI)* i / 1000 + phase ) + wh2 * Math.sin( (parseFloat(document.getElementById("frequency_input_1").value) * 2 * Math.PI)* i / 1000 + phase1 ) + wh3 * Math.sin( (parseFloat(document.getElementById("frequency_input_2").value) * 2 * Math.PI)* i / 1000 + phase2) + wh4 * Math.sin( (parseFloat(document.getElementById("frequency_input_3").value) * 2 * Math.PI)* i / 1000 + phase3 ) + wh5 * Math.sin( (parseFloat(document.getElementById("frequency_input_4").value) * 2 * Math.PI)* i / 1000 + phase4 )  ;
			
			y2 = wh * Math.sin( (parseFloat(document.getElementById("frequency_input").value) * 2 * Math.PI)* (i+step) / 1000 + (parseFloat(document.getElementById("phase_input").value) * Math.PI ) ) + wh2 * Math.sin( (parseFloat(document.getElementById("frequency_input_1").value) * 2 * Math.PI)* (i+step) / 1000 + phase1 ) + wh3 * Math.sin( (parseFloat(document.getElementById("frequency_input_2").value) * 2 * Math.PI)* (i+step) / 1000 + phase2 ) + wh4 * Math.sin( (parseFloat(document.getElementById("frequency_input_3").value) * 2 * Math.PI)* (i+step) / 1000 + phase3 ) + wh5 * Math.sin( (parseFloat(document.getElementById("frequency_input_4").value) * 2 * Math.PI)* (i+step) / 1000 + phase4 )   ;
			
            ctx.moveTo(ox+i*scale, oy-y1);
            ctx.lineTo(ox+(i + step)*scale, oy-y2);
        }
        ctx.stroke();
        ctx.restore();
    }

	function clearCanvas(id) {
        var canvas = document.getElementById(id);
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    }
	
   function setComponents() {
        /* Build data arrays of frequency components */
        for (var i = 0; i < ncomps; i++) {
            if (i % 2 == 0) {
                wavedata[i] = 1.0 / (i + 1);
            }
            else {
                wavedata[i] = 0.0;
            }
        }
    }
	
	function drawpi() {
		 for (var n = 1; n <6; n++){
			 var startel =  document.getElementById("start"+n);
			 var s = "s(t) = ";
			 startel.innerHTML = translate(s);
				var el = document.getElementById("pi"+n);
				var f = "sin(2 \\pi"; 			   
				el.innerHTML = translate(f);
				var midel =  document.getElementById("mid"+n);
			 var t = "t + ";
			 midel.innerHTML = translate(t);
			 var endel =  document.getElementById("end"+n);
			// var u = "&deg; )";
			 var u = "\\pi )";
			 endel.innerHTML = translate(u);
		 }
    }
    //drawAxes("time_graph", axes);
    //drawTimeDomainLabels("time_graph");
    //drawSquareWave();

    //drawAxes("component_graph", axes);
    //drawTimeDomainLabels("component_graph");
    //drawComponentWave(harmonic);
    //drawAxes("sum_graph", axes);
    //drawTimeDomainLabels("sum_graph");
    //drawSumWave(harmonic);
   var audioCtx = new (window.AudioContext || window.webkitAudioContext)();
	var oscillator, resultant, playing = false;
		var osc1, osc2, osc3, osc4 ,osc5;


	drawWave("component_graph", 0.5, 200, 0);
	drawWave("first_harmonic", 0, 400, 0);
	drawWave("second_harmonic", 0, 600, 0);
	drawWave("third_harmonic", 0, 800, 0);
	drawWave("fourth_harmonic", 0, 1000, 0);
	
	f = [200, 400, 600, 800, 1000];
	a = [0.5, 0, 0, 0, 0];
	freqdata = [200, 400, 600, 800, 1000];
	ampdata = [0.5, 0, 0, 0, 0];
	
	drawWave("component_graph", a[0], f[0], 0);
	drawWave("first_harmonic", a[1], f[1], 0);
	drawWave("second_harmonic", a[2], f[2], 0);
	drawWave("third_harmonic",a[3], f[3], 0);
	drawWave("fourth_harmonic", a[4], f[4], 0);
//console.log("draweing frequency graph");
	drawFreqGraph("freq_graph", f[0], a[0]);
	drawFreqGraph("freq_graph_1",f[1], a[1]);
	drawFreqGraph("freq_graph_2",f[2], a[2]);
	drawFreqGraph("freq_graph_3",f[3], a[3]);
	drawFreqGraph("freq_graph_4",f[4], a[4]);
	
	drawResultant("resultant");;

    //setWaveFreq();
    setComponents();
    //drawFreqGraph();
    drawFormula(harmonic);
	drawpi();

	$("#frequency_input").on("input change", function(ev) {
        freq = parseFloat(this.value);
		var f_amp = parseFloat(document.getElementById("amplitude_input").value);
		var f_phase = parseFloat(document.getElementById("phase_input").value)
 		if (isNaN(f_phase)) f_phase = 0;
       //updateFreqText();
        angle_step = freq/50;
		//console.log("freq drawing wave " + f_amp + ", " +  freq+ ", " +  f_phase);
        drawWave("component_graph", f_amp, freq, f_phase);
		var f = [], a = [];
		f.push(freq); a.push(f_amp);
        clearCanvas("freq_graph");
		drawFreqGraph("freq_graph",f, a);
		drawResultant("resultant");
	});
	
	$("#frequency_input_1").on("input change", function(ev) {
		var first_har = parseFloat(this.value);
		//console.log("settign first harmonic to   " +  first_har);
		var amp1 = parseFloat(document.getElementById("amplitude_input_1").value);
		var phase1 = parseFloat(document.getElementById("phase_input_1").value)
		if (isNaN(phase1)) phase1 = 0;
        drawWave("first_harmonic", amp1, first_har, phase1);
		var f = [], a = [];
		f.push(first_har); a.push(amp1);
        clearCanvas("freq_graph_1");
		drawFreqGraph("freq_graph_1",f, a );
		drawResultant("resultant");
	});

	$("#frequency_input_2").on("input change", function(ev) {
		var second_har = parseFloat(this.value);
		//console.log("settign second harmonic to   " +  second_har);
		document.getElementById("frequency_input_2").value = second_har; 
		var amp2 = parseFloat(document.getElementById("amplitude_input_2").value);
		var phase2 = parseFloat(document.getElementById("phase_input_2").value)
 		if (isNaN(phase2)) phase2 = 0;
       drawWave("second_harmonic", amp2, second_har, phase2);
		var f = [], a = [];
		f.push(second_har); a.push(amp2);
        clearCanvas("freq_graph_2");
		drawFreqGraph("freq_graph_2",f, a );
		drawResultant("resultant");
	});

	$("#frequency_input_3").on("input change", function(ev) {
		var third_har = parseFloat(this.value);
		//console.log("settign third harmonic to   " +  third_har);
		document.getElementById("frequency_input_3").value = third_har; 
		var amp3 = parseFloat(document.getElementById("amplitude_input_3").value);
		var phase3 = parseFloat(document.getElementById("phase_input_3").value)
		if (isNaN(phase3)) phase3 = 0;
        drawWave("third_harmonic", amp3, third_har, phase3);
		var f = [], a = [];
		f.push(third_har); a.push(amp3);
        clearCanvas("freq_graph_3");
		drawFreqGraph("freq_graph_3",f, a );
		drawResultant("resultant");
	});

	$("#frequency_input_4").on("input change", function(ev) {
		var fourth_har = parseFloat(this.value);
		//console.log("settign fourth harmonic to   " +  fourth_har);
		document.getElementById("frequency_input_4").value = fourth_har; 
		var amp4 = parseFloat(document.getElementById("amplitude_input_4").value);
		var phase4 = parseFloat(document.getElementById("phase_input_4").value)
 		if (isNaN(phase4)) phase4 = 0;
       drawWave("fourth_harmonic", amp4, fourth_har, phase4);
		var f = [], a = [];
		f.push(fourth_har); a.push(amp4);
        clearCanvas("freq_graph_4");
		drawFreqGraph("freq_graph_4",f, a );
		drawResultant("resultant");
	});
	
    $("#amplitude_input").on("input change", function(ev) {
        amp = parseFloat(this.value);
		var a_freq = parseFloat(document.getElementById("frequency_input").value);
		var a_phase = parseFloat(document.getElementById("phase_input").value)
		if (isNaN(a_phase)) a_phase = 0;
        //updateAmpText();
		//console.log("amp drawing wave " + amp + ", " +  a_freq+ ", " +  a_phase);
        drawWave("component_graph", amp, a_freq, a_phase);
		var f = [], a = [];
		f.push(a_freq); a.push(amp);
        clearCanvas("freq_graph");
		drawFreqGraph("freq_graph",f, a);
		drawResultant("resultant");
    });
    $("#phase_input").on("input change", function(ev) {
        phase = parseFloat(this.value);
 		var p_amp = parseFloat(document.getElementById("amplitude_input").value);
		var p_freq = parseFloat(document.getElementById("frequency_input").value);
		if (isNaN(phase)) phase = 0;
       //updatePhaseText();
		//console.log("phase drawing wave " + p_amp + ", " +  p_freq+ ", " +  phase);
        drawWave( "component_graph", p_amp, p_freq, phase);
		drawResultant("resultant");
    });
	
	$("#audio").on("click", function(ev) { 
		if (!playing){ 
		    console.log("have pressed button");
			var play_phase = (parseFloat(document.getElementById("phase_input").value) * Math.PI );
			var play_freq = parseFloat(document.getElementById("frequency_input").value);
			var play_amp = parseFloat(document.getElementById("amplitude_input").value);	
		if (isNaN(play_phase)) play_phase = 0;
		   playWave(play_amp, play_freq, play_phase, "audio");
		   document.getElementById("audio_img").src='./stop_48.png';
 		}
		else{
			oscillator.stop();
			playing=false;
		   document.getElementById("audio_img").src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAEn0lEQVRoge2ZT2gcVRzHn5kVPBTsJdhDlB4saC3iwUORHBaJIpLkTXBzECLoTUTSoIFMNz28mUB7CHQnp1CyIeDBZLdKqjkEzWHJvC05CLbZeWOgPXgQabC1a7Oz82beKM/DztvMJpvNZsv+UfYLc/k92P1+5v1+7/3eGwC66qqrrv7XQghFFH1xvt0+GtJEYum0Mre4oehJLmIa8dc04s+gnCcji59qp7+aiutL7yhzyR8UPcnDACphfP/x7qmEXZ+x/Lfb6fWQLieSHyl6cluYDwOgnCdrln9NtdhWGEYjbAHd4afb6RsAAMDlRHJS0ZO7YfNhgLDQtndBs9i8ShgtgfgPkOkOttozAACAuL7wwtRccvag8VoAQijnDmiELQcQjzTL/6JVvgEAAMT1hdeVueRXR5kPA8AsXYLYHaj2OyjnKSKlEHEnWmJeub747pSe/LGW+QoATHnw/Aaz9JqcyVfkvWq6X6om+0slrKDm2CdNNV+tWI8F2HQmYZbulEGydGco470S/l1EvCvBTDxE205fc8zPVS/WemtgKOtchJhulUDc/DC23wuPa5a/oRLGNctfPbG5Dz6ffnN0PL4VG4/zo556jdcq4miGRyCmy8Fs+DKmUTGGtp0+sTohi71xIoDYePxWLfNPA9CzYk+AJf5c+P+Gs25CpFM0wyMirhE/Udoj/JsnBahp/mkApJTNpZT9IJLe6xexUYP3QuyuQ0w5NGi8PAuWfUYlzFcJoydqO5oJ0JOy7wQQVFouxEQcYncgSKXC+xn7THkWLP+7oO34sCMAwDfuOWmlcENK2bwnZd8FX++VVyCI6QbElMuGU94DxN6gWaz+jrapAIGkdHGtBFG4UgbYdCaDVWm9DGDSaNArZToKIJLe65dSNpfSdtkYxM5IAGCJmHbXe00ljKuml+soAJB+/FKpFgr3ywBG4TzElA9j5w8Ru3qf9wY90m5nAXzr9Ekpm0fS9j0RGtx8cg5i+g80nEeA82cAAODqz4XeYCntLIBnV55cPJhCI7g4WJoBuiNiMyZ/tZRCrLNSqFoRy4YzcaiILb+/s4p4+c8XIyu2LqVs3pO2CUh758UQxO5NiCmHm85kGcB0JztqGZVSRRxsZH54IwuaOw4xpXKGnhVxzfJXO2ojC8znw+ZHNx4/P2w4tyCmXMYUld9+o63E6Hj8+6a1EssFBFYrDzHDm0UUNHO/RjP7jV7Dzdzopen+2KX4T01dRkHQTmfdeXG4kY2ifODtN9ZO16OpI24f6gUYuV24IGN3TTRw0HBi4XGR+w0daOpVI0dK2aAf75/ESmdj+bZd8YYRcSeCI2UBWe7LTQMAAIC4vlBxA3ccwL5xNw+z7ny4dQYAAO0X9plK2K5GGEMm+7Sp5kMQ9V+rYHcVGk4sXKxCyPTGglWHa5Y/2xLzIYjGL7ZM/y3NYotBy1BUTW9a9EIt18muFp0+zfJnVcLyQc7nkemNtdrzIdW83DVpFOU8RSP+ukgXsdYjq7Ie2qqDN3YifuB6/XdE2A2V/D2EEO9pp9+qqvaBQyUMa8RPINMb66g3fpT+05+Yuuqqq66O1b9OiqAm8YGwvgAAAABJRU5ErkJggg==";
		}
	});
	

    $("#amplitude_input_1").on("input change", function(ev) {
        amp = parseFloat(this.value);
		var a_freq = parseFloat(document.getElementById("frequency_input_1").value);
		var a_phase = parseFloat(document.getElementById("phase_input_1").value)
 		if (isNaN(a_phase)) a_phase = 0;
       //updateAmpText();
		//console.log("amp drawing wave " + amp + ", " +  a_freq+ ", " +  a_phase);
        drawWave("first_harmonic", amp, a_freq, a_phase);
		var f = [], a = [];
		f.push(a_freq); a.push(amp);
        clearCanvas("freq_graph_1");
		drawFreqGraph("freq_graph_1",f, a);
		drawResultant("resultant");
    });
	
    $("#phase_input_1").on("input change", function(ev) {
        phase = parseFloat(this.value);
 		var p_amp = parseFloat(document.getElementById("amplitude_input_1").value);
		var p_freq = parseFloat(document.getElementById("frequency_input_1").value);
 		if (isNaN(phase)) phase = 0;
         //updatePhaseText();
		//console.log("phase drawing wave " + p_amp + ", " +  p_freq+ ", " +  phase);
        drawWave( "first_harmonic", p_amp, p_freq, phase);
 		drawResultant("resultant");
   });
	
	$("#audio_1").on("click", function(ev) { 
		if (!playing){ 
		   // console.log("have pressed button");
			var play_phase = (parseFloat(document.getElementById("phase_input_1").value) * Math.PI );
			var play_freq = parseFloat(document.getElementById("frequency_input_1").value);
			var play_amp = parseFloat(document.getElementById("amplitude_input_1").value);	
		if (isNaN(play_phase)) play_phase = 0;
		   playWave(play_amp, play_freq, play_phase, "audio_1");
		   document.getElementById("audio_1_img").src='./stop_48.png';
 		}
		else{
			oscillator.stop();
			playing=false;
		   document.getElementById("audio_1_img").src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAEn0lEQVRoge2ZT2gcVRzHn5kVPBTsJdhDlB4saC3iwUORHBaJIpLkTXBzECLoTUTSoIFMNz28mUB7CHQnp1CyIeDBZLdKqjkEzWHJvC05CLbZeWOgPXgQabC1a7Oz82beKM/DztvMJpvNZsv+UfYLc/k92P1+5v1+7/3eGwC66qqrrv7XQghFFH1xvt0+GtJEYum0Mre4oehJLmIa8dc04s+gnCcji59qp7+aiutL7yhzyR8UPcnDACphfP/x7qmEXZ+x/Lfb6fWQLieSHyl6cluYDwOgnCdrln9NtdhWGEYjbAHd4afb6RsAAMDlRHJS0ZO7YfNhgLDQtndBs9i8ShgtgfgPkOkOttozAACAuL7wwtRccvag8VoAQijnDmiELQcQjzTL/6JVvgEAAMT1hdeVueRXR5kPA8AsXYLYHaj2OyjnKSKlEHEnWmJeub747pSe/LGW+QoATHnw/Aaz9JqcyVfkvWq6X6om+0slrKDm2CdNNV+tWI8F2HQmYZbulEGydGco470S/l1EvCvBTDxE205fc8zPVS/WemtgKOtchJhulUDc/DC23wuPa5a/oRLGNctfPbG5Dz6ffnN0PL4VG4/zo556jdcq4miGRyCmy8Fs+DKmUTGGtp0+sTohi71xIoDYePxWLfNPA9CzYk+AJf5c+P+Gs25CpFM0wyMirhE/Udoj/JsnBahp/mkApJTNpZT9IJLe6xexUYP3QuyuQ0w5NGi8PAuWfUYlzFcJoydqO5oJ0JOy7wQQVFouxEQcYncgSKXC+xn7THkWLP+7oO34sCMAwDfuOWmlcENK2bwnZd8FX++VVyCI6QbElMuGU94DxN6gWaz+jrapAIGkdHGtBFG4UgbYdCaDVWm9DGDSaNArZToKIJLe65dSNpfSdtkYxM5IAGCJmHbXe00ljKuml+soAJB+/FKpFgr3ywBG4TzElA9j5w8Ru3qf9wY90m5nAXzr9Ekpm0fS9j0RGtx8cg5i+g80nEeA82cAAODqz4XeYCntLIBnV55cPJhCI7g4WJoBuiNiMyZ/tZRCrLNSqFoRy4YzcaiILb+/s4p4+c8XIyu2LqVs3pO2CUh758UQxO5NiCmHm85kGcB0JztqGZVSRRxsZH54IwuaOw4xpXKGnhVxzfJXO2ojC8znw+ZHNx4/P2w4tyCmXMYUld9+o63E6Hj8+6a1EssFBFYrDzHDm0UUNHO/RjP7jV7Dzdzopen+2KX4T01dRkHQTmfdeXG4kY2ifODtN9ZO16OpI24f6gUYuV24IGN3TTRw0HBi4XGR+w0daOpVI0dK2aAf75/ESmdj+bZd8YYRcSeCI2UBWe7LTQMAAIC4vlBxA3ccwL5xNw+z7ny4dQYAAO0X9plK2K5GGEMm+7Sp5kMQ9V+rYHcVGk4sXKxCyPTGglWHa5Y/2xLzIYjGL7ZM/y3NYotBy1BUTW9a9EIt18muFp0+zfJnVcLyQc7nkemNtdrzIdW83DVpFOU8RSP+ukgXsdYjq7Ie2qqDN3YifuB6/XdE2A2V/D2EEO9pp9+qqvaBQyUMa8RPINMb66g3fpT+05+Yuuqqq66O1b9OiqAm8YGwvgAAAABJRU5ErkJggg==";
		}
			});
	
    $("#amplitude_input_2").on("input change", function(ev) {
        amp = parseFloat(this.value);
		var a_freq = parseFloat(document.getElementById("frequency_input_2").value);
		var a_phase = parseFloat(document.getElementById("phase_input_2").value)
 		if (isNaN(a_phase)) a_phase = 0;
       //updateAmpText();
		//console.log("amp drawing wave " + amp + ", " +  a_freq+ ", " +  a_phase);
        drawWave("second_harmonic", amp, a_freq, a_phase);
		var f = [], a = [];
		f.push(a_freq); a.push(amp);
        clearCanvas("freq_graph_2");
		drawFreqGraph("freq_graph_2",f, a);
		drawResultant("resultant");
    });
    $("#phase_input_2").on("input change", function(ev) {
        phase = parseFloat(this.value);
 		var p_amp = parseFloat(document.getElementById("amplitude_input_2").value);
		var p_freq = parseFloat(document.getElementById("frequency_input_2").value);
		if (isNaN(phase)) phase = 0;
       //updatePhaseText();
		//console.log("phase drawing wave " + p_amp + ", " +  p_freq+ ", " +  phase);
        drawWave( "second_harmonic", p_amp, p_freq, phase);
 		drawResultant("resultant");
   });
	
$("#audio_2").on("click", function(ev) { 
		if (!playing){ 
			//console.log("have pressed button");
			var play_phase = (parseFloat(document.getElementById("phase_input_2").value) * Math.PI );
			var play_freq = parseFloat(document.getElementById("frequency_input_2").value);
			var play_amp = parseFloat(document.getElementById("amplitude_input_2").value);	
		if (isNaN(play_phase)) play_phase = 0;
		   playWave(play_amp, play_freq, play_phase, "audio_2");
		   document.getElementById("audio_2_img").src='./stop_48.png';
 		}
		else{
			oscillator.stop();
			playing=false;
		   document.getElementById("audio_2_img").src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAEn0lEQVRoge2ZT2gcVRzHn5kVPBTsJdhDlB4saC3iwUORHBaJIpLkTXBzECLoTUTSoIFMNz28mUB7CHQnp1CyIeDBZLdKqjkEzWHJvC05CLbZeWOgPXgQabC1a7Oz82beKM/DztvMJpvNZsv+UfYLc/k92P1+5v1+7/3eGwC66qqrrv7XQghFFH1xvt0+GtJEYum0Mre4oehJLmIa8dc04s+gnCcji59qp7+aiutL7yhzyR8UPcnDACphfP/x7qmEXZ+x/Lfb6fWQLieSHyl6cluYDwOgnCdrln9NtdhWGEYjbAHd4afb6RsAAMDlRHJS0ZO7YfNhgLDQtndBs9i8ShgtgfgPkOkOttozAACAuL7wwtRccvag8VoAQijnDmiELQcQjzTL/6JVvgEAAMT1hdeVueRXR5kPA8AsXYLYHaj2OyjnKSKlEHEnWmJeub747pSe/LGW+QoATHnw/Aaz9JqcyVfkvWq6X6om+0slrKDm2CdNNV+tWI8F2HQmYZbulEGydGco470S/l1EvCvBTDxE205fc8zPVS/WemtgKOtchJhulUDc/DC23wuPa5a/oRLGNctfPbG5Dz6ffnN0PL4VG4/zo556jdcq4miGRyCmy8Fs+DKmUTGGtp0+sTohi71xIoDYePxWLfNPA9CzYk+AJf5c+P+Gs25CpFM0wyMirhE/Udoj/JsnBahp/mkApJTNpZT9IJLe6xexUYP3QuyuQ0w5NGi8PAuWfUYlzFcJoydqO5oJ0JOy7wQQVFouxEQcYncgSKXC+xn7THkWLP+7oO34sCMAwDfuOWmlcENK2bwnZd8FX++VVyCI6QbElMuGU94DxN6gWaz+jrapAIGkdHGtBFG4UgbYdCaDVWm9DGDSaNArZToKIJLe65dSNpfSdtkYxM5IAGCJmHbXe00ljKuml+soAJB+/FKpFgr3ywBG4TzElA9j5w8Ru3qf9wY90m5nAXzr9Ekpm0fS9j0RGtx8cg5i+g80nEeA82cAAODqz4XeYCntLIBnV55cPJhCI7g4WJoBuiNiMyZ/tZRCrLNSqFoRy4YzcaiILb+/s4p4+c8XIyu2LqVs3pO2CUh758UQxO5NiCmHm85kGcB0JztqGZVSRRxsZH54IwuaOw4xpXKGnhVxzfJXO2ojC8znw+ZHNx4/P2w4tyCmXMYUld9+o63E6Hj8+6a1EssFBFYrDzHDm0UUNHO/RjP7jV7Dzdzopen+2KX4T01dRkHQTmfdeXG4kY2ifODtN9ZO16OpI24f6gUYuV24IGN3TTRw0HBi4XGR+w0daOpVI0dK2aAf75/ESmdj+bZd8YYRcSeCI2UBWe7LTQMAAIC4vlBxA3ccwL5xNw+z7ny4dQYAAO0X9plK2K5GGEMm+7Sp5kMQ9V+rYHcVGk4sXKxCyPTGglWHa5Y/2xLzIYjGL7ZM/y3NYotBy1BUTW9a9EIt18muFp0+zfJnVcLyQc7nkemNtdrzIdW83DVpFOU8RSP+ukgXsdYjq7Ie2qqDN3YifuB6/XdE2A2V/D2EEO9pp9+qqvaBQyUMa8RPINMb66g3fpT+05+Yuuqqq66O1b9OiqAm8YGwvgAAAABJRU5ErkJggg==";
		}
			});
	
	$("#amplitude_input_3").on("input change", function(ev) {
        amp = parseFloat(this.value);
		var a_freq = parseFloat(document.getElementById("frequency_input_3").value);
		var a_phase = parseFloat(document.getElementById("phase_input_3").value)
		if (isNaN(a_phase)) a_phase = 0;
        //updateAmpText();
		//console.log("amp drawing wave " + amp + ", " +  a_freq+ ", " +  a_phase);
        drawWave("third_harmonic", amp, a_freq, a_phase);
		var f = [], a = [];
		f.push(a_freq); a.push(amp);
        clearCanvas("freq_graph_3");
		drawFreqGraph("freq_graph_3",f, a);
		drawResultant("resultant");
    });
    $("#phase_input_3").on("input change", function(ev) {
        phase = parseFloat(this.value);
 		var p_amp = parseFloat(document.getElementById("amplitude_input_3").value);
		var p_freq = parseFloat(document.getElementById("frequency_input_3").value);
		if (isNaN(phase)) phase = 0;
       //updatePhaseText();
		//console.log("phase drawing wave " + p_amp + ", " +  p_freq+ ", " +  phase);
        drawWave( "third_harmonic", p_amp, p_freq, phase);
 		drawResultant("resultant");
   });
	
		$("#audio_3").on("click", function(ev) { 
		if (!playing){ 
			//console.log("have pressed button");
			var play_phase = (parseFloat(document.getElementById("phase_input_3").value) * Math.PI );
			var play_freq = parseFloat(document.getElementById("frequency_input_3").value);
			var play_amp = parseFloat(document.getElementById("amplitude_input_3").value);	
		if (isNaN(play_phase)) play_phase = 0;
		   playWave(play_amp, play_freq, play_phase, "audio_3");
		   document.getElementById("audio_3_img").src='./stop_48.png';
 		}
		else{
			oscillator.stop();
			playing=false;
		   document.getElementById("audio_3_img").src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAEn0lEQVRoge2ZT2gcVRzHn5kVPBTsJdhDlB4saC3iwUORHBaJIpLkTXBzECLoTUTSoIFMNz28mUB7CHQnp1CyIeDBZLdKqjkEzWHJvC05CLbZeWOgPXgQabC1a7Oz82beKM/DztvMJpvNZsv+UfYLc/k92P1+5v1+7/3eGwC66qqrrv7XQghFFH1xvt0+GtJEYum0Mre4oehJLmIa8dc04s+gnCcji59qp7+aiutL7yhzyR8UPcnDACphfP/x7qmEXZ+x/Lfb6fWQLieSHyl6cluYDwOgnCdrln9NtdhWGEYjbAHd4afb6RsAAMDlRHJS0ZO7YfNhgLDQtndBs9i8ShgtgfgPkOkOttozAACAuL7wwtRccvag8VoAQijnDmiELQcQjzTL/6JVvgEAAMT1hdeVueRXR5kPA8AsXYLYHaj2OyjnKSKlEHEnWmJeub747pSe/LGW+QoATHnw/Aaz9JqcyVfkvWq6X6om+0slrKDm2CdNNV+tWI8F2HQmYZbulEGydGco470S/l1EvCvBTDxE205fc8zPVS/WemtgKOtchJhulUDc/DC23wuPa5a/oRLGNctfPbG5Dz6ffnN0PL4VG4/zo556jdcq4miGRyCmy8Fs+DKmUTGGtp0+sTohi71xIoDYePxWLfNPA9CzYk+AJf5c+P+Gs25CpFM0wyMirhE/Udoj/JsnBahp/mkApJTNpZT9IJLe6xexUYP3QuyuQ0w5NGi8PAuWfUYlzFcJoydqO5oJ0JOy7wQQVFouxEQcYncgSKXC+xn7THkWLP+7oO34sCMAwDfuOWmlcENK2bwnZd8FX++VVyCI6QbElMuGU94DxN6gWaz+jrapAIGkdHGtBFG4UgbYdCaDVWm9DGDSaNArZToKIJLe65dSNpfSdtkYxM5IAGCJmHbXe00ljKuml+soAJB+/FKpFgr3ywBG4TzElA9j5w8Ru3qf9wY90m5nAXzr9Ekpm0fS9j0RGtx8cg5i+g80nEeA82cAAODqz4XeYCntLIBnV55cPJhCI7g4WJoBuiNiMyZ/tZRCrLNSqFoRy4YzcaiILb+/s4p4+c8XIyu2LqVs3pO2CUh758UQxO5NiCmHm85kGcB0JztqGZVSRRxsZH54IwuaOw4xpXKGnhVxzfJXO2ojC8znw+ZHNx4/P2w4tyCmXMYUld9+o63E6Hj8+6a1EssFBFYrDzHDm0UUNHO/RjP7jV7Dzdzopen+2KX4T01dRkHQTmfdeXG4kY2ifODtN9ZO16OpI24f6gUYuV24IGN3TTRw0HBi4XGR+w0daOpVI0dK2aAf75/ESmdj+bZd8YYRcSeCI2UBWe7LTQMAAIC4vlBxA3ccwL5xNw+z7ny4dQYAAO0X9plK2K5GGEMm+7Sp5kMQ9V+rYHcVGk4sXKxCyPTGglWHa5Y/2xLzIYjGL7ZM/y3NYotBy1BUTW9a9EIt18muFp0+zfJnVcLyQc7nkemNtdrzIdW83DVpFOU8RSP+ukgXsdYjq7Ie2qqDN3YifuB6/XdE2A2V/D2EEO9pp9+qqvaBQyUMa8RPINMb66g3fpT+05+Yuuqqq66O1b9OiqAm8YGwvgAAAABJRU5ErkJggg==";
		}
			});
	
	$("#amplitude_input_4").on("input change", function(ev) {
        amp = parseFloat(this.value);
		var a_freq = parseFloat(document.getElementById("frequency_input_4").value);
		var a_phase = parseFloat(document.getElementById("phase_input_4").value)
		if (isNaN(a_phase)) a_phase = 0;
        //updateAmpText();
		//console.log("amp drawing wave " + amp + ", " +  a_freq+ ", " +  a_phase);
        drawWave("fourth_harmonic", amp, a_freq, a_phase);
		var f = [], a = [];
		f.push(a_freq); a.push(amp);
        clearCanvas("freq_graph_4");
		drawFreqGraph("freq_graph_4",f, a);
 		drawResultant("resultant");
   });
    $("#phase_input_4").on("input change", function(ev) {
        phase = parseFloat(this.value);
 		var p_amp = parseFloat(document.getElementById("amplitude_input_4").value);
		var p_freq = parseFloat(document.getElementById("frequency_input_4").value);
 		if (isNaN(phase)) phase = 0;
      //updatePhaseText();
		//console.log("phase drawing wave " + p_amp + ", " +  p_freq+ ", " +  phase);
        drawWave( "fourth_harmonic", p_amp, p_freq, phase);
 		drawResultant("resultant");
   });
	
		$("#audio_4").on("click", function(ev) { 
	    //console.log("have pressed button");
		if (!playing){ 
			var play_phase = (parseFloat(document.getElementById("phase_input_4").value) * Math.PI );
			var play_freq = parseFloat(document.getElementById("frequency_input_4").value);
			var play_amp = parseFloat(document.getElementById("amplitude_input_4").value);	
		if (isNaN(play_phase)) play_phase = 0;
		   playWave(play_amp, play_freq, play_phase, "audio_4");
		   document.getElementById("audio_4_img").src='./stop_48.png';
 		}
		else{
			oscillator.stop();
			playing=false;
		   document.getElementById("audio_4_img").src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAEn0lEQVRoge2ZT2gcVRzHn5kVPBTsJdhDlB4saC3iwUORHBaJIpLkTXBzECLoTUTSoIFMNz28mUB7CHQnp1CyIeDBZLdKqjkEzWHJvC05CLbZeWOgPXgQabC1a7Oz82beKM/DztvMJpvNZsv+UfYLc/k92P1+5v1+7/3eGwC66qqrrv7XQghFFH1xvt0+GtJEYum0Mre4oehJLmIa8dc04s+gnCcji59qp7+aiutL7yhzyR8UPcnDACphfP/x7qmEXZ+x/Lfb6fWQLieSHyl6cluYDwOgnCdrln9NtdhWGEYjbAHd4afb6RsAAMDlRHJS0ZO7YfNhgLDQtndBs9i8ShgtgfgPkOkOttozAACAuL7wwtRccvag8VoAQijnDmiELQcQjzTL/6JVvgEAAMT1hdeVueRXR5kPA8AsXYLYHaj2OyjnKSKlEHEnWmJeub747pSe/LGW+QoATHnw/Aaz9JqcyVfkvWq6X6om+0slrKDm2CdNNV+tWI8F2HQmYZbulEGydGco470S/l1EvCvBTDxE205fc8zPVS/WemtgKOtchJhulUDc/DC23wuPa5a/oRLGNctfPbG5Dz6ffnN0PL4VG4/zo556jdcq4miGRyCmy8Fs+DKmUTGGtp0+sTohi71xIoDYePxWLfNPA9CzYk+AJf5c+P+Gs25CpFM0wyMirhE/Udoj/JsnBahp/mkApJTNpZT9IJLe6xexUYP3QuyuQ0w5NGi8PAuWfUYlzFcJoydqO5oJ0JOy7wQQVFouxEQcYncgSKXC+xn7THkWLP+7oO34sCMAwDfuOWmlcENK2bwnZd8FX++VVyCI6QbElMuGU94DxN6gWaz+jrapAIGkdHGtBFG4UgbYdCaDVWm9DGDSaNArZToKIJLe65dSNpfSdtkYxM5IAGCJmHbXe00ljKuml+soAJB+/FKpFgr3ywBG4TzElA9j5w8Ru3qf9wY90m5nAXzr9Ekpm0fS9j0RGtx8cg5i+g80nEeA82cAAODqz4XeYCntLIBnV55cPJhCI7g4WJoBuiNiMyZ/tZRCrLNSqFoRy4YzcaiILb+/s4p4+c8XIyu2LqVs3pO2CUh758UQxO5NiCmHm85kGcB0JztqGZVSRRxsZH54IwuaOw4xpXKGnhVxzfJXO2ojC8znw+ZHNx4/P2w4tyCmXMYUld9+o63E6Hj8+6a1EssFBFYrDzHDm0UUNHO/RjP7jV7Dzdzopen+2KX4T01dRkHQTmfdeXG4kY2ifODtN9ZO16OpI24f6gUYuV24IGN3TTRw0HBi4XGR+w0daOpVI0dK2aAf75/ESmdj+bZd8YYRcSeCI2UBWe7LTQMAAIC4vlBxA3ccwL5xNw+z7ny4dQYAAO0X9plK2K5GGEMm+7Sp5kMQ9V+rYHcVGk4sXKxCyPTGglWHa5Y/2xLzIYjGL7ZM/y3NYotBy1BUTW9a9EIt18muFp0+zfJnVcLyQc7nkemNtdrzIdW83DVpFOU8RSP+ukgXsdYjq7Ie2qqDN3YifuB6/XdE2A2V/D2EEO9pp9+qqvaBQyUMa8RPINMb66g3fpT+05+Yuuqqq66O1b9OiqAm8YGwvgAAAABJRU5ErkJggg==";
		}
			});
		$("#audio_square").on("click", function(ev) { 
	    //console.log("have pressed button to play resultant");
		if (!playing){ 
			playResultant();
		 	document.getElementById("audio_square_img").src='./stop_48.png';
 		}
		else{
			oscillator.stop();
			//resultant.stop();
			playing=false;
		   document.getElementById("audio_square_img").src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAEn0lEQVRoge2ZT2gcVRzHn5kVPBTsJdhDlB4saC3iwUORHBaJIpLkTXBzECLoTUTSoIFMNz28mUB7CHQnp1CyIeDBZLdKqjkEzWHJvC05CLbZeWOgPXgQabC1a7Oz82beKM/DztvMJpvNZsv+UfYLc/k92P1+5v1+7/3eGwC66qqrrv7XQghFFH1xvt0+GtJEYum0Mre4oehJLmIa8dc04s+gnCcji59qp7+aiutL7yhzyR8UPcnDACphfP/x7qmEXZ+x/Lfb6fWQLieSHyl6cluYDwOgnCdrln9NtdhWGEYjbAHd4afb6RsAAMDlRHJS0ZO7YfNhgLDQtndBs9i8ShgtgfgPkOkOttozAACAuL7wwtRccvag8VoAQijnDmiELQcQjzTL/6JVvgEAAMT1hdeVueRXR5kPA8AsXYLYHaj2OyjnKSKlEHEnWmJeub747pSe/LGW+QoATHnw/Aaz9JqcyVfkvWq6X6om+0slrKDm2CdNNV+tWI8F2HQmYZbulEGydGco470S/l1EvCvBTDxE205fc8zPVS/WemtgKOtchJhulUDc/DC23wuPa5a/oRLGNctfPbG5Dz6ffnN0PL4VG4/zo556jdcq4miGRyCmy8Fs+DKmUTGGtp0+sTohi71xIoDYePxWLfNPA9CzYk+AJf5c+P+Gs25CpFM0wyMirhE/Udoj/JsnBahp/mkApJTNpZT9IJLe6xexUYP3QuyuQ0w5NGi8PAuWfUYlzFcJoydqO5oJ0JOy7wQQVFouxEQcYncgSKXC+xn7THkWLP+7oO34sCMAwDfuOWmlcENK2bwnZd8FX++VVyCI6QbElMuGU94DxN6gWaz+jrapAIGkdHGtBFG4UgbYdCaDVWm9DGDSaNArZToKIJLe65dSNpfSdtkYxM5IAGCJmHbXe00ljKuml+soAJB+/FKpFgr3ywBG4TzElA9j5w8Ru3qf9wY90m5nAXzr9Ekpm0fS9j0RGtx8cg5i+g80nEeA82cAAODqz4XeYCntLIBnV55cPJhCI7g4WJoBuiNiMyZ/tZRCrLNSqFoRy4YzcaiILb+/s4p4+c8XIyu2LqVs3pO2CUh758UQxO5NiCmHm85kGcB0JztqGZVSRRxsZH54IwuaOw4xpXKGnhVxzfJXO2ojC8znw+ZHNx4/P2w4tyCmXMYUld9+o63E6Hj8+6a1EssFBFYrDzHDm0UUNHO/RjP7jV7Dzdzopen+2KX4T01dRkHQTmfdeXG4kY2ifODtN9ZO16OpI24f6gUYuV24IGN3TTRw0HBi4XGR+w0daOpVI0dK2aAf75/ESmdj+bZd8YYRcSeCI2UBWe7LTQMAAIC4vlBxA3ccwL5xNw+z7ny4dQYAAO0X9plK2K5GGEMm+7Sp5kMQ9V+rYHcVGk4sXKxCyPTGglWHa5Y/2xLzIYjGL7ZM/y3NYotBy1BUTW9a9EIt18muFp0+zfJnVcLyQc7nkemNtdrzIdW83DVpFOU8RSP+ukgXsdYjq7Ie2qqDN3YifuB6/XdE2A2V/D2EEO9pp9+qqvaBQyUMa8RPINMb66g3fpT+05+Yuuqqq66O1b9OiqAm8YGwvgAAAABJRU5ErkJggg==";
		}

    });	

	/*
	function playWave(play_amp, play_freq, play_phase){
	var k, track = '', player;
	
		//console.log("in playing wave amp = " + play_amp + " frequency = " + play_freq + " phase = " + play_phase);
		player = document.getElementById("myaudio");
		//for(k = 11025; k--;) {  
		for(k = 22050; k--;) {  
				//track += String.fromCharCode(Math.sin(k/44100*2*Math.PI*659.26)*127+128);
				track += String.fromCharCode(play_amp*Math.sin(k/44100*2*Math.PI*play_freq + play_phase)*127+128);
		}

		var wav = 'data:audio/wav;base64,UklGRjUrAABXQVZFZm10IBAAAAA\BAAEARKwAAESsAAABAAgAZGF0YREr'+btoa('\0\0'+track);
		//console.log("wav length " + wav.length);
		//player = new Audio(wav);
		player.src = wav;
		player.play();				
		
	}*/
	
		function playWave(play_amp, play_freq, play_phase, button_id){
		var k, track = '', player;
				 oscillator = audioCtx.createOscillator();
				var gainNode = audioCtx.createGain();
				oscillator.connect(gainNode);
				gainNode.connect(audioCtx.destination);
				gainNode.gain.value = play_amp;
				oscillator.frequency.value = play_freq;
				oscillator.type = "sine";
				var   duration = 10000;
				console.log(" amp = "+ play_amp, play_freq, play_phase);
				oscillator.start();
				playing = true;
				
				 setTimeout(
					  function(){
						oscillator.stop();
						playing = false;
						document.getElementById(button_id + "_img").src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAEn0lEQVRoge2ZT2gcVRzHn5kVPBTsJdhDlB4saC3iwUORHBaJIpLkTXBzECLoTUTSoIFMNz28mUB7CHQnp1CyIeDBZLdKqjkEzWHJvC05CLbZeWOgPXgQabC1a7Oz82beKM/DztvMJpvNZsv+UfYLc/k92P1+5v1+7/3eGwC66qqrrv7XQghFFH1xvt0+GtJEYum0Mre4oehJLmIa8dc04s+gnCcji59qp7+aiutL7yhzyR8UPcnDACphfP/x7qmEXZ+x/Lfb6fWQLieSHyl6cluYDwOgnCdrln9NtdhWGEYjbAHd4afb6RsAAMDlRHJS0ZO7YfNhgLDQtndBs9i8ShgtgfgPkOkOttozAACAuL7wwtRccvag8VoAQijnDmiELQcQjzTL/6JVvgEAAMT1hdeVueRXR5kPA8AsXYLYHaj2OyjnKSKlEHEnWmJeub747pSe/LGW+QoATHnw/Aaz9JqcyVfkvWq6X6om+0slrKDm2CdNNV+tWI8F2HQmYZbulEGydGco470S/l1EvCvBTDxE205fc8zPVS/WemtgKOtchJhulUDc/DC23wuPa5a/oRLGNctfPbG5Dz6ffnN0PL4VG4/zo556jdcq4miGRyCmy8Fs+DKmUTGGtp0+sTohi71xIoDYePxWLfNPA9CzYk+AJf5c+P+Gs25CpFM0wyMirhE/Udoj/JsnBahp/mkApJTNpZT9IJLe6xexUYP3QuyuQ0w5NGi8PAuWfUYlzFcJoydqO5oJ0JOy7wQQVFouxEQcYncgSKXC+xn7THkWLP+7oO34sCMAwDfuOWmlcENK2bwnZd8FX++VVyCI6QbElMuGU94DxN6gWaz+jrapAIGkdHGtBFG4UgbYdCaDVWm9DGDSaNArZToKIJLe65dSNpfSdtkYxM5IAGCJmHbXe00ljKuml+soAJB+/FKpFgr3ywBG4TzElA9j5w8Ru3qf9wY90m5nAXzr9Ekpm0fS9j0RGtx8cg5i+g80nEeA82cAAODqz4XeYCntLIBnV55cPJhCI7g4WJoBuiNiMyZ/tZRCrLNSqFoRy4YzcaiILb+/s4p4+c8XIyu2LqVs3pO2CUh758UQxO5NiCmHm85kGcB0JztqGZVSRRxsZH54IwuaOw4xpXKGnhVxzfJXO2ojC8znw+ZHNx4/P2w4tyCmXMYUld9+o63E6Hj8+6a1EssFBFYrDzHDm0UUNHO/RjP7jV7Dzdzopen+2KX4T01dRkHQTmfdeXG4kY2ifODtN9ZO16OpI24f6gUYuV24IGN3TTRw0HBi4XGR+w0daOpVI0dK2aAf75/ESmdj+bZd8YYRcSeCI2UBWe7LTQMAAIC4vlBxA3ccwL5xNw+z7ny4dQYAAO0X9plK2K5GGEMm+7Sp5kMQ9V+rYHcVGk4sXKxCyPTGglWHa5Y/2xLzIYjGL7ZM/y3NYotBy1BUTW9a9EIt18muFp0+zfJnVcLyQc7nkemNtdrzIdW83DVpFOU8RSP+ukgXsdYjq7Ie2qqDN3YifuB6/XdE2A2V/D2EEO9pp9+qqvaBQyUMa8RPINMb66g3fpT+05+Yuuqqq66O1b9OiqAm8YGwvgAAAABJRU5ErkJggg==";
					  }, 
					  duration
					);  

		/*	var k, track = '', player;
			player = document.getElementById("myaudio");
	
		//console.log("in playing wave amp = " + play_amp + " frequency = " + play_freq + " phase = " + play_phase);

		for(k = 22050; k--;) {  
				//track += String.fromCharCode(Math.sin(k/44100*2*Math.PI*659.26)*127+128);
				track += String.fromCharCode(play_amp*127*Math.sin(k/44100*2*Math.PI*play_freq + play_phase)+128);
		}
			//	console.log("track = " + track);
		//player = new Audio('data:audio/wav;base64,UklGRjUrAABXQVZFZm10IBAAAAA\BAAEARKwAAESsAAABAAgAZGF0YREr'+btoa('\0\0'+track));
		var wav = 'data:audio/wav;base64,UklGRjUrAABXQVZFZm10IBAAAAA\BAAEARKwAAESsAAABAAgAZGF0YREr'+btoa('\0\0'+track);
		player.src = wav;
		player.play();				
		*/
	}
	/*
	function playResultant(){
	var k, track = '', player, amp1, amp2, amp3, amp4, amp5;
			player = document.getElementById("myaudio");

		 amp1 = parseFloat(document.getElementById("amplitude_input").value) ;
        amp2 = parseFloat(document.getElementById("amplitude_input_1").value) ;
        amp3 = parseFloat(document.getElementById("amplitude_input_2").value) ;
        amp4 = parseFloat(document.getElementById("amplitude_input_3").value) ;
        amp5 = parseFloat(document.getElementById("amplitude_input_4").value) ;

		//for(k = 11025; k--;) {  
		for(k = 22050; k--;) {  
				//track += String.fromCharCode(Math.sin(k/44100*2*Math.PI*659.26)*127+128);
				//track += String.fromCharCode(play_amp*Math.sin(k/44100*2*Math.PI*play_freq + play_phase)*127+128);
				
			track += String.fromCharCode( ((amp1*Math.sin( (parseFloat(document.getElementById("frequency_input").value) * 2 * Math.PI)* k/44100 + (parseFloat(document.getElementById("phase_input").value) * Math.PI ) ) + amp2 * Math.sin( (parseFloat(document.getElementById("frequency_input_1").value) * 2 * Math.PI)* k/44100 + (parseFloat(document.getElementById("phase_input_1").value) * Math.PI ) ) + amp3 * Math.sin( (parseFloat(document.getElementById("frequency_input_2").value) * 2 * Math.PI)* k/44100 + (parseFloat(document.getElementById("phase_input_2").value) * Math.PI ) ) + amp4 * Math.sin( (parseFloat(document.getElementById("frequency_input_3").value) * 2 * Math.PI)* k/44100 + (parseFloat(document.getElementById("phase_input_3").value) * Math.PI ) ) + amp5 * Math.sin( (parseFloat(document.getElementById("frequency_input_4").value) * 2 * Math.PI)* k/44100 + (parseFloat(document.getElementById("phase_input_4").value) * Math.PI ) ))/(amp1+amp2+amp3+amp4+amp5))*127 + 128) ;

				}
			//	console.log("track = " + track);
		//player = new Audio('data:audio/wav;base64,UklGRjUrAABXQVZFZm10IBAAAAA\BAAEARKwAAESsAAABAAgAZGF0YREr'+btoa('\0\0'+track));
		var wav = 'data:audio/wav;base64,UklGRjUrAABXQVZFZm10IBAAAAA\BAAEARKwAAESsAAABAAgAZGF0YREr'+btoa('\0\0'+track);
		player.src = wav;
		player.play();				
		
	}
*/

	function playResultant(){
			var k, track = '', player, amp1, amp2, amp3, amp4, amp5, fre1, fre2, fre3, fre4, fre5, n=0;

		if (  document.getElementById("amplitude_input").value == 0){ amp1 = 0.0; }
				else {amp1 = parseFloat(document.getElementById("amplitude_input").value) ; n++;} 		
        if ( document.getElementById("amplitude_input_1").value == 0){ amp2 = 0.0; }
				else {amp2 = parseFloat(document.getElementById("amplitude_input_1").value); n++;} 		
        if (  document.getElementById("row2_graph").style.display == 'none'){ amp3 = 0.0; }
				else {amp3 = parseFloat(document.getElementById("amplitude_input_2").value) ; n++;} 		
        if (  document.getElementById("row3_graph").style.display == 'none'){ amp4 = 0.0; }
				else {amp4 = parseFloat(document.getElementById("amplitude_input_3").value) ; n++;} 		
        if (  document.getElementById("row4_graph").style.display == 'none'){ amp5 = 0.0; }
				else {amp5 = parseFloat(document.getElementById("amplitude_input_4").value) ; n++;} 		

		if (  document.getElementById("frequency_input").value == 0){ fre1 = 0.0; }
				else {fre1 = parseFloat(document.getElementById("frequency_input").value) ; n++;} 		
        if ( document.getElementById("frequency_input_1").value == 0){ fre2 = 0.0; }
				else {fre2 = parseFloat(document.getElementById("frequency_input_1").value); n++;} 		
        if (  document.getElementById("row2_graph").style.display == 'none'){ fre3 = 0.0; }
				else {fre3 = parseFloat(document.getElementById("frequency_input_2").value) ; n++;} 		
        if (  document.getElementById("row3_graph").style.display == 'none'){ fre4 = 0.0; }
				else {fre4 = parseFloat(document.getElementById("frequency_input_3").value) ; n++;} 		
        if (  document.getElementById("row4_graph").style.display == 'none'){ fre5 = 0.0; }
				else {fre5 = parseFloat(document.getElementById("frequency_input_4").value) ; n++;} 		

		if (  document.getElementById("phase_input").value == 0){ phase1 = 0.0; }
				else {phase1 = parseFloat(document.getElementById("phase_input").value) ; n++;} 		
        if ( document.getElementById("phase_input_1").value == 0){ phase2 = 0.0; }
				else {phase2 = parseFloat(document.getElementById("phase_input_1").value); n++;} 		
        if (  document.getElementById("row2_graph").style.display == 'none'){ phase3 = 0.0; }
				else {phase3 = parseFloat(document.getElementById("phase_input_2").value) ; n++;} 		
        if (  document.getElementById("row3_graph").style.display == 'none'){ phase4 = 0.0; }
				else {phase4 = parseFloat(document.getElementById("phase_input_3").value) ; n++;} 		
        if (  document.getElementById("row4_graph").style.display == 'none'){ phase5 = 0.0; }
				else {phase5 = parseFloat(document.getElementById("phase_input_4").value) ; n++;} 		
		
				var   duration = 10000;
				
				var samplerate = audioCtx.sampleRate; 
				var buffer = audioCtx.createBuffer(1, samplerate * 10, samplerate);
				console.log("amplitude 1 = " + amp1);
				
				var data = buffer.getChannelData(0);
				
				for(var i=0; i < data.length; i++){
					//generate waveform
					// audio needs to be in [-1.0; 1.0]
						data[i] = ( amp1*Math.sin( (fre1 * 2 * Math.PI* i/samplerate) + (phase1 * Math.PI ) ) +  amp2*Math.sin( (fre2 * 2 * Math.PI* i/samplerate) + (phase2 * Math.PI ) ) + amp3*Math.sin( (fre3 * 2 * Math.PI* i/samplerate) + (phase3 * Math.PI ) ) + amp4*Math.sin( (fre4 * 2 * Math.PI* i/samplerate) + (phase4 * Math.PI ) ) + amp5*Math.sin( (fre5 * 2 * Math.PI* i/samplerate) + (phase5 * Math.PI ) ) ); 

				}
				//console.log("Data = " + data);
				//console.log("sample rate = " + audioCtx.sampleRate);
				var   duration = 10000;

				oscillator = audioCtx.createBufferSource();
				oscillator.buffer = buffer;

				oscillator.connect(audioCtx.destination);
				oscillator.start();
				playing = true;
				
				 setTimeout(
					  function(){
						if (oscillator != null) oscillator.stop(); 

						playing = false;
						document.getElementById("audio_square_img").src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAEn0lEQVRoge2ZT2gcVRzHn5kVPBTsJdhDlB4saC3iwUORHBaJIpLkTXBzECLoTUTSoIFMNz28mUB7CHQnp1CyIeDBZLdKqjkEzWHJvC05CLbZeWOgPXgQabC1a7Oz82beKM/DztvMJpvNZsv+UfYLc/k92P1+5v1+7/3eGwC66qqrrv7XQghFFH1xvt0+GtJEYum0Mre4oehJLmIa8dc04s+gnCcji59qp7+aiutL7yhzyR8UPcnDACphfP/x7qmEXZ+x/Lfb6fWQLieSHyl6cluYDwOgnCdrln9NtdhWGEYjbAHd4afb6RsAAMDlRHJS0ZO7YfNhgLDQtndBs9i8ShgtgfgPkOkOttozAACAuL7wwtRccvag8VoAQijnDmiELQcQjzTL/6JVvgEAAMT1hdeVueRXR5kPA8AsXYLYHaj2OyjnKSKlEHEnWmJeub747pSe/LGW+QoATHnw/Aaz9JqcyVfkvWq6X6om+0slrKDm2CdNNV+tWI8F2HQmYZbulEGydGco470S/l1EvCvBTDxE205fc8zPVS/WemtgKOtchJhulUDc/DC23wuPa5a/oRLGNctfPbG5Dz6ffnN0PL4VG4/zo556jdcq4miGRyCmy8Fs+DKmUTGGtp0+sTohi71xIoDYePxWLfNPA9CzYk+AJf5c+P+Gs25CpFM0wyMirhE/Udoj/JsnBahp/mkApJTNpZT9IJLe6xexUYP3QuyuQ0w5NGi8PAuWfUYlzFcJoydqO5oJ0JOy7wQQVFouxEQcYncgSKXC+xn7THkWLP+7oO34sCMAwDfuOWmlcENK2bwnZd8FX++VVyCI6QbElMuGU94DxN6gWaz+jrapAIGkdHGtBFG4UgbYdCaDVWm9DGDSaNArZToKIJLe65dSNpfSdtkYxM5IAGCJmHbXe00ljKuml+soAJB+/FKpFgr3ywBG4TzElA9j5w8Ru3qf9wY90m5nAXzr9Ekpm0fS9j0RGtx8cg5i+g80nEeA82cAAODqz4XeYCntLIBnV55cPJhCI7g4WJoBuiNiMyZ/tZRCrLNSqFoRy4YzcaiILb+/s4p4+c8XIyu2LqVs3pO2CUh758UQxO5NiCmHm85kGcB0JztqGZVSRRxsZH54IwuaOw4xpXKGnhVxzfJXO2ojC8znw+ZHNx4/P2w4tyCmXMYUld9+o63E6Hj8+6a1EssFBFYrDzHDm0UUNHO/RjP7jV7Dzdzopen+2KX4T01dRkHQTmfdeXG4kY2ifODtN9ZO16OpI24f6gUYuV24IGN3TTRw0HBi4XGR+w0daOpVI0dK2aAf75/ESmdj+bZd8YYRcSeCI2UBWe7LTQMAAIC4vlBxA3ccwL5xNw+z7ny4dQYAAO0X9plK2K5GGEMm+7Sp5kMQ9V+rYHcVGk4sXKxCyPTGglWHa5Y/2xLzIYjGL7ZM/y3NYotBy1BUTW9a9EIt18muFp0+zfJnVcLyQc7nkemNtdrzIdW83DVpFOU8RSP+ukgXsdYjq7Ie2qqDN3YifuB6/XdE2A2V/D2EEO9pp9+qqvaBQyUMa8RPINMb66g3fpT+05+Yuuqqq66O1b9OiqAm8YGwvgAAAABJRU5ErkJggg==";
					  }, 
					  duration
					);  
		/*
		var total = (amp1+amp2+amp3+amp4+amp5);
	
		for(k = 22050; k--;) {  
				//track += String.fromCharCode(Math.sin(k/44100*2*Math.PI*659.26)*127+128);
				//track += String.fromCharCode(play_amp*Math.sin(k/44100*2*Math.PI*play_freq + play_phase)*127+128);
			sum = (amp1*Math.sin( (parseFloat(document.getElementById("frequency_input").value) * 2 * Math.PI)* k/44100 + (parseFloat(document.getElementById("phase_input").value) * Math.PI / 180) ) + (amp2*Math.sin( (parseFloat(document.getElementById("frequency_input_1").value) * 2 * Math.PI)* k/44100 + (parseFloat(document.getElementById("phase_input_1").value) * Math.PI / 180) )) + (amp3*Math.sin( (parseFloat(document.getElementById("frequency_input_2").value) * 2 * Math.PI)* k/44100 + (parseFloat(document.getElementById("phase_input_2").value) * Math.PI / 180) )) + (amp4*Math.sin( (parseFloat(document.getElementById("frequency_input_3").value) * 2 * Math.PI)* k/44100 + (parseFloat(document.getElementById("phase_input_3").value) * Math.PI / 180) )) + (amp5*Math.sin( (parseFloat(document.getElementById("frequency_input_4").value) * 2 * Math.PI)* k/44100 + (parseFloat(document.getElementById("phase_input_4").value) * Math.PI / 180) )));
		//	console.log("factor = " + factor);
			if (total > 1 ) { sum = sum/total; } 
			if (sum > 1) {console.log("alert sum > 1 " + sum + ", " + factor + " , " + (amp1+amp2+amp3+amp4+amp5)); 	}		
			sum = 127 * sum;
			track += String.fromCharCode( sum + 128 ) ;
// /Math.sqrt(amp1*amp1+amp2*amp2+amp3*amp3+amp4*amp4+amp5*amp5)) + 128 ) ;
				}
			//	console.log("track = " + track);
		//player = new Audio('data:audio/wav;base64,UklGRjUrAABXQVZFZm10IBAAAAA\BAAEARKwAAESsAAABAAgAZGF0YREr'+btoa('\0\0'+track));
		var wav = 'data:audio/wav;base64,UklGRjUrAABXQVZFZm10IBAAAAA\BAAEARKwAAESsAAABAAgAZGF0YREr'+btoa('\0\0'+track);
		player.src = wav;
		player.play();				
		*/
	}

  

    function drawTimeDomainLabels(id) {
        var canvas = document.getElementById(id);
        var ctx = canvas.getContext("2d");
        ctx.save();
        ctx.font = "14px Arial";
        ctx.fillStyle = "#000000";
        ctx.textAlign = "right";
        ctx.translate(0.5, 0.5)
        ctx.save();
        ctx.translate(10, 10);
        ctx.rotate(3*Math.PI/2);
        ctx.fillText("Voltage (V)", 0,0);
        ctx.restore();
        ctx.fillText("time (ms)", 396,axes[0].oy+14);
        ctx.restore();
    }

    function drawAxes(id, axes) {
        var canvas = document.getElementById(id);
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#808080";
        ctx.lineWidth = 1;
        ctx.beginPath();
        // vertical axes
        ctx.moveTo(axes[0].ox, axes[0].oy + amp);
        ctx.lineTo(axes[0].ox, axes[0].oy - amp - 8);
        ctx.moveTo(axes[0].ox, axes[0].oy - amp - 8);
        ctx.lineTo(axes[0].ox - 4, axes[0].oy - amp - 4);
        ctx.moveTo(axes[0].ox, axes[0].oy - amp - 8);
        ctx.lineTo(axes[0].ox + 4, axes[0].oy - amp - 4);
        // horizontal axes
        ctx.moveTo(0, axes[0].oy);
        ctx.lineTo(w, axes[0].oy);
        ctx.moveTo(w, axes[0].oy);
        ctx.lineTo(w - 4, axes[0].oy - 4);
        ctx.moveTo(w, axes[0].oy);
        ctx.lineTo(w - 4, axes[0].oy + 4);
        ctx.stroke();
        ctx.restore();
    }

 
	
	    function reduce(numerator,denominator){
        var gcd = function gcd(a,b){
            return b ? gcd(b, a%b) : a;
        };
        gcd = gcd(numerator,denominator);
        return [numerator/gcd, denominator/gcd];
    }

  



    function drawSumWave(nc) {
        var y1, y2;

        var canvas = document.getElementById("sum_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#0095c8";
        ctx.lineWidth = 2;
        ctx.beginPath();
        sine_width = gw / 2;
        for (var i = 0; i < gw; i=i+1) {
            //calculate sine wave
            //y1 = amp * Math.cos(2.0 * Math.PI * i/sine_width);
            //y2 = amp * Math.cos(2.0 * Math.PI * (i + 1)/sine_width);
            a = amp;
            y1 = 0, y2 = 0;
            for (j=1; j<=nc; j++) {
                y1 = y1 + 1 / (j * 2 - 1) * a * Math.cos((j * 2 - 1) * 2.0 * Math.PI * i / sine_width + (j - 1) % 2 * Math.PI);
            }

            if (j==1)
                ctx.moveTo(axes[0].ox+i, oy1 - y1);
            else
                ctx.lineTo(axes[0].ox+i, oy1 - y1);
        }
        ctx.stroke();
        ctx.restore();
    }


    function clearCanvas(id) {
        var canvas = document.getElementById(id);
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    }

    function drawFormula(nc) {
        var el = document.getElementById("eqn");
        var f = "s(t) = A"; 
        nl_flag = false;
        for (var j = 1; j <= nc; j++) {
            if ((j > 6) && !(nl_flag)) {
                f += " \\newline ";
                nl_flag = true;
            }
            if (j > 1) {
                f += " + ";
                f += "\\frac{1}{" + (j * 2 - 1) + "} ";
            }
            f += "{\\sin(2 \\pi f t + \\phi)}";         
        }
       
        el.innerHTML = translate(f);
    }
	
	function updateEqn() {
        var el = document.getElementById("eqn");
        var f = "s(t) = " + amp.toFixed(2); 
            f += "{\\sin(2 \\pi " + parseInt(freq) +" t + " + +(phase*360.0/16.0).toFixed(1) + "\\degrees)}";
		
        el.innerHTML = translate(f) ;
    }
	
	
	VLE.resize_iframe(); 
}

});
