$(document).ready(function () {

    /*		var msg ="You are viewing this activity in ";
     if (/MSIE 10/i.test(navigator.userAgent)) {
     // This is internet explorer 10
     //window.alert('isIE10');
     msg += "Internet Explorer 10 ";
     }
     else if (/MSIE 9/i.test(navigator.userAgent) || /rv:11.0/i.test(navigator.userAgent)) {
     // This is internet explorer 9 or 11
     //window.location = 'pages/core/ie.htm';
     msg += "Internet Explorer 11 ";
     }
     else if (/Edge\/\d./i.test(navigator.userAgent)){
     // This is Microsoft Edge
     //window.alert('Microsoft Edge');
     msg += "Edge ";
     }

     if ( (/MSIE 10/i.test(navigator.userAgent)) || (/MSIE 9/i.test(navigator.userAgent) || /rv:11.0/i.test(navigator.userAgent)) || (/Edge\/\d./i.test(navigator.userAgent)) ){
     document.getElementById("main_container").style.display = "none";
     document.getElementById("alert_div").innerHTML = msg + ", which does not support the features needed for this activity.<br/> Please use Firefox or Chrome to view this activity.";
     document.getElementById("alert_div").style.display = "block";
     }
     else{
     */
    // astronomy vars:
    var aconv = 215.00;
    var Rconv = 0.1027;///69900.00 / 696000.00;
    var Fstar = 1.00;

    // slider vars
    var i = 90.00;
    var R_star = 1.27;
    var R_planet = 1.75;
    var P_orb = 10.00;

    var POI_y = 0.0;
    var transit_time = 0.0;

    //graph-drawing etc
    var margin = 25;
    var axes_color = "#000000";

    var ymax = 1.0;
    var ymin = 0.8;
    var ninc = 2000;
    var xmax = 10;
    var xmin = -10;
    var axes = [];

    axes[0] = {
        "ox": 20,
        "oy": 20 + 1
    };

    // line dash function for browsers without it, e.g. IE9 & 10
    var CP = window.CanvasRenderingContext2D && CanvasRenderingContext2D.prototype;
    if (CP.lineTo) {
        CP.dashedLine = function (x, y, x2, y2, da) {
            if (!da) {
                da = [10, 5];
            }
            this.save();
            var dx = (x2 - x), dy = (y2 - y);
            var len = Math.sqrt(dx * dx + dy * dy);
            var rot = Math.atan2(dy, dx);
            this.translate(x, y);
            this.moveTo(0, 0);
            this.rotate(rot);
            var dc = da.length;
            var di = 0, draw = true;
            x = 0;
            while (len > x) {
                x += da[di++ % dc];
                if (x > len) {
                    x = len;
                }
                draw ? this.lineTo(x, 0) : this.moveTo(x, 0);
                draw = !draw;
            }
            this.restore();
        }
    }

    function drawEqn(i, R_star, R_planet, P_orb) {
        var Afull = Math.PI * Math.pow((R_planet * Rconv ), 2.0); //console.log("Afull = " + Afull);
        var R_planet_au = R_planet * Rconv / aconv; //console.log("R_planet_au = " + R_planet_au);
        var M_star = -99.0;
        var Bx = -99.0;
        var absB = 20.0;
        if (R_star < Math.pow(2.00, (15.0 / 19.0))) {
            M_star = Math.pow(R_star, (1.0 / 0.90));
        }
        else {
            M_star = Math.pow(R_star, (19.0 / 15.0));
        }
        //console.log("M_star = " + M_star);

        var a = Math.pow((Math.pow((P_orb / 365), 2.00) / M_star), (1.00 / 3.00));
        //console.log("a = " + a);
        document.getElementById("separation").innerHTML = "Planet-star separation: " + a.toFixed(4) + " AU";

        var Z = a * Math.cos(i * Math.PI / 180.00);
        //console.log("Z = " + Z);

        var w, h, ox, oy, y1, scale, step, wh;
        //console.log("drawing wave " + amp, freq, phase);
        var canvas = document.getElementById("component_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        drawTimeGraphAxes();

        ox = margin; //parseInt(w / 2);
        //ox = parseInt(margin);

        oy = margin;  //parseInt(h / 2);
        scale = (w - (margin * 2)) / (xmax - xmin);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#3a4891";
        ctx.lineWidth = 1.5;
        // step = 0.01;
        step = (xmax - xmin) / ninc;
        //console.log(" - ----------------- Step = " + step);
        var b, S, L, Aless, A, Ftrans, Freal;

        //wh = (amp * h - margin * 2) / 2;
        wh = ( h - margin * 2) / (ymax - ymin);
        //console.log("wh = " + wh);
        ctx.beginPath();
        y1 = wh * (1.0 - ymin);
        ctx.moveTo(ox, h - oy - y1);

        for (var j = xmin; j <= xmax; j = j + step) {
            //calculate eqns:
            //console.log("");
            //console.log("------------------- new step ------------------------------------");
            //console.log("");
            b = a * Math.sin((2.00 * Math.PI * j / 24.0) / P_orb);

            if (Math.abs(j) <= 6.00 * P_orb) {
                S = Math.sqrt((b * b) + (Z * Z));
            }
            else {
                S = 1.00 + R_planet_au + R_star;
            }

            L = Math.abs(S - (R_star / aconv));

            if (L < R_planet_au) {
                Aless = (R_planet * Rconv * R_planet * Rconv) * ( Math.acos(L / R_planet_au) -
                    (  (L / ( R_planet_au * R_planet_au)) * Math.sqrt(R_planet_au * R_planet_au - L * L)));
            }
            else {
                Aless = (R_planet * Rconv * R_planet * Rconv) * ( Math.acos(L / R_planet_au) );
            }
            if (isNaN(Aless)) {
                Aless = 0;
            }

            var branch2max = R_star / aconv + R_planet_au;
            if (Math.abs(branch2max - S) < absB) {
                absB = Math.abs(branch2max - S);
                Bx = j;
            }

            if (S <= R_star / aconv - R_planet_au) {
                A = Afull; //console.log("branch 4");
            }
            else if (S <= R_star / aconv) {
                A = Afull - Aless; //console.log("branch 3");
            }
            else if (S <= R_star / aconv + R_planet_au) {
                A = Aless; //console.log("branch 2");
            }
            else {
                A = 0; //console.log("branch 1");
            }

            Ftrans = Fstar * (1.00 - A / (Math.PI * R_star * R_star));

            if (Ftrans >= 0.00) {
                Freal = Ftrans;
            }
            else {
                Freal = 0.00;
            }

            if (Math.abs(j) < 1.0e-7) {
                POI_y = Freal;
                //console.log("SETTING POI @ 0 = " + Freal);
                console.log(j, Freal, Ftrans, A);
            }
            y1 = wh * (Freal - ymin);
            ctx.lineTo(ox + (j - xmin) * scale, h - oy - y1);
        }
        ctx.stroke();
        ctx.restore();
        var perc = POI_y;
        if (POI_y >= 0.0) {
            perc = (1.00 - POI_y) * 100.0;
        }
        else {
            perc = 100.0;
        }

        if (Math.abs(Math.abs(POI_y) - 1.00) < 1.0e-5) {
            transit_time = 0.0;
        }
        else {
            transit_time = 2.00 * Math.abs(Bx);
        }

        console.log(POI_y, perc);
        document.getElementById("transitdepth").innerHTML = "Transit depth: " + perc.toFixed(2) + "%";
        document.getElementById("transittime").innerHTML = "Total transit time: " + transit_time.toFixed(2) + " hours";
    }

    function drawTimeGraphAxes() {
        var canvas = document.getElementById("component_graph");
        var ctx = canvas.getContext("2d");
        var w = canvas.width;
        var h = canvas.height;
        ctx.save();
        var ox = margin; //parseInt(w / 2);
        var oy = h - margin;//parseInt(h / 2);
        ctx.lineWidth = 1;
        ctx.strokeStyle = axes_color;
        ctx.beginPath();
        ctx.moveTo(ox, margin - 10);
        ctx.lineTo(ox, h - margin);
        ctx.moveTo(margin, oy);
        ctx.lineTo(w - margin, oy);
        // draw ticks - horizontal axis
        ctx.moveTo(w - margin, oy);
        ctx.lineTo(w - margin, oy + 6);
        ctx.moveTo(margin, oy);
        ctx.lineTo(margin, oy + 6);
        // draw ticks - vertical axis
        ctx.moveTo(ox, margin);
        ctx.lineTo(ox - 6, margin);
        ctx.moveTo(ox, h - margin);
        ctx.lineTo(ox - 6, h - margin);
        ctx.stroke();
        // draw labels
        var yscale = ( h - margin * 2) / 10;
        var xscale = ( w - margin * 2) / 20;
        for (var ij = 1; ij < 20; ij++) {
            // draw ticks - horizontal axis
            ctx.moveTo(margin + ij * xscale, oy);
            ctx.lineTo(margin + ij * xscale, oy + 6);
            var xnum = xmin + ij;
            if (xnum < 0) {
                ctx.fillText('' + xnum.toFixed(0), margin + ij * xscale - 6, oy + 20);
            }
            else {
                ctx.fillText('' + xnum.toFixed(0), margin + ij * xscale - 3, oy + 20);
            }
            ctx.stroke();
        }
        for (var ik = 1; ik < 10; ik++) {
            // draw ticks - vertical axis
            ctx.moveTo(ox, h - margin - ik * yscale);
            ctx.lineTo(ox - 4, h - margin - ik * yscale);
            var ynum = ymin + (ik * (ymax - ymin) / 10);
            ctx.fillText('' + ynum.toFixed(2), ox - 24, h - margin - ik * yscale + 4);
            ctx.stroke();
        }
        ctx.font = '10pt Arial';
        ctx.fillText('time from mid-transit in hours', w - margin - 154, oy - 6);
        ctx.fillText('' + xmin, margin - 6, oy + 20);
        ctx.fillText('' + xmax, w - margin - 10, oy + 20);
        ctx.fillText('1', ox - 16, margin + 4);
        ctx.fillText('0.8', ox - 24, h - margin + 4);
        //ctx.font = 'italic 10pt Arial';
        // ctx.fillText('t', w - margin - 34, oy - 6);
        ctx.fillText('Relative measured brightness', ox + 5, margin - 14);
        ctx.restore();
    }

    drawEqn(90.0, 1.27, 1.75, 10.0);

    $("#i_input").on("input change", function () {
        i = parseFloat(this.value);
        R_star = parseFloat(document.getElementById("r_star_input").value);
        R_planet = parseFloat(document.getElementById("r_planet_input").value);
        P_orb = parseFloat(document.getElementById("p_orb_input").value);
        document.getElementById("i_result").innerHTML = "" + i.toFixed(1) + "&deg; ";
        drawEqn(i, R_star, R_planet, P_orb);
    });
    $("#r_star_input").on("input change", function () {
        i = parseFloat(document.getElementById("i_input").value);
        R_star = parseFloat(this.value);
        R_planet = parseFloat(document.getElementById("r_planet_input").value);
        P_orb = parseFloat(document.getElementById("p_orb_input").value);
        document.getElementById("r_star_result").innerHTML = "" + R_star.toFixed(2);
        drawEqn(i, R_star, R_planet, P_orb);
    });
    $("#r_planet_input").on("input change", function () {
        i = parseFloat(document.getElementById("i_input").value);
        R_star = parseFloat(document.getElementById("r_star_input").value);
        R_planet = parseFloat(this.value);
        P_orb = parseFloat(document.getElementById("p_orb_input").value);
        document.getElementById("r_planet_result").innerHTML = "" + R_planet.toFixed(2);
        drawEqn(i, R_star, R_planet, P_orb);
    });
    $("#p_orb_input").on("input change", function () {
        i = parseFloat(document.getElementById("i_input").value);
        R_star = parseFloat(document.getElementById("r_star_input").value);
        R_planet = parseFloat(document.getElementById("r_planet_input").value);
        P_orb = parseFloat(this.value);
        document.getElementById("p_orb_result").innerHTML = "" + P_orb.toFixed(2);
        drawEqn(i, R_star, R_planet, P_orb);
    });

    //}
});
