// are we running in epub? - crude check
if ((location.protocol != "http:") && (location.protocol != "https:") && (location.protocol != "file:")) {
    // really want to be able to check if specifically running in iBooks
    $("body").css({"margin-top": "50px"}); //shift activity downwards to escape top black bar in iBooks
}

var answers = [[1,0,1,0],[1,0,1,1],[0,0,0,0],[0,0,0,1]];
var genes = [[-1,-1,-1,-1],[-1,-1,-1,-1],[-1,-1,-1,-1],[-1,-1,-1,-1]];
var missing = ["No","One","Two","Three","Four"];

var ticked = "<img src='images/cross.png' alt='ticked box'/>"
var unticked = "<img src='images/solid.png' alt='unticked box'/>"
var correct = "<img src='images/correct.png' class='answer' alt='icon right'/>";
var incorrect = "<img src='images/incorrect.png' class='answer' alt='icon wrong'/>";

var num_tries = 0;


$("#btnNext").on("click", function(e) {
    $("#question1").css("display","none");
    $("#question2").css("display","block");
    $("#gene0-0-0").focus();
});

$("#btnCheckA").on("click", function(e) {
    var answers_correct = 0;
    if ($("#male").val() == 1) {
        answers_correct++;
        $("#feedbackA").html(correct);
    } else {
        $("#feedbackA").html(incorrect);
    }
    if ($("#female").val() == 4) {
        answers_correct++;
        $("#feedbackB").html(correct);
    } else {
        $("#feedbackB").html(incorrect);
    }
    $("#feedbackC").html("You have got "+ answers_correct +" out of 2 answers correct.");

    if (answers_correct == 2) {
        $("#btnCheckA").css("display","none");
        $("#btnRevealA").css("display","none");
        $("#btnNext").css("display","inline-block");
    }
});

$("#btnRevealA").on("click", function(e) {
    $("#male").val(1)
    $("#female").val(4)

    $("#feedbackA").html("");
    $("#feedbackB").html("");
    $("#feedbackC").html("These are the correct answers.");

    $("#btnCheckA").css("display","none");
    $("#btnRevealA").css("display","none");
    $("#btnNext").css("display","inline-block");
});

$(".gene").html("<img src='images/box.png' alt='empty box'/>");

$(".gene").on("click keydown", function(e) {
    if ((e.type == "keydown") && (e.which != 32) && (e.which != 13)) return;
    //console.log(this);
    var geneNum = parseInt(this.id.substr(4,1));
    var row = parseInt(this.id.substr(6,1));
    var col = parseInt(this.id.substr(8,1));
    geneVal = genes[geneNum][2*row+col];
    console.log(geneNum,row,col, "=", geneVal);

    if ((geneVal == -1) || (geneVal == 1)) {
        $("#gene"+geneNum+"-"+row+"-"+col).html(unticked);
        genes[geneNum][2*row+col] = 0;
    } else {
        $("#gene"+geneNum+"-"+row+"-"+col).html(ticked);
        genes[geneNum][2*row+col] = 1;
    }

    var num_missing = 0;
    if ((genes[geneNum][0] == -1) || (genes[geneNum][1] == -1) || (genes[geneNum][2] == -1) || (genes[geneNum][3] == -1)) {
        $("#state" + geneNum).html("Click in<br/>all the<br/>boxes");
    } else {
        if (genes[geneNum][0] == 1) num_missing++;
        if (genes[geneNum][1] == 1) num_missing++;
        if (genes[geneNum][2] == 1) num_missing++;
        if (genes[geneNum][3] == 1) num_missing++;
        $("#state" + geneNum).html(missing[num_missing] + "<br/>" + "gene" + (num_missing == 1 ? "" : "s") + "<br/>" + "missing");
    }
    e.preventDefault();
});

$("#btnCheckB").on("click", function(e) {
    var answers_correct = 0;

    var num_correct;
    for (i=0; i<4; i++) {
        num_correct = 0;
        if (genes[i][0] == answers[i][0]) num_correct++;
        if (genes[i][1] == answers[i][1]) num_correct++;
        if (genes[i][2] == answers[i][2]) num_correct++;
        if (genes[i][3] == answers[i][3]) num_correct++;

        if (num_correct == 4) {
            $("#feedback" + i).html(correct);
            answers_correct++;
        } else
            $("#feedback" + i).html(incorrect);
    }

    num_tries++;

    if (answers_correct == 4) {
        $("#feedback").html("Well done, you have got all of the answers correct.");
        $("#btnCheckB").prop("disabled",true);
        $("#btnRevealB").prop("disabled",true);
    } else {
        if (num_tries < 2) {
            $("#feedback").html("You have got " + answers_correct + " out of 4 answers correct.");
        } else {
            $("#feedback").html("You have got " + answers_correct + " out of 4 answers correct. Click the 'Reveal answer' button to see the correct answers.");
            $("#btnCheckB").prop("disabled",true);
        }
    }
});

$("#btnRevealB").on("click", function(e) {
    $("#btnCheckB").prop("disabled",true);
    $("#btnRevealB").prop("disabled",true);

    $(".answer").css("display","none");

    var num_missing ;

    for (geneNum=0; geneNum<4; geneNum++) {
        num_missing = 0;
        for (row=0; row<2; row++)
            for (col=0; col<2; col++)
                if (answers[geneNum][2*row+col] == 1)
                    $("#gene"+geneNum+"-"+row+"-"+col).html(ticked);
                else
                    $("#gene"+geneNum+"-"+row+"-"+col).html(unticked);

        if (answers[geneNum][0] == 1) num_missing++;
        if (answers[geneNum][1] == 1) num_missing++;
        if (answers[geneNum][2] == 1) num_missing++;
        if (answers[geneNum][3] == 1) num_missing++;
        $("#state" + geneNum).html(missing[num_missing] + "<br/>" + "gene" + (num_missing == 1 ? "" : "s") + "<br/>" + "missing");
    }

    $("#feedback").html("These are the correct answers.");
});
