/**************************************************
 * Interactive Codon Diagram
 *
 * by Adrian Singh, Open University 2016-17
 *
 **************************************************/

var container = $("#container");
var svgUrl = "images/sk299_codon_FINAL_amended_HO.svg";

var bgColorAll = "#ffffff";
var fgColorCodon = "#034EA2";
var fgColorAmino = "#000000";
var fgColorA = "#ed1847";
var bgColorA = "lightblue";
var fgColorB = "#3da040";
var bgColorB = "#f9c0ca"; //"pink";
var fgColorC = "#f26722"; //"#aa5d00";
var bgColorC = "lightgreen";
var fgColorD = "white";
var bgColorD = "#ed1847";
var focusRingColor = "#5b9dd9";

var isDialog = false;
//done();

// are we running in epub? - crude check
if ((location.protocol != "http:") && (location.protocol != "https:") && (location.protocol != "file:")) {
    // really want to be able to check if specifically running in iBooks
    $("body").css({"margin-top":"40px"}); //shift activity downwards to escape top black bar in iBooks
}

// load and inject SVG into the page
//var svgToInject = document.getElementById('imgsvg');
//svgToInject.setAttribute("data-src", svgUrl);
//SVGInjector(svgToInject, {}, function() {
//    $("svg").css("width", "500");
//    $("svg").css("height", "500");
//    configure();
//    done();
//});
configure();
done();


function configure() {
    //wrap each amino acid segment in an svg anchor tag so it can be tabbed to
    for (var j=1; j<=25; j++) {
        a = document.createElementNS('http://www.w3.org/2000/svg', 'a');
        a.setAttributeNS('http://www.w3.org/1999/xlink', 'xlink:href', 'javascript:void(0);');
        a.setAttribute("id", "_D"+j);
        $el = $("#D"+j);
        $el.wrap(a);
    }

    // set diagram segment colors
    for (z=1; z<=25; z++) {
        paths = $("#D"+z).find("path");
        $(paths[0]).attr("fill", bgColorAll);
        $(paths[0]).attr("stroke", "black");
        $(paths[0]).attr("stroke-opacity", "0.25");
        paths = $("#C"+z).find("path");
        $(paths[0]).attr("fill", bgColorAll);
        $(paths[0]).attr("stroke", "black");
        $(paths[0]).attr("stroke-opacity", "0.25");
        paths = $("#B"+z).find("path");
        $(paths[0]).attr("fill", bgColorAll);
        $(paths[0]).attr("stroke", "black");
        $(paths[0]).attr("stroke-opacity", "0.25");
        paths = $("#A"+z).find("path");
        $(paths[0]).attr("fill", bgColorAll);
        $(paths[0]).attr("stroke", "black");
        $(paths[0]).attr("stroke-opacity", "0.25");
    }
}

function done() {
    for (var j=1; j<=25; j++) {
        $("#_D"+j).on("focusin", (function (j) {
            return function() {
                for (z=1; z<=25; z++) {
                    paths = $("#D"+z).find("path");
                    $(paths[0]).attr("stroke", "black");
                    $(paths[0]).attr("stroke-opacity", "0.25");
                    $(paths[0]).attr("stroke-width", "1");
                }
                paths = $("#D"+j).find("path");
                $(paths[0]).attr("stroke", focusRingColor);
                $(paths[0]).attr("stroke-opacity", "1");
                $(paths[0]).attr("stroke-width", "2");
            }
        }(j)));
        $("#_D"+j).css("cursor", "pointer");
        $("#_D"+j).on("click keydown", (function (j) {
            return function(e) {
                if (isDialog) {
                    $("#dialog").dialog("close");
                    isDialog = false;
                }

                if (e.type == "keydown") {
                    if (e.which != 32) return;
                    e.preventDefault();
                }
                for (z=1; z<=25; z++) {
                    paths = $("#D"+z).find("path");
                    for (i = 0; i < paths.length; i++) {
                        if (i == 0) $(paths[i]).attr("fill", bgColorAll);
                        else $(paths[i]).attr("fill", fgColorAmino);
                    }
                    paths = $("#C"+z).find("path");
                    for (i = 0; i < paths.length; i++) {
                        if (i == 0) $(paths[i]).attr("fill", bgColorAll);
                        else $(paths[i]).attr("fill", fgColorCodon);
                    }
                    paths = $("#B"+z).find("path");
                    for (i = 0; i < paths.length; i++) {
                        if (i == 0) $(paths[i]).attr("fill", bgColorAll);
                        else $(paths[i]).attr("fill", fgColorCodon);
                    }
                    paths = $("#A"+z).find("path");
                    for (i = 0; i < paths.length; i++) {
                        if (i == 0) $(paths[i]).attr("fill", bgColorAll);
                        else $(paths[i]).attr("fill", fgColorCodon);
                    }
                }

                var master = "UCAG", A, B, C, D;
                //var seq = data.codons[j - 1][1][0];
                //var A = master.indexOf(seq[0]) + 1;
                //var B = 4 * (A - 1) + master.indexOf(seq[1]) + 1;
                //var C = j;
                var amino = data.codons[j - 1][0];
                var seq, A, B, C, str = "", codonCount=0;
                var isFirstTime = true;
                for (z=0; z<data.codons.length; z++) {
                    if (data.codons[z][0] == amino) {
                        j = z + 1;
                        seq = data.codons[j - 1][1][0];
                        A = master.indexOf(seq[0]) + 1;
                        B = 4 * (A - 1) + master.indexOf(seq[1]) + 1;
                        C = j;
                        console.log(data.codons[z] + ": A" + A + "+B" + B + "+C" + C);
                        paths = $("#D" + j).find("path");
                        for (i = 0; i < paths.length; i++) {
                            if (i == 0) $(paths[i]).attr("fill", bgColorD);
                            else $(paths[i]).attr("fill", fgColorD);
                        }
                        paths = $("#C" + C).find("path");
                        for (i = 0; i < paths.length; i++) {
                            if (i == 0) $(paths[i]).attr("fill", bgColorC);
                            else $(paths[i]).attr("fill", fgColorC);
                        }
                        paths = $("#B" + B).find("path");
                        for (i = 0; i < paths.length; i++) {
                            if (i == 0) $(paths[i]).attr("fill", bgColorB);
                            else $(paths[i]).attr("fill", fgColorB);
                        }
                        paths = $("#A" + A).find("path");
                        for (i = 0; i < paths.length; i++) {
                            if (i == 0) $(paths[i]).attr("fill", bgColorA);
                            else $(paths[i]).attr("fill", fgColorA);
                        }
                        for (i=0; i<data.codons[j - 1][1].length; i++) {
                            str += "<span style='color:"+(isFirstTime?'white':'#000000')+"'>or </span>"
                                + "<span style='color:"+fgColorA+"'><b>"+data.codons[j - 1][1][i][0] + "</b></span>"
                                + "<span style='color:"+fgColorB+"'><b>"+data.codons[j - 1][1][i][1] + "</b></span>"
                                + "<span style='color:"+fgColorC+"'><b>"+data.codons[j - 1][1][i][2] + "</b></span>"
                                + "<br/>";
                            codonCount++;
                            isFirstTime = false;
                        }
                    }
                }
                var str2 = "<span style='font-weight:bold; font-size:1.2em; color:"+bgColorD+"'>"+data.codons[j - 1][0]+"</span>";
                var boxStr = "<table><tr><td>"+str+"</td><td id='brace'></td><td>"+str2+"</td></tr></table>";
                boxStr += "<span style='font-size:0.8em'>"+data.codons[j-1][2]+"</span>";
                $("#box").html(boxStr).css("display", "table");

                // generate and insert brace
                var braceHeight = (codonCount>1) ? 30+(codonCount-2)*16 : 30;
                var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
                svg.setAttributeNS(null, 'width', 30);
                svg.setAttributeNS(null, 'height', braceHeight);
                var brace = document.createElementNS('http://www.w3.org/2000/svg', 'path');
                brace.setAttributeNS(null, 'class', 'curlyBrace');
                brace.setAttributeNS(null, "d", makeCurlyBrace(10,braceHeight,10,0,10,0.6));
                svg.appendChild(brace);
                document.getElementById("brace").appendChild(svg);

                if (data.codons[j - 1][0] != "stop") {
                    $btn = $("<br/><input style='margin-top:10px;padding:4px 6px' type='button' id='view' value='View chemical structure'/>");
                    $("#box").append($btn);
                    $("#structure").attr("src", data.codons[j - 1][3]);
                    $("#view").on("click", function () {
                        $("#dialog").dialog({
                            title: data.codons[j - 1][0],
                            //width: "250px",
                            position: {my: "center", at: "center", of: $("svg")}
                        });
                        $(".ui-dialog-titlebar-close").focus();
                        isDialog = true;
                    });
                    $("#view").on("focusin", function() { //remove focus outline from last svg segment
                        console.log("view focusin");
                        paths = $("#_D25").find("path");
                        $(paths[0]).attr("stroke", "black");
                        $(paths[0]).attr("stroke-opacity", "0.25");
                        $(paths[0]).attr("stroke-width", "1");
                    });
                }
                VLE.resize_iframe();
            }
        }(j)));
    }
}

function makeCurlyBrace(x1,y1,x2,y2,w,q) {
    //Calculate unit vector
    var dx = x1-x2;
    var dy = y1-y2;
    var len = Math.sqrt(dx*dx + dy*dy);
    dx = dx / len;
    dy = dy / len;

    //Calculate Control Points of path,
    var qx1 = x1 + q*w*dy;
    var qy1 = y1 - q*w*dx;
    var qx2 = (x1 - .25*len*dx) + (1-q)*w*dy;
    var qy2 = (y1 - .25*len*dy) - (1-q)*w*dx;
    var tx1 = (x1 -  .5*len*dx) + w*dy;
    var ty1 = (y1 -  .5*len*dy) - w*dx;
    var qx3 = x2 + q*w*dy;
    var qy3 = y2 - q*w*dx;
    var qx4 = (x1 - .75*len*dx) + (1-q)*w*dy;
    var qy4 = (y1 - .75*len*dy) - (1-q)*w*dx;

    return ( "M " +  x1 + " " +  y1 +
    " Q " + qx1 + " " + qy1 + " " + qx2 + " " + qy2 +
    " T " + tx1 + " " + ty1 +
    " M " +  x2 + " " +  y2 +
    " Q " + qx3 + " " + qy3 + " " + qx4 + " " + qy4 +
    " T " + tx1 + " " + ty1 );
}

function bracket() {
    var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    svg.setAttributeNS(null, 'width', 20);
    svg.setAttributeNS(null, 'height', 50);

    var brace = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    brace.setAttributeNS(null, 'class', 'curlyBrace');
    brace.setAttributeNS(null, "d", makeCurlyBrace(0,50,0,0,10,0.6));
    svg.appendChild(brace);
    document.body.appendChild(svg);
}
