// are we running in epub? - crude check
if ((location.protocol != "http:") && (location.protocol != "https:") && (location.protocol != "file:")) {
    // really want to be able to check if specifically running in iBooks
    $("body").css({"margin-top": "50px"}); //shift activity downwards to escape top black bar in iBooks
}

$("#image1").attr("src", "images/arrow_right.png");
$("#image2").attr("src", "images/arrow_right.png");

modeTop = 0;
modeBot = 0;
enableArrows();
numTries = 3;

$("#arrow1").on("click keydown", function(e) {
    if (!isEnabled) return;
    if ((e.type == "keydown") && (e.which != 32) && (e.which != 13)) return;
    modeTop++;
    if (modeTop > 2) modeTop = 1;
    if (modeTop == 1) $("#image1").attr("src", "images/arrow_up.png");
    if (modeTop == 2) $("#image1").attr("src", "images/arrow_down.png");
    e.preventDefault();
});

$("#arrow2").on("click keydown", function(e) {
    if (!isEnabled) return;
    if ((e.type == "keydown") && (e.which != 32) && (e.which != 13)) return;
    modeBot++;
    if (modeBot > 2) modeBot = 1;
    if (modeBot == 1) $("#image2").attr("src", "images/arrow_up.png");
    if (modeBot == 2) $("#image2").attr("src", "images/arrow_down.png");
    e.preventDefault();
});

$("#check").on("click", function(e) {
    disableArrows();
    numTries--;
    $("#check").css("display","none");
    if ((modeTop == 2) && (modeBot == 2)) {
        $("#answer").html("Yes, that is the correct answer.");
    } else if (numTries == 0) {
        $("#answer").html("No, that is incorrect. The correct answer is shown.");
        $("#image1").attr("src", "images/arrow_down.png");
        $("#image2").attr("src", "images/arrow_down.png");
        return;
    } else {
        $("#answer").html("No, that is incorrect.");
        $("#tryagain").css("display","block").focus();
    }
});

$("#tryagain").on("click", function(e) {
    enableArrows();
    $("#answer").html("");
    $("#tryagain").css("display","none");
    $("#check").css("display","block").focus();
});

function enableArrows() {
    isEnabled = true;
    $("#arrow1").attr("tabindex", "0");
    $("#arrow2").attr("tabindex", "0");
}

function disableArrows() {
    isEnabled = false;
    $("#arrow1").attr("tabindex", "");
    $("#arrow2").attr("tabindex", "");
}