/*\
|*|
|*|  :: cookies.js ::
|*|
|*|  A complete cookies reader/writer framework with full unicode support.
|*|
|*|  Revision #1 - September 4, 2014
|*|
|*|  https://developer.mozilla.org/en-US/docs/Web/API/document.cookie
|*|  https://developer.mozilla.org/User:fusionchess
|*|
|*|  This framework is released under the GNU Public License, version 3 or later.
|*|  http://www.gnu.org/licenses/gpl-3.0-standalone.html
|*|
|*|  Syntaxes:
|*|
|*|  * docCookies.setItem(name, value[, end[, path[, domain[, secure]]]])
|*|  * docCookies.getItem(name)
|*|  * docCookies.removeItem(name[, path[, domain]])
|*|  * docCookies.hasItem(name)
|*|  * docCookies.keys()
|*|
\*/

var docCookies = {
  getItem: function (sKey) {
    if (!sKey) { return null; }
    return decodeURIComponent(document.cookie.replace(new RegExp("(?:(?:^|.*;)\\s*" + encodeURIComponent(sKey).replace(/[\-\.\+\*]/g, "\\$&") + "\\s*\\=\\s*([^;]*).*$)|^.*$"), "$1")) || null;
  },
  setItem: function (sKey, sValue, vEnd, sPath, sDomain, bSecure) {
    if (!sKey || /^(?:expires|max\-age|path|domain|secure)$/i.test(sKey)) { return false; }
    var sExpires = "";
    if (vEnd) {
      switch (vEnd.constructor) {
        case Number:
          sExpires = vEnd === Infinity ? "; expires=Fri, 31 Dec 9999 23:59:59 GMT" : "; max-age=" + vEnd;
          break;
        case String:
          sExpires = "; expires=" + vEnd;
          break;
        case Date:
          sExpires = "; expires=" + vEnd.toUTCString();
          break;
      }
    }
    document.cookie = encodeURIComponent(sKey) + "=" + encodeURIComponent(sValue) + sExpires + (sDomain ? "; domain=" + sDomain : "") + (sPath ? "; path=" + sPath : "") + (bSecure ? "; secure" : "");
    return true;
  },
  removeItem: function (sKey, sPath, sDomain) {
    if (!this.hasItem(sKey)) { return false; }
    document.cookie = encodeURIComponent(sKey) + "=; expires=Thu, 01 Jan 1970 00:00:00 GMT" + (sDomain ? "; domain=" + sDomain : "") + (sPath ? "; path=" + sPath : "");
    return true;
  },
  hasItem: function (sKey) {
    if (!sKey) { return false; }
    return (new RegExp("(?:^|;\\s*)" + encodeURIComponent(sKey).replace(/[\-\.\+\*]/g, "\\$&") + "\\s*\\=")).test(document.cookie);
  },
  keys: function () {
    var aKeys = document.cookie.replace(/((?:^|\s*;)[^\=]+)(?=;|$)|^\s*|\s*(?:\=[^;]*)?(?:\1|$)/g, "").split(/\s*(?:\=[^;]*)?;\s*/);
    for (var nLen = aKeys.length, nIdx = 0; nIdx < nLen; nIdx++) { aKeys[nIdx] = decodeURIComponent(aKeys[nIdx]); }
    return aKeys;
  }
};


/* Utils Specific to this project */
var c24 =['#33cc33','#ff0000','#3366ff','#00e7b4','#a6cee3','#fb9a99','#b15928','#b4002f','#bcbc34','#393d77','#ff8200','#7800a8','#ff00d7','#ffc100','#b2df8a','#fdb56d','#cab2d6','#c39c95','#29bece','#cc70bc','#669c95','#ff7a9a','#e3026f','#006d33']
var c24h =['#196619','#7f0000','#19337f','#00735a','#536771','#7d4d4c','#582c14','#5a0017','#5d5d1a','#1c1e3b','#7f4100','#3c0054','#7f006b','#7f6000','#586f44','#7e5a36','#64586a','#614e4a','#145e67','#66375d','#334e4a','#7f3c4d','#710137','#003619']
var blue = '#2800D7'
var orange = '#FB8E1E'
var palette = ["#c39c95", "#cc70bc", "#393d77", "#e3026f", "#cab2d6", "#b2df8a", "#fdb56d", "#a6cee3", "#b4002f", "#ff8200", "#bcbc34", "#3366ff", "#ff7a9a", "#669c95", "#29bece", "#ff0000", "#7800a8", "#006d33", "#ffc100", "#fb9a99", "#ff00d7", "#33cc33", "#00e7b4", "#b15928"]
var palette = ["#cab2d6", "#ffc100", "#a6cee3", "#669c95", "#b4002f", "#393d77", "#e3026f", "#00e7b4", "#cc70bc", "#ff0000", "#b2df8a", "#fdb56d", "#c39c95", "#29bece", "#ff8200", "#b15928", "#ff00d7", "#006d33", "#7800a8", "#33cc33", "#3366ff", "#bcbc34", "#ff7a9a", "#fb9a99"]
var palette = ["#c39c95", "#bcbc34", "#a6cee3", "#b4002f", "#006d33", "#29bece", "#cab2d6", "#b15928", "#33cc33", "#cc70bc", "#ff8200", "#b2df8a", "#ff00d7", "#ffc100", "#393d77", "#e3026f", "#3366ff", "#fb9a99", "#ff7a9a", "#7800a8", "#669c95", "#00e7b4", "#fdb56d", "#ff0000"]
// var palette = ["#c6c6c6", "#c6c6c6", "#b4002f", "#bcbc34", "#cab2d6", "#006d33", "#ff7a9a", "#ff0000", "#33cc33", "#7800a8", "#ff8200", "#fb9a99", "#b15928", "#b2df8a", "#29bece", "#a6cee3", "#3366ff", "#ff00d7", "#00e7b4", "#669c95", "#cc70bc", "#c39c95", "#ffc100", "#e3026f", "#fdb56d", "#393d77"]
// var palette = ["#c6c6c6", "#c6c6c6", "#ff8200", "#cab2d6", "#a6cee3", "#393d77", "#ffc100", "#bcbc34", "#3366ff", "#00e7b4", "#b15928", "#fb9a99", "#006d33", "#ff0000", "#33cc33", "#29bece", "#b4002f", "#e3026f", "#fdb56d", "#cc70bc", "#c39c95", "#7800a8", "#b2df8a", "#669c95", "#ff00d7", "#ff7a9a"]

//              observed  orbital     *solar     volcano     ozone                Aresols   land use   greenhouse  natural    human     all
var palette = ["#c6c6c6", "#29bece", "#ff8200", "#ff0000", "rgb(51, 204, 51)", "#393d77", "#bcbc34", "#006d33", "#3366ff", "#b4002f", "#7800a8"]
//              observed  orbital     *solar     volcano     natural     land use     ozone         Aresols    greenhouse   human     all
var palette = ["#c6c6c6", "#29bece", "#ff8200", "#ff0000", "rgb(102, 156, 149)", "#bcbc34","rgb(102, 156, 149)", "#393d77", "#006d33", "#3366ff", "#b4002f"]

// rgb(102, 156, 149)
// rgb(178, 223, 138)


// var palette =d3.shuffle(c24)

var color = function(i) {return palette[i%palette.length]}

var time = d3.time.format('%Y')
var duration = 400

/* Utils Generic */
var numf = d3.format(',f')
var format = d3.time.format("%Y-%m-%d");

function tweenNum(d) {
  var i = d3.interpolate(this.textContent.replace(/\D/g, ''), d)

  return function(t) {
      this.textContent = numf(i(t));
  };
}

function unSlug(text){
    return text.toLowerCase().replace(/ /g,'-').replace(/[^\w-]+/g,'')
}

function toSlug(text){
    return text.toLowerCase().replace(/ /g,'-').replace(/\//g,'').replace(/[^\w-]+/g,'')
}

function isNumeric(n) {
  return !isNaN(parseFloat(n)) && isFinite(n);
}

function getJsonFromUrl() {
  var query = location.search.substr(1);
  var result = {};
  query.split("&").forEach(function(part) {
    var item = part.split("=");
    result[item[0]] = decodeURIComponent(item[1]);
  });
  return result;
}

// Array.prototype.clone = function() {
//   return _.map(this, _.clone)
// }

Date.prototype.getWeek = function() {
  var onejan = new Date(this.getFullYear(), 0, 1);
  return Math.ceil((((this - onejan) / 86400000) + onejan.getDay() + 1) / 7);
}

function padLeft(s) {
  return ('00' + s).slice(-2)
}

function componentToHex(c) {
    var hex = c.toString(16);
    return hex.length == 1 ? "0" + hex : hex;
}

function hexToRgb(hex) {
    // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
    var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    hex = hex.replace(shorthandRegex, function(m, r, g, b) {
        return r + r + g + g + b + b;
    });

    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : null;

}


// Kelvin To Celsius
function kToC(t){
  // 272.15K = 1 C
  return (t -272.15)
}
// Celsius to Fahrenheit
function cToF(t){
  // 272.15K = 1 C
  return (t)*9/5
}
// Celsius to Fahrenheit
function fToC(t){
  // 272.15K = 1 C
  return t/(9/5)
}
// Kelvin To Fahrenheit
function kToF(t){
  // 272.15K = 1 C
  return (t -272.15)*9/5+32
}

function useCelsius() {
  // I'm guessing this cookie is the correct one to use
  // also being conservative and defaulting to Farenheit if it doesn't match
  return docCookies.getItem('ak_rg') === 'Europe'
}

function formatTemperature(t) {
  return useCelsius() ? d3.format('+.1f')(fToC(t)) + '˚C' : d3.format('+.0f')(t) + '˚F' 
}


