(function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){

var chart = null;

function drawHistogram(container, data, grouping, gridLineWidth, fontSize, gridLineColor, barColor, backGroundColor,
        pmfColor, outline, axisColor, animation, frameWidth, frameHeight, title, isLogarithmic, hpFilterPosition,
        yMax, xMax, yTitle, shadeColour, xTitle){
        xMax = 2;
        xMin = -2;
        var borderWidth = 0;
        var borderColor = '#000000';
        if(outline){
            borderWidth = 1;
        }
        var pointWidth=null;
        if(data.length < 20){
            pointWidth = 2;
        }
        if(data.length<4){
            data.push([1.1,0],[1.2,0],[1.3,0],[1.4,0]);
        }
        chart=Highcharts.chart(container, {
            chart: {
                type: 'column',
                backgroundColor: backGroundColor,
                width: frameWidth,
                height: frameHeight
            },
            title: {
                text: title,
                style: {
                    color: axisColor
                }
            },
            colors: [
                barColor,
                pmfColor
            ],
            xAxis: {
                endOnTick: true,
                startOnTick: true,
                title: {
                    text: xTitle,
                    style: {
                        fontSize: (fontSize).toFixed(0) +"px",
                        color: axisColor,
                        fontFamily: "Arial, Verdana, sans-serif"
                    }
                },
                lineWidth: gridLineWidth,
                lineColor: axisColor,
                gridLineWidth: 0,
                gridLineColor: gridLineColor,
                tickColor: gridLineColor,
                labels: {
                    style: {
                        color: axisColor,
                        fontSize: (fontSize).toFixed(0) +"px",
                        fontFamily: "Arial, Verdana, sans-serif"
                    }
                },
                min: xMin,
                max: xMax,
                //type: isLogarithmic ? 'logarithmic' : null,
                minPadding: 0
            },
            yAxis: [{
                min: 0,
                title: {
                    text: yTitle,
                    style: {
                        fontSize: (fontSize).toFixed(0) +"px",
                        color: axisColor,
                        fontFamily: "Arial, Verdana, sans-serif"
                    }
                },
                lineWidth: gridLineWidth,
                lineColor: axisColor,
                gridLineWidth: 0,
                gridLineColor: gridLineColor,
                tickColor: gridLineColor,
                labels: {
                    style: {
                        color: axisColor,
                        fontSize: (fontSize).toFixed(0) +"px",
                        fontFamily: "Arial, Verdana, sans-serif"
                    }
                },
                max:yMax
            }],
            plotOptions: {
                bar: {
                    color: barColor
                },
                series: {
                    shadow:false,
                    borderWidth: borderWidth,
                    borderColor: borderColor
                },
                column: {
                    pointWidth: pointWidth,
                    pointPadding: 0,
                    groupPadding: 0
                }
            },
            legend: {
                enabled: false
            },
            series: [{
                name: ' ',
                type: 'column',
                data: data,
                animation: animation
            }],
            exporting: {
                buttons: {
                    contextButton: {
                        menuItems: ['downloadCSV']
                    }
                }
            }
        });

        if(container == 'container1') {
            window.yMax = chart.yAxis[0].max;
            var chart1=chart;
        }else{
            var chart2=chart;
        }

        if(data.length > 0) {
            var hpFilterPositionActual = ((hpFilterPosition / (xMax - xMin))) * (chart.series[0].xAxis.width)
                + (chart.series[0].xAxis.width / 2);
            doShading(hpFilterPositionActual, chart, shadeColour);

            if (container == "container2") {
                  //Slider is irrelevant to the second histogram.
            }else{

                //Calculate position of filter (this may be a chart with a logarithmic X-axis)
                var filterValue = 0;
                for (var i = 0; i < chart.series[0].data.length; i++) {

                    if (typeof chart.series[0].data[i] == "undefined")
                        return;     //Chart is currently being redrawn
                    //Find the nearest match to the slider position
                    var lPosition = chart.series[0].data[i].plotX;
                    var rPosition = -1;
                    if (i < chart.series[0].data.length - 1) {
                        rPosition = chart.series[0].data[i + 1].plotX;
                    }

                    if ((lPosition < hpFilterPositionActual) && rPosition == -1) {
                        filterValue = chart.series[0].data[i].plotX;
                        break;
                    } else if ((lPosition > hpFilterPositionActual) && i == 0) {
                        filterValue = chart.series[0].data[i].plotX;
                        break;
                    } else if (lPosition < hpFilterPositionActual && rPosition > hpFilterPositionActual) {
                        var below = hpFilterPositionActual - lPosition;
                        var above = rPosition - hpFilterPositionActual;
                        if (below < above) {
                            filterValue = chart.series[0].data[i].x;
                            break;
                        } else {
                            filterValue = chart.series[0].data[i + 1].x;
                            break;
                        }
                    }
                }
            }
        }


        var credits = document.getElementsByClassName("highcharts-credits");
        for (var i = 0; i < credits.length; i++) {
            credits[i].href="http://www.highcharts.com/products/highcharts";
        }

        var hamburger = document.getElementById(container).getElementsByClassName("highcharts-button")[0];
        if(getBrowserVersion()[0] == 'Trident') {
            //Highcharts download doesn't work properly in IE11 so disable the hamburger button,
            //if user wants to print it they can use PrintSc
            hamburger.style.zIndex = "-1";
            hamburger.style.visibility = "hidden";
        } else {
            hamburger.tabIndex = "0";
            hamburger.addEventListener('keydown', function(e){
                var event = window.event ? window.event : e;
                if(event.keyCode==13 || event.keyCode==32) {
                    if(container == 'container1') {
                        chart1.downloadCSV();   //Make sure it keeps the two charts' data separate.
                    }else{
                        chart2.downloadCSV();
                    }
                }
            });
        }

        var curr = new Date();
        console.log("End of drawHistogram:"+curr.getTime());

        return filterValue;
}

function doShading(lowCutoff, chart, shadeColour){

    var series = chart.series[0];
    var plotX0 = series.yAxis.left;
    var plotXmax = series.xAxis.width;
    var yTop = series.xAxis.top;
    var yBottom = yTop+(series.yAxis.height);

    var renderer = chart.renderer;
    renderer.rect(plotX0, yTop, lowCutoff, yBottom - yTop, 0).attr({
        'stroke-width': 0,
        fill: shadeColour,
        zIndex: -1
    }).add();

}


function getBrowserVersion(){

        var navigatorObj = navigator.appName,
            userAgentObj = navigator.userAgent,
            matchVersion;
        if(userAgentObj.indexOf("iPad") > -1 ||  userAgentObj.indexOf("Safari") > -1){
            return "mac or ipad";
        }
        //Something else breaks if it is one of the above platforms so return immediately.
        var match = userAgentObj.match(/(opera|chrome|safari|firefox|msie|trident)\/?\s*(\.?\d+(\.\d+)*)/i);
        if( match && (matchVersion = userAgentObj.match(/version\/([\.\d]+)/i)) !== null) match[2] = matchVersion[1];
        //mobile
        if (navigator.userAgent.match(/iPhone|Android|webOS|iPad/i)) {
            return match ? [match[1], match[2], mobile] : [navigatorObj, navigator.appVersion, mobile];
        }
        // web browser
        return match ? [match[1], match[2]] : [navigatorObj, navigator.appVersion, '-?'];

}

;/**
 * Created by gcm77 on 14/07/2017.
 */

var wavesurfer;
//const WavDecoder = require("wav-decoder");
var signalData = null;
var noiseData = null;
var signalNoisyData = null;
var signalFilteredData = null;

var decodedData = null;
var decodedNoisyData = null;
var decodedFilteredData = null;
var filteredData = null;
var data2 = null;

var player1;
var player2;
var audioContext;
var fileReader;
var preFilterArray;
var fft1Data;
var fft2Data;
var hpFilterPosition=0;
var lpFilterPosition=0;
var filterMode = "lo";
var hpMoving = false;
var lpMoving = false;
var noiseMoving = false;
var noiseLevel;
var xAxisGraph = 8000;
var graphCompensator = 1;
var graphMax = null;
var graphMin = null;

var recorderTitleOrig = 'Audible signal';
var recorderTitleNoisy = 'Audible signal with noise';
var topHistoTitle = 'Probability histogram of unfiltered signal';
var topHistoTitleNoisy = 'Probability histogram of unfiltered signal';
var topHistoTitleOrig = 'Original signal';
var bottomHistoTitle = 'Probability histogram of filtered signal';
var uiConstants = {ui:{keycodes:{SPACE:32, ENTER:13 }}};

var histSampleArray = [];
var resolution = 0;
var filterAmplitude = 0;
var filteredArray = [];
window.yMax = 0;
var loadingAccessibilitySettings = false;
var colourScheme=getColorScheme('black_on_white');

function getColorScheme(colorScheme){

    var gridLineColor = '#7F7F7F';
    var barColor = '#CF0B2C';
    var backGroundColor = '#FFFFFF';
    var pmfColor = '#000000';
    var divClass = 'access_std';
    var axisColor = '#000000';
    var shadeColor = '#EEEEEE';
    var splineColour = '#7cb5ec';
    switch (colorScheme){
        case "black_on_white":
            //Use defaults
            break;
        case "white_on_black":
            gridLineColor = '#FFFFFF';
            barColor = '#FFFFFF';
            backGroundColor = '#000000';
            pmfColor = '#FFED00';
            divClass = 'access_wtob';
            axisColor = '#FFFFFF';
            shadeColor = '#999999';
            splineColour = '#FFFFFF';
            break;
        case "yellow_on_black":
            gridLineColor = '#FFED00';
            barColor = '#FFED00';
            backGroundColor = '#000000';
            pmfColor = '#00FF00';
            //pmfColor = '#3333FF';
            divClass = 'access_yob';
            axisColor = '#FFED00';
            shadeColor = '#999999';
            splineColour = '#FFED00';
            break;
        case "dark_blue_on_light_blue":
            gridLineColor = '#0000AA';
            barColor = '#3333FF';
            backGroundColor = '#EFF6F9';
            pmfColor = '#FFED00';
            divClass = 'access_dbolb';
            axisColor = '#0000AA';
            shadeColor = '#999999';
            splineColour = '#3333FF';
            break;
    }

    return {
        gridLineColor:gridLineColor,
        barColor:barColor,
        backGroundColor:backGroundColor,
        pmfColor:pmfColor,
        divClass:divClass,
        axisColor:axisColor,
        shadeColor:shadeColor,
        splineColour:splineColour
    };
}


window.onload = function() {

    var msg = "You are viewing this activity in ";
    if (/MSIE 10/i.test(navigator.userAgent)) {
        // This is internet explorer 10
        //window.alert('isIE10');
        msg += "Internet Explorer 10 ";
    }
    else if (/MSIE 9/i.test(navigator.userAgent) || /rv:11.0/i.test(navigator.userAgent)) {
        // This is internet explorer 9 or 11
        //window.alert('isIE9 or 11');
        // window.location = 'pages/core/ie.htm';
        msg += "Internet Explorer 11 ";
    }
    else if (/Edge\/\d./i.test(navigator.userAgent)) {
        // This is Microsoft Edge
        //window.alert('Microsoft Edge');
        msg += "Edge ";
    }
    else if(window.safari !== undefined || (navigator.userAgent.search("Safari") >= 0 && navigator.userAgent.search("Chrome") < 0)) {
        msg += "Safari";
    }

    var userAgent = navigator.userAgent || navigator.vendor || window.opera;
    if (/iPad|iPhone|iPod/.test(userAgent) && !window.MSStream && !(/windows phone/i.test(userAgent)) && !(/android/i.test(userAgent))) {
        document.getElementById("mainDiv").style.display = "none";
        document.getElementById("alert_div").innerHTML =
            "You are using an iOS device which does not support the features needed for this activity.<br/> Please use Firefox or Chrome in Windows, OSX or Android to view this activity";
        document.getElementById("alert_div").style.display = "block";
    } else {
        if ((/MSIE 10/i.test(navigator.userAgent)) || (/MSIE 9/i.test(navigator.userAgent) || /rv:11.0/i.test(navigator.userAgent))
            || (/iPad|iPhone|iPod/.test(userAgent) && !window.MSStream) || ((window.safari !== undefined) || (navigator.userAgent.search("Safari") >= 0
            && navigator.userAgent.search("Chrome") < 0))) {
            document.getElementById("mainDiv").style.display = "none";
            document.getElementById("alert_div").innerHTML = msg + ", which does not support the features needed for this activity.<br/> Please use Firefox or Chrome to view this activity.";
            document.getElementById("alert_div").style.display = "block";
        }
    }

    var retrieveFromVLE = function(data) {
        // use these to grab students for this activity from vle
        var course_id = VLE.get_param('course_id') || VLE.get_param('_c');
        var document_id = VLE.get_param('document_id') || VLE.get_param('_i');
        var activity_id = VLE.get_param('activity_id') || VLE.get_param('_a');

        VLE.get_server_data(true, data, function(values){
                loadOK(values);
                loadingAccessibilitySettings = false;
            },
            function(msg){
                loadingAccessibilitySettings = false;
                if (!msg === null) {
                    // failure code goes here
                    //alert("Failed to retrieve values from VLE: "+msg);
                }else {
                    //alert("Retrieved values from VLE: " + msg);
                }
            },activity_id, document_id, course_id);
    }

    var loadOK = function(values) {
        ///_sectionA = values['sectionA'];
        ///_sectionB = values['sectionB'];

        var colourSchemeString = values['colorSchemeKey'];
        document.getElementById("colorSchemeSelect").value=colourSchemeString;
        colourScheme=getColorScheme(colourSchemeString);
        changeColour(colourScheme);
    }

    loadingAccessibilitySettings = true;
    var data = ['colorSchemeKey'];
    // array of keys to find
    retrieveFromVLE(data);

    parent.addEventListener("resize", function(){handleResize()});
    handleResize();

    player1 = videojs("myAudio",
        {
            controls: true,
            width: 350,
            height: 50,
            plugins: {
                wavesurfer: {
                    waveColor: "violet",
                    progressColor: "#2E732D",
                    debug: false,
                    cursorWidth: 1,
                    msDisplayMax: 20,
                    hideScrollbar: true
                }
            }
        });

    player2 = videojs("myAudio2",
        {
            controls: true,
            width: 350,
            height: 50,
            plugins: {
                wavesurfer: {
                    waveColor: "violet",
                    progressColor: "#2E732D",
                    debug: false,
                    cursorWidth: 1,
                    msDisplayMax: 20,
                    hideScrollbar: true
                }
            }
        });

    decodedData = null;
    decodedNoisyData = null;
    var AudioContext = window.AudioContext || window.webkitAudioContext;
    audioContext = new AudioContext();
    fft1Data = [];
    fft2Data = [];

    doEmptyHisto("container1");
    doEmptyHisto("container2");
    drawSplineGraph("container4",[],'Filtered data signal');

    fileReader = new FileReader();

    /*
    setTimeout(function () {
        player1.recorder.getDevice();
        document.getElementsByClassName("vjs-device-button")[0].tabIndex = 2;
    }, 1000);
    */
    /*
    var url = "./media/silencetone.wav";
    var request = new XMLHttpRequest();
    request.open('GET', url, true);
    request.responseType = 'arraybuffer';
    */
    generateSignalData();
    var tempData = new Float32Array(signalData);
    var sampleRate = 8000;
    decodedData = audioContext.createBuffer(1, tempData.length, sampleRate);
    decodedData.copyToChannel(tempData, 0);   //Load a duplicate into the buffer
    drawSplineGraph("container3",signalData,'Filtered data signal');
    doHistogram("container3",signalData);
    updateDetections();
    var source=decodedData;
    applyFilter(source);
    setTimeout(function(){
        applySettings();
    },1000);
    //The above will now be loaded by player 1 once player1 is ready

    player1.on('deviceError', function () {
        console.log('device error:', player1.deviceErrorCode);
    });
    player1.on('error', function (error) {
        console.log('error:', error);
    });

// user clicked the record button and started recording
    player1.on('startRecord', function () {
        console.log('started recording!');
    });

// user completed recording and stream is available
    //https://www.html5rocks.com/en/tutorials/webaudio/intro/


    player1.on('finishRecord', function () {
        console.log('finished recording: ');

        var playBtn = document.getElementsByClassName("vjs-play-control vjs-control vjs-button vjs-paused")[0];
        if (playBtn !== null && typeof playBtn != "undefined") {
            playBtn.style.display = "none";
        }

        fileReader.readAsArrayBuffer(player1.recordedData);
        document.getElementsByClassName("vjs-play-control")[0].tabIndex = 0;

    });

    setInterval(function(){

        var playBtn = document.getElementsByClassName("vjs-play-control vjs-control vjs-button vjs-playing")[0];
        if (playBtn !== null && typeof playBtn != "undefined") {
            playBtn.className="vjs-play-control vjs-control vjs-button vjs-paused";
        }

    },3000);

    player1.on('ready', function () {
        //Now turn the data back into a .wav

        var wavArrayBuffer = audioBufferToWav(decodedData);
        var dataView = new DataView(wavArrayBuffer);
        var wavBlob = new Blob([dataView], {type: 'audio/wav'});
        player1.waveform.surfer.loadBlob(wavBlob);

        document.getElementById("zoomSlider").oninput = function () {
            //var selection = $( "#slider" ).slider( "values" ) * 10;
            var selection = document.getElementById("zoomSlider").value;

            var zoomLevel = Number(selection);
            player1.waveform.surfer.zoom(zoomLevel);

            // Set the new zoom value to the param
            player1.waveform.surfer.params.minPxPerSec = zoomLevel;

            // Redraw the waveform with the updated zoom value
            player1.waveform.surfer.drawBuffer();

            // Zoom in where cursor location is
            player1.waveform.surfer.seekAndCenter(
                player1.waveform.surfer.getCurrentTime() / player1.waveform.surfer.getDuration()
            );

        };
        //var curr = new Date();
        //console.log("End of on ready"+curr.getTime());

    });

    player2.on('ready', function () {

        document.getElementById("zoomSlider2").oninput = function () {
            //var selection = $( "#slider" ).slider( "values" ) * 10;
            var selection = document.getElementById("zoomSlider2").value;

            var zoomLevel = Number(selection);
            player2.waveform.surfer.zoom(zoomLevel);

            // Set the new zoom value to the param
            player2.waveform.surfer.params.minPxPerSec = zoomLevel;

            // Redraw the waveform with the updated zoom value
            player2.waveform.surfer.drawBuffer();

            // Zoom in where cursor location is
            player2.waveform.surfer.seekAndCenter(
                player2.waveform.surfer.getCurrentTime() / player2.waveform.surfer.getDuration()
            );

        };
        //var curr = new Date();
        //console.log("End of on ready"+curr.getTime());

    });

    function generateSignalData(){
        var fullLength = 10000;
        signalData = [];
        for(var i=0; i<fullLength; i++){
            if( i < fullLength / 2) {
                signalData.push(0);
            }else{
                signalData.push(1);
            }
        }
    }

    function generateToneData(){
        var tempData = [];
        var freq = 440;  //Middle 'A'
        var counter = 0 ;
        var increase = freq / 2600;

        for(var i=0; i<signalData.length; i++){
            if(signalData[i] >= 1) {
                tempData.push((Math.sin(counter) / 2 ) );
                counter += increase;
            }else{
                tempData.push(0);
            }
        }
        return tempData;
    }



    function addNoise() {

        if(!(decodedData == null)) {
            var tempData = decodedData.getChannelData(0);
            decodedNoisyData = audioContext.createBuffer(1, decodedData.length, decodedData.sampleRate);
            var data = tempData.slice();  //So we don't corrupt the original
            var frameCount = data.length;
            var sampleCompensator = decodedData.sampleRate / 16000;

            //var snRatio=38.9;  //Noisy
            //var snRatio=144;
            //Create a noise signal the same duration as the audible signal and the original digital signal.
            noiseLevel = document.getElementById("noiseSlider").value;
            noiseData = generateNoise(data.length, noiseLevel);

            signalNoisyData = [];
            //Add to the original signal and the audio signal (but reduce the volume on the audio version)
            for (var i = 0; i < data.length; i++) {
                data[i] = data[i] + noiseData[i] / 5;
                signalNoisyData[i] = signalData[i] + noiseData[i];
            }

            data = new Float32Array(data);
            decodedNoisyData.copyToChannel(data, 0);   //Load a duplicate into the filtered buffer
            //Now turn the data back into a .wav
            var wavArrayBuffer = audioBufferToWav(decodedNoisyData);
            var dataView = new DataView(wavArrayBuffer);
            var wavBlob = new Blob([dataView], {type: 'audio/wav'});
            if (typeof player1.waveform.surfer !== "undefined") {
                player1.waveform.surfer.loadBlob(wavBlob);      //It might not exist yet
            }
        }
    }

    function removeNoise() {

        if(!(decodedData == null)) {
            //Revert to the original version
            var wavArrayBuffer = audioBufferToWav(decodedData);
            var dataView = new DataView(wavArrayBuffer);
            var wavBlob = new Blob([dataView], {type: 'audio/wav'});
            player1.waveform.surfer.loadBlob(wavBlob);
        }
    }

    function applyFilter(dataSource) {

        var data = signalNoisyData;
        //If some sound has actually been recorded
        if(signalNoisyData == null) data = signalData;

        var sampleLength = data.length;
        //So we don't corrupt the recorded sound
        filteredArray = [];

        var firLength = parseInt(document.getElementById('firSlider').value);
        //firLength = 100;

        var pointer = 0;
        //Balancing code
        while (pointer < firLength / 2) {
            filteredArray.push(0);
            pointer++;
        }

        while (pointer < sampleLength - (firLength / 2)) {
            var sumSignal = 0;
            for (var i = (pointer - firLength / 2); i < (pointer + firLength / 2); i++) {
                //sumSignal += Math.pow(data[i], 2);
                sumSignal += data[i];
            }
            var meanSignal = sumSignal / firLength;

            filteredArray.push(meanSignal);
            pointer++;  //Move on - samples overlap
        }

        //More balancing code
        while (pointer < firLength) {
            filteredArray.push(1);
            pointer++;
        }

        drawSplineGraph('container4',filteredArray,'Filtered data signal');
        doHistogram2();

        filteredData = audioContext.createBuffer(1, decodedData.length, decodedData.sampleRate);

        data2 = new Float32Array(filteredArray);
        filteredData.copyToChannel(data2, 0);   //Load a duplicate into the filtered buffer
        //Now turn the data back into a .wav
        var wavArrayBuffer = audioBufferToWav(filteredData);
        var dataView = new DataView(wavArrayBuffer);
        var wavBlob = new Blob([dataView], {type: 'audio/wav'});

        if(typeof player2.waveform.surfer !== "undefined") {
            player2.waveform.surfer.loadBlob(wavBlob);
        }
    }

    function removeFilter() {
        //Now turn the data which was stored earlier back into a .wav
        var wavBlob = preFilterArray;
        player1.waveform.surfer.loadBlob(wavBlob);
    }

    function doHistogram(containerID,dataSource) {

        /* The sound waveform is a string of amplitudes.  The problem with this is that it includes zero-crossing so */
        /* do I need to break it into time segments first and measure the amplitude of those?                        */
        /* Or does the activity involve dragging a sample area along?                                                */

        /* The sound waveform is a string of amplitudes.  The problem with this is that it includes zero-crossing so */
        /* do I need to break it into time segments first and measure the amplitude of those?                        */
        /* Or does the activity involve dragging a sample area along?                                                */

        if(!(dataSource == null)) {

            /*
                        //Because we're not histogramming actual sound in this activity
            var tempData = dataSource.getChannelData(0);
            var data = tempData.slice();  //So we don't corrupt the recorded sound
             */
            var data = dataSource.slice();

            var sampleLength = data.length;
            //var modulus = length % 4;
            //If sampling rate is  22050 then this should give approx. 10mS samples.
            var subSampleLength = 30;
            var subSamples = [];
            var pointer=0;
            //Averaging filter
            /*
            while((pointer+subSampleLength) < sampleLength){
                var endPoint = (pointer+subSampleLength);
                var squareSumSignal = 0;
                for(var i=pointer; i<endPoint; i++){
                    squareSumSignal += Math.pow(data[i]+1, 2);   //Add 1 so that negativity is not lost by squaring
                }
                subSamples.push((Math.sqrt((1 / subSampleLength) * squareSumSignal))-1);  //Subtract 1 again
                pointer = pointer+subSampleLength;  //Move on to the next sample
            }
            */

            //Now calculate the histogram of the subsamples
            //resolution = getClassWidth(subSamples.length, 0, subSamples);
            var resolution = 0.01;
            //var resolution = 0.005;
            //if(resolution == 0){
            //    resolution = 1;
            //}
            //histSampleArray = histogram(subSamples, resolution/250, false);
            //histSampleArray = histogram(subSamples, resolution, false);
            histSampleArray = histogram(data, resolution, false);
            var logarithmicX = document.getElementById("logarithmic").checked;
            logarithmicX = false;
            /*
            for (var i = 0; i < histSampleArray.length; i++) {
                if (histSampleArray[i][0] < 0.00000001) {
                    //Prevent Highcharts error
                    histSampleArray.splice(i, 1);
                }
            }
            */

            var lcSliderPosition = document.getElementById("lcSlider").value;

            filterAmplitude = drawHistogram('container1', histSampleArray, resolution, 1, 14, colourScheme.axisColor,
                colourScheme.barColor, colourScheme.backGroundColor, colourScheme.pmfColor, false, colourScheme.axisColor,
                true, '500', '300', topHistoTitle, logarithmicX, lcSliderPosition, null, 1.5, "probability",
                colourScheme.shadeColor, "voltage (V)");

            /*
            drawHistogram('container2', histSampleArray2, resolution, 1, 12, '#000000', '#ff0000', '#ffffff',
                '#000000', false, '#000000', true, '500', '300', bottomHistoTitle, logarithmicX, lcSliderPosition,
                null, 1.5, "Probability");
            */

            //Enable the play button only after FFT calculation has completed
            /*
            var playBtn = document.getElementsByClassName("vjs-play-control vjs-control vjs-button")[0];
            if (playBtn !== null && typeof playBtn != "undefined"){
                playBtn.style.display = "inline-block";
            }
            */
            var volBtns = document.getElementsByClassName("vjs-mute-control vjs-control vjs-button");
            if (volBtns[0] !== null && typeof volBtns[0] != "undefined") {
                volBtns[0].style.display = "inline-block";
            }

        }
        var curr = new Date();
        console.log("End of doHistogram"+curr.getTime());
    }

    function handleResize(){

        var parentWidth = 0;
        if (parent.innerWidth) {
            parentWidth = parent.innerWidth;
        } else if (parent.document.documentElement && parent.document.documentElement.clientWidth) {
            parentWidth = parent.document.documentElement.clientWidth;
        } else if (parent.document.body) {
            parentWidth = parent.document.body.clientWidth;
        }

        var centerWidth = parentWidth + 20;
        //alert("centerWidth is:"+centerWidth);

        if (parentWidth < 860) {
            document.getElementById("mainDiv").style.width = centerWidth - 98 + 'px';
            document.getElementById("mainDiv").style.overflowY = 'scroll';
            document.getElementById("mainDiv").style.height=Math.max(document.documentElement.clientHeight, window.innerHeight || 0) + 'px';
            document.getElementById("origDiv").style.width = '100%';
            document.getElementById("container1").style.width = '100%';
            document.getElementById("filteredDiv").style.width = '100%';
            document.getElementById("container2").style.width = '100%';
            document.getElementById("controls2").style.width = '100%';
        }else{
            document.getElementById("mainDiv").style.width = '100%';
            //document.getElementById("origDiv").style.width = '100%';
            document.getElementById("mainDiv").style.height=null;
            document.getElementById("mainDiv").style.overflowY = 'auto';
            document.getElementById("container1").style.width = '45%';
            document.getElementById("filteredDiv").style.width = '45%';
            document.getElementById("container2").style.width = '45%';
            document.getElementById("controls2").style.width = '45%';
            document.getElementById("mainDiv").style.width = parentWidth + 'px';
        }
    }


    function doHistogram2() {

        /* The sound waveform is a string of amplitudes.  The problem with this is that it includes zero-crossing so */
        /* do I need to break it into time segments first and measure the amplitude of those?                        */
        /* Or does the activity involve dragging a sample area along?                                                */

        /* The sound waveform is a string of amplitudes.  The problem with this is that it includes zero-crossing so */
        /* do I need to break it into time segments first and measure the amplitude of those?                        */
        /* Or does the activity involve dragging a sample area along?                                                */

        var data = filteredArray;

        var sampleLength = data.length;
        //var modulus = length % 4;
        //If sampling rate is  22050 then this should give approx. 10mS samples.
        var sampleLength = data.length;
        //var modulus = length % 4;
        //If sampling rate is  22050 then this should give approx. 10mS samples.
        var subSampleLength = 30;
        var subSamples = [];
        var pointer=0;
        //Averaging filter
        /*
        while((pointer+subSampleLength) < sampleLength){
            var endPoint = (pointer+subSampleLength);
            var squareSumSignal = 0;
            for(var i=pointer; i<endPoint; i++){
                squareSumSignal += Math.pow(data[i], 2);
            }
            subSamples.push(Math.sqrt((1 / subSampleLength) * squareSumSignal));
            pointer = pointer+subSampleLength;  //Move on to the next sample
        }
        */

        //Now calculate the histogram of the subsamples
        //resolution = getClassWidth(subSamples.length, 0, subSamples);
        var resolution = 0.01;
        //var resolution = 0.005;
        //if(resolution == 0){
        //    resolution = 1;
        //}
        //histSampleArray = histogram(subSamples, resolution/250, false);
        //histSampleArray2 = histogram(subSamples, resolution, false);
        histSampleArray2 = histogram(data, resolution, false);
        var logarithmicX = document.getElementById("logarithmic").checked;
        logarithmicX = false;
        /*
        for (var i = 0; i < histSampleArray.length; i++) {
            if (histSampleArray[i][0] < 0.00000001) {
                //Prevent Highcharts error
                histSampleArray.splice(i, 1);
            }
        }
        */
        var lcSliderPosition = document.getElementById("lcSlider").value;

        //Test code start
        //histSampleArray2[0][1] = 0;
        //Test code end

        drawHistogram('container2', histSampleArray2, resolution, 1, 14, colourScheme.axisColor,
            colourScheme.barColor,
            colourScheme.backGroundColor,colourScheme.pmfColor, false, colourScheme.axisColor, true, '500', '300',
            bottomHistoTitle, logarithmicX, lcSliderPosition, null, 1.5, "probability",colourScheme.shadeColor,
            "voltage (V)");
    }

    function drawSplineGraph(container,data,title){
        var graphArray = [];
        var multiplier =  (1 / data.length) *  (data.length /  8000); //sampling frequency
        for(var i=0; i<data.length; i++){
            graphArray.push([i*multiplier,data[i]]);
        }

        doSpline(container, graphArray, 1, 14,
            colourScheme.gridLineColor,
            colourScheme.shadeColor,
            colourScheme.backGroundColor,
            colourScheme.axisColor, false, 0, 0, colourScheme.splineColour, 0, 0,
            true, 1, 0.05, true, false, null, null,
            true,
            title, -2, 3, parseFloat((data.length /  sampleRate).toFixed(2)), null);
    }


    function updateDetections(){
        var threshold = parseFloat(document.getElementById("lcSlider").value);
        var detections = 0;
        var falsePos = 0;
        var missedDetect = 0;
        var trueNeg = 0;

        if(document.getElementById("noiseSlider").value > 0) {
            for (var i = 0; i < signalData.length; i++) {
                if ((signalNoisyData[i] >= threshold) && (signalData[i] >= 0.5)) {
                    detections++;
                } else if ((signalNoisyData[i] < threshold) && (signalData[i] < 0.5)) {
                    trueNeg++;
                } else if ((signalNoisyData[i] >= threshold) && (signalData[i] < 0.5)) {
                    falsePos++;
                } else if ((signalNoisyData[i] < threshold) && (signalData[i] >= 0.5)) {
                    missedDetect++;
                }
            }
            detections = detections / signalData.length * 100;
            falsePos = falsePos / signalData.length * 100;
            missedDetect = missedDetect / signalData.length * 100;
            trueNeg = trueNeg / signalData.length * 100;
        }else {
            for (var i = 0; i < signalData.length; i++) {
                if (signalData[i] == 1) {
                    detections++;
                } else if (signalData[i] == 0) {
                    trueNeg++;
                }
            }
            detections = detections / signalData.length * 100;
            falsePos = 0;
            missedDetect = 0;
            trueNeg = trueNeg / signalData.length * 100;
        }
        document.getElementById("detections").value = detections;
        document.getElementById("falsePos").value = falsePos;
        document.getElementById("missedDetect").value = missedDetect;
        document.getElementById("trueNeg").value = trueNeg;

        //Now update lower half detections if filteredarray populated
        if(filteredArray.length > 0){
            detections = 0;
            falsePos = 0;
            missedDetect = 0;
            trueNeg = 0;
            var lengthDiffOffset = Math.round((signalData.length - filteredArray.length) / 2);
            for (var i = 0; i < filteredArray.length; i++) {
                if ((filteredArray[i] >= threshold) && (signalData[i+lengthDiffOffset] >= 0.5)) {
                    detections++;
                } else if ((filteredArray[i] < threshold) && (signalData[i+lengthDiffOffset] < 0.5)) {
                    trueNeg++;
                } else if ((filteredArray[i] >= threshold) && (signalData[i+lengthDiffOffset] < 0.5)) {
                    falsePos++;
                } else if ((filteredArray[i] < threshold) && (signalData[i+lengthDiffOffset] >= 0.5)) {
                    missedDetect++;
                }
            }
            detections = detections / filteredArray.length * 100;
            falsePos = falsePos / filteredArray.length * 100;
            missedDetect = missedDetect / filteredArray.length * 100;
            trueNeg = trueNeg / filteredArray.length * 100;
        }else{
            if(signalNoisyData !== null) {
                for (var i = 0; i < signalData.length; i++) {
                    if ((signalNoisyData[i] >= threshold) && (signalData[i] >= 0.5)) {
                        detections++;
                    } else if ((signalNoisyData[i] < threshold) && (signalData[i] < 0.5)) {
                        trueNeg++;
                    } else if ((signalNoisyData[i] >= threshold) && (signalData[i] < 0.5)) {
                        falsePos++;
                    } else if ((signalNoisyData[i] < threshold) && (signalData[i] >= 0.5)) {
                        missedDetect++;
                    }
                }
                detections = detections / signalData.length * 100;
                falsePos = falsePos / signalData.length * 100;
                missedDetect = missedDetect / signalData.length * 100;
                trueNeg = trueNeg / signalData.length * 100;
            }else {
                detections = 0;
                falsePos = 0;
                missedDetect = 0;
                trueNeg = 0;
            }
        }

        document.getElementById("detections2").value = detections;
        document.getElementById("falsePos2").value = falsePos;
        document.getElementById("missedDetect2").value = missedDetect;
        document.getElementById("trueNeg2").value = trueNeg;
    }

    /*
    document.getElementById("logarithmic").addEventListener('click', function() {
        var logarithmicY = document.getElementById("logarithmic").checked;
        logarithmicX = false;
        var lcSliderPosition = document.getElementById("lcSlider").value;
        filterAmplitude = drawHistogram('container1', histSampleArray, resolution, 1, 12, '#000000', '#ff0000', '#ffffff',
            '#000000', false, '#000000', true, '500', '300', topHistoTitle, null, lcSliderPosition, "Probability");

    });
    */

    document.getElementById("lcSlider").oninput = function () {
        //var selection = $( "#slider" ).slider( "values" ) * 10;

        var selection = document.getElementById("lcSlider").value;
        //hpFilterPosition = (Number(selection) / 4096) * xAxisGraph;

        if(!hpMoving){
            hpMoving = true;
            setTimeout( function(){
                //findMaxAndMinFromRange(fft1Data);
                hpMoving = false;

                var logarithmicX = document.getElementById("logarithmic").checked;
                logarithmicX = false;
                filterAmplitude = drawHistogram('container1', histSampleArray, resolution, 1, 14, colourScheme.axisColor,
                    colourScheme.barColor, colourScheme.backGroundColor, colourScheme.pmfColor, false, colourScheme.axisColor,
                    true, '500', '300', topHistoTitle, logarithmicX, selection, null, 1.5, "probability",
                    colourScheme.shadeColor, "voltage (V)");

            }, 100);

        }

    };

    function regenerateAllGraphs(){

        var lcSliderPosition = document.getElementById("lcSlider").value;
        var logarithmicX = false;

        var data = signalData;
        if(document.getElementById("noiseSlider").value > 0){
            data = signalNoisyData;
        }

        var graphArray = [];
        var multiplier =  (1 / data.length) *  (data.length /  8000); //sampling frequency
        for(var i=0; i<data.length; i++){
            graphArray.push([i*multiplier,data[i]]);
        }

        doSpline('container3', graphArray, 1, 13,
            colourScheme.gridLineColor,
            colourScheme.shadeColor,
            colourScheme.backGroundColor,
            colourScheme.axisColor, false, 0, 0, colourScheme.splineColour, 0, 0,
            true, 1, 0.05, true, false, null, null,
            true,
            'Unfiltered data signal', -2, 3, (signalNoisyData.length /  sampleRate), null);

        filterAmplitude = drawHistogram('container1', histSampleArray, resolution, 1, 14, colourScheme.axisColor,
            colourScheme.barColor, colourScheme.backGroundColor, colourScheme.pmfColor, false, colourScheme.axisColor,
            true, '500', '300', topHistoTitle, logarithmicX, lcSliderPosition, null, 1.5, "probability",
            colourScheme.shadeColor, "voltage (V)");

        graphArray = [];
        multiplier =  (1 / data.length) *  (data.length /  8000); //sampling frequency
        for(var i=0; i<data.length; i++){
            graphArray.push([i*multiplier,data[i]]);
        }

        doSpline('container4', graphArray, 1, 13,
            colourScheme.gridLineColor,
            colourScheme.shadeColor,
            colourScheme.backGroundColor,
            colourScheme.axisColor, false, 0, 0, colourScheme.splineColour, 0, 0,
            true, 1, 0.05, true, false, null, null,
            true,
            'Filtered data signal', -2, 3, (filteredArray.length /  sampleRate), null);

        drawHistogram('container2', histSampleArray2, resolution, 1, 14, colourScheme.axisColor,
            colourScheme.barColor,colourScheme.backGroundColor,colourScheme.pmfColor, false, colourScheme.axisColor,
            true, '500', '300', bottomHistoTitle, logarithmicX, lcSliderPosition,
            null, 1.5, "probability",colourScheme.shadeColor, "voltage (V)");

    }

    function doEmptyHisto(containerID) {

        //Empty graphs
        if(containerID=="container1") {
            drawHistogram('container1', [], 0, 1, 14, colourScheme.axisColor,
                colourScheme.barColor, colourScheme.backGroundColor, colourScheme.pmfColor, false, colourScheme.axisColor,
                true, '500', '300', topHistoTitle, false, 0, null, 1.5, "probability",colourScheme.shadeColor, "voltage (V)");
        }else if(containerID=="container2") {
            drawHistogram('container2', [], 0, 1, 14, colourScheme.axisColor,
                colourScheme.barColor, colourScheme.backGroundColor, colourScheme.pmfColor, false, colourScheme.axisColor,
                true, '500', '300', topHistoTitle, false, 0, null, 1.5, "probability",colourScheme.shadeColor, "voltage (V)");
        }

    }

    function applySettings(){

        if(document.getElementById("noiseSlider").value > 0) {
            signalNoisyData = signalData;
        }

        //if(document.getElementById("noiseSlider").value > 0) {
        document.getElementById("recorderTitle").textContent=recorderTitleNoisy;
        topHistoTitle = topHistoTitleNoisy;
        //Only regenerate noise if it has changed amplitude - otherwise too resource-hungry
        //if(document.getElementById("noiseSlider").value !==  noiseLevel) {
        addNoise();
        //}
        noiseLevel = document.getElementById("noiseSlider").value;
        drawSplineGraph('container3',signalNoisyData,'Unfiltered data signal');
        doHistogram("container1",signalNoisyData);

        var source=decodedData;

        if(document.getElementById("noiseSlider").value > 0) {
            source=decodedNoisyData;
        }

        applyFilter(source);
        updateDetections();
    }

    var applyButtons = document.getElementsByClassName("applyBtn");
    for(var i=0; i<applyButtons.length; i++){
        applyButtons[i].addEventListener("click", function(){
            applySettings();
        });
    }

    function findMaxAndMinFromRange(graphData) {
        if(graphData.length > 0) {
            graphMax = 0;
            graphMin = Infinity;
            for (var i = 0; i < graphData.length; i++) {
                if (graphData[i] > graphMax) {
                    graphMax = graphData[i];
                }
                if (graphData[i] < graphMin) {
                    graphMin = graphData[i];
                }
            }
        }
    }

    function toggleControls(e){

        e.preventDefault();     //Stop it from scrolling back to top.
        var controls = document.getElementById("accessControlDiv");
        if(controls.style.display === 'block'){
            controls.style.display = 'none';
        }else{
            controls.style.display = 'block';
            var actDiv = document.getElementById("mainDiv");
            actDiv.scrollTop = actDiv.scrollHeight;
            window.scrollTo(0,document.body.scrollHeight);
            document.getElementById("colorSchemeSelect").focus();
        }
    }
    document.getElementById("openAccessControls").addEventListener('click', toggleControls);

    function changeColour(colourScheme){

        var mainDiv = document.getElementById("mainDiv");
        mainDiv.style.color=colourScheme.axisColor;
        mainDiv.style.backgroundColor=colourScheme.backGroundColor;

        var inputCollection = document.getElementsByTagName("INPUT");
        for(i = 0;i < inputCollection.length; i++)
        {
            var currInput = inputCollection[i];
            currInput.style.backgroundColor = colourScheme.backGroundColor;
            currInput.style.color = colourScheme.axisColor;
        }
        var currInput = document.getElementById("colorSchemeSelect");
        currInput.style.backgroundColor = colourScheme.backGroundColor;
        currInput.style.color = colourScheme.axisColor;
    }

    document.getElementById("colorSchemeSelect").addEventListener('change', function (event) {
        var dropDown = event.target;
        var colourSchemeName = dropDown.options[dropDown.selectedIndex].value;
        colourScheme=getColorScheme(colourSchemeName);
        changeColour(colourScheme);
        regenerateAllGraphs();
        applySettings();
        var values={
            'colorSchemeKey' : colourSchemeName
        };
        submitToVLE(values);
    });

    var submitToVLE = function(values) {
        // use these to reference students saved data
        var course_id = VLE.get_param('course_id') || VLE.get_param('_c');
        var document_id = VLE.get_param('document_id') || VLE.get_param('_i');
        var activity_id = VLE.get_param('activity_id') || VLE.get_param('_a');

        // an empty variable not using anything here
        var previous_values;

        // call the vle api to save the students text entity
        VLE.set_server_data(true, values, function() {
            // success code goes here
        }, function(msg) {
            if (!msg === null) {
                // failure code goes here
                //alert("Failed to save values to VLE: "+msg);
            }else{
                //alert("Saved values to VLE: "+msg);
            }
        }, previous_values, null , activity_id, document_id, course_id);
    };

};

;

function  histogram(data, step, logarithmicBins) {
        //Note - this returns the PROPORTION of weights in each range by dividing by the number in the sample.
        //NOT the NUMBER of weights in each range, this is to match the behaviour of SUStats.
        var histo = {},
            x,
            i,
            arr = [];

        // Group down
        for (i = 0; i < data.length; i++) {

            x = Math.floor(data[i] / step) * step;

            if (!histo[x]) {
                histo[x] = 0;
            }
            histo[x]++;
        }

        // Make the histo group into an array
        for (x in histo) {
            if (histo.hasOwnProperty((x))) {
                arr.push([parseFloat(x), histo[x]/data.length]);
            }
        }

        // Finally, sort the array
        arr.sort(function (a, b) {
            return a[0] - b[0];
        });

        return arr;
    }

function  getPMF(range,sampleSize,resolution){

        var mean = 74.58;
        var sd = 17.96;
        var alpha = (mean/sd)*(mean/sd)-0.9;
        var beta = sd*sd/mean;
        var scale = 1/beta;

        var pmfArray = [];
        var y = 0;
        for (var i = 0; i < range; i++) {


            var x = Math.floor(i / resolution) * resolution;
            //Y is the total of all entries in this range.

            if(i==x) {
                y = 0;
                for (var j = i; j < i + resolution; j++) {
                    var pdf = jStat.gamma.pdf(x, alpha, beta);
                    y = y + pdf;
                }
                //pmfArray.push({x,y});
            }

        }

        return pmfArray;

    }

function  gammaRandom(sampleSize, resolution){

        var mean = 74.58;
        var sd = 17.96;
        var alpha = (mean/sd)*(mean/sd)-0.9;
        var beta = sd*sd/mean;
        //var scale = 1/beta;

        var data = [];

        for (var i = 0; i < sampleSize; i++) {
            var histValue = jStat.gamma.sample( alpha, beta );
            data.push(histValue);
        }

        return data;

    }

function  random(){
    return jStat.uniform.sample( 1, 6 );
}

function   getClassWidth(sampleSize, range, sample){

    //var numIntervals = Math.round(Math.sqrt(sampleSize));
    //return Math.round(range / numIntervals);
    //return Math.round(Math.pow(sampleSize,0.333333)/0.6);
    var sigma=jStat.stdev(sample);
    var retValue = 2.468*sigma*(Math.pow(sampleSize,-1/3));
    //alert("sigma is "+sigma+" retvalue is "+retValue);
    return retValue;
}

//The following are from gaussian.js

var erfc = function(x) {
    var z = Math.abs(x);
    var t = 1 / (1 + z / 2);
    var r = t * Math.exp(-z * z - 1.26551223 + t * (1.00002368 +
            t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 +
            t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 +
            t * (-0.82215223 + t * 0.17087277)))))))))
    return x >= 0 ? r : 2 - r;
};

// Inverse complementary error function
// From Numerical Recipes 3e p265
var ierfc = function(x) {
    if (x >= 2) { return -100; }
    if (x <= 0) { return 100; }

    var xx = (x < 1) ? x : 2 - x;
    var t = Math.sqrt(-2 * Math.log(xx / 2));

    var r = -0.70711 * ((2.30753 + t * 0.27061) /
        (1 + t * (0.99229 + t * 0.04481)) - t);

    for (var j = 0; j < 2; j++) {
        var err = erfc(r) - xx;
        r += err / (1.12837916709551257 * Math.exp(-(r * r)) - r * err);
    }

    return (x < 1) ? r : -r;
};

// Models the normal distribution
var Gaussian = function(mean, variance) {
    if (variance <= 0) {
        throw new Error('Variance must be > 0 (but was ' + variance + ')');
    }
    this.mean = mean;
    this.variance = variance;
    this.standardDeviation = Math.sqrt(variance);
}

// Probability density function
Gaussian.prototype.pdf = function(x) {
    var m = this.standardDeviation * Math.sqrt(2 * Math.PI);
    var e = Math.exp(-Math.pow(x - this.mean, 2) / (2 * this.variance));
    return e / m;
};

// Cumulative density function
Gaussian.prototype.cdf = function(x) {
    return 0.5 * erfc(-(x - this.mean) / (this.standardDeviation * Math.sqrt(2)));
};

// Percent point function
Gaussian.prototype.ppf = function(x) {
    return this.mean - this.standardDeviation * Math.sqrt(2) * ierfc(2 * x);
};

// Product distribution of this and d (scale for constant)
Gaussian.prototype.mul = function(d) {
    if (typeof(d) === "number") {
        return this.scale(d);
    }
    var precision = 1 / this.variance;
    var dprecision = 1 / d.variance;
    return fromPrecisionMean(
        precision + dprecision,
        precision * this.mean + dprecision * d.mean);
};

// Quotient distribution of this and d (scale for constant)
Gaussian.prototype.div = function(d) {
    if (typeof(d) === "number") {
        return this.scale(1 / d);
    }
    var precision = 1 / this.variance;
    var dprecision = 1 / d.variance;
    return fromPrecisionMean(
        precision - dprecision,
        precision * this.mean - dprecision * d.mean);
};

// Addition of this and d
Gaussian.prototype.add = function(d) {
    return gaussian(this.mean + d.mean, this.variance + d.variance);
};

// Subtraction of this and d
Gaussian.prototype.sub = function(d) {
    return gaussian(this.mean - d.mean, this.variance + d.variance);
};

// Scale this by constant c
Gaussian.prototype.scale = function(c) {
    return gaussian(this.mean * c, this.variance * c * c);
};

var gaussian = function(mean, variance) {
    return new Gaussian(mean, variance);
};

var fromPrecisionMean = function(precision, precisionmean) {
    return gaussian(precisionmean / precision, 1 / precision);
};;//Arguments - frequency (Hz) and duration (seconds)
function mixNoise(waveArrayIn,amp,snRatio) {
    var retArray = [];
    var noiseScale = amp * (1/snRatio);
    var squareSumNoise = 0;
    var squareSumSignal = 0;
    var uni = false;

    for (var i = 0; i < waveArrayIn.length; i++) {
        if(uni){
            var noiseVolts = (Math.random() * noiseScale - (noiseScale / 2));
        }else{
            //var standard = gaussian(0, noiseScale);
            //var noiseVolts = standard();
            //var noiseVolts = gaussian(0, noiseScale);
            //noiseScale = noiseScale = amp * (1/(snRatio - 0.38)) * 0.19;
            noiseScale = amp * (1/snRatio);
            var distribution = gaussian(0, noiseScale);
            var noiseVolts = distribution.ppf(Math.random());
            //noiseVolts = noiseVolts / 3.5;
            //noiseVolts = noiseVolts / 2.25;
        }
        retArray[i] = waveArrayIn[i] + noiseVolts;
        squareSumNoise += Math.pow(noiseVolts, 2);
        squareSumSignal += Math.pow(waveArrayIn[i], 2);
    }
    //Now calculate rms of noise
    var rmsNoise = Math.sqrt((1 / waveArrayIn.length) * squareSumNoise);
    //document.getElementById("rmsDisplay").value = rmsNoise.toFixed(3);


    //Calculate rms of signal
    //var rmsSignal = Math.sqrt((1 / waveArrayIn.length) * squareSumSignal);
    var rmsSignal = 1 / Math.sqrt(2);

    //document.getElementById("snDisplay").value=(rmsSignal / rmsNoise).toFixed(3);
    //document.getElementById("dbDisplay").value=(10*(Math.log(Math.pow(rmsSignal,2) / Math.pow(rmsNoise,2)) * Math.LOG10E)).toFixed(3);

    return retArray;
}


function generateNoise(duration, amp) {
    var retArray = [];
    var noiseScale = amp;
    var squareSumNoise = 0;
    var squareSumSignal = 0;
    for (var i = 0; i < duration; i++) {
        if(noiseScale> 0) {
            var distribution = gaussian(0, noiseScale);
            retArray[i] = distribution.ppf(Math.random());
        }else{
            retArray[i] = 0;
        }
    }
    return retArray;
};/**
 * Created by gcm77 on 16/02/2017.
 */


function doSpline(container, data1, gridLineWidth, fontSize, gridLineColor, shadeColor, backGroundColor,
         axisColor, animation, shadeStart, shadeEnd, splineColor, xPointerPosition, sliderPosition,
         formulaToRight, verticalAxisLabelStep, verticalAxisMax, horizontalAxisLabelsOn, logarithmicY,
         hpFilterPosition, lpFilterPosition,  animation, title, yMin, yMax, xMax, filterMode){

    var yType = null;
    if(logarithmicY){
        yType = 'logarithmic';
    }

    var chart = Highcharts.chart(container, {

        chart:{
            backgroundColor: backGroundColor
        },
        title: {
            text: title,
            style: {
                color: axisColor
            }
        },

        legend: {
            enabled: false
        },

        xAxis: {
            max: xMax,
            lineColor: axisColor,
            title: {
                text: 'time (s)',
                style:{
                    fontSize: fontSize.toFixed(0) +"px",
                    color: axisColor,
                    fontFamily: "Arial, Verdana, sans-serif"
                },
            },
            labels: {
                style:{
                    fontSize: fontSize.toFixed(0) +"px",
                    color: axisColor,
                    fontFamily: "Arial, Verdana, sans-serif"
                },
            },
        },

        yAxis: {
            title: {
                style:{
                    fontSize: fontSize.toFixed(0) +"px",
                    color: axisColor,
                    fontFamily: "Arial, Verdana, sans-serif"
                },
                text: 'voltage (V)',
                style:{
                    fontSize: fontSize.toFixed(0) +"px",
                    color: axisColor,
                    fontFamily: "Arial, Verdana, sans-serif"
                },
            },
            max: yMax,
            min: yMin,
            lineColor: axisColor,
            gridLineColor: shadeColor,
            tickColor: gridLineColor,
            labels: {
                style:{
                    fontSize: fontSize.toFixed(0) +"px",
                    color: axisColor,
                    fontFamily: "Arial, Verdana, sans-serif"
                },
            }
        },

        plotOptions: {
            series: {
                color:splineColor
            }
        },

        series: [{
            name: null,
            data: data1,
            type: 'spline',
            animation: false
        }]
    });



    //doShading(filterMode, hpFilterPosition, lpFilterPosition, chart);

    var hamburger = document.getElementById(container).getElementsByClassName("highcharts-button")[0];
    hamburger.style.zIndex = "-1";
    hamburger.style.visibility = "hidden";
}


function getBrowserVersion(){

    var navigatorObj = navigator.appName,
        userAgentObj = navigator.userAgent,
        matchVersion;
    if(userAgentObj.indexOf("iPad") > -1 ||  userAgentObj.indexOf("Safari") > -1){
        return "mac or ipad";
    }
    //Something else breaks if it is one of the above platforms so return immediately.
    var match = userAgentObj.match(/(opera|chrome|safari|firefox|msie|trident)\/?\s*(\.?\d+(\.\d+)*)/i);
    if( match && (matchVersion = userAgentObj.match(/version\/([\.\d]+)/i)) !== null) match[2] = matchVersion[1];
    //mobile
    if (navigator.userAgent.match(/iPhone|Android|webOS|iPad/i)) {
        return match ? [match[1], match[2], mobile] : [navigatorObj, navigator.appVersion, mobile];
    }
    // web browser
    return match ? [match[1], match[2]] : [navigatorObj, navigator.appVersion, '-?'];

}



;//Arguments - frequency (Hz) and duration (seconds)
generateSignal=function(freq,duration) {
    var data=[];
    var counter = 0 ;
    var increase = freq / 2600;
// 100 iterations
    //var increase = Math.PI * 2 / (freq / 2000);


    for ( i = 0; i <= duration; i++) {
        data.push((Math.sin(counter) / 2 ) / 10 );
        counter += increase;
    }
    return data;
}

},{}]},{},[1])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
