/*jslint browser: true, devel: true */

// get the applet
var ggbApplet = document.ggbApplet;

function resetValues() {
	ggbApplet.setValue("ax", reset_ax);
	changeSlider('ax', reset_ax);
	sliderUpdate('ax');
	ggbApplet.setValue("bx", reset_bx);
	changeSlider('bx', reset_bx);
	sliderUpdate('bx');
}

// move mu slider to the left
function muLeft() {
	ggbApplet.evalCommand("ax = ax - 0.001");
}

// move mu slider to the right
function muRight() {
	ggbApplet.evalCommand("ax = ax + 0.001");
}

// move sigma slider to the left
function sigmaLeft() {
	ggbApplet.evalCommand("bx = bx - 0.001");
}

// move sigma slider to the right
function sigmaRight() {
	ggbApplet.evalCommand("bx = bx + 0.001");
}

function setEvents() {
	document.getElementById("axLeftButton").onclick = muLeft;
	document.getElementById("axRightButton").onclick = muRight;
	document.getElementById("bxLeftButton").onclick = sigmaLeft;
	document.getElementById("bxRightButton").onclick = sigmaRight;
	document.getElementById("resetButton").onclick = resetValues;
    document.getElementById('ax').oninput = function() { changeSlider('ax', this.value); };
    document.getElementById('ax').onchange = function() { changeSlider('ax', this.value); };
    document.getElementById('bx').oninput = function() { changeSlider('bx', this.value); };
    document.getElementById('bx').onchange = function() { changeSlider('bx', this.value); };
}

// first thing applet does
function ggbOnInit() {
  document.getElementsByTagName("canvas")[0].tabIndex = -1;
  ggbConfigureMale();
	setEvents();
	registerListeners();
  //accessInit();
}