(function ($, window, document, undefined) {

    'use strict';
    var $dragging = null;
    $(function () {


        $('.showRuler').click(
                function () {
                    if ($(this).text() === 'show ruler') {
                        $('.ruler').show();
                        $(this).text('show solution');
                    } else if ($(this).text() === 'show solution') {
                        $('.solution').css('visibility', 'visible');
                        $(this).text('start again');
                    } else {
                        $('.ruler').hide();
                        $('.solution').css('visibility', 'hidden');
                        $('.ruler').css('bottom', '7px').css('left', '5px').css('top', 238);
                        $(this).text('show ruler');
                    }
                });

        $(document.body).on('mousemove', function (e) {
            if ($dragging) {
                var elW = $('div.ruler').outerWidth(),
                        elH = $('div.ruler').outerHeight();
                $dragging.offset({
                    top: e.pageY - elH + 10,
                    left: e.pageX - elW + 120
                });
            }
        });


        $(document.body).on('mousedown', 'div.ruler', function (e) {
            $dragging = $(e.target);
        });

        $(document.body).on('mouseup', function () {
            $dragging = null;
        });

    });
})(jQuery, window, document);
