// import {config, itemData} from data;
require('classlist-polyfill');
require('babel-polyfill');
var noUiSlider = require('noUiSlider');
var stretchy = require('../modules/stretchy/stretchy.js');
var activity = require('../modules/activity.js');
var tingle = require('tingle.js');
var bsn = require("bootstrap.native");
import TmUtils from '../modules/tmUtils.js';
import ItemCommon from '../modules/itemCommon.js';

import $ from "jquery";
require('jquery-ui');

// iframe hack to get around the 880px limit and width="*" not working yet!
let iframe = window.frameElement;
if (iframe !== null) {
    iframe.width = '1000px';
}

var container;
var data;
var dataFile = 'https://students-acct.open.ac.uk/science/s112/timemachine_media/week01-scale-01/data.js';

// let showScales = document.getElementById('show-scales').checked;
let showScales = true;

/**
 * @function dataLoad
 * @description Attaches a script element to the head of index.xhtml
 * @param dataFile String URL for the js data file to add.
 * @param callback The function to call once the elements have been added to the head of the document.
 */
var dataLoad = function(dataFile, callback){
    var headElem = document.getElementsByTagName('head')[0];
    var srcAddition = document.createElement('script');
    srcAddition.src = dataFile;
    headElem.appendChild(srcAddition);
    srcAddition.onreadystatechange = callback;
    srcAddition.onload = callback;
};

var init = function () {
    // Sort the data by size, add tabindex values to aid keyboard accessibility, then re-sort by id
    // to jumble the activity items.
    itemData.sort(function(a, b) {
        return parseFloat(b.yStart) - parseFloat(a.yStart);
    });
    for (let i = 0; i < itemData.length; i++) {
        itemData[i].tabIndex = i * 10 + 100;
    }
    itemData.sort(function(a, b) {
        return parseInt(a.id) - parseInt(b.id);
    });

    var xSlider = document.getElementById('x-slider');
    noUiSlider.create(xSlider, {
        start: 8,
        connect: [false, true],
        range: {
            min: 0,
            max: 100
        },
        orientation: 'horizontal',
        direction: 'rtl',
    });
    
    var ySlider = document.getElementById('y-slider');
    noUiSlider.create(ySlider, {
        start: 60,
        range: {
            min: 0,
            max: 100
        },
        orientation: 'vertical',
        direction: 'ltr',
    });

    container = document.getElementById('time-size-container');
    var stretchyOptions = {
        canvasWidth: 4000,
        canvasHeight: 2500,
        range: {
            x: {
                min: 3E-10,
                max: 3E21
            },
            y: {
                min: 2E-19,
                max: 4E27
            },
        },
        controls: {
            xMax: 100,
            yMax: 100
        },
        scales: {
            show: showScales,
            widthX: 70,
            widthY: 48
        }
    };

    stretchy.init(container, stretchyOptions);

    // Set initial slider values.
    stretchy.setSizeX(xSlider.noUiSlider.get());
    stretchy.setSizeY(100);
    stretchy.setPanY(ySlider.noUiSlider.get());
    // stretchy.setPanX(xSlider.noUiSlider.get());

    xSlider.noUiSlider.on('slide', function(){
        // Stretch.
        stretchy.setSizeX(this.get());
        // Pan.
        // stretchy.setPanX(this.get());
    });

    ySlider.noUiSlider.on('slide', function(){
        stretchy.setPanY(this.get());
    });

    // Commented out the slider handle keyboard handlers do to implementing
    // WASD control of the sliders separately.

    // X slider
    let xHandle = xSlider.querySelector('.noUi-handle');
    xHandle.setAttribute('tabindex', -1);
    xHandle.addEventListener('click', function(){
        this.focus();
    });

    // Y slider
    let yHandle = ySlider.querySelector('.noUi-handle');
    yHandle.setAttribute('tabindex', -1);
    yHandle.addEventListener('click', function(){
        this.focus();
    });

    // Cursor key control of sliders (wasd keys) without initial slider handle focus.
    document.body.addEventListener('keydown', function(e) {
        let value;
        switch (e.key.toLowerCase()) {
            case 'a':   // Left
                value = Number(xSlider.noUiSlider.get());
                xSlider.noUiSlider.set(value + 3);
                stretchy.setSizeX(xSlider.noUiSlider.get());
                break;
            case 'd':  // Right
                value = Number(xSlider.noUiSlider.get());
                xSlider.noUiSlider.set(value - 3);
                stretchy.setSizeX(xSlider.noUiSlider.get());
                break;
            case 's':   // Down
                value = Number(ySlider.noUiSlider.get());
                ySlider.noUiSlider.set(value + 5);
                stretchy.setPanY(ySlider.noUiSlider.get());
                break;
            case 'w':     // Up
                value = Number(ySlider.noUiSlider.get());
                ySlider.noUiSlider.set(value - 5);
                stretchy.setPanY(ySlider.noUiSlider.get());
                break;
        }
    });

    // TODO: Left here as part of an incomplete show/hide scales option.
    // document.getElementById('show-scales').addEventListener('click', function (e) {
    //     showScales = e.target.checked;
    //     stretchy.showScales(showScales);
    // });

    activity.init(stretchy);

    // Menu event listeners.
    document.getElementById('activity-reset').addEventListener('click', (e) => {
        activity.clearMatched();
        // areYouSure.open();
    });

    document.getElementById('progress-reset').addEventListener('click', (e) => {
        for (const item of itemData) {
            if (item.hasOwnProperty('completed') && item.completed === true) {
                ItemCommon.toggleCheckbox(document.getElementById(`checkbox-${item.id}`));
            }
        }

        TmUtils.vleSave();
        // areYouSure.open();
    });

    document.getElementById('help-button').addEventListener('click', (e) => {
        showHelp();
    });

    document.getElementById('help').addEventListener('click', (e) => {
        showHelp();
    });

    function showHelp() {
        let helpModal = document.getElementById('tm-modal-help');
        let helpModalInstance = new bsn.Modal(helpModal, {});
        helpModalInstance.show();
        const modalBody = document.querySelector('div#tm-modal-help div.modal-body');
        modalBody.setAttribute('tabindex', '0');
    }

    document.getElementById('menu-toggle-activity-panel').addEventListener('click', (e) => {
        activity.toggleSidePanel(e);
    });

    // Set tabindex.

}

// Menu.
// let Dropdown = new bsn.Dropdown;
let menuDropdown = document.getElementById('tm-menu1');
let menuDropdownInit = new bsn.Dropdown(menuDropdown).toggle;

function saveOk() {
    console.log('saveOk callback');
}
function saveError() {
    console.log('saveError callback');
}
function getOk() {
    console.log('getOk callback');
}
function getError() {
    console.log('---- getError callback ----');
}

let vleOptions = {
    userOrGroups: true,
    localStorage: false,
    saveOk: saveOk,
    saveError: saveError,
    getOk: getOk,
    getError: getError
}

function okCallback(values) {
    if (values.data !== '') {
        let data = JSON.parse(values.data);

        for (let id of data.completed) {
            itemData[TmUtils.getIndexFromId(id)].completed = true;
        }

        for (let id of data.matched) {
            itemData[TmUtils.getIndexFromId(id)].matched = true;
        }
    }

    init();
}

function errorCallback(message) {
    if (message === null) {
        // Not connected the VLE.
        console.warn('Not connected to the VLE, cannot get data.');
    } else {
        console.log('Unable to get data from server.' + message);
    }

    // getError(message);
    init();
}

// TODO: Not currently using this feature.
// dataLoad(dataFile, init);

// Lets go, load data from the VLE, if possible, which in turn runs init().
TmUtils.vleLoad(okCallback, errorCallback);
