let bigInfo = require('./modal.js');
import ItemCommon from '../itemCommon.js'

export default class ItemDragDrop {
    constructor(canvas, canvasWidth, canvasHeight, xPos, yPos, itemData, range) {
        this.canvas = canvas;
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.xPos = xPos;
        this.yPos = yPos;
        this.itemData = itemData;
        this.range = range;
        this.itemDiv = {};

        this.init();
    }

    init() {
        this.itemDiv = document.createElement('div');
        this.itemDiv.setAttribute('class', 'item item-activity droppable');
        this.itemDiv.setAttribute('id', `item-${this.itemData.id}`)
        if (this.itemData.style.curColour !== undefined && this.itemData.style.curColour !== '') {
            // TODO: replace this with addClass code on classlist.
            this.itemDiv.setAttribute('class', `item-activity item-activity-${this.itemData.style.curColour}`);
            // this.itemDiv.classList.add(this.itemData.style.curColour);
        }

        // Make itemDiv tabable.
        ItemCommon.addTabable(this.itemData, this.itemDiv);

        this.itemDiv.addEventListener('click', (e) => {
            ItemCommon.increaseItemZindex(e.target);
        })
        
        this.canvas.appendChild(this.itemDiv);

        let label = document.createTextNode('?');
        let labelSpan = document.createElement('span');
        labelSpan.setAttribute('class', 'item-title-default');
        labelSpan.appendChild(label);
        this.itemDiv.appendChild(labelSpan);

        // Create the y-marker.
        let marker = document.createElement('img');
        marker.setAttribute('src', 'src/images/y-marker.png');
        marker.setAttribute('class', 'y-marker');
        this.itemDiv.appendChild(marker);

        marker.style.top = (this.itemDiv.offsetHeight / 2) - 3 + 'px';
    }

    update(xPos, yPos) {
        this.xPos = xPos;
        this.yPos = yPos;

        // Calculate the x axis start and end position.
        let logStart = Math.log10(this.itemData.xStart || this.range.x.min),
            logEnd = Math.log10(this.itemData.xEnd),
            logMin = Math.log10(this.range.x.min),
            logRange = Math.log10(this.range.x.max) - logMin;
        let xStart = (logStart-logMin) / logRange * this.xPos;
        let xEnd = (logEnd - logMin) / logRange * this.xPos;

        this.itemDiv.style.left = xStart + 'px';
        // -1 for the right border width;
        this.itemDiv.style.width = (xEnd - xStart) - 1 + 'px';

        // Calculate the y axis start and end position.
        logStart = Math.log10(this.itemData.yStart || this.range.y.min);
        // logEnd = Math.log10(this.itemData.yEnd);
        logMin = Math.log10(this.range.y.min);
        logRange = Math.log10(this.range.y.max) - logMin;
        let yStart = this.canvasHeight - (logStart - logMin) / logRange * this.yPos;
        // Adjust for the marker.
        yStart -= (this.itemDiv.offsetHeight / 2) + 1;
        this.itemDiv.style.top = yStart + 'px';

        ItemCommon.setTabable(this.itemDiv, this.itemData.tabable);
    }

    show() {
        this.itemDiv.style.display = 'block';
    }

    hide() {
        this.itemDiv.style.display = 'none';
    }

    /**
     * Deletes this instance's div from the DOM.
     * TODO: Currently there is no way to add it back from within this instance.
     * @memberof Item
     */
    delete() {
        this.itemDiv.parentNode.removeChild(this.itemDiv);
    }

    /**
     * Returns the div width of this item.
     * 
     * @returns {Number} Width the div.
     * 
     * @memberof Item
     */
    getWidth() {
        return this.itemDiv.offsetWidth;
    }
}