/*
 * questionData template created to prevent ie8 logging an undefined variable error
 */
var questionData = {
  "html": "<div id=\"input-div0\" class=\"input-div\">[__INPUT__] years</div><div id=\"shadow0\" class=\"shadow\"></div><div id=\"input-div1\" class=\"input-div\">[__INPUT__] days</div>  <div id=\"shadow1\" class=\"shadow\"></div>  <div id=\"input-div2\" class=\"input-div\">[__INPUT__] hours</div>  <div id=\"shadow2\" class=\"shadow\"></div><div id=\"input-div3\" class=\"input-div\">[__INPUT__] minutes</div><div id=\"shadow3\" class=\"shadow\"></div><div id=\"input-div4\" class=\"input-div\">[__INPUT__] seconds</div>",
  "correct": [800, 292200, 7012800, 420768000, 25246080000],
  "tolerances": [1, 1, 1, 1, 1],
  "toleranceTypes": ['absolute', 'absolute', 'absolute', 'absolute', 'absolute'],
  "checkSign": true,
  "maxTries": 3,
  "buttonCaption": "",
  "removeIncorrect": true,
  "signFeedback": "",
  "partialFeedback":"Some of your answers are incorrect.",
  "correctFeedback": "Your answers are correct.",
  "incorrectFeedback": "Your answers are not correct. Try again.",
  "multipleIncorrectFeedback": "Your answers are still not correct.",
  "invalidInputFeedback": "",
  "intermediateFeedback": " Incorrect answers have been removed.",
  "extraCorrectFeedback": "",
  "extraIncorrectFeedback": " The correct answers are now shown.",
  "extraFeedback": "<br/><br/>The oak is 25 246 080 000 seconds old if the oak is exactly 800 years old. You could do all of these calculations at once (in a single equation), but the way of laying out and working through a complex calculation, step by step, may be a useful method you could apply elsewhere or if you find working with units tricky. You should be able to see how some of the units cancel each other out in each row where they appear in both the numerator and denominator of fractions."
};

/**
 * @function numeric_input
 * @module numeric_input
 * @description Created for the media library. This script creates a numeric input question from an attached data file
 *     and optional images.
 */

var numeric_input = (function () {
  "use strict";
  var data = "", i, numTries = 0, inputs = [],imageObj = {}, protocol;
      
  // var images = VLE.get_param('im'),
  //     cssSrc = VLE.get_param('numeric_css'),
  //     scriptSrc = VLE.get_param('numeric_input_data');

  var images = false;

  /**
   * @function dataLoad
   * @description Attaches a link element and script element to the head of index.xhtml document.
   *     The href and src attributes are taken from the cssSrc and scriptSrc vars declared above.
   * @param callback The function to call once the elements have been added to the head of the document.
   */
  var dataLoad = function(callback){
    var headElem = document.getElementsByTagName('head')[0];
    if(cssSrc != null){
      var cssAddition = document.createElement('link');
      cssAddition.rel='stylesheet';
      cssAddition.type = 'text/css';
      cssAddition.href = cssSrc;
      headElem.appendChild(cssAddition);
    }
    var srcAddition = document.createElement('script');
    srcAddition.src = scriptSrc;
    headElem.appendChild(srcAddition);
    srcAddition.onreadystatechange = callback;
    srcAddition.onload = callback;
  };

  /** @function init
   *  @description Uses question data loaded from attachment.
   *      Checks if it is offline and adds an offline class for EPUB3.
   *      Uses VLE.get_param to create an object to manage images.
   *      Calls replaceStrings() to convert the question data into usable XHTML.
   */
  var init = function () {
    var i;
    data = window.questionData;
    protocol = location.protocol;
    var elpage = document.getElementById('page-content');
    if(protocol != "http:" && protocol != "https:"){
      if(elpage){
        elpage.className += 'offline';
      }
    }
    // if (images == "true") {
    //   imageObj.imageSrc1 = VLE.get_param('image_1');
    //   imageObj.imageAlt1 = VLE.get_param('image_1_alt');
    //   imageObj.imageSrc2 = VLE.get_param('image_2');
    //   imageObj.imageAlt2 = VLE.get_param('image_2_alt');
    //   imageObj.imageSrc3 = VLE.get_param('image_3');
    //   imageObj.imageAlt3 = VLE.get_param('image_3_alt');
    //   imageObj.imageSrc4 = VLE.get_param('image_4');
    //   imageObj.imageAlt4 = VLE.get_param('image_4_alt');
    // }
    // replaceStrings(data, updateDisplay);

    for (i = 0; i < 4; i++) {
      ( function (i) {
        document.querySelector('#input' + i).addEventListener('input', function (e) {
          document.querySelector('#shadow' + i).innerHTML = this.value;
        });
      }(i));
    }
    
  };

  /** @function replaceStrings
   *  @description Uses the string from data.html and replaces [__INPUT__] with an input HTML element.
   *  @param {Function} strCallback Function to be used once data has been formatted.
   *  @param {Object} data Question data from **.js attachment.
   */
  var replaceStrings = function(data, strCallback) {
    var optionNum = 0;
    inputs = data.html.split("[__INPUT__]");
    var optionString = inputs[0];
    inputs.splice(0, 1);
    for (i = 0; i < inputs.length; i++) {
      optionString += "<input type='text' id='input" + (optionNum++) + "' value=''/>" + inputs[i];
    }
    optionString.replace(/\[__(.*?)__\]/g, "");
    strCallback(optionString);
  };

  /** @function replaceImages
   *  @description Finds any [IMAGE_*] tag in a string and replaces it with an HTML img tag.
   *  @param string {String} Text that can contains [IMAGE_*] tag.
   *  @returns {String}
   */
  var replaceImages = function (string) {
    string = string.replace(/\[IMAGE_1\]/g, "<img src='" + imageObj.imageSrc1 + "' alt='" + imageObj.imageAlt1 + "'/>")
        .replace(/\[IMAGE_2\]/g, "<img src='" + imageObj.imageSrc2 + "' alt='" + imageObj.imageAlt2 + "'/>")
        .replace(/\[IMAGE_3\]/g, "<img src='" + imageObj.imageSrc3 + "' alt='" + imageObj.imageAlt3 + "'/>")
        .replace(/\[IMAGE_4\]/g, "<img src='" + imageObj.imageSrc4 + "' alt='" + imageObj.imageAlt4 + "'/>");
    return string;
  };

  /** @function updateDisplay
   *  @description Adds question string to div#question
   *  @param optionString {String} String that has been formatted in to HTML question.
   */
  var updateDisplay = function (optionString) {
    // document.getElementById("question").innerHTML = replaceImages(optionString);
    // document.getElementById("check").innerHTML = data.buttonCaption || "Check";
    // document.getElementById("page-content").style.display ="block";
  };

 /** @function checkAnswers
  * @description Gets the value of the numeric input boxes, replaces any unicode minus type signs
  *      Compares the inputted answers to the correct answers in the data file.
  *      Results are either 'correct', 'incorrect' or 'partially correct'.
  *      Checks how many times they have attempted the question.
  *      Feedback is retrieved from external data file and displayed.
  *      If no further attempts are allowed the input boxes and buttons are disabled.
  */
  var checkAnswers = function () {
    var inputBox, response, answer, tolerance, toleranceType, feedback = "", ok = true, partial = false, tf,
        wrongSign = false, invalidInput = false;

    for (i = 0; i < 5; i++) {
      answer = data.correct[i];
      tolerance = data.tolerances[i];
      toleranceType = data.toleranceTypes[i];
      try {
        inputBox = document.getElementById("input" + i);
        response = inputBox.value;
        // Replace all unicode characters for minus and hyphen in case student has copy and pasted their answer.
        response = response.replace(/\u2010|\u2011|\u2012|\u2013|\u2014|\u2015|\u2212|\u002D/g, "-");
        response = parseFloat(response);
      } catch (e) {
        return;
      }
      // Checks if the input value parsed correctly.
      if (isNaN(response)) {
        invalidInput = true;
      }
      // Compares the input to the answer with extra checks from the data file.
      if (toleranceType === "absolute") {
        tf = (Math.abs(response - answer) < tolerance);
        if (!tf && data.checkSign) {
          response *= -1.0;
          if (Math.abs(response - answer) < tolerance) {
            wrongSign = true;
          }
        }
      }
      else if (toleranceType === "relative") {
        tf = (((Math.abs(response - answer) / answer) * 100) < tolerance);
      }
      ok = ok && tf;
      if (tf) {
        partial = true;
      } else {
        if (data.removeIncorrect) {
          inputBox.value = '';
          if (i < 4) {
            document.querySelector('#shadow' + i).innerHTML = '';
          }
        }
      }

    console.log('ok in loop: ', ok);
    }
   // Feedback section
   console.log('ok final: ', ok);
    if (ok) {
      feedback = " "+ data.correctFeedback + " " + (data.extraCorrectFeedback || "") + " " + (data.extraFeedback || "");
      disableOptions();
    }
    else {
      numTries++;
      if (partial) {
        feedback += " " + data.partialFeedback;
      }
      else if (!ok) {
        feedback += " " + (numTries > 1 ? data.multipleIncorrectFeedback : data.incorrectFeedback);
      }
      if (numTries < data.maxTries && invalidInput) {
        feedback += " " + data.invalidInputFeedback;
      }
      if (numTries < data.maxTries && wrongSign) {
        feedback += " " +data.signFeedback;
      }
      if (numTries < data.maxTries) {
        feedback += " " +data.intermediateFeedback;
      }
      if (numTries >= data.maxTries) { //fill in correct answers
        feedback += " " + (data.extraIncorrectFeedback || "") + " " + (data.extraFeedback);
        disableOptions();
        showCorrectAnswers();
      }
    }
    // Check for images used in the answer.
    if(images == "true"){
      feedback = replaceImages(feedback);
    }
    document.getElementById("feedback").innerHTML = feedback;
    document.getElementById("feedback").style.display = "block";
  };

  /**
   * @function disableOptions
   * @description If the answer is correct or the student has no more tries the input
   *      boxes and buttons are disabled.
   */
  var disableOptions = function () {
    for (i = 0; i < 5; i++) {
      document.getElementById("input" + i).disabled = "disabled";
    }
    document.getElementById("check").disabled = "disabled";
  };

  var showCorrectAnswers = function () {
    var allInputs = document.querySelectorAll('input');
    for (var i = 0; i < allInputs.length; i++) {
      allInputs[i].value = data.correct[i];
      if (i < allInputs.length - 1) {
        document.querySelector('#shadow' + i).innerHTML = data.correct[i];
      }
    }
  }

  return {
    init: init,
    dataLoad: dataLoad,
    checkAnswers: checkAnswers
  };
}());

// numeric_input.dataLoad(numeric_input.init);
numeric_input.init();
