GLOBAL = {};
GLOBAL.slide=1;
GLOBAL.transcripts= [
    "The English oak is also known as the pedunculate oak, or by its scientific name <i>Quercus robur</i>. It is an icon of the English landscape because of the large size and longevity of the trees. This species also occurs naturally in western Europe and is widely planted in temperate regions across the world. Pedunculate oaks can grow into magnificent trees. ",
    "A very old oak was recently identified in High Park at Blenheim Palace, central England. Researchers estimated the tree is at least 800 years old. It has a trunk girth of 10.34 m and is about 25 m tall. This tree has existed through countless changes of monarchs, government and technological development, not to mention changes in local climate and land use.",
    "Organisms change as they age: they germinate (or hatch, or are born) then grow, perhaps reproduce, and eventually die. This process is referred to as their lifecycle. The timescales involved in these cycles can vary between species, ranging from days to millennia.<br/><br/>The following slides highlight some changes in the lifecycle of an oak. The height and age information provided were calculated using another, younger oak tree which was felled and studied. The ancient oak is hollow inside making it impossible to reconstruct its history in the same way.<br/><br/>First, the acorn germinates and a seedling establishes. This seedling will grow to a height of around 10 cm by the time it is 2 months of age.",
    "By 2 years the oak seedling is approximately 30 cm tall.<br/><br/>The early days or years of life can be a precarious time for an oak. They are small, and therefore vulnerable to drought, lack of light in their environment and being eaten or trampled. Seedlings are also vulnerable because they do not yet have an extensive root system or many leaves that can resist damage.",
    "If conditions are favourable a seedling becomes a sapling, which can then grow into a tree. Saplings face competition from other trees for resources such as light, water and nutrients.<br/><br/>Oaks grow most quickly for the first 120 years of their life. In this example it has reached a height of 5 m – considerably taller than an adult human – in its first 15 years.",
    "To grow big enough to reproduce, oaks must survive many biological and environmental challenges. An oak is considered mature when it starts producing acorns, usually when it is about 40 years old (around 11 m tall).<br/><br/>An oak may produce thousands of acorns across its lifetime, but many of these will not grow into trees. A fertilised flower could be damaged before the seed even forms. If the seed does form then it could produce an acorn that is subsequently eaten by animals or destroyed by fungi. Equally, the acorn could be dispersed into a location that is unsuitable for it to grow.",
    "As time advances an oak can be subjected to insect attack or disease, provide habitats to animals, lose branches and encounter periods of good and bad weather. Some trees will die as a result of environmental pressures, but many survive hundreds of years to reach heights above 20 m.<br/><br/>Acorns, seedlings, saplings and mature trees each face different challenges and death can occur at any stage in their lifecycle. An oak of any age is a thriving organism - fascinating to contemplate as we consider its biology, chemistry, physics and interactions with its environment.",
    "A mature reproductive oak is successfully producing a new generation, fulfilling the aim of life in the struggle for existence. But an ancient oak, such as this oak from High Park at Blenheim, which has lived for over 800 years, really is one that has defied the odds. It is one in a million, and probably even more!"
    ];
GLOBAL.prevVolume= 0.8;
GLOBAL.isMuted = false;

if(!console)var console={
    log:function(){},
    dir:function(){}
}; //to avoid error on non consolable browsers if I forget to comment out a console.function


(function($) {
    // back and forth buttons
    MediaElementPlayer.prototype.buildback = function(player, controls, layers, media) {
        // create the back button
        var back =
            $('<div class="mejs-button mejs-back-button mejs-back-off">' +
                '<button aria-label="back" title="back" aria-controls="mep_0" type="button"></button>' +
                '</div>')
            // append it to the toolbar
                .appendTo(controls)
                // add a click toggle event
                .click(function() {
                    if (GLOBAL.slide > 1) {
                        var currentlyPlaying = ($('#mediaplayer audio')[0].paused) ? false : true;
                        goToStep(Math.min(GLOBAL.slide-1,GLOBAL.slide-1),currentlyPlaying,'back');
                    }
                });
    };
    MediaElementPlayer.prototype.buildforth = function(player, controls, layers, media) {
        // create the forth button
        var forth =
            $('<div class="mejs-button mejs-forth-button  mejs-forth-on">' +
                '<button aria-label="forth" title="forth" aria-controls="mep_0" type="button"></button>' +
                '</div>')
                // append it to the toolbar
                .appendTo(controls)
                // add a click event
                .click(function() {
                    if (GLOBAL.slide < interactiveData.interactivities.steps.length) {
                        console.log("GLOBAL.slide:"+GLOBAL.slide)
                        var currentlyPlaying = ($('#mediaplayer audio')[0].paused) ? false : true;
                        goToStep(GLOBAL.slide+1,currentlyPlaying,'forth');
                    }
                });
    };
})(jQuery);


$(document).ready(function() {
    $('body').addClass('m160-slide-audio'); //so CSS can distinguish between different activities

    // Set the first slide.
    $( "#image-div").css({
            backgroundImage: "url('images/"+interactiveData.interactivities.steps[0].img+"')"
    });

    // Set up the first transcript.
    $( "#transcript-blurb").html(GLOBAL.transcripts[0]);
});


function setUpAudio(autoPlay, prevVol){
    if (typeof(prevVol)==='undefined') prevVol=0.8;
    GLOBAL.meplayer = new MediaElementPlayer('#audio_player',{

        pluginPath: 'audio/',
        // initial volume when the player starts
        startVolume: prevVol,
        // enables Flash and Silverlight to resize to content size
        enableAutosize: true,
        // the order of controls you want on the control bar (and other plugins below)
        features: ['back','forth','playpause','progress','tracks','volume'],
        // Hide controls when playing and mouse is not over the video
        alwaysShowControls: true,
        // force iPad's native controls
        iPadUseNativeControls: false,
        // force iPhone's native controls
        iPhoneUseNativeControls: false,
        // force Android's native controls
        AndroidUseNativeControls: false,
        // forces the hour marker (##:00:00)
        alwaysShowHours: false,
        // show framecount in timecode (##:00:00:00)
        showTimecodeFrameCount: false,
        // used when showTimecodeFrameCount is set to true
        framesPerSecond: 25,
        // turns keyboard support on and off for this instance
        enableKeyboard: true,
        // when this player starts, it will pause other players
        pauseOtherPlayers: true,
        //timer rate, used for polling key points
        timerRate: 200,
        //language
        startLanguage:'en',
        //muted value needs to be stored and re-applied
        muted: GLOBAL.isMuted,
        // array of keyboard commands
        keyActions: [],
        success: function(me) {

            GLOBAL.keyPointStep = -1;
            GLOBAL.keyPointOffset = -1;
            var numOfKeyPoints = Object.keys(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints).length;

            me.addEventListener('timeupdate', function (e) {

                if (numOfKeyPoints > 0) {  //we have keypoints in the audio
                    //console.log('we have keypoints');
                    //interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints.forEach( function(el,index,el) {
                    $.each(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints, function(index,el) {

                        if ((me.currentTime > el.time)  && (index > GLOBAL.keyPointOffset)) {
                            GLOBAL.keyPointOffset = index;
                            return false;
                        }
                    });
                    if (GLOBAL.keyPointStep !== GLOBAL.keyPointOffset) {
                        eval(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints[GLOBAL.keyPointOffset].script);
                        GLOBAL.keyPointStep = GLOBAL.keyPointOffset;
                    }
                }
            }, false);

            $("#mediaplayer audio").bind("ended", function() {
               //me.removeEventListener('timeupdate', arguments.callee);
                GLOBAL.prevVolume=me.volume;
                GLOBAL.isMuted = me.muted;
                (GLOBAL.slide < interactiveData.interactivities.steps.length) ? goToStep(GLOBAL.slide+1,true,'forth') : GLOBAL.slide = interactiveData.interactivities.steps.length+1;
            });
            $("#mediaplayer audio").bind("play", function() {
                if (GLOBAL.slide === interactiveData.interactivities.steps.length+1) setUpSlide(1);
                setTimeout('GLOBAL.meplayer.setMuted('+GLOBAL.isMuted+')',50) ;
            })
            if (autoPlay) me.play();
        }
    });

}


function goToStep(stepNum,autoPlay,dir) {

    $('#folio').text(stepNum);

    GLOBAL.slide = stepNum;
    setTimeout(function() {
        switchAudio(stepNum,autoPlay);
    }, 1500);
    switchImage(stepNum);

    $( "#transcript-blurb").html(GLOBAL.transcripts[stepNum-1]);
    // Make sure the transcript div is scrolled to the top.
    $("#transcript-blurb").scrollTop(0);

    // $( "#captions-div .caption-step").hide();
    // $( "#captions-div #captions-"+stepNum).show();

    setTimeout('updateButtons('+stepNum+',"'+dir+'")',20);
}

function updateButtons(stepNum, dir) {

    if ((stepNum=== interactiveData.interactivities.steps.length) && (dir === 'forth')) {
        $('.mejs-button.mejs-forth-button').removeClass('mejs-forth-on').addClass('mejs-forth-off');
        $('.mejs-button.mejs-back-button').addClass('mejs-back-on').removeClass('mejs-back-off');
    } else if ((stepNum=== 1) && (dir === 'back')) {
        $('.mejs-button.mejs-back-button').removeClass('mejs-back-on').addClass('mejs-back-off');
    } else {
        $('.mejs-button.mejs-forth-button').addClass('mejs-forth-on').removeClass('mejs-forth-off');
        $('.mejs-button.mejs-back-button').addClass('mejs-back-on').removeClass('mejs-back-off');
    }

}


/*function goNextStep() {
    GLOBAL.slide++;

    if (GLOBAL.slide<6) {
        switchAudio(GLOBAL.slide,true);
        switchImage(GLOBAL.slide);
        $( "#transcript").text(GLOBAL.transcripts[GLOBAL.slide-1]);
    } else {//finished final slide
        switchAudio(1,false);
        switchImage(1);
        GLOBAL.slide = 1;
    }
}*/

function playVideo() {
    console.log("hello matey, playVideo");
    GLOBAL.meplayer.play();
}

function switchAudio(slideNum,autoPlay) {

    //GLOBAL.meplayer.setSrc("audio/slide"+slideNum+".mp3");
    //GLOBAL.meplayer.media.load(); //4 hours later!! christ almighty this api is appallingly (un)-documented

    $("#mediaplayer").html("<audio id='audio_player' src='audio/slide"+slideNum+".mp3' type='audio/mp3' controls='controls' width='750'></audio>");
    //$("#mediaplayer audio").prop("src", "audio/slide"+slideNum+".mp3");
    setUpAudio(autoPlay, GLOBAL.prevVolume);
    //if (autoPlay) GLOBAL.meplayer.play();
}


function switchImage(slideNum) {
    $( "#image-div").css({
      backgroundImage: "url('images/"+interactiveData.interactivities.steps[slideNum-1].img+"')"
    });
            


    // $("#overlaid-image img").attr("src","images/slide"+slideNum+".jpg");

    // if ((slideNum === 1) || (slideNum === 6))  {
    //     $( "#image-div" ).removeAttr('style');//clear jquery.animate()
    //     $( "#overlay-image-div").hide();
    //     $( "#captions-1" ).show();
    // } else if (slideNum === 5) {
    //     $( "#image-div").removeAttr('style').css({
    //         left: "2px",
    //         top: "-35px",
    //         height: "720px",
    //         width: "720",
    //         backgroundImage: "url('images/m-160-bg-5.jpg')"
    //     });
    //     $( "#overlay-image-div").hide();
    // } else {
        // $( "#image-div").css({
        //     left: "-212px",
        //     top: "-300px",
        //     height: "1374px",
        //     width: "767px",
        //     backgroundImage: "url('images/m-160-bg.jpg')"
        // });
        // $( "#overlay-image-div").show();
    
}

function setUpSlide(slideNum) {
    console.log('set up slide')
    $('#folio').text(slideNum);
    switchAudio(slideNum,true);
    switchImage(slideNum);
    $( "#transcript-blurb").html(GLOBAL.transcripts[slideNum-1]);
    if (slideNum === 1) {
        $('.mejs-button.mejs-back-button').removeClass('mejs-back-on').addClass('mejs-back-off');
        $('.mejs-button.mejs-forth-button').addClass('mejs-forth-on').removeClass('mejs-forth-off');
    }
    GLOBAL.slide = 1;
    $( "#image-div" ).removeAttr('style');//clear jquery.animate()
}


//  -----------------  animations  ---------------------------  //

function zoomInOnWheat() {
    console.log('zoomInOnWheat')

    $( "#image-div").removeAttr('style');//clear jquery.animate()
    $( "#captions-1" ).hide();
    $( "#image-div").animate({
        left: "-212px",
        top: "-300px",
        height: "1374px",
        width: "767px"
    }, 1500, function() {
        //$( "#overlay-image-div").show();
        $( "#captions-1" ).hide();
    });
}