import TmUtils from '../modules/tmUtils.js';

export default class ItemCommon {
    /**
     * 
     * 
     * @static
     * @param {any} el 
     * @memberof ItemCommon
     */
    static toggleCheckbox(el) {
        // Toggle the colour to the checked colour.
        el.classList.toggle('item-icon-checkmark-checked');

        // Toggle the completed status for the item in itemData.
        let idx = TmUtils.getIndexFromElement(el);
        let item = itemData[idx];

        if (item.hasOwnProperty('completed')) {
            item.completed = (item.completed === true) ? false : true;
        } else {
            item.completed = true;
        }
    }

    static createCheckbox(itemData) {
        let checkbox = document.createElement('span');
        checkbox.setAttribute('class', 'icon-checkmark icon item-icon-checkmark');
        checkbox.setAttribute('id', `checkbox-${itemData.id}`);
        if (itemData.style.curColour !== undefined && itemData.style.curColour !== '') {
            checkbox.classList.add(`item-icon-checkmark-${itemData.style.curTemplate}-${itemData.style.curColour}`);
        }

        // Make the checkbox the 'ticked'.
        if (itemData.hasOwnProperty('completed') && itemData.completed === true) {
            checkbox.classList.add('item-icon-checkmark-checked');
        }
        checkbox.setAttribute('title', 'Progress');
        checkbox.addEventListener('click', (e) => {
                ItemCommon.toggleCheckbox(e.target);
                // Save to the vle.
                TmUtils.vleSave();
            });

        checkbox.addEventListener('keydown', (e) => {
            if (e.which === 13 || e.which === 32) {
                ItemCommon.toggleCheckbox(e.target);
                // Save to the vle.
                TmUtils.vleSave();
            }
        });

        return checkbox;
    }

    static createOlink(itemData) {
        if (itemData.hasOwnProperty('olink')) {
            let olink = document.createElement('span');
            olink.setAttribute('class', 'icon-link icon item-icon-olink');
            olink.setAttribute('id', `olink-${itemData.id}`);
            olink.setAttribute('title', 'Link to materials');

            VLE.get_olink_url(itemData.olink.scDoc, itemData.olink.scSection,
                    function (olinkUrl) {
                        olink.addEventListener('click', (e) => {
                            // this.openUrl(e, olinkUrl);
                            e.preventDefault();
                            window.open(olinkUrl);
                        });

                        olink.addEventListener('keydown', (e) => {
                            if (e.which === 13 || e.which === 32) {
                                // this.openUrl(e, olinkUrl);
                                e.preventDefault();
                                window.open(olinkUrl);
                            }
                        });
                    },
                    function (message){
                        console.warn('Get olink failed: ' + message)
                    });

            return olink;
        } else {
            return false;
        }
    }

    /**
     * Increases the z-index of the provided item element to be one more than the item with
     * the highest z-index.
     * 
     * @static
     * @param {object} elem - DOM element
     * @memberof ItemCommon
     */
    static increaseItemZindex(elem) {
        let maxZindex = parseInt(window.getComputedStyle(elem,null).getPropertyValue("z-index"));
        let items = document.querySelectorAll('.item');
        for (let item of items) {
            let itemZindex = parseInt(window.getComputedStyle(item,null).getPropertyValue("z-index"));
            maxZindex = (itemZindex > maxZindex) ? itemZindex : maxZindex;
        }

        elem.style.zIndex = String(maxZindex + 1);
    }

    static addTabable(itemData, elem) {
        if (!itemData.hasOwnProperty('tabable')) {
            itemData.tabable = [];
        }

        itemData.tabable.push(elem);
    }

    /**
     * Sets the provided array of elements to have a tabindex value of 0
     * if the itemDiv is visible in the viewport.
     * 
     * @static
     * @param {any} itemDiv 
     * @param {any} elemArr 
     * @memberof ItemCommon
     */
    static setTabable(itemDiv, elemArr) {
        const visible = this.itemVisible(itemDiv);

        if (visible) {
            for (let elem of elemArr) {
                elem.setAttribute('tabindex', '0');
            }
        } else {
            for (let elem of elemArr) {
                elem.removeAttribute('tabindex');
            }
        }
    }

    /**
     * Checks if a item is visible - in the viewport.
     * 
     * @static
     * @param {any} itemDiv 
     * @returns 
     * @memberof ItemCommon
     */
    static itemVisible(itemDiv) {
        let divPos = TmUtils.stripPx(itemDiv.style.top);
        let viewportTop = TmUtils.stripPx(document.getElementById('stretchy-canvas').style.top);
        viewportTop = Math.abs(viewportTop);
        let viewportHeight = TmUtils.stripPx(document.getElementById('stretchy-outer').style.height);
        let viewportBottom = viewportTop + viewportHeight;
        if (divPos >= viewportTop && divPos <= viewportBottom) {
            return true;
        } else {
            return false;
        }
    }
}