export default class Saver {
    constructor(options, data) {
        console.log('constructor: ', options);
        console.log('constructor: ', data);

        this.data = {};

        if (options.hasOwnProperty('userOrGroups')) {
            this.userOrGroups = options.userOrGroups;
        } else {
            this.userOrGroups = true;
        }

        if (typeof data !== 'undefined') {
            this.setData(data, true);
        }

        if (options.hasOwnProperty('getOk')) {
            this.getOk = options.getOk;
        }
        if (options.hasOwnProperty('getError')) {
            this.getError = options.getError;
        }
        if (options.hasOwnProperty('saveOk')) {
            this.saveOk = options.saveOk;
        }
        if (options.hasOwnProperty('saveError')) {
            this.saveError = options.saveError;
        }

        this.previousValues = {};
    }

    getData(prop) {
        if (this.data.hasOwnProperty(prop)) {
            return this.data[prop];
        } else {
            console.error(`No such property '${prop}'`);
        }
        
    }

    setData(data, save = false) {
        for (let prop in data) {
            this.data[prop] = data[prop];
        }
        
        console.log('setData: ', this.data, save);
        if (save) {
        	this.save();
            console.log('saving');
        }
    }

    get() {
        VLE.get_server_data(true, ['text'],
            (values) => {
                // All good.
                this.data = JSON.parse(values);
                this.getOk();
            },
            (message) => {
                if (message === null) {
                    // Not connected the VLE.
                    console.warn('Not connected to the VLE, cannot get data.');
                } else {
                    console.log('Unable to get data from server.' + message);
                }

                this.getError(message);
            },
            this.activityId, this.documentId, this.courseId);
    }

    save() {
        VLE.set_server_data(this.userOrGroups, JSON.stringify(this.data),
            () => {
                console.log('Saved, all good');
                this.saveOk();
            },
            (message) => {
                if (message === null) {
                    // Not on the VLE.
                    console.warn('Not connected to the VLE, cannot save data.');
                } else {
                    console.log('Unable to save data to VLE: ' + message);
                }

                this.saveError(message);
            },
            this.previousValues, null, this.activityId, this.documentId, this.courseId);
    }
}