GLOBAL = {};
GLOBAL.slide=1;
GLOBAL.transcripts= [
  "Atoms are made of particles known as protons, neutrons and electrons. Electrons are thought to be indivisible, but neutrons and protons are made of smaller components called quarks. Protons and neutrons each consist of three quarks.<br/><br/>Quarks and electrons are considered ‘point’ particles, meaning they have no size. They are studied using particle accelerators which use very high energy particles to break apart atoms. Quantum mechanics is the field of science which describes the behaviour of such tiny particles.",
  "There are six types of quarks, rather wonderfully known as flavours. These are ‘up’, ‘down’, ‘strange’, ‘charm’, ‘top’, and ‘bottom’ quarks. They are named in part because of their properties and also because these names were pithy (rather than accurate) descriptions! Quarks are often represented graphically by a circle containing the first letter of their flavour.",
  "Photons are also tiny particles. They represent a parcel of light or electromagnetic energy. A photon has properties of both a wave (such as frequency) and a particle, and therefore sometimes photons are drawn as waves or points.<br/><br/>A photon has no mass, but is associated with an energy that is proportional to its frequency. The equation that relates wavelength and frequency for electromagnetic waves is: <i>λ</i> x <i>f</i> = <i>c</i>, where <i>λ</i> represents the wavelength, <i>f</i> is the frequency and <i>c</i> is the speed of light in a vacuum, which is often approximated to 3 x 10<sup>8</sup> m s<sup>–1</sup>. Photons with a frequency of around 400–700 nm are visible to humans, as shown here.",
  "Photons are key fundamental particles that are essential for life on Earth. They carry light and energy from the Sun, powering photosynthesis.<br/><br/>In plants, chlorophyll molecules (in conjunction with proteins) absorb several wavelengths of light. The red line in this figure is the proportion of photons absorbed by plants, with peaks at around 455 nm and 660 nm. A very low proportion of photons with wavelengths in the green part of the spectrum (around 500–570 nm) is absorbed by chlorophyll. These wavelengths are instead reflected away from the plant, which is why its leaves look green to an observer.",
  "Photosynthesis is a clear example of how multiple fields of science are needed to understand complex processes. For instance quantum mechanics can inform branches of chemistry in helping to understanding how light can power reactions and convert sunlight into stored energy in a leaf. In turn, this knowledge can inform biology by explaining how plants grow in different environmental conditions such as varying light levels.<br/><br/>In fact quantum mechanics can be used to study the efficiency of photosynthesis directly, by studying the way ‘point’ particles such as photons and electrons move through leaves."
  ];
GLOBAL.prevVolume= 0.8;
GLOBAL.isMuted = false;

if(!console)var console={
    log:function(){},
    dir:function(){}
}; //to avoid error on non consolable browsers if I forget to comment out a console.function


(function($) {
    // back and forth buttons
    MediaElementPlayer.prototype.buildback = function(player, controls, layers, media) {
        // create the back button
        var back =
            $('<div class="mejs-button mejs-back-button mejs-back-off">' +
                '<button aria-label="back" title="back" aria-controls="mep_0" type="button"></button>' +
                '</div>')
            // append it to the toolbar
                .appendTo(controls)
                // add a click toggle event
                .click(function() {
                    if (GLOBAL.slide > 1) {
                        var currentlyPlaying = ($('#mediaplayer audio')[0].paused) ? false : true;
                        goToStep(Math.min(GLOBAL.slide-1,GLOBAL.slide-1),currentlyPlaying,'back');
                    }
                });
    };
    MediaElementPlayer.prototype.buildforth = function(player, controls, layers, media) {
        // create the forth button
        var forth =
            $('<div class="mejs-button mejs-forth-button  mejs-forth-on">' +
                '<button aria-label="forth" title="forth" aria-controls="mep_0" type="button"></button>' +
                '</div>')
                // append it to the toolbar
                .appendTo(controls)
                // add a click event
                .click(function() {
                    if (GLOBAL.slide < interactiveData.interactivities.steps.length) {
                        console.log("GLOBAL.slide:"+GLOBAL.slide)
                        var currentlyPlaying = ($('#mediaplayer audio')[0].paused) ? false : true;
                        goToStep(GLOBAL.slide+1,currentlyPlaying,'forth');
                    }
                });
    };
})(jQuery);


$(document).ready(function() {
    $('body').addClass('m160-slide-audio'); //so CSS can distinguish between different activities

    // Set the first slide.
    $( "#image-div").css({
            backgroundImage: "url('images/"+interactiveData.interactivities.steps[0].img+"')"
    });

    // Set up the first transcript.
    $( "#transcript-blurb").html(GLOBAL.transcripts[0]);
});


function setUpAudio(autoPlay, prevVol){
    if (typeof(prevVol)==='undefined') prevVol=0.8;
    GLOBAL.meplayer = new MediaElementPlayer('#audio_player',{

        pluginPath: 'audio/',
        // initial volume when the player starts
        startVolume: prevVol,
        // enables Flash and Silverlight to resize to content size
        enableAutosize: true,
        // the order of controls you want on the control bar (and other plugins below)
        features: ['back','forth','playpause','progress','tracks','volume'],
        // Hide controls when playing and mouse is not over the video
        alwaysShowControls: true,
        // force iPad's native controls
        iPadUseNativeControls: false,
        // force iPhone's native controls
        iPhoneUseNativeControls: false,
        // force Android's native controls
        AndroidUseNativeControls: false,
        // forces the hour marker (##:00:00)
        alwaysShowHours: false,
        // show framecount in timecode (##:00:00:00)
        showTimecodeFrameCount: false,
        // used when showTimecodeFrameCount is set to true
        framesPerSecond: 25,
        // turns keyboard support on and off for this instance
        enableKeyboard: true,
        // when this player starts, it will pause other players
        pauseOtherPlayers: true,
        //timer rate, used for polling key points
        timerRate: 200,
        //language
        startLanguage:'en',
        //muted value needs to be stored and re-applied
        muted: GLOBAL.isMuted,
        // array of keyboard commands
        keyActions: [],
        success: function(me) {

            GLOBAL.keyPointStep = -1;
            GLOBAL.keyPointOffset = -1;
            var numOfKeyPoints = Object.keys(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints).length;

            me.addEventListener('timeupdate', function (e) {

                if (numOfKeyPoints > 0) {  //we have keypoints in the audio
                    //console.log('we have keypoints');
                    //interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints.forEach( function(el,index,el) {
                    $.each(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints, function(index,el) {

                        if ((me.currentTime > el.time)  && (index > GLOBAL.keyPointOffset)) {
                            GLOBAL.keyPointOffset = index;
                            return false;
                        }
                    });
                    if (GLOBAL.keyPointStep !== GLOBAL.keyPointOffset) {
                        eval(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints[GLOBAL.keyPointOffset].script);
                        GLOBAL.keyPointStep = GLOBAL.keyPointOffset;
                    }
                }
            }, false);

            $("#mediaplayer audio").bind("ended", function() {
               //me.removeEventListener('timeupdate', arguments.callee);
                GLOBAL.prevVolume=me.volume;
                GLOBAL.isMuted = me.muted;
                (GLOBAL.slide < interactiveData.interactivities.steps.length) ? goToStep(GLOBAL.slide+1,true,'forth') : GLOBAL.slide = interactiveData.interactivities.steps.length+1;
            });
            $("#mediaplayer audio").bind("play", function() {
                if (GLOBAL.slide === interactiveData.interactivities.steps.length+1) setUpSlide(1);
                setTimeout('GLOBAL.meplayer.setMuted('+GLOBAL.isMuted+')',50) ;
            })
            if (autoPlay) me.play();
        }
    });

}


function goToStep(stepNum,autoPlay,dir) {

    $('#folio').text(stepNum);

    GLOBAL.slide = stepNum;
    setTimeout(function() {
        switchAudio(stepNum,autoPlay);
    }, 1500);
    switchImage(stepNum);

    $( "#transcript-blurb").html(GLOBAL.transcripts[stepNum-1]);
    // Make sure the transcript div is scrolled to the top.
    $("#transcript-blurb").scrollTop(0);

    // $( "#captions-div .caption-step").hide();
    // $( "#captions-div #captions-"+stepNum).show();

    setTimeout('updateButtons('+stepNum+',"'+dir+'")',20);
}

function updateButtons(stepNum, dir) {

    if ((stepNum=== interactiveData.interactivities.steps.length) && (dir === 'forth')) {
        $('.mejs-button.mejs-forth-button').removeClass('mejs-forth-on').addClass('mejs-forth-off');
        $('.mejs-button.mejs-back-button').addClass('mejs-back-on').removeClass('mejs-back-off');
    } else if ((stepNum=== 1) && (dir === 'back')) {
        $('.mejs-button.mejs-back-button').removeClass('mejs-back-on').addClass('mejs-back-off');
    } else {
        $('.mejs-button.mejs-forth-button').addClass('mejs-forth-on').removeClass('mejs-forth-off');
        $('.mejs-button.mejs-back-button').addClass('mejs-back-on').removeClass('mejs-back-off');
    }

}


/*function goNextStep() {
    GLOBAL.slide++;

    if (GLOBAL.slide<6) {
        switchAudio(GLOBAL.slide,true);
        switchImage(GLOBAL.slide);
        $( "#transcript").text(GLOBAL.transcripts[GLOBAL.slide-1]);
    } else {//finished final slide
        switchAudio(1,false);
        switchImage(1);
        GLOBAL.slide = 1;
    }
}*/

function playVideo() {
    console.log("hello matey, playVideo");
    GLOBAL.meplayer.play();
}

function switchAudio(slideNum,autoPlay) {

    //GLOBAL.meplayer.setSrc("audio/slide"+slideNum+".mp3");
    //GLOBAL.meplayer.media.load(); //4 hours later!! christ almighty this api is appallingly (un)-documented

    $("#mediaplayer").html("<audio id='audio_player' src='audio/slide"+slideNum+".mp3' type='audio/mp3' controls='controls' width='750'></audio>");
    //$("#mediaplayer audio").prop("src", "audio/slide"+slideNum+".mp3");
    setUpAudio(autoPlay, GLOBAL.prevVolume);
    //if (autoPlay) GLOBAL.meplayer.play();
}


function switchImage(slideNum) {
    $( "#image-div").css({
      backgroundImage: "url('images/"+interactiveData.interactivities.steps[slideNum-1].img+"')"
    });
            


    // $("#overlaid-image img").attr("src","images/slide"+slideNum+".jpg");

    // if ((slideNum === 1) || (slideNum === 6))  {
    //     $( "#image-div" ).removeAttr('style');//clear jquery.animate()
    //     $( "#overlay-image-div").hide();
    //     $( "#captions-1" ).show();
    // } else if (slideNum === 5) {
    //     $( "#image-div").removeAttr('style').css({
    //         left: "2px",
    //         top: "-35px",
    //         height: "720px",
    //         width: "720",
    //         backgroundImage: "url('images/m-160-bg-5.jpg')"
    //     });
    //     $( "#overlay-image-div").hide();
    // } else {
        // $( "#image-div").css({
        //     left: "-212px",
        //     top: "-300px",
        //     height: "1374px",
        //     width: "767px",
        //     backgroundImage: "url('images/m-160-bg.jpg')"
        // });
        // $( "#overlay-image-div").show();
    
}

function setUpSlide(slideNum) {
    console.log('set up slide')
    $('#folio').text(slideNum);
    switchAudio(slideNum,true);
    switchImage(slideNum);
    $( "#transcript-blurb").html(GLOBAL.transcripts[slideNum-1]);
    if (slideNum === 1) {
        $('.mejs-button.mejs-back-button').removeClass('mejs-back-on').addClass('mejs-back-off');
        $('.mejs-button.mejs-forth-button').addClass('mejs-forth-on').removeClass('mejs-forth-off');
    }
    GLOBAL.slide = 1;
    $( "#image-div" ).removeAttr('style');//clear jquery.animate()
}


//  -----------------  animations  ---------------------------  //

function zoomInOnWheat() {
    console.log('zoomInOnWheat')

    $( "#image-div").removeAttr('style');//clear jquery.animate()
    $( "#captions-1" ).hide();
    $( "#image-div").animate({
        left: "-212px",
        top: "-300px",
        height: "1374px",
        width: "767px"
    }, 1500, function() {
        //$( "#overlay-image-div").show();
        $( "#captions-1" ).hide();
    });
}