GLOBAL = {};
GLOBAL.slide=1;
GLOBAL.transcripts= [
  "Atoms, such as the carbon atom depicted here, are composed of different numbers of a range of subatomic particles. Protons and neutrons, which are themselves composed of smaller particles called quarks, are held together in a central nucleus. Electrons occupy a cloud around the nucleus. ",
  "The 118 elements that make up all known matter differ from each other in the number of protons that their atoms contain. Carbon, for example, has six protons while an atom containing seven protons is nitrogen and one with eight protons is oxygen. ",
  "Here is a carbon atom again, with six protons and six neutrons in its nucleus. Both the protons and neutrons have diameters of about 2 × 10<sup>−15</sup> m. They also have similar masses of about 1.67 × 10<sup>−27</sup> kg.<br/><br/>The actual weight of carbon’s subatomic particles should not be confused with its atomic mass number. This value is derived from summing the number of protons and neutrons in an atom of that element.",
  "Some elements can occur in slightly different forms in which their atoms have the same number of protons in the nucleus, but not the same number of neutrons. These different forms of the element are called isotopes.<br/><br/>Carbon most frequently has six neutrons, and this is known as carbon-12, often represented as <sup>12</sup>C. It is named in this way because, with six protons and six neutrons, it has an atomic mass number of 12. Carbon can also exist in a form containing seven neutrons known as carbon-13, or even eight neutrons forming carbon-14. Each of the isotopes is chemically similar, the major difference being their different atomic mass numbers. <br/><br/>Approximately 98.9% of carbon exists on Earth as carbon-12, and 1.1% as carbon-13. Only a very small amount of carbon exists as carbon-14, but this isotope is important because it can be used to work out the age of some organic samples in a process known as carbon dating.",
  "Most <sup>14</sup>C originates in the upper atmosphere when neutrons, produced by cosmic rays, react with atoms of the most common nitrogen isotope, <sup>14</sup>N. The <sup>14</sup>C becomes part of CO<sub>2</sub>, which can be incorporated into plants through photosynthesis. Only living organisms are able to continually incorporate <sup>14</sup>C into the molecules associated with life. Amounts of this isotope in an organism decline after its death.",
  "When a plant dies the <sup>14</sup>C it contains decays over time, and is converted back to <sup>14</sup>N at a predictable rate. It takes 5730 years for half of the <sup>14</sup>C in a sample to decay, and this number of years is known as the half-life of <sup>14</sup>C. <br/><br/>Because isotopes decay in a predictable way, if we know the original ratio of <sup>14</sup>C to <sup>12</sup>C in a sample, we can determine the age of that sample. The technique used to determine this change is known as radiocarbon dating.<br/><br/>We can use radiocarbon dating to reliably date organic samples up to 26 000 years old. After that, samples can be dated up to around 50 000 years old, but with less certainty. After around 55 000 years the amount of <sup>14</sup>C remaining in a sample is too small to be measured.",
  "In the 1950s and 1960s nuclear weapons testing significantly changed the ratios of <sup>14</sup>C to <sup>12</sup>C in the atmosphere. Samples are therefore usually dated to before 1950, which is also known, somewhat unhelpfully, as ‘years before present’. For example, 6000 years before present, or bp, means 6000 years before 1950, which in 2017 would be 6067 years ago. <br/><br/>Complex calibrations are needed to convert isotope data into calendar years, as well as very accurate equipment to measure the isotopes because of the tiny amounts of <sup>14</sup>C involved.",
  "Oaks, and indeed many plant species, colonised the British Isles, spreading from south to north between 10 000 and 6000 years ago. This time period fits well within the range of accurate radiocarbon dating that is possible from studying levels of <sup>14</sup>C and other isotopes in fossils.<br/><br/>It is our understanding of, and ability to measure, subatomic particles such as neutrons that has allowed the radiocarbon dating process to be developed. Knowledge of isotopes such as <sup>12</sup>C and <sup>14</sup>C, with their different numbers of neutrons, has radically changed our ability to reconstruct past environments."
  ];
GLOBAL.prevVolume= 0.8;
GLOBAL.isMuted = false;

if(!console)var console={
    log:function(){},
    dir:function(){}
}; //to avoid error on non consolable browsers if I forget to comment out a console.function


(function($) {
    // back and forth buttons
    MediaElementPlayer.prototype.buildback = function(player, controls, layers, media) {
        // create the back button
        var back =
            $('<div class="mejs-button mejs-back-button mejs-back-off">' +
                '<button aria-label="back" title="back" aria-controls="mep_0" type="button"></button>' +
                '</div>')
            // append it to the toolbar
                .appendTo(controls)
                // add a click toggle event
                .click(function() {
                    if (GLOBAL.slide > 1) {
                        var currentlyPlaying = ($('#mediaplayer audio')[0].paused) ? false : true;
                        goToStep(Math.min(GLOBAL.slide-1,GLOBAL.slide-1),currentlyPlaying,'back');
                    }
                });
    };
    MediaElementPlayer.prototype.buildforth = function(player, controls, layers, media) {
        // create the forth button
        var forth =
            $('<div class="mejs-button mejs-forth-button  mejs-forth-on">' +
                '<button aria-label="forth" title="forth" aria-controls="mep_0" type="button"></button>' +
                '</div>')
                // append it to the toolbar
                .appendTo(controls)
                // add a click event
                .click(function() {
                    if (GLOBAL.slide < interactiveData.interactivities.steps.length) {
                        console.log("GLOBAL.slide:"+GLOBAL.slide)
                        var currentlyPlaying = ($('#mediaplayer audio')[0].paused) ? false : true;
                        goToStep(GLOBAL.slide+1,currentlyPlaying,'forth');
                    }
                });
    };
})(jQuery);


$(document).ready(function() {
    $('body').addClass('m160-slide-audio'); //so CSS can distinguish between different activities

    // Set the first slide.
    $( "#image-div").css({
            backgroundImage: "url('images/"+interactiveData.interactivities.steps[0].img+"')"
    });

    // Set up the first transcript.
    $( "#transcript-blurb").html(GLOBAL.transcripts[0]);
});


function setUpAudio(autoPlay, prevVol){
    if (typeof(prevVol)==='undefined') prevVol=0.8;
    GLOBAL.meplayer = new MediaElementPlayer('#audio_player',{

        pluginPath: 'audio/',
        // initial volume when the player starts
        startVolume: prevVol,
        // enables Flash and Silverlight to resize to content size
        enableAutosize: true,
        // the order of controls you want on the control bar (and other plugins below)
        features: ['back','forth','playpause','progress','tracks','volume'],
        // Hide controls when playing and mouse is not over the video
        alwaysShowControls: true,
        // force iPad's native controls
        iPadUseNativeControls: false,
        // force iPhone's native controls
        iPhoneUseNativeControls: false,
        // force Android's native controls
        AndroidUseNativeControls: false,
        // forces the hour marker (##:00:00)
        alwaysShowHours: false,
        // show framecount in timecode (##:00:00:00)
        showTimecodeFrameCount: false,
        // used when showTimecodeFrameCount is set to true
        framesPerSecond: 25,
        // turns keyboard support on and off for this instance
        enableKeyboard: true,
        // when this player starts, it will pause other players
        pauseOtherPlayers: true,
        //timer rate, used for polling key points
        timerRate: 200,
        //language
        startLanguage:'en',
        //muted value needs to be stored and re-applied
        muted: GLOBAL.isMuted,
        // array of keyboard commands
        keyActions: [],
        success: function(me) {

            GLOBAL.keyPointStep = -1;
            GLOBAL.keyPointOffset = -1;
            var numOfKeyPoints = Object.keys(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints).length;

            me.addEventListener('timeupdate', function (e) {

                if (numOfKeyPoints > 0) {  //we have keypoints in the audio
                    //console.log('we have keypoints');
                    //interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints.forEach( function(el,index,el) {
                    $.each(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints, function(index,el) {

                        if ((me.currentTime > el.time)  && (index > GLOBAL.keyPointOffset)) {
                            GLOBAL.keyPointOffset = index;
                            return false;
                        }
                    });
                    if (GLOBAL.keyPointStep !== GLOBAL.keyPointOffset) {
                        eval(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints[GLOBAL.keyPointOffset].script);
                        GLOBAL.keyPointStep = GLOBAL.keyPointOffset;
                    }
                }
            }, false);

            $("#mediaplayer audio").bind("ended", function() {
               //me.removeEventListener('timeupdate', arguments.callee);
                GLOBAL.prevVolume=me.volume;
                GLOBAL.isMuted = me.muted;
                (GLOBAL.slide < interactiveData.interactivities.steps.length) ? goToStep(GLOBAL.slide+1,true,'forth') : GLOBAL.slide = interactiveData.interactivities.steps.length+1;
            });
            $("#mediaplayer audio").bind("play", function() {
                if (GLOBAL.slide === interactiveData.interactivities.steps.length+1) setUpSlide(1);
                setTimeout('GLOBAL.meplayer.setMuted('+GLOBAL.isMuted+')',50) ;
            })
            if (autoPlay) me.play();
        }
    });

}


function goToStep(stepNum,autoPlay,dir) {

    $('#folio').text(stepNum);

    GLOBAL.slide = stepNum;
    setTimeout(function() {
        switchAudio(stepNum,autoPlay);
    }, 1500);
    switchImage(stepNum);

    $( "#transcript-blurb").html(GLOBAL.transcripts[stepNum-1]);
    // Make sure the transcript div is scrolled to the top.
    $("#transcript-blurb").scrollTop(0);

    // $( "#captions-div .caption-step").hide();
    // $( "#captions-div #captions-"+stepNum).show();

    setTimeout('updateButtons('+stepNum+',"'+dir+'")',20);
}

function updateButtons(stepNum, dir) {

    if ((stepNum=== interactiveData.interactivities.steps.length) && (dir === 'forth')) {
        $('.mejs-button.mejs-forth-button').removeClass('mejs-forth-on').addClass('mejs-forth-off');
        $('.mejs-button.mejs-back-button').addClass('mejs-back-on').removeClass('mejs-back-off');
    } else if ((stepNum=== 1) && (dir === 'back')) {
        $('.mejs-button.mejs-back-button').removeClass('mejs-back-on').addClass('mejs-back-off');
    } else {
        $('.mejs-button.mejs-forth-button').addClass('mejs-forth-on').removeClass('mejs-forth-off');
        $('.mejs-button.mejs-back-button').addClass('mejs-back-on').removeClass('mejs-back-off');
    }

}


/*function goNextStep() {
    GLOBAL.slide++;

    if (GLOBAL.slide<6) {
        switchAudio(GLOBAL.slide,true);
        switchImage(GLOBAL.slide);
        $( "#transcript").text(GLOBAL.transcripts[GLOBAL.slide-1]);
    } else {//finished final slide
        switchAudio(1,false);
        switchImage(1);
        GLOBAL.slide = 1;
    }
}*/

function playVideo() {
    console.log("hello matey, playVideo");
    GLOBAL.meplayer.play();
}

function switchAudio(slideNum,autoPlay) {

    //GLOBAL.meplayer.setSrc("audio/slide"+slideNum+".mp3");
    //GLOBAL.meplayer.media.load(); //4 hours later!! christ almighty this api is appallingly (un)-documented

    $("#mediaplayer").html("<audio id='audio_player' src='audio/slide"+slideNum+".mp3' type='audio/mp3' controls='controls' width='750'></audio>");
    //$("#mediaplayer audio").prop("src", "audio/slide"+slideNum+".mp3");
    setUpAudio(autoPlay, GLOBAL.prevVolume);
    //if (autoPlay) GLOBAL.meplayer.play();
}


function switchImage(slideNum) {
    $( "#image-div").css({
      backgroundImage: "url('images/"+interactiveData.interactivities.steps[slideNum-1].img+"')"
    });
            


    // $("#overlaid-image img").attr("src","images/slide"+slideNum+".jpg");

    // if ((slideNum === 1) || (slideNum === 6))  {
    //     $( "#image-div" ).removeAttr('style');//clear jquery.animate()
    //     $( "#overlay-image-div").hide();
    //     $( "#captions-1" ).show();
    // } else if (slideNum === 5) {
    //     $( "#image-div").removeAttr('style').css({
    //         left: "2px",
    //         top: "-35px",
    //         height: "720px",
    //         width: "720",
    //         backgroundImage: "url('images/m-160-bg-5.jpg')"
    //     });
    //     $( "#overlay-image-div").hide();
    // } else {
        // $( "#image-div").css({
        //     left: "-212px",
        //     top: "-300px",
        //     height: "1374px",
        //     width: "767px",
        //     backgroundImage: "url('images/m-160-bg.jpg')"
        // });
        // $( "#overlay-image-div").show();
    
}

function setUpSlide(slideNum) {
    console.log('set up slide')
    $('#folio').text(slideNum);
    switchAudio(slideNum,true);
    switchImage(slideNum);
    $( "#transcript-blurb").html(GLOBAL.transcripts[slideNum-1]);
    if (slideNum === 1) {
        $('.mejs-button.mejs-back-button').removeClass('mejs-back-on').addClass('mejs-back-off');
        $('.mejs-button.mejs-forth-button').addClass('mejs-forth-on').removeClass('mejs-forth-off');
    }
    GLOBAL.slide = 1;
    $( "#image-div" ).removeAttr('style');//clear jquery.animate()
}


//  -----------------  animations  ---------------------------  //

function zoomInOnWheat() {
    console.log('zoomInOnWheat')

    $( "#image-div").removeAttr('style');//clear jquery.animate()
    $( "#captions-1" ).hide();
    $( "#image-div").animate({
        left: "-212px",
        top: "-300px",
        height: "1374px",
        width: "767px"
    }, 1500, function() {
        //$( "#overlay-image-div").show();
        $( "#captions-1" ).hide();
    });
}