var modalInner = {},
    iFrame = {};

function create(itemData) {
    var body = document.getElementsByTagName('body')[0];
    var modal = document.createElement('div');
    modal.setAttribute('id', 'modal');
    modal.setAttribute('class', 'modal');
    
    modalInner = document.createElement('div');
    modalInner.setAttribute('class', 'modal-inner');
    // modalInner.style.width = itemData.media.width + 'px';
    // modalInner.style.height = itemData.media.height + 'px';
    
    var closeButton = document.createElement('button');
    closeButton.innerHTML = '&#215;';
    closeButton.setAttribute('class', 'modal-close-button');
    closeButton.setAttribute('title', 'close');
    closeButton.setAttribute('tabindex', '0');

    // let title = document.createElement('div');
    // title.setAttribute('class', 'modal-title');
    // title.innerHTML = (`<h2>This is the title</h2>`);

    let titleDiv = document.createElement('div');
    titleDiv.setAttribute('class', 'modal-title');
    let title = document.createElement('h1');
    title.innerText = itemData.media.title;
    titleDiv.appendChild(title);

    // Create the iframe.
    iFrame = document.createElement('iframe');
    iFrame.style.width = "100%";
    iFrame.style.height = "100%";
    iFrame.style.border = '0';
    iFrame.setAttribute('allowfullscreen', 'true');

    modalInner.appendChild(closeButton);
    modalInner.appendChild(titleDiv);
    modalInner.appendChild(iFrame);
    modal.appendChild(modalInner);
    body.appendChild(modal);

    // modalInner.style.left = (modal.offsetWidth / 2 - itemData.media.width / 2) + 'px';
    // modalInner.style.top = (modal.offsetHeight / 2 - itemData.media.height / 2) + 'px';

    // Event delegation.
    modal.addEventListener('click', (e) => {
        e.preventDefault;
        e.stopPropagation;
        if (e.target.classList.contains('modal')) {
            close(modal);
        };
        if (e.target.classList.contains('modal-close-button')) {
            close(modal);
        };
    })

    modal.addEventListener('keydown', (e) => {
        if (e.which === 27) {
            close(modal);
        }
    });

    // window.onresize = () => {
    //     setPosition(itemData.media.width, itemData.media.height);
    // }
};

function show(itemData) {
    if (!document.getElementById('modal')) {
        create(itemData);
    };

    // Create the iframe.
    // iFrame = document.createElement('iframe');
    // iFrame.style.width = "100%";
    // iFrame.style.height = "100%";
    // iFrame.style.border = '0';
    // iFrame.setAttribute('allowfullscreen', 'true');

    // modalInner.appendChild(iFrame);

console.log('setting iframe src');
    iFrame.setAttribute('src', config.media + '/' + itemData.media.media + '/index.html?ID=' + Date.now());
    iFrame.onload = () => {
        modalInner.style.width = itemData.media.width + 'px';
        modalInner.style.height = itemData.media.height + 'px';
        setPosition(itemData.media.width, itemData.media.height);
        // modalInner.style.left = (modal.offsetWidth / 2 - itemData.media.width / 2) + 'px';
        // modalInner.style.top = (modal.offsetHeight / 2 - itemData.media.height / 2) + 'px';
console.log('iframe onload');
        // modal.style.opacity = '1';
        // modal.style.zIndex = '5000';
        // modalInner.style.opacity = '1';
        // modalInner.style.zIndex = '501';
    }

    modal.style.opacity = '1';
    modal.style.zIndex = '5000';
    // modalInner.style.opacity = '1';
    // modalInner.style.zIndex = '501';

    // Set the close button to have the focus.
    document.querySelector('div#modal button.modal-close-button').focus();
};

function close(modal) {
    // modal.remove(modalInner);
    // modalInner.removeChild(iFrame);
    console.log('should be hiding modal now...');
    hide(modal);
    iFrame.removeAttribute('src');
}

function hide(modal) {
console.log('modal hide function');
    modal.style.opacity = '0';
    modal.style.zIndex = '-1';
    // modalInner.style.opacity = '0';
    // modalInner.style.zIndex = '-1';
};

function setPosition(width, height) {
    modalInner.style.left = (modal.offsetWidth / 2 - width / 2) + 'px';
    modalInner.style.top = (modal.offsetHeight / 2 - height / 2) + 'px';
}

function destroyVideo() {

}

export {show}