import Scale from '../scale/scale.js';
import ItemControl from './itemControl.js';

var range;
var canvasWidth, canvasHeight;
var canvas = {};
var xPos, yPos;
var options = {};
var xGuideLines = [];
var yGuideLines = [];
var numGuideLines = 20;
let controls = {};
let containerElem = {};
let outer = {};
let scales = {};
let xScaleDiv = {};
let yScaleDiv = {};
let myScaleX = {};
let myScaleY = {};
// let scalePointsX = [];
// let scalePointsY = [];
let itemControl;
let displayCats = ['main'];
let saver = {};

function init(elem, passedOptions, saverInstance) {
    containerElem = elem;
    // Validate passed parameters and set defaults.
    if (isObject(passedOptions)) {
        options = passedOptions;
        canvasWidth = options.canvasWidth;
        canvasHeight = options.canvasHeight;
        range = options.range;
        xPos = canvasWidth;
        yPos = canvasHeight;
        controls = options.controls;
        scales = options.scales;
    } else {
        console.warn('options is not an object or is null');
        return;
    }

    saver = saverInstance;

    // Create a 'window' div for the canvas.
    outer = document.createElement('div');
    outer.setAttribute('id', 'stretchy-outer');
    setOuterSize();
    containerElem.appendChild(outer);

    // Build the canvas.
    canvas = document.createElement('div');
    canvas.setAttribute('id', 'stretchy-canvas');
    outer.appendChild(canvas);

    // Add the scales, hidden initially in CSS.
    xScaleDiv = document.createElement('div');
    xScaleDiv.setAttribute('id', 'scale-x');
    xScaleDiv.style.left = scales.widthY +'px';
    xScaleDiv.style.height = scales.widthX +'px';
    xScaleDiv.style.width = String(xPos) + 'px';
    containerElem.appendChild(xScaleDiv);
    
    yScaleDiv = document.createElement('div');
    yScaleDiv.setAttribute('id', 'scale-y')
    yScaleDiv.style.width = scales.widthY +'px';
    yScaleDiv.style.height = String(yPos) + 'px';
    containerElem.appendChild(yScaleDiv);

    let xScaleConfig = {
        container: document.querySelector('#scale-x'),
        vertical: false,
        rtl: false,
        minVal: range.x.min,
        maxVal: range.x.max,
        skipLabels: {
            lessThan: 34,
            num: 2
        }
    };
    myScaleX = new Scale(xScaleConfig);
    let scalePointsX = myScaleX.drawScale();
    drawGridLines('x', scalePointsX);

    let yScaleConfig = {
        container: document.querySelector('#scale-y'),
        vertical: true,
        rtl: false,
        minVal: range.y.min,
        maxVal: range.y.max
    };
    myScaleY = new Scale(yScaleConfig);
    let scalePointsY = myScaleY.drawScale();
    drawGridLines('y', scalePointsY);

    // Add a blanking panel to the origin corner to hide the scales.
    let scaleOriginCorner = document.createElement('div');
    scaleOriginCorner.setAttribute('class', 'scale-origin-corner');
    scaleOriginCorner.style.width = scales.widthY +'px';
    scaleOriginCorner.style.height = scales.widthX +'px';
    containerElem.appendChild(scaleOriginCorner);

    let canvasConfig = {
            container: canvas,
            displayCats,
            canvasWidth,
            canvasHeight,
            xPos,
            yPos,
            range: range};

    itemControl = new ItemControl(canvasConfig, itemData, saver);
};

function updateItems() {
    itemControl.display(xPos, yPos);
};

function addDisplayCategory(category) {
    // If the category is not in the array then add it.
    if (displayCats.indexOf(category) === -1) {
        displayCats.push(category);
    }
    updateItems();
};

function removeDisplayCategory(category) {
    if (displayCats.indexOf(category) !== -1) {
        displayCats.splice(displayCats.indexOf(category), 1);
    }
    updateItems();
};

function setSizeX(x) {
    // Validate x boundary conditions.
    if (x > controls.xMax) x = controls.xMax;
    if (x < 0) x = 0;

    let canvasRange = canvasWidth - outer.clientWidth;
    let xFactor = canvasRange / controls.xMax;
    
    xPos = outer.clientWidth + x * xFactor;
    canvas.style.width = String(xPos) + 'px';
    updateItems();
    updateScaleX(xPos);
};

function setSizeY(y) {
    // Validate y boundary conditions.
    if (y > controls.yMax) x = controls.yMax;
    if (y < 0) y = 0;

    let canvasRange = canvasHeight - outer.clientHeight;
    let yFactor = canvasRange / controls.yMax;
    
    yPos = outer.clientHeight + y * yFactor;
    canvas.style.height = String(yPos) + 'px';
    updateItems();
}

function setPanX(x) {
    // Validate x boundary conditions.
    if (x > controls.xMax) x = controls.xMax;
    if (x < 0) x = 0;

    let panRange = canvas.clientWidth - outer.clientWidth;
    let xFactor = panRange / controls.xMax;

    canvas.style.left = String(0 - x * xFactor) + 'px';
    updateItems();
}

function setPanY(y) {
    // Validate x boundary conditions.
    if (y > controls.yMax) x = controls.yMax;
    if (y < 0) y = 0;

    let panRange = canvas.clientHeight - outer.clientHeight;
    let yFactor = panRange / controls.yMax;
    canvas.style.top = String(0 - y * yFactor) + 'px';

    updateItems();
    updateScaleY(0 - y * yFactor);
};

function updateScaleX(xPos) {
    xScaleDiv.style.width = String(xPos) + 'px';
    let scalePointsX = myScaleX.drawScale();
    drawGridLines('x', scalePointsX);
}

function updateScaleY(top) {
    yScaleDiv.style.top = top + 'px';
    let scalePointsY = myScaleY.drawScale();
    drawGridLines('y', scalePointsY);
}

function drawGridLines(axis, gridPoints) {
    var i;
    var xLine = {},
        yLine = {},
        line = {};

    // Delete all (any) grid lines first.
    let allGridLines = document.querySelectorAll(`.${axis}-line`);
    for (let oneLine of allGridLines) {
        canvas.removeChild(oneLine);
    }

    for (const value of gridPoints) {
        line = document.createElement('div');
        line.setAttribute('class', `${axis}-line grid-line`);
        if (axis === 'x') {
            line.style.height = String(yPos) + 'px';
            // -1 for the border thickness.
            line.style.left = value - 1 + 'px';
        } else if (axis === 'y') {
            line.style.width = String(xPos) + 'px';
            // -1 for the border thickness.
            line.style.top = (yPos - value - 1) + 'px';
        }

        canvas.appendChild(line);
    }
};

function showScales(show) {
    scales.show = show ? true : false;
    setOuterSize();
};

function setOuterSize() {
    if (scales.show) {
        outer.style.width = containerElem.clientWidth - scales.widthY - 2 + 'px';
        outer.style.height = containerElem.clientHeight - scales.widthX - 2 + 'px';
    } else {
        outer.style.width = containerElem.clientWidth + 'px';
        outer.style.height = containerElem.clientHeight + 'px';
    }
}

/**
 * Set the style (template and colour) for a particular item id.
 * 
 * @param {Number} idx - Id of the item to be updated.
 * @param {String} style - An itemStyles object literal name.
 * 
 * @memberof ItemControl
 */
function setStyle(id, style) {
    itemControl.setStyle(id, style);
    updateItems();
}   

function isObject(val) {
    if (val === null) { return false;}
    return ( (typeof val === 'function') || (typeof val === 'object') );
};

export {init, setSizeX, setSizeY, setPanX, setPanY, showScales, addDisplayCategory, removeDisplayCategory, setStyle}