export default class TmUtils {
    /**
     * Gets the itemData array index from 
     * 
     * @param {any} el 
     * @returns 
     */
    static getIdFromElement(el) {
            return el.id.substr(el.id.indexOf("-") + 1);
    }

    /**
     * Utility - Gets the array index of a data item's (in itemData) id property value.
     * 
     * @param {any} id - Data item's id property value.
     * @returns {Number}
     */
    static getIndexFromId(id) {
        for (var i = 0; i < itemData.length; i++) {
            if (itemData[i].id === id) {
                break;
            }
        }
        return i;
    }

    static getIndexFromElement(el) {
        return TmUtils.getIndexFromId(TmUtils.getIdFromElement(el));
    }

    static vleLoad(okCallback, errorCallback) {
        // Check for parameters passed from the structured content document.        
        let activityId = VLE.get_param('activity_id') || VLE.get_param('_a'),
            documentId = VLE.get_param('document_id') || VLE.get_param('_i'),
            courseId = VLE.get_param('course_id') || VLE.get_param('_c');

        VLE.get_server_data(true, ['data'], okCallback, errorCallback, activityId, documentId, courseId);
    }

    static vleSave() {
        let data = {
            matched: [],
            completed: []
        }

        // Pull out the matched and completed info from the main data array.
        for (let item of itemData) {
            if (item.hasOwnProperty('matched')) {
                if (item.matched === true) {
                    data.matched.push(item.id);
                }
            }
            if (item.hasOwnProperty('completed')) {
                if (item.completed === true) {
                    data.completed.push(item.id);
                }
            }
        }

        data = JSON.stringify(data);

        // check for parameters passed from the structured content document.
        let activityId = VLE.get_param('activity_id') || VLE.get_param('_a'),
            documentId = VLE.get_param('document_id') || VLE.get_param('_i'),
            courseId = VLE.get_param('course_id') || VLE.get_param('_c');

        VLE.set_server_data(true, {data},
            () => {
                console.log('Saved to VLE, all good');
            },
            (message) => {
                if (message === null) {
                    // Not on the VLE.
                    console.warn('Not connected to the VLE, cannot save data.');
                } else {
                    console.log('Unable to save data to VLE: ' + message);
                }

                // this.saveError(message);
            },
            this.previousValues, null, this.activityId, this.documentId, this.courseId);
    }

    static stripPx(string) {
        return Number(string.substr(0, string.length - 2));
    }
}