GLOBAL = {};
GLOBAL.slide=1;
GLOBAL.transcripts= [
  "An organism such as an oak has specialised organs such as leaves. These organs also have specific features, such as stomate guard cells that control the exchange of gases between a leaf and the air. Cells themselves contain specialised components called organelles.<br/><br/>The organelle shown here is called a chloroplast, which is unique to plants and other photosynthetic organisms. The following slides examine chloroplast’s abundance and function.",
  "This is a cross-section of a plant cell, with a chloroplast labelled. A plant’s guard cells – which form part of a pore or stomate on the surface of a leaf – often contain a few chloroplasts in a similar density to the stylised cell here. In contrast, cells inside a leaf can be packed with chloroplasts, sometimes numbering in the hundreds.",
  "Chloroplasts replicate inside plant cells in a process facilitated by interacting proteins. These proteins are shown, circling the chloroplasts and then forming a constriction which eventually results in the formation of two chloroplasts. While we don’t know how long this process takes in oaks, in smaller herbaceous plants chloroplast division can occur in under 20 hours in the laboratory.",
  "Chloroplasts are the sites where the reactions of photosynthesis take place. These organelles have evolved to provide the multiple conditions needed for the reactions involved. On the right is a microscope image of a chloroplast showing its size and internal structures, which we will look at in more detail shortly.<br/><br/>Note the scale indicated by the bar provided next to the microscope image. Such bars provide important information when looking at images at all size scales.",
  "Chloroplasts are full of folded membranes known as thylakoids, which provide space for the many reactions that take place here. The membranes form a barrier between two fluids: shown as the stroma and thylakoid lumen. A chemical difference is created between the fluids on either side of the membrane, resulting in a gradient that can be used to power reactions.",
  "Thylakoid membranes are about 30 nm thick. Proteins that span the membrane facilitate some of the reactions of photosynthesis. We won’t go into the details of these, but there are many reactions happening very quickly in these membranes.<br/><br/>The protein on the right of this image is called ATP-synthase because it synthesises an energy-carrying molecule with the acronym ATP. This protein can produce up to 130 molecules in a second!",
  "The protein on the left of this image is a chlorophyll pigment, which captures light to power photosynthesis.<br/><br/>Chlorophyll pigments absorb light in several wavelengths or colours, but reflect wavelengths in the green part of the spectrum (around 500–570 nm). This is why chloroplasts appear green to us. Even though chloroplasts are too small to see with your eye, their sheer abundance and colour make it easy to see where in a plant there are cells containing these organelles."
];
GLOBAL.prevVolume= 0.8;
GLOBAL.isMuted = false;

if(!console)var console={
    log:function(){},
    dir:function(){}
}; //to avoid error on non consolable browsers if I forget to comment out a console.function


(function($) {
    // back and forth buttons
    MediaElementPlayer.prototype.buildback = function(player, controls, layers, media) {
        // create the back button
        var back =
            $('<div class="mejs-button mejs-back-button mejs-back-off">' +
                '<button aria-label="back" title="back" aria-controls="mep_0" type="button"></button>' +
                '</div>')
            // append it to the toolbar
                .appendTo(controls)
                // add a click toggle event
                .click(function() {
                    if (GLOBAL.slide > 1) {
                        var currentlyPlaying = ($('#mediaplayer audio')[0].paused) ? false : true;
                        goToStep(Math.min(GLOBAL.slide-1,GLOBAL.slide-1),currentlyPlaying,'back');
                        //math.min as we could be on step 6, we always want to go back to 4 or less
                    }
                });
    };
    MediaElementPlayer.prototype.buildforth = function(player, controls, layers, media) {
        // create the forth button
        var forth =
            $('<div class="mejs-button mejs-forth-button  mejs-forth-on">' +
                '<button aria-label="forth" title="forth" aria-controls="mep_0" type="button"></button>' +
                '</div>')
                // append it to the toolbar
                .appendTo(controls)
                // add a click event
                .click(function() {
                    if (GLOBAL.slide < 7) {
                        console.log("GLOBAL.slide:"+GLOBAL.slide)
                        var currentlyPlaying = ($('#mediaplayer audio')[0].paused) ? false : true;
                        goToStep(GLOBAL.slide+1,currentlyPlaying,'forth');
                    }
                });
    };
})(jQuery);


$(document).ready(function() {
    $('body').addClass('m160-slide-audio'); //so CSS can distinguish between different activities

    // Set the first slide.
    $( "#image-div").css({
            backgroundImage: "url('images/slide1.jpg')"
    });

    // Set up the first transcript.
    $( "#transcript-blurb").html(GLOBAL.transcripts[0]);
});


function setUpAudio(autoPlay, prevVol){
    if (typeof(prevVol)==='undefined') prevVol=0.8;
    GLOBAL.meplayer = new MediaElementPlayer('#audio_player',{

        pluginPath: 'audio/',
        // initial volume when the player starts
        startVolume: prevVol,
        // enables Flash and Silverlight to resize to content size
        enableAutosize: true,
        // the order of controls you want on the control bar (and other plugins below)
        features: ['back','forth','playpause','progress','tracks','volume'],
        // Hide controls when playing and mouse is not over the video
        alwaysShowControls: true,
        // force iPad's native controls
        iPadUseNativeControls: false,
        // force iPhone's native controls
        iPhoneUseNativeControls: false,
        // force Android's native controls
        AndroidUseNativeControls: false,
        // forces the hour marker (##:00:00)
        alwaysShowHours: false,
        // show framecount in timecode (##:00:00:00)
        showTimecodeFrameCount: false,
        // used when showTimecodeFrameCount is set to true
        framesPerSecond: 25,
        // turns keyboard support on and off for this instance
        enableKeyboard: true,
        // when this player starts, it will pause other players
        pauseOtherPlayers: true,
        //timer rate, used for polling key points
        timerRate: 200,
        //language
        startLanguage:'en',
        //muted value needs to be stored and re-applied
        muted: GLOBAL.isMuted,
        // array of keyboard commands
        keyActions: [],
        success: function(me) {

            GLOBAL.keyPointStep = -1;
            GLOBAL.keyPointOffset = -1;
            var numOfKeyPoints = Object.keys(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints).length;

            me.addEventListener('timeupdate', function (e) {

                if (numOfKeyPoints > 0) {  //we have keypoints in the audio
                    //console.log('we have keypoints');
                    //interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints.forEach( function(el,index,el) {
                    $.each(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints, function(index,el) {

                        if ((me.currentTime > el.time)  && (index > GLOBAL.keyPointOffset)) {
                            GLOBAL.keyPointOffset = index;
                            return false;
                        }
                    });
                    if (GLOBAL.keyPointStep !== GLOBAL.keyPointOffset) {
                        eval(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints[GLOBAL.keyPointOffset].script);
                        GLOBAL.keyPointStep = GLOBAL.keyPointOffset;
                    }
                }
            }, false);

            $("#mediaplayer audio").bind("ended", function() {
               //me.removeEventListener('timeupdate', arguments.callee);
                GLOBAL.prevVolume=me.volume;
                GLOBAL.isMuted = me.muted;
                (GLOBAL.slide < 7) ? goToStep(GLOBAL.slide+1,true,'forth') : GLOBAL.slide = 8;
            });
            $("#mediaplayer audio").bind("play", function() {
                if (GLOBAL.slide === 8) setUpSlide(1);
                setTimeout('GLOBAL.meplayer.setMuted('+GLOBAL.isMuted+')',50) ;
            })
            if (autoPlay) me.play();
        }
    });

}


function goToStep(stepNum,autoPlay,dir) {
    $('#folio').text(stepNum);

    GLOBAL.slide = stepNum;
    setTimeout(function() {
        switchAudio(stepNum,autoPlay);
    }, 1500);
    switchImage(stepNum);

    $( "#transcript-blurb").html(GLOBAL.transcripts[stepNum-1]);
    // Make sure the transcript div is scrolled to the top.
    $("#transcript-blurb").scrollTop(0);

    // $( "#captions-div .caption-step").hide();
    // $( "#captions-div #captions-"+stepNum).show();

    setTimeout('updateButtons('+stepNum+',"'+dir+'")',20);
}

function updateButtons(stepNum, dir) {

    if ((stepNum=== 7) && (dir === 'forth')) {
        $('.mejs-button.mejs-forth-button').removeClass('mejs-forth-on').addClass('mejs-forth-off');
        $('.mejs-button.mejs-back-button').addClass('mejs-back-on').removeClass('mejs-back-off');
    } else if ((stepNum=== 1) && (dir === 'back')) {
        $('.mejs-button.mejs-back-button').removeClass('mejs-back-on').addClass('mejs-back-off');
    } else {
        $('.mejs-button.mejs-forth-button').addClass('mejs-forth-on').removeClass('mejs-forth-off');
        $('.mejs-button.mejs-back-button').addClass('mejs-back-on').removeClass('mejs-back-off');
    }

}


/*function goNextStep() {
    GLOBAL.slide++;

    if (GLOBAL.slide<6) {
        switchAudio(GLOBAL.slide,true);
        switchImage(GLOBAL.slide);
        $( "#transcript").text(GLOBAL.transcripts[GLOBAL.slide-1]);
    } else {//finished final slide
        switchAudio(1,false);
        switchImage(1);
        GLOBAL.slide = 1;
    }
}*/

function playVideo() {
    console.log("hello matey, playVideo");
    GLOBAL.meplayer.play();
}

function switchAudio(slideNum,autoPlay) {

    //GLOBAL.meplayer.setSrc("audio/slide"+slideNum+".mp3");
    //GLOBAL.meplayer.media.load(); //4 hours later!! christ almighty this api is appallingly (un)-documented

    $("#mediaplayer").html("<audio id='audio_player' src='audio/slide"+slideNum+".mp3' type='audio/mp3' controls='controls' width='750'></audio>");
    //$("#mediaplayer audio").prop("src", "audio/slide"+slideNum+".mp3");
    setUpAudio(autoPlay, GLOBAL.prevVolume);
    //if (autoPlay) GLOBAL.meplayer.play();
}


function switchImage(slideNum) {
    $( "#image-div").css({
            backgroundImage: "url('images/slide" + slideNum + ".jpg')"
    });
            


    // $("#overlaid-image img").attr("src","images/slide"+slideNum+".jpg");

    // if ((slideNum === 1) || (slideNum === 6))  {
    //     $( "#image-div" ).removeAttr('style');//clear jquery.animate()
    //     $( "#overlay-image-div").hide();
    //     $( "#captions-1" ).show();
    // } else if (slideNum === 5) {
    //     $( "#image-div").removeAttr('style').css({
    //         left: "2px",
    //         top: "-35px",
    //         height: "720px",
    //         width: "720",
    //         backgroundImage: "url('images/m-160-bg-5.jpg')"
    //     });
    //     $( "#overlay-image-div").hide();
    // } else {
        // $( "#image-div").css({
        //     left: "-212px",
        //     top: "-300px",
        //     height: "1374px",
        //     width: "767px",
        //     backgroundImage: "url('images/m-160-bg.jpg')"
        // });
        // $( "#overlay-image-div").show();
    
}

function setUpSlide(slideNum) {
    console.log('set up slide')
    $('#folio').text(slideNum);
    switchAudio(slideNum,true);
    switchImage(slideNum);
    $( "#transcript-blurb").html(GLOBAL.transcripts[slideNum-1]);
    if (slideNum === 1) {
        $('.mejs-button.mejs-back-button').removeClass('mejs-back-on').addClass('mejs-back-off');
        $('.mejs-button.mejs-forth-button').addClass('mejs-forth-on').removeClass('mejs-forth-off');
    }
    GLOBAL.slide = 1;
    $( "#image-div" ).removeAttr('style');//clear jquery.animate()
}


//  -----------------  animations  ---------------------------  //

function zoomInOnWheat() {
    console.log('zoomInOnWheat')

    $( "#image-div").removeAttr('style');//clear jquery.animate()
    $( "#captions-1" ).hide();
    $( "#image-div").animate({
        left: "-212px",
        top: "-300px",
        height: "1374px",
        width: "767px"
    }, 1500, function() {
        //$( "#overlay-image-div").show();
        $( "#captions-1" ).hide();
    });
}