GLOBAL = {};
GLOBAL.slide=1;
GLOBAL.transcripts= [
    "Earth, our planet, has a mean radius of 6371 km. While we tend to think of it as round, the Earth is not a perfect sphere – its diameter is slightly bigger at the Equator than at the poles. Radiometric dating, which uses isotopes to determine the age of materials, indicates that the Earth is around 4.54 billion years old.",
    "Earth has a very hot core consisting chiefly of iron, while the layers known as the mantle and crust are much cooler by comparison. Much of the planet’s surface is covered by water and it is the only planet on which life is known to exist. It is surrounded by a gaseous atmosphere, the composition of which is dominated by nitrogen and oxygen.",
    "The Earth spins on an axis and completes one rotation in 24 hours. It also orbits the Sun in a 940 million km trajectory that takes 365.25 days.<br/><br/>It is the Earth’s rotation, relative to the position of the Sun, which gives us day and night. The Sun appears to rise and set as different parts of the planet turn towards or away from it.",
    "The axis on which the Earth spins is at a 23.4° angle to the plane of its orbit. This angle, coupled with the Earth’s orbit, causes seasonal variation to occur.<br/><br/>Locations towards the poles experience big differences in day length compared to those closer to the Equator. Poleward locations have very long days during their summers and almost continual night in midwinter, so, in December, the North Pole remains in darkness while the South Pole is always illuminated by the Sun. The length of days and nights changes less throughout the year at locations that are close to the Equator.<br/><br/>This variation in day length and temperature over the year is one factor contributing to the diversity of environments on Earth, and hence the evolution of different plant and animal species across the globe.",
    "It is often convenient to consider Earth as a flat projection rather than a 3D object, especially when comparing locations. Any location can be defined in terms of its latitude and longitude, both of which are measured in degrees, relative to specific points on the planet.<br/><br/>The zero line for latitude is the Equator, and latitude extends 90° north and 90° south of this line to the poles. The zero degree line for longitude is called the prime meridian, and passes through Greenwich in England. From here, longitude values extend 180° both to the east and west, adding up to 360° around the world.<br/><br/>In the example shown here, lines of latitude and longitude have been overlaid.",
    "As an example of how latitude and longitude can be used to describe location, High Park, at Blenheim Palace in central England, is situated at 51.84° north of the Equator and 1.36° west of the prime meridian. Therefore it is more than halfway to the North Pole from the Equator, and not very far west of the prime meridian.<br/><br/>Satellite observation techniques make it possible to calculate longitude and latitude to a high level of precision (namely to numerous significant figures). This information can be used for both scientific and commercial purposes.",
    "Locations at the same latitude as each other experience the same day lengths at a given point in the year, while locations at the same longitude are in similar time zones. So, when it is 09:00 in Stockholm, Sweden (59.33° N, 18.07° E), it is the same time in Cape Town, South Africa (33.92° S, 18.42° E).<br/><br/>Today, we can fly quickly from one part of the Earth to the other, which means we can experience very different seasons and day lengths within a single 24 hour period. Long haul flights are planet-sized voyages, and provide an opportunity to observe how the spin and orbit of the planet affects life on Earth."
    ];
GLOBAL.prevVolume= 0.8;
GLOBAL.isMuted = false;

if(!console)var console={
    log:function(){},
    dir:function(){}
}; //to avoid error on non consolable browsers if I forget to comment out a console.function


(function($) {
    // back and forth buttons
    MediaElementPlayer.prototype.buildback = function(player, controls, layers, media) {
        // create the back button
        var back =
            $('<div class="mejs-button mejs-back-button mejs-back-off">' +
                '<button aria-label="back" title="back" aria-controls="mep_0" type="button"></button>' +
                '</div>')
            // append it to the toolbar
                .appendTo(controls)
                // add a click toggle event
                .click(function() {
                    if (GLOBAL.slide > 1) {
                        var currentlyPlaying = ($('#mediaplayer audio')[0].paused) ? false : true;
                        goToStep(Math.min(GLOBAL.slide-1,GLOBAL.slide-1),currentlyPlaying,'back');
                    }
                });
    };
    MediaElementPlayer.prototype.buildforth = function(player, controls, layers, media) {
        // create the forth button
        var forth =
            $('<div class="mejs-button mejs-forth-button  mejs-forth-on">' +
                '<button aria-label="forth" title="forth" aria-controls="mep_0" type="button"></button>' +
                '</div>')
                // append it to the toolbar
                .appendTo(controls)
                // add a click event
                .click(function() {
                    if (GLOBAL.slide < interactiveData.interactivities.steps.length) {
                        console.log("GLOBAL.slide:"+GLOBAL.slide)
                        var currentlyPlaying = ($('#mediaplayer audio')[0].paused) ? false : true;
                        goToStep(GLOBAL.slide+1,currentlyPlaying,'forth');
                    }
                });
    };
})(jQuery);


$(document).ready(function() {
    $('body').addClass('m160-slide-audio'); //so CSS can distinguish between different activities

    // Set the first slide.
    $( "#image-div").css({
            backgroundImage: "url('images/"+interactiveData.interactivities.steps[0].img+"')"
    });

    // Set up the first transcript.
    $( "#transcript-blurb").html(GLOBAL.transcripts[0]);
});


function setUpAudio(autoPlay, prevVol){
    if (typeof(prevVol)==='undefined') prevVol=0.8;
    GLOBAL.meplayer = new MediaElementPlayer('#audio_player',{

        pluginPath: 'audio/',
        // initial volume when the player starts
        startVolume: prevVol,
        // enables Flash and Silverlight to resize to content size
        enableAutosize: true,
        // the order of controls you want on the control bar (and other plugins below)
        features: ['back','forth','playpause','progress','tracks','volume'],
        // Hide controls when playing and mouse is not over the video
        alwaysShowControls: true,
        // force iPad's native controls
        iPadUseNativeControls: false,
        // force iPhone's native controls
        iPhoneUseNativeControls: false,
        // force Android's native controls
        AndroidUseNativeControls: false,
        // forces the hour marker (##:00:00)
        alwaysShowHours: false,
        // show framecount in timecode (##:00:00:00)
        showTimecodeFrameCount: false,
        // used when showTimecodeFrameCount is set to true
        framesPerSecond: 25,
        // turns keyboard support on and off for this instance
        enableKeyboard: true,
        // when this player starts, it will pause other players
        pauseOtherPlayers: true,
        //timer rate, used for polling key points
        timerRate: 200,
        //language
        startLanguage:'en',
        //muted value needs to be stored and re-applied
        muted: GLOBAL.isMuted,
        // array of keyboard commands
        keyActions: [],
        success: function(me) {

            GLOBAL.keyPointStep = -1;
            GLOBAL.keyPointOffset = -1;
            var numOfKeyPoints = Object.keys(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints).length;

            me.addEventListener('timeupdate', function (e) {

                if (numOfKeyPoints > 0) {  //we have keypoints in the audio
                    //console.log('we have keypoints');
                    //interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints.forEach( function(el,index,el) {
                    $.each(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints, function(index,el) {

                        if ((me.currentTime > el.time)  && (index > GLOBAL.keyPointOffset)) {
                            GLOBAL.keyPointOffset = index;
                            return false;
                        }
                    });
                    if (GLOBAL.keyPointStep !== GLOBAL.keyPointOffset) {
                        eval(interactiveData.interactivities.steps[GLOBAL.slide -1].keyPoints[GLOBAL.keyPointOffset].script);
                        GLOBAL.keyPointStep = GLOBAL.keyPointOffset;
                    }
                }
            }, false);

            $("#mediaplayer audio").bind("ended", function() {
               //me.removeEventListener('timeupdate', arguments.callee);
                GLOBAL.prevVolume=me.volume;
                GLOBAL.isMuted = me.muted;
                (GLOBAL.slide < interactiveData.interactivities.steps.length) ? goToStep(GLOBAL.slide+1,true,'forth') : GLOBAL.slide = interactiveData.interactivities.steps.length+1;
            });
            $("#mediaplayer audio").bind("play", function() {
                if (GLOBAL.slide === interactiveData.interactivities.steps.length+1) setUpSlide(1);
                setTimeout('GLOBAL.meplayer.setMuted('+GLOBAL.isMuted+')',50) ;
            })
            if (autoPlay) me.play();
        }
    });

}


function goToStep(stepNum,autoPlay,dir) {

    $('#folio').text(stepNum);

    GLOBAL.slide = stepNum;
    setTimeout(function() {
        switchAudio(stepNum,autoPlay);
    }, 1500);
    switchImage(stepNum);

    $( "#transcript-blurb").html(GLOBAL.transcripts[stepNum-1]);
    // Make sure the transcript div is scrolled to the top.
    $("#transcript-blurb").scrollTop(0);

    // $( "#captions-div .caption-step").hide();
    // $( "#captions-div #captions-"+stepNum).show();

    setTimeout('updateButtons('+stepNum+',"'+dir+'")',20);
}

function updateButtons(stepNum, dir) {

    if ((stepNum=== interactiveData.interactivities.steps.length) && (dir === 'forth')) {
        $('.mejs-button.mejs-forth-button').removeClass('mejs-forth-on').addClass('mejs-forth-off');
        $('.mejs-button.mejs-back-button').addClass('mejs-back-on').removeClass('mejs-back-off');
    } else if ((stepNum=== 1) && (dir === 'back')) {
        $('.mejs-button.mejs-back-button').removeClass('mejs-back-on').addClass('mejs-back-off');
    } else {
        $('.mejs-button.mejs-forth-button').addClass('mejs-forth-on').removeClass('mejs-forth-off');
        $('.mejs-button.mejs-back-button').addClass('mejs-back-on').removeClass('mejs-back-off');
    }

}


/*function goNextStep() {
    GLOBAL.slide++;

    if (GLOBAL.slide<6) {
        switchAudio(GLOBAL.slide,true);
        switchImage(GLOBAL.slide);
        $( "#transcript").text(GLOBAL.transcripts[GLOBAL.slide-1]);
    } else {//finished final slide
        switchAudio(1,false);
        switchImage(1);
        GLOBAL.slide = 1;
    }
}*/

function playVideo() {
    console.log("hello matey, playVideo");
    GLOBAL.meplayer.play();
}

function switchAudio(slideNum,autoPlay) {

    //GLOBAL.meplayer.setSrc("audio/slide"+slideNum+".mp3");
    //GLOBAL.meplayer.media.load(); //4 hours later!! christ almighty this api is appallingly (un)-documented

    $("#mediaplayer").html("<audio id='audio_player' src='audio/slide"+slideNum+".mp3' type='audio/mp3' controls='controls' width='750'></audio>");
    //$("#mediaplayer audio").prop("src", "audio/slide"+slideNum+".mp3");
    setUpAudio(autoPlay, GLOBAL.prevVolume);
    //if (autoPlay) GLOBAL.meplayer.play();
}


function switchImage(slideNum) {
    $( "#image-div").css({
      backgroundImage: "url('images/"+interactiveData.interactivities.steps[slideNum-1].img+"')"
    });
            


    // $("#overlaid-image img").attr("src","images/slide"+slideNum+".jpg");

    // if ((slideNum === 1) || (slideNum === 6))  {
    //     $( "#image-div" ).removeAttr('style');//clear jquery.animate()
    //     $( "#overlay-image-div").hide();
    //     $( "#captions-1" ).show();
    // } else if (slideNum === 5) {
    //     $( "#image-div").removeAttr('style').css({
    //         left: "2px",
    //         top: "-35px",
    //         height: "720px",
    //         width: "720",
    //         backgroundImage: "url('images/m-160-bg-5.jpg')"
    //     });
    //     $( "#overlay-image-div").hide();
    // } else {
        // $( "#image-div").css({
        //     left: "-212px",
        //     top: "-300px",
        //     height: "1374px",
        //     width: "767px",
        //     backgroundImage: "url('images/m-160-bg.jpg')"
        // });
        // $( "#overlay-image-div").show();
    
}

function setUpSlide(slideNum) {
    console.log('set up slide')
    $('#folio').text(slideNum);
    switchAudio(slideNum,true);
    switchImage(slideNum);
    $( "#transcript-blurb").html(GLOBAL.transcripts[slideNum-1]);
    if (slideNum === 1) {
        $('.mejs-button.mejs-back-button').removeClass('mejs-back-on').addClass('mejs-back-off');
        $('.mejs-button.mejs-forth-button').addClass('mejs-forth-on').removeClass('mejs-forth-off');
    }
    GLOBAL.slide = 1;
    $( "#image-div" ).removeAttr('style');//clear jquery.animate()
}


//  -----------------  animations  ---------------------------  //

function zoomInOnWheat() {
    console.log('zoomInOnWheat')

    $( "#image-div").removeAttr('style');//clear jquery.animate()
    $( "#captions-1" ).hide();
    $( "#image-div").animate({
        left: "-212px",
        top: "-300px",
        height: "1374px",
        width: "767px"
    }, 1500, function() {
        //$( "#overlay-image-div").show();
        $( "#captions-1" ).hide();
    });
}