// let tmUtils = require('./tm-utils.js');
import TmUtils from './tmUtils.js';

let stretchy = {};

/**
 * Initialise the activity.
 * 
 * @param {Object} stretchyInstance - Instance of stretchy.
 */
function init(stretchyInstance) {
    stretchy = stretchyInstance;

    let activityItems = itemData.filter((item) => {
            return item.category === 'activity'
        });

    // Create the activity items in the side panel.
    let sidePanelContent = document.querySelector('#sidepanel-content');
    for (let activityItem of activityItems) {
        let activityItemDiv = document.createElement('div');
        activityItemDiv.setAttribute('class', 'sidepanel-activity-item tabindex-change');
        activityItemDiv.setAttribute('id', `activity-${activityItem.id}`);
        activityItemDiv.setAttribute('tabindex', '-1');

        let label = document.createTextNode(`${activityItem.title}`);
        let labelSpan = document.createElement('span');
        labelSpan.setAttribute('class', 'sidepanel-activity-item-title');
        labelSpan.appendChild(label);

        let tickSpan = document.createElement('span');
        tickSpan.setAttribute('class', 'icon-checkmark activity-matched-tick');

        activityItemDiv.appendChild(labelSpan);
        activityItemDiv.appendChild(tickSpan);
        sidePanelContent.appendChild(activityItemDiv);

        if (activityItem.matched) {
            sidepanelItemMatch(activityItemDiv);
            canvasItemMatch(activityItem.id);
        }
    }

    document.querySelector('#mySidenav').addEventListener('click', (e) => {
        highlightSidenavActivityItem(e);
    });

    document.querySelector('#mySidenav').addEventListener('keydown', (e) => {
        if (e.which === 13 || e.which === 32) {
            highlightSidenavActivityItem(e);
        }
    });

    document.querySelector('#stretchy-canvas').addEventListener('click', (e) => {
        highlightCanvasActivityItem(e);
    });

    document.querySelector('#stretchy-canvas').addEventListener('keydown', (e) => {
        if (e.which === 13 || e.which === 32) {
            highlightCanvasActivityItem(e);
        }
    });

    document.getElementById('side-panel-close-button').addEventListener('click', toggleSidePanel, false);
    document.getElementById('side-panel-close').addEventListener('click', toggleSidePanel, false);
    document.getElementById('side-panel-open').addEventListener('click', toggleSidePanel, false);
}

function highlightSidenavActivityItem(e) {
    let classes = e.target.classList
    if (classes.contains('sidepanel-activity-item')) {
        highlightOne(e.target, 'clicked', 'sidepanel-activity-item')
    } else if (classes.contains('sidepanel-activity-item-title')) {
        highlightOne(e.target.parentNode, 'clicked', 'sidepanel-activity-item');
    } else {
        removeClassAll('clicked', 'sidepanel-activity-item');
    }
}

function highlightCanvasActivityItem(e) {
    let classes = e.target.classList
    if (classes.contains('item-activity')) {
        highlightOne(e.target, 'clicked', 'item-activity');
    } else {
        removeClassAll('clicked', 'item-activity');
    }
}

function checkActivity() {
    let activityItem = document.querySelector('#stretchy-canvas .clicked');
    let sidepanelItem = document.querySelector('#sidepanel-content .clicked');
    let idx;

    if (activityItem !== null && sidepanelItem !== null) {
        let activityItemId = activityItem.id.substr(activityItem.id.indexOf("-") + 1)
        let sidepanelItemId = sidepanelItem.id.substr(sidepanelItem.id.indexOf("-") + 1)

        if (activityItemId === sidepanelItemId) {
            
            // Set the canvas item style.
            canvasItemMatch(activityItemId);

            // Set the side panel item style.
            sidepanelItemMatch(sidepanelItem);
            
            // Save to the data file, and to the VLE.
            itemData[TmUtils.getIndexFromId(activityItemId)].matched = true;
            TmUtils.vleSave();
        } else {
            // No match.
        }
    }
}

function canvasItemMatch(activityItemId) {
    // Set the canvas item style.
    stretchy.setStyle(TmUtils.getIndexFromId(activityItemId), 'activityComplete');
}

function sidepanelItemMatch(sidepanelItem) {
    sidepanelItem.lastChild.classList.add('tick-visible');
    sidepanelItem.classList.add('matched');
    sidepanelItem.classList.remove('clicked');
}

function clearMatched() {
    let items = document.querySelectorAll('.sidepanel-activity-item.matched');
    for (let item of items) {
        // Clear side panel items.
        item.classList.remove('matched');
        item.lastChild.classList.remove('tick-visible');

        // Reset canvas activity items.
        let id = item.id.substr(item.id.indexOf("-") + 1);
        stretchy.setStyle(TmUtils.getIndexFromId(id), 'activity');

        itemData[TmUtils.getIndexFromId(id)].matched = false;
    }

    TmUtils.vleSave();
}

function toggleSidePanel(event) {
    let sidePanelOpen = document.getElementById('side-panel-open');
    let sidePanelClose = document.getElementById('side-panel-close');
    let mySidenav = document.getElementById("mySidenav");

    if (mySidenav.clientWidth === 0) {
        mySidenav.style.width = '300px';
        mySidenav.style.boxShadow = '-3px 0 10px #cccccc';
        sidePanelOpen.style.display = 'none';
        sidePanelClose.style.display = 'inline';
        showActivityItems();
        setTabindex('0');
        // document.querySelector('div#mySidenav .closebtn').focus();
        let menuText = document.getElementById('menu-toggle-activity-panel-text');
        menuText.innerHTML = 'Close activity panel'
    } else {
        mySidenav.style.width = '0';
        mySidenav.style.boxShadow = 'none';
        sidePanelOpen.style.display = 'inline';
        sidePanelClose.style.display = 'none';
        // stretchy.removeDisplayCategory('activity');
        hideActivityItems();
        setTabindex('-1');
        let menuText = document.getElementById('menu-toggle-activity-panel-text');
        menuText.innerHTML = 'Open activity panel'
    }
}

function showActivityItems() {
    stretchy.addDisplayCategory('activity');
}

function hideActivityItems() {
    let checkBox = document.getElementById('always-show');
    if (!checkBox.checked) {
        stretchy.removeDisplayCategory('activity');
    }
}

function setTabindex(value) {
    let elements = document.querySelectorAll('div#mySidenav .tabindex-change');
    for (let el of elements) {
        el.setAttribute('tabindex', value);
    }
}

function highlightOne(elemClicked, highlightClass, selectClass) {
    if (elemClicked.classList.contains(highlightClass)) {
        elemClicked.classList.remove(highlightClass);
    } else {
        removeClassAll(highlightClass, selectClass);

        elemClicked.classList.add(highlightClass);
        checkActivity();
    }
}

function removeClassAll(remove, selectClass) {
    let allElements = document.querySelectorAll(`.${selectClass}`);
    for (let element of allElements) {
        element.classList.remove(remove);
    }
}

export {init, clearMatched, toggleSidePanel}