require('classlist-polyfill');
let media = require('./modal.js');
import Tooltip from 'tooltip.js';

export default class ItemLabel {
    constructor(canvas, canvasWidth, canvasHeight, xPos, yPos, itemData, range) {
        this.canvas = canvas;
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.xPos = xPos;
        this.yPos = yPos;
        this.itemData = itemData;
        this.range = range;
        this.itemDiv = {};

        this.init();
    }

    init() {
        let iconsDiv = document.createElement('div');
        iconsDiv.setAttribute('class', 'icons');

        let label = document.createTextNode(this.itemData.title);
        let labelSpan = document.createElement('span');
        labelSpan.setAttribute('class', 'item-title-label');
        labelSpan.appendChild(label);
        
        
        this.itemDiv = document.createElement('div');
        this.itemDiv.setAttribute('class', 'item item-label');
        this.itemDiv.setAttribute('id', `item-${this.itemData.id}`);
        if (this.itemData.style.curColour !== undefined && this.itemData.style.curColour !== '') {
            // TODO: replace this with addClass code on classlist.
            this.itemDiv.setAttribute('class', `item-label item-label-${this.itemData.style.curColour}`);
        }

        this.itemDiv.appendChild(labelSpan);
        this.canvas.appendChild(this.itemDiv);

        this.itemDiv.addEventListener('click', (e) => {
            ItemCommon.increaseItemZindex(e.target);
        })

        // this.update(this.xPos, this.yPos);
    }

    update(xPos, yPos) {
        this.xPos = xPos;
        this.yPos = yPos;

        // Calculate the x axis start and end position.
        let logStart = Math.log10(this.itemData.xStart || this.range.x.min),
            logEnd = Math.log10(this.itemData.xEnd),
            logMin = Math.log10(this.range.x.min),
            logRange = Math.log10(this.range.x.max) - logMin;
        let xStart = (logStart-logMin) / logRange * this.xPos;
        let xEnd = (logEnd - logMin) / logRange * this.xPos;

        this.itemDiv.style.left = xStart + 'px';
        this.itemDiv.style.width = (xEnd - xStart) + 'px';

        // Calculate the y axis start and end position.
        logStart = Math.log10(this.itemData.yStart || this.range.y.min);
        // logEnd = Math.log10(this.itemData.yEnd);
        logMin = Math.log10(this.range.y.min);
        logRange = Math.log10(this.range.y.max) - logMin;
        let yStart = this.canvasHeight - (logStart - logMin) / logRange * this.yPos;
        // Adjust for the marker.
        yStart -= (this.itemDiv.offsetHeight / 2) + 1;

        this.itemDiv.style.top = yStart + 'px';
    }

    show() {
        this.itemDiv.style.display = 'block';
    }

    hide() {
        this.itemDiv.style.display = 'none';
    }

    /**
     * Deletes this instance's div from the DOM.
     * TODO: Currently there is no way to add it back from within this instance.
     * @memberof Item
     */
    delete() {
        this.itemDiv.parentNode.removeChild(this.itemDiv);
    }

    /**
     * Returns the div width of this item.
     * 
     * @returns {Number} Width the div.
     * 
     * @memberof Item
     */
    getWidth() {
        return this.itemDiv.offsetWidth;
    }
}