OU.util.ModalInfo = function() {
    var modalInfoDiv = null,
            maskDiv = null;

    OU.util.ModalInfo.prototype.remove = function() {
        if (modalInfoDiv) { // close any current info boxes
            modalInfoDiv.remove();
            modalInfoDiv = null;
        }
        if (maskDiv) {
            maskDiv.remove();
            maskDiv = null;
        }
    };
    OU.util.ModalInfo.prototype.view = function(content, event) {
        this.remove();
        if (typeof content === 'string') {
            content = {
                html: content
            };
        }
        if (typeof content === 'object' && content.html) {
            var modalInfo = this,
                    html = content.html,
                    maskColour = content.maskColour || 'rgba(0, 0, 0, 0)',
                    x, y, w;
            w = content.width || 200;
            if (event && event.x !== undefined && event.y !== undefined) {
                x = event.x - w / 2;
                y = event.y - 40;
            }
            else {
                x = window.innerWidth / 2 - w / 2;
                y = window.innerHeight / 3;
            }
            y = y < 10 ? 10 : y;
            x = x < 10 ? 10 : (x > window.innerWidth - w - 10 ? window.innerWidth - w - 10 : x);

            maskDiv = new OU.util.Div({
                style: 'background:' + maskColour,
                zIndex: OU.POP_UP_LEVEL
            });
            modalInfoDiv = new OU.util.Div({
                x: x,
                y: y,
                w: w,
                h: 'auto',
                style: 'background:#fff;color:#222;padding:10px;border:1px solid #666;border-radius:10px;',
                htmlClass: 'fastease',
                zIndex: OU.POP_UP_LEVEL + 10,
                innerHTML: html
            });
            setTimeout(function() {
                if (maskDiv) {
                    OU.events.addListener(maskDiv.div, function() {
                        modalInfo.remove();
                    });
                }
            }, 1000);
            var boxH = modalInfoDiv.div.clientHeight;
            if (y + boxH > window.innerHeight) {
                modalInfoDiv.resize({
                    x: x,
                    y: window.innerHeight - boxH - 40,
                    w: w,
                    h: boxH + 10
                });
            }

        }
    };
};
