/**
 * Keyboard - Keyboard for formatted unicode text input (sub,sup,i,b,u)
 *
 *
 * @author Will Rawes
 */

OU.require('OU.util.DynText');
OU.require('OU.util.Layer');
OU.require('OU.util.Div');
/**
 * @class Keyboard for formatted unicode text input (sub,sup,i,b,u)
 *
 *
 * @param {object} params - options, examples by Will:
 *              keys:"7\u00a08\u00a09\u00a0\n 4\u00a05\u00a06\u00a0\n 1\u00a02\u00a03\u00a0\n 0\u00a0.\u00a0", // is a number pad
 *              calculate:true,
 *              scientific:true,
 *              ok:true,
 *              background:'#fcfcfc',
 *              formatting:false,
 *              unicode:false,
 *              space:false,
 *              specials:false,
 * <ul>
 * <li><strong>{object} container:</strong> (required) The calling object, typically an OU.util.Activity</li>
 * <li><strong>{int} zIndex:</strong> (optional) zIndex for the layer used for display, defaults to OU.DATA_LEVEL</li>
 * </ul>
 */
OU.util.Keyboard = function ( params ) {
    var self = this;
    if (params===undefined)params = {};
    this.container = params.container || {};
    this.zIndexStart = params.zIndex || OU.DATA_LEVEL;
    this.zOffset = this.container.zOffset || 0;
    this.zIndexStart = this.zIndexStart + this.zOffset + 10;
    if (this.container.controller!==undefined && this.container.controller.activities!==undefined && this.container.controller.activities[this.container.instance]!==undefined && this.container.controller.activities[this.container.instance]._zOffset!==undefined) {
        this.zOffset = this.container.controller.activities[this.container.instance]._zOffset;
        this.zIndexStart = this.zIndexStart + this.zOffset;
    }
    else {
        this.zOffset = this.zIndexStart;
    }
    this.params = params;
    this.style = params.style || '';
    this.addStyle = '';
    this.nChars=0;
    if (params.overflow!==undefined)
        this.addStyle = 'overflow:' + params.overflow + '; ';
    /**
     * @WillCode Some "Will code", please see Will Rawes if you need to maintain or change this code.
     * @private
     */
    OU.util.Keyboard.prototype.init = function ( params ) {
        var i, j, txt, fn;
        this.newLs = [];
        this.maxChars=this.params.maxChars;
        if (this.params.calculate){
            this.maxChars=10;
            this.keys0 = "7\u00a08\u00a09\u00a0+\u00a0\n 4\u00a05\u00a06\u00a0-\u00a0\n 1\u00a02\u00a03\u00a0×\u00a0\n 0\u00a0.\u00a0E\u00a0÷\u00a0";
        }else if (this.params.numbers){
            this.maxChars=10;

            this.keys0 = "7\u00a08\u00a09\u00a0\n 4\u00a05\u00a06\u00a0\n 1\u00a02\u00a03\u00a0\n 0\u00a0.\u00a0-\u00a0\n E\u00a0";
        }else this.keys0 = (this.params.keys || "`̱1!2\"3£4$5%6^7&8*9(0)-_=+\n Q W E R T Y U I O P {[}]\n A S D F G H J K L ;:'@#~\n \\|Z X C V B N M ,<.>/?");
        j = 0;
        this.nRows = 1;
        for (i = 0; i < this.keys0.length; i += 2)
            if (this.keys0[i]==='\n') {
                this.newLs.push((j));
                this.nRows++;
            }
            else j++;
        this.keys0 = this.keys0.replace(/\n /g, "");
        this.keys = this.keys0;
        this.uniCOffs = 0;
        this.space = (params.space!==false);
        this.unicode = (params.unicode!==false);
        this.formatting = (params.formatting!==false);
        this.shift = (params.shift!==false);
        this.enter = (params.enter!==false);
        this.isWeb = 0;
        if (params===undefined)
            params = {};
        var x = params.x || 0,
            y = params.y || 0,
            w = params.w * 1.2 || 480,
            h = params.h || 360;
        this.w = w * params.container.w;
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        if (params.dontRegister===undefined || params.dontRegister===false) {
                OU.addRemovable(this, this.zOffset);
        }
        this.layer = new OU.util.Layer({
            container:this.container,
            hasEvents:true,
            zIndex:this.zIndexStart + 1
        });
        this.selDiv = new OU.util.Div({
            container:this.container,
            zIndex:this.zIndexStart,
            showScroll:false
        });
        this.div = new OU.util.Div({
            container:this.container,
            zIndex:this.zIndexStart + 2,
            style:"position:absolute;background:#fff;border:solid 1px;border-radius:3px;padding:0px;overflow:visible;display:block;",
            showScroll:false
        });
        this.div.div.tabIndex = 1;
        this.selDiv.div.className = "gpd";
        this.kb = [];
        this.shift = false;
        this.closeB = this.newButton("×", null
            , function () {
                self.nChars=0;
                if (OU.thsKP)OU.thsKP.dispDiv.style.border = 'solid 1px';
                self.setVisible(false);
            });
        for (i = 0; i < this.keys.length / 2; i++) {
            j = i * 2;
            txt = (this.keys[j + 1]===" " ? this.keys[j] : this.keys[j]) + (this.keys[j + 1]!=="\u00a0" ? " <sup>" + this.keys[j + 1] + "</sup>" : "");
            fn = function ( th ) {
                th[0].nChars++;
                if(th[0].maxChars){
                    if(th[0].nChars>th[0].maxChars)return;
                }
                var n1 = th[0].keys.charCodeAt(th[1] * 2)
                    , n2 = th[0].keys.charCodeAt(th[1] * 2 + 1)
                    , s1 = String.fromCharCode(n1)
                    , s2 = String.fromCharCode(n2)
                    , s;
                if (s1==="<")s1 = "&lt;";
                if (s2==="<")s2 = "&lt;";
                if (s1===">")s1 = "&gt;";
                if (s2===">")s2 = "&gt;";
                if (s2===" " && th[0].uniCOffs===0)s = (th[0].shift ? s1 : String.fromCharCode(n1 + 32));
                else s = (th[0].shift ? s2 : s1);
                th[0].html += s;
                th[0].div.div.innerHTML = th[0].html;
            };
            this.kb[i] = this.newButton(txt, i, fn);
        }
        if (this.unicode) {
            this.nRows += 4;
            this.changeUnic = function () {
                var sel = document.getElementById('kbSel');
            };
            var sh = "<option value='0.1'>Unicode page...</option>";
            for (i = 0; i < 200; i++)sh += "<option value='" + i + "'>" + i + "</option>";
            this.kbSel = document.createElement("select");
            this.kbSel.innerHTML = sh;
            this.du = this.keys0.length;
            this.ind = 0;
            this.kbSel.onchange = function () {
                if (this.value==="next") {
                    self.ind++;
                    self.uniCOffs += self.du;
                } else if (this.value==="previous") {
                    if (self.ind > 0) {
                        self.ind--;
                        self.uniCOffs -= self.du;
                    }
                }
                else {
                    self.ind = parseInt(this.value);
                    self.uniCOffs = parseInt(this.value) * self.du;
                }
                this.value = self.ind;
                self.render();
            };
            this.kbSel.setAttribute("style", 'z-index:' + (this.zIndexStart + 10) + ';position:relative;');
            this.selDiv.div.appendChild(this.kbSel);
            this.prvUni = this.newButton("\u25c4", null, function () {
                if (self.ind===0)return;
                self.ind--;
                self.kbSel.value = self.ind;
                self.uniCOffs -= self.du;
                self.render();
            });
            this.nxtUni = this.newButton("\u25ba", null, function () {
                self.ind++;
                self.kbSel.value = self.ind;
                self.uniCOffs += self.du;
                self.render();
            });
        }
        this.delS = ["leftarrow", "\u2190", function ( th ) {
            var l = th[0].html.length;
            if (l < 0)return;
            if (th[0].html[l - 1]===">")l = th[0].html.lastIndexOf("<") + 1;
            var ss = th[0].html.substring(l - 4, l);
            if (ss==="&gt;" || ss==="&lt;")l -= 3;
            th[0].html = th[0].html.substring(0, l - 1);
            th[0].div.div.innerHTML = th[0].html;
        }];
        this.specs = (this.params.specials!==false
                          && (!this.params.numbers && !this.params.calculate) ?
                      [
                          ["uparrow", "\u21e7", function ( th ) {
                              th[0].shift = !th[0].shift;
                              if (th[0].isWeb)th[0].specBs[0].style.backgroundImage = "url('../library/css/bbg" + (th[0].shift ? "h" : "") + ".png')";
                              else th[0].specBs[0].params.onOff = th[0].shift;
                              th[0].specBs[0].render();
                          }]
                          ,
                          this.delS
                          /*,["leftarrow","\u21b5",function(th){
                           th[0].html+="<br/>";
                           th[0].div.div.innerHTML=th[0].html;
                           }]*/
                      ]
            : []);//[this.delS]);
        this.specBs = [];
        for (i = 0; i < this.specs.length; i++) {
            this.specBs[i] = this.newButton(this.specs[i][1], i, this.specs[i][2]);
        }
        var self = this;
        if (this.space) {
            this.nRows++;
            this.space = this.newButton(" ", 1, function ( th ) {
                th[0].html += "\u00a0";
                self.div.div.innerHTML = th[0].html;
            });
        }
        if (this.params.ok) {
            this.nRows++;
            this.okB = this.newButton((this.params.scientific ? "Done" : "OK"), 1, self.params.okFn);
        }
        this.clearB = this.newButton("C", 1
            , function () {
                self.nChars=0;
                self.html = "";
                self.div.div.innerHTML = "";
            }
        );
        if (this.params.calculate) {
            this.nRows++;
            if (this.params.scientific) {
                this.nRows += 2;
                i = 0;
                self.sciFs = ["log", "exp", "sin", "cos", "tan"];
                self.sciBs = [];
                for (i = 0; i < self.sciFs.length; i++) {
                    fn = function ( th ) {
                        self.nChars=0;
                        var v;
                        try {
                            var n = (self.div.div.innerHTML.replace(/\&nbsp\;/g, "").replace(/\u00d7/g,"*").replace(/\u00f7/g,"/"));
                            if (isNaN(n))v = "Error";
                            else {
                                if (th[1] > 1 && self.degrees)n = n / 180 * Math.PI;
                                n = eval(n);
                                v = eval("Math." + self.sciFs[th[1]] + "(" + n + ")");
                            }
                            if (isFinite(v * 1e5))v = (parseInt(v * 1e5 + (v < 0 ? -0.5 : 0.5))) / 1e5;
                        } catch(ee) {
                            v = "Error";
                        }
                        self.html = String(v).replace("NaN", "Error");
                        self.div.div.innerHTML = self.html;
                    };
                    self.sciBs[i] = self.newButton("\u00a0 " + self.sciFs[i].toUpperCase() + "\u00a0", i, fn, '#111111');
                }
                self.degrees = false;
                self.sciBs[i] = self.newButton("RAD/deg", i, function ( th ) {
                    self.degrees = !self.degrees;
                    self.sciBs[th[1]].setTxt(self.degrees ? "DEG/rad" : "RAD/deg");
                });
                //self.sciBs[i]=self.newButton("Deg/<u>Rad</u>",i,function(th){
                //self.degrees=!self.degrees;
                //self.sciBs[th[1]].setTxt(self.degrees?"<u>Deg</u>/Rad":"Deg/<u>Rad</u>");
                //});
            }
            this.okB = this.newButton("=", 1
                , function () {
                    self.nChars=0;
                    var v, num;
                    try {
                        v = (self.div.div.innerHTML.replace(/\&nbsp\;/g, "").replace(/\u00d7/g,"*").replace(/\u00f7/g,"/"));
                        if (v.indexOf("rr") > 0 || v.indexOf("def") > 0 || v.indexOf("nfi") > 0)v = "Error";
                        else {
                            num = eval(v);
                            if (isNaN(num))v = "Error";
                            else if (isFinite(num * 1e5))v = (num * 1e5 + (num < 0 ? -0.5 : 0.5) | 0) / 1e5;
                            else v = num;
                        }
                    } catch(ee) {
                        v = "Error";
                    }
                    self.html = (v);
                    self.div.div.innerHTML = self.html;
                }
            );
            this.cancelB = this.newButton("Done", 1, function () {
                self.nChars=0;
                if (self.params.okFn)self.params.okFn();
                if (OU.thsKP)OU.thsKP.dispDiv.style.border = 'solid 1px';
                self.setVisible(false);
            });
        }
        this.extras = [
            ["Subscript", "<sub>", 2],
            ["Superscript", "<sup>", 1],
            ["Bold", "<b>"],
            ["Italic", "<i>"]
            ,
            ["Underline", "<u>"]
        ];
        this.extraBs = [];
        this.html = "";
        if (this.formatting) {
            this.nRows++;
            for (i = 0; i < this.extras.length; i++) {
                this.extraBs[i] = this.newButton(this.extras[i][0], i,
                    function ( th ) {
                        var b = th[0].extraBs[th[1]]
                            , s = th[0].extras[th[1]][1];
                        b.params.onOff = !b.params.onOff;
                        if (b.style)b.style.backgroundImage = "url('../library/css/bbg" + (b.params.onOff ? "h" : "") + ".png')";
                        if (!b.params.onOff)s = s.replace("<", "</");
                        var otherB = th[0].extras[th[1]][2];
                        if (otherB) {
                            th[0].extraBs[otherB - 1].params.onOff = false;
                            if (th[0].extraBs[otherB - 1].style)th[0].extraBs[otherB - 1].style.backgroundImage = "url('../library/css/bbg.png')";
                            th[0].extraBs[otherB - 1].render();
                            th[0].html += th[0].extras[otherB - 1][1].replace("<", "</");
                        }
                        th[0].html += s;
                        th[0].div.div.innerHTML = th[0].html;
                        b.render();
                    }
                );
                if (this.isWeb)this.extraBs[i].params = {
                    onOff:false,
                    hasOnOff:true,
                    onOffIndicator:true
                };
            }
        }
        this.setVisible(false);
    };
    /**
     * Changes the HTML content of "this.div"
     * @param {string} s - new html
     */
    OU.util.Keyboard.prototype.setHtml = function (s) {
        this.html = s;
        this.div.div.innerHTML = this.html;
    };
    /**
     * Render function - does nothing!
     */
    OU.util.Keyboard.prototype.render = function () {
    };
    /**
     * Returns a new button, either HTML(deprecated) or canvas based depending on "this.isWeb"
     * @private
     */
    OU.util.Keyboard.prototype.newButton = function ( txt, i, fn) {
        var btn;
        if (txt.indexOf('_ <sup>_') >= 0) {
            btn = {
                render:function () {
                },
                resize:function () {
                },
                setTxt:function () {
                }
            };
        }
        else {
            var ctx, tfn = fn || function () {
            };
            if (this.isWeb) {
                ctx = this.selDiv.div;
                btn = document.createElement("a");
                btn.th = [this, i];
                btn.onclick = function () {
                    tfn(this.th);
                };
                btn.href = "javascript:;";
                btn.setAttribute("style", "position:absolute;top:10px;left:20px; font-size:90%;text-align:center;");
                btn.style.zIndex = this.zIndexStart + 10;
                btn.render = function () {
                };
                btn.resize = function ( dims ) {
                    this.style.left = "" + ((parseInt(self.layer.canvas.style.left) + dims.x) | 0) + "px";
                    this.style.top = "" + ((parseInt(self.layer.canvas.style.top) + dims.y) | 0) + "px";
                    this.style.height = "" + ((dims.h * 0.7) | 0) + "px";
                    this.style.width = "" + ((dims.w * 0.7) | 0) + "px";
                    this.style.fontSize = "" + ((dims.h / 2.3) | 0) + "px";
                };
                ctx.appendChild(btn);
                btn.style.padding = "0px";
                btn.style.paddingTop = "0.5%";
            }
            else {
                btn = new OU.util.Button({
                    txt:txt,
                    layer:this.layer,
                    background:{
                        col:'#aaaaaa',
                        radius:2,
                        borderCol:'#999999'
                    },
                    onClick:fn,
                    onClickParam:[this, i]
                });
                btn.th = [this, i];
                btn.params.onClick = function () {
                    fn(this.th);
                };
            }
            btn.setTxt = function ( t ) {
                if (this.params) {
                    this.params.txt = t;
                    this.render();
                } else if (this.th)this.innerHTML = t;
            };
            btn.setTxt(txt);
        }
        return btn;
    };
    /**
     * @WillCode Seems to hide or show the keyboard - only Will and God knows why! :)
     */
    OU.util.Keyboard.prototype.setVisible = function ( v, html ) {
        var self=this;
        this.isVisible=v;
  //      setTimeout(function(v,html){
//alert(this);
        var disp = (v ? "block" : "none");
        if (v) {
            if (html!==undefined) {
                self.nChars=html.replace(/ /g,"").replace(/\&nbsp\;/g," ").length;
                self.html = html;
                self.div.div.innerHTML = html;
            }
        }
        self.layer.canvas.style.display = disp;
        self.div.div.style.display = disp;
        self.selDiv.div.style.display = disp;
//        },1000);
    };
    /**
     * Resizes the keyboard. I don't think this works correctly.
     * @param {object} p - Unused!
     */
    OU.util.Keyboard.prototype.resize = function ( p ) {
        var
            x = window.innerWidth * this._x,
            y = window.innerHeight * this._y,
            bw = window.innerHeight * this._h / (this.nRows + 1) * 0.95,
            bh = bw,
            ygap = bw * 0.8,
            xgap = bw * 0.88,
            ky, kx = 1,
            i, j, lw,
            kx0 = 5 + x, ky0 = bw
            ;
        ky = ygap * 1.2 + ky0 + bw * (this.unicode ? 3.3 : 1) * 0.7;
        lw = (//this.params.w?this.params.w*window.innerWidth:
            (this.params.scientific || this.params.calculate ? bw * 2.65 : (this.params.numbers ? bw * 1.75 : (this.params.w ? this.params.w * window.innerWidth : bw * 10.5))));
        this.div.resize({
            x:kx0 + bw * 0.1,
            y:y + bw * 0.96,
            w:lw + bw * 0.8,
            h:bw * (this.unicode ? 3.3 : 1) * 0.57
        });
        this.layer.resize({
            x:x,
            y:y,
            w:lw + bw * 1.3,
            h:bw * (this.nRows + (this.params.scientific ? 0.3 : -0.05))
        });
        kx = kx0;
        bh *= 0.9;
        var fs = ((bh / 2.2) | 0) + "px";
        this.div.div.style.fontSize = fs;
        this.closeB.background.col = '#222222';
        this.closeB.resize({
            x:lw + bw * 0.2,
            y:bw * 0.1,
            w:bw * 0.8,
            h:bh * 0.8
        });
        this.closeB.render();
        if (this.unicode) {
            this.kbSel.style.fontSize = fs;
            this.selDiv.div.style.fontSize = fs;
            this.prvUni.resize({
                x:kx,
                y:ky - bw * 0.85,
                w:bw * 0.8,
                h:bh * 0.8
            });
            this.prvUni.render();
            kx += bw;
            this.kbSel.style.left = (kx + bw * 0.2) + "px";
            this.kbSel.style.top = (y + bw * 2.6) + "px";
            kx += bw * 4.5;
            this.nxtUni.resize({
                x:kx,
                y:ky - bw * 0.85,
                w:bw * 0.8,
                h:bh * 0.8
            });
            this.nxtUni.render();
            if (kx - x > lw)lw = kx - x;
        }
        else ky -= bw;
        if (kx - x > lw)lw = kx - x + bw;
        kx0 -= parseInt(self.layer.canvas.style.left);
        kx = kx0 - 3;
        if (this.sciBs) {
            for (i = 0; i < this.sciBs.length; i++) {
                this.sciBs[i].resize({
                    x:kx,
                    y:ky,
                    w:bw * 2.07,
                    h:bh
                });
                this.sciBs[i].render();
                if (kx - x + bw > lw)lw = kx - x + bw;
                kx += xgap * 2;
                if (i % 2==1) {
                    kx = kx0 - 3;
                    ky += ygap;
                }
            }
        }
        kx = kx0;
        for (i = 0; i < this.keys.length / 2; i++) {
            for (j = this.newLs.length; j--;)if (i===this.newLs[j]) {
                kx = kx0;
                ky += ygap;
            }
            this.kb[i].resize({
                x:kx,
                y:ky,
                w:bw,
                h:bh
            });
            if (this.params.scientific) {
                if (this.kb[i].background && i % 4!==3)this.kb[i].background.col = '#dddddd';
            } else if (this.kb[i].background)this.kb[i].background.col = '#dddddd';
            this.kb[i].render();
            if (kx - x > lw)lw = kx - x;
            kx += xgap;
        }
        for (i = 0; i < this.specBs.length; i++) {
            this.specBs[i].resize({
                x:kx,
                y:ky,
                w:bw,
                h:bh
            });
            this.specBs[i].background.col = '#111111';
            this.specBs[i].render();
            if (kx - x > lw)lw = kx - x - bw / 3;
            kx += xgap;
        }
        ky += ygap;
        if (this.space) {
            kx = kx0 + bw * 3;
            this.space.resize({
                x:kx,
                y:ky,
                w:bw * 4,
                h:bh
            });
            this.space.render();
            kx += bw * 3.1;
            if (kx - x > lw)lw = kx - x;
        }
        else kx = kx0;
        if (this.clearB) {
            if (this.params.keys)kx = lw - xgap * 2;
            this.clearB.resize({
                x:kx + xgap,
                y:ky - (this.params.scientific ? 0 : ygap),
                w:bw,
                h:bh
            });
            this.clearB.render();
            kx += xgap;
        }
        if (this.okB) {
            if (this.params.scientific) {
                kx -= xgap;
                this.okB.resize({
                    x:kx,
                    y:ky,
                    w:bw,
                    h:bh
                });
                kx += xgap * 2;
            }
            else {
                this.okB.background.col = '#222222';
                this.okB.resize({
                    x:kx + xgap,
                    y:ky - ygap,
                    w:bw,
                    h:bh
                });
                kx += xgap;
            }
            this.okB.render();
        }
        if (this.cancelB) {// also used as done in calculator
            this.cancelB.background.col = '#222222';
            this.cancelB.resize({
                x:kx - bw * 0.1,
                y:ky,
                w:bw * 2.1,
                h:bh
            });
            this.cancelB.render();
        }
        if (kx - x > lw)lw = kx - x + bw;
        ky += ygap;
        kx = kx0;
        for (i = 0; i < this.extraBs.length; i++) {
            this.extraBs[i].resize({
                x:kx,
                y:ky,
                w:bw * 2.6,
                h:bh * 0.97
            });
            this.extraBs[i].render();
            if (kx - x > lw)lw = kx - x + bw;
            kx += xgap * 2.5 + 3;
        }
        this.layer.canvas.style.border = 'solid 1px #dddddd';
        this.layer.canvas.style.background = '#6f7072' || self.data.background;
        this.layer.canvas.style.borderRadius = '4px';

        if(this.isVisible===true)this.setVisible(true);
        else this.setVisible(false);
    };
    /**
     * Removes the keyboard and corresponding layers/divs
     */
    OU.util.Keyboard.prototype.remove = function () {
        this.layer.remove();
        this.selDiv.remove();
        this.div.remove();
    };
    this.init(params);
};
/**
 * @class Keypad - Uses the Keyboard class to enter a value in a standard html text input field.
 * The key pad is activited when the input field is clicked or touched.
 * The value can be generated using an optional calculator, or scientific calculator
 *
 * When finished (OK button pressed) value in display is inserted into the specified inputField
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 * 
 * @param {object} params - options:
 * <ul>
 * <li><strong>{DOM INPUT object} inputField:</strong> (required) The input field to trigger the keypad and put the final value in</li>
 * <li><strong>{object} container:</strong> The calling object, typically an OU.util.Activity</li>
 * <li><strong>{int} x:</strong> X co-ordinate of the keypad</li>
 * <li><strong>{int} y:</strong> Y co-ordinate of the keypad</li>
 * <li><strong>{int} w:</strong> Width of the keypad</li>
 * <li><strong>{int} h:</strong> Height of the keypad</li>
 * <li><strong>{string} type:</strong> (optional) ['numeric' | 'calculator' | 'scientific'] defaults to numeric</li>
 * </ul>
 */
OU.util.Keypad = function ( params ) {
    var self = this;
    this.inputField = params.inputField;
    params.x = params.x || 0.01;
    params.y = params.y || 0.01;
    params.w = params.w || 0.7;
    params.h = params.h || 0.7;
    params.numbers = params.calculate = params.scientific = false;
    switch(params.type) {
        default:
        case 'numeric':
            params.numbers = true;
            break;
        case 'calculator':
            params.calculate = true;
            break;
        case 'scientific':
            params.calculate = true;
            params.scientific = true;
            break;
    }
    params.unicode = false;
    params.ok = true;
    params.space = false;
    params.specials = false;
    params.background = '#fcfcfc';
    params.formatting = false;
    params.zIndex = params.container.zOffset + OU.ABSOLUTE_TOP;
    params.ok = true;
    params.okFn = function () {
        self.inputField.value = self.keyboard.div.div.innerHTML;
        self.keyboard.remove();
        self.keyboard = undefined;
    };
    this.keyboardParams = params;
    /**
     * Launches the keypad when the inputField triggers it
     * @private
     */
    this.startFn = function ( e ) {
        e.preventDefault();
        if (self.keyboard===undefined) {
            self.keyboard = new OU.util.Keyboard(self.keyboardParams);
            self.keyboard.div.div.innerHTML = self.keyboard.html = self.inputField.value;
            self.keyboard.resize();
            self.keyboard.setVisible(true);
        }
    };
    this.inputField.addEventListener("mousedown", this.startFn, false, 0, true);
    this.inputField.addEventListener("dblclick", this.startFn, false, 0, true);
    this.inputField.addEventListener("touchstart", this.startFn, false, 0, true);
    /**
     * Resizes the keypad (doesn't currently work, as it relies on the keyboard resize function that is broken)
     */
    OU.util.Keypad.prototype.resize = function () {
        //TODO fix Keyboard resizing and then call it here
    };
    /**
     * Removes keypad and corresponding event listeners, etc.
     */
    OU.util.Keypad.prototype.remove = function () {
        this.inputField.removeEventListener("mousedown", this.startFn);
        this.inputField.removeEventListener("mdblclick", this.startFn);
        this.inputField.removeEventListener("touchstart", this.startFn);
    };
};