/**
 * @fileOverview Slideshow - basic slideshow as utility, no transitions
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */
/**
 * @class Slideshow - basic slideshow as utility, with no transitions
 * 
 * @param {object} params - options:
 * <ul>
 * <li><strong>{object} container:</strong> (required) The calling object, typically an OU.util.Acitivity </li>
 * <li><strong>{canvas.context} context:</strong> (required) Context of the canvas/layer to render to</li>
 * <li><strong>{int} x:</strong> X co-ordinate</li>
 * <li><strong>{int} y:</strong> Y co-ordinate</li>
 * <li><strong>{int} w:</strong> Width</li>
 * <li><strong>{int} h:</strong> Height</li>
 * <li><strong>{int} startImage:</strong> index of the image to start on, defaults to 0</li>
 * <li><strong>{json object[]} images:</strong> array of images in json structure, with format:</li>
 * <ul>
 * <li><strong>{DOM Image object} image:</strong> the image for each slide</li>
 * </ul>
 * </ul>
 */
OU.util.Slideshow = function(params) {
    this.container = params.container;
    this.context = params.context;
    this.x = params.x || 0;
    this.y = params.y || 0;
    this.w = params.w || this.container.w;
    this.h = params.h || this.container.h;
    this.images = params.images;
    this.numImages = this.images.length;
    this.shownImage = params.startImage || 0;
    /**
     * Resize the slidehow
     * 
     * @param {object} params - (optional) new dims:
     * <ul>
     * <li><strong>{int} x:</strong> X co-ordinate</li>
     * <li><strong>{int} y:</strong> Y co-ordinate</li>
     * <li><strong>{int} w:</strong> Width</li>
     * <li><strong>{int} h:</strong> Height</li>
     * </ul>
     */
    OU.util.Slideshow.prototype.resize = function(params) {
        var j,i;
        params = params || {};
        this.x = params.x || this.x;
        this.y = params.y || this.y;
        this.w = params.w || this.w;
        this.h = params.h || this.h;
        this.maxW=this.maxH=0;

        for(j=this.numImages; j--;) {
            i = this.images[j];
            if(i.image!==undefined) {
                i.w=i.image.width;
                i.h = i.image.height;
                if(i.w>this.w) {
                    i.h = (this.w/i.w) * i.h;
                    i.w = this.w;
                }
                if(i.h>this.h) {
                    i.w = (this.h/i.h) * i.w;
                    i.h = this.h;
                }
                i.x = this.x+(this.w-i.w)/2;
                i.y = this.y+(this.h-i.h)/2;
                if(i.w>this.maxW)
                    this.maxW=i.w;
                if(i.h>this.maxH)
                    this.maxH=i.h;
            }
        }
        this.render();
    };
    /**
     * Renders the current slide
     */
    OU.util.Slideshow.prototype.render = function() {
        var i = this.images[this.shownImage];
        if(i.image!==undefined) {
            this.context.clearRect(this.x,this.y,this.w,this.h);
            this.context.drawImage(i.image,i.x,i.y, i.w,i.h);
        }
    };
    /**
     * Change to a new slide
     * @param {int} idx - new slide index
     */
    OU.util.Slideshow.prototype.move = function(idx) {
        this.shownImage=idx;
        this.render();
    };
    this.resize();
};
