/**
 * ModalMessage
 *
 *
 * @author Nigel Clarke
 */

OU.require('OU.util.Div');
/**
 * @class ModealMessage
 */
OU.util.ModalMessage = function(params) {
    this.modalLayer = null;
    this.messageLayer = null;
    OU.util.ModalMessage.prototype.init = function() {
        if (!OU._modalMessageLive) {
            OU._modalMessageLive = true;
            var message = this, x, y, w, h;
            x = params.x || window.innerWidth / 4;
            y = params.y || window.innerHeight * .4;
            w = params.w || window.innerWidth / 2;
            h = params.h || window.innerHeight * .2;
            this.modalLayer = new OU.util.Div({
                container: params.container,
                zIndex: OU.ABSOLUTE_TOP
            });
            if (!params.noModalClose) {
                OU.events.addListener(this.modalLayer.div, function() {
                    message.close();
                }, 'tap');
            }
            this.messageLayer = new OU.util.Div({
                x: x,
                y: y,
                w: w,
                h: "auto",
                zIndex: OU.ABSOLUTE_TOP + 1,
                htmlClass: "fastease modalMessage",
                innerHTML: params.html,
                transform: {
                    translate: {
                        y: -window.innerHeight
                    }
                }
            });
            setTimeout(function() {
                message.messageLayer.transform({
                    translate: {
                        y: 0
                    }
                });
            }, 20);
            if (params.timeout) {
                setTimeout(function() {
                    message.close();
                }, params.timeout);
            }
        }
    };
    OU.util.ModalMessage.prototype.close = function() {
        if (this.modalLayer) {
            this.modalLayer.remove();
            this.modalLayer = null;
        }
        if (this.messageLayer) {
            this.messageLayer.remove();
            this.messageLayer = null;
        }
        OU._modalMessageLive = false;
    };
    this.init();
};
